/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.webservices.client;

import com.wordsteps.model.Dictionary;
import com.wordsteps.model.Language;
import com.wordsteps.model.Word;
import java.util.Date;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapPrimitive;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransport;

public class DictionariesServiceClient {
    private String endPoint = "http://wordsteps.com/ws/server.php";
    private static final String REQ_PARAM_CLIENT_ID = "clientId";
    private static final String REQ_PARAM_SRC_LANG = "sourceLanguage";
    private static final String REQ_PARAM_TRG_LANG = "targetLanguage";
    private static final String REQ_PARAM_SORT_BY = "sortBy";
    private static final String REQ_NAMESPACE = "urn:FreeMobilSOAPData.getDictionaries";
    private static final String REQ_METHOD = "FreeMobilSOAPData.getDictionaries";
    private static final String REQ_PARAM_UI_LANGUAGE = "uiLanguage";
    private static final String REQ_PARAM_VERSION = "version";
    private static final String REQ_METHOD_UPDATE_INFO = "FreeMobilSOAPData.getUpdatesInfo";

    public Dictionary[] getDictionaries(String clientId, String sourceLanguage, String targetLanguage, String sortBy) {
        SoapObject req = new SoapObject(REQ_NAMESPACE, REQ_METHOD);
        req.addProperty(REQ_PARAM_CLIENT_ID, (Object)clientId);
        req.addProperty(REQ_PARAM_SRC_LANG, (Object)sourceLanguage);
        req.addProperty(REQ_PARAM_TRG_LANG, (Object)targetLanguage);
        req.addProperty(REQ_PARAM_SORT_BY, (Object)sortBy);
        SoapSerializationEnvelope env = new SoapSerializationEnvelope(100);
        env.bodyOut = req;
        Dictionary[] dictionaries = null;
        HttpTransport http = new HttpTransport(this.endPoint);
        try {
            http.call(null, env);
            SoapObject response = (SoapObject)((SoapObject)env.bodyIn).getProperty("return");
            dictionaries = new Dictionary[response.getPropertyCount()];
            for (int i = 0; i < response.getPropertyCount(); ++i) {
                SoapObject dictionarySoap = (SoapObject)response.getProperty(i);
                dictionaries[i] = new Dictionary();
                dictionaries[i].setId(Integer.parseInt("" + dictionarySoap.getProperty("id")));
                dictionaries[i].getInfo().setAuthor("" + dictionarySoap.getProperty("author"));
                dictionaries[i].getInfo().setComplexity(Integer.parseInt("" + dictionarySoap.getProperty("complexity")));
                SoapObject categoriesSoap = (SoapObject)dictionarySoap.getProperty("categories");
                String[] categories = new String[categoriesSoap.getPropertyCount()];
                for (int j = 0; j < categoriesSoap.getPropertyCount(); ++j) {
                    categories[j] = "" + categoriesSoap.getProperty(j);
                }
                dictionaries[i].getInfo().setCategories(categories);
                dictionaries[i].getInfo().setCreationDate(new Date(Long.parseLong("" + dictionarySoap.getProperty("creationDate"))));
                dictionaries[i].getInfo().setRate(Integer.parseInt("" + dictionarySoap.getProperty("rating")));
                dictionaries[i].getInfo().setName("" + dictionarySoap.getProperty("name"));
                dictionaries[i].getInfo().setSourceLanguage(Language.parse("" + dictionarySoap.getProperty(REQ_PARAM_SRC_LANG)));
                dictionaries[i].getInfo().setTargetLanguage(Language.parse("" + dictionarySoap.getProperty(REQ_PARAM_TRG_LANG)));
                SoapObject wordsSoap = (SoapObject)dictionarySoap.getProperty("words");
                Word[] words = new Word[wordsSoap.getPropertyCount()];
                for (int j = 0; j < wordsSoap.getPropertyCount(); ++j) {
                    SoapObject wordSoap = (SoapObject)wordsSoap.getProperty(j);
                    String word = "" + wordSoap.getProperty("word");
                    String translation = "" + wordSoap.getProperty("translation");
                    String transcription = "";
                    if (wordSoap.getProperty("transcription") instanceof SoapPrimitive) {
                        transcription = "" + wordSoap.getProperty("transcription");
                    }
                    words[j] = new Word(word, translation, transcription);
                }
                dictionaries[i].setWords(words);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dictionaries;
    }

    public String getUpdateInfo(String version, String uiLanguage) {
        SoapObject req = new SoapObject(REQ_NAMESPACE, REQ_METHOD_UPDATE_INFO);
        req.addProperty(REQ_PARAM_VERSION, (Object)version);
        req.addProperty(REQ_PARAM_UI_LANGUAGE, (Object)uiLanguage);
        SoapSerializationEnvelope env = new SoapSerializationEnvelope(100);
        env.bodyOut = req;
        HttpTransport http = new HttpTransport(this.endPoint);
        try {
            http.call(null, env);
            Object response = ((SoapObject)env.bodyIn).getProperty("return");
            if (response instanceof SoapPrimitive) {
                return response.toString();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

