/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.serialization;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.SoapFault;
import org.ksoap2.serialization.DM;
import org.ksoap2.serialization.FwdRef;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.Marshal;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapPrimitive;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SoapSerializationEnvelope
extends SoapEnvelope {
    protected static final int QNAME_TYPE = 1;
    protected static final int QNAME_NAMESPACE = 0;
    protected static final int QNAME_MARSHAL = 3;
    private static final String ANY_TYPE_LABEL = "anyType";
    private static final String ARRAY_MAPPING_NAME = "Array";
    private static final String NULL_LABEL = "null";
    private static final String NIL_LABEL = "nil";
    private static final String HREF_LABEL = "href";
    private static final String ID_LABEL = "id";
    private static final String ROOT_LABEL = "root";
    private static final String TYPE_LABEL = "type";
    private static final String ITEM_LABEL = "item";
    private static final String ARRAY_TYPE_LABEL = "arrayType";
    static final Marshal DEFAULT_MARSHAL = new DM();
    public Hashtable properties = new Hashtable();
    Hashtable idMap = new Hashtable();
    Vector multiRef;
    public boolean implicitTypes;
    public boolean dotNet;
    protected Hashtable qNameToClass = new Hashtable();
    protected Hashtable classToQName = new Hashtable();

    public SoapSerializationEnvelope(int n) {
        super(n);
        this.addMapping(this.enc, ARRAY_MAPPING_NAME, PropertyInfo.VECTOR_CLASS);
        DEFAULT_MARSHAL.register(this);
    }

    public void parseBody(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        this.bodyIn = null;
        xmlPullParser.nextTag();
        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getNamespace().equals(this.env) && xmlPullParser.getName().equals("Fault")) {
            SoapFault soapFault = new SoapFault();
            soapFault.parse(xmlPullParser);
            this.bodyIn = soapFault;
        } else {
            while (xmlPullParser.getEventType() == 2) {
                String string = xmlPullParser.getAttributeValue(this.enc, ROOT_LABEL);
                Object object = this.read(xmlPullParser, null, -1, xmlPullParser.getNamespace(), xmlPullParser.getName(), PropertyInfo.OBJECT_TYPE);
                if ("1".equals(string) || this.bodyIn == null) {
                    this.bodyIn = object;
                }
                xmlPullParser.nextTag();
            }
        }
    }

    protected void readSerializable(XmlPullParser xmlPullParser, KvmSerializable kvmSerializable) throws IOException, XmlPullParserException {
        int n = -1;
        int n2 = kvmSerializable.getPropertyCount();
        PropertyInfo propertyInfo = new PropertyInfo();
        while (xmlPullParser.nextTag() != 3) {
            String string = xmlPullParser.getName();
            int n3 = n2;
            do {
                if (n3-- == 0) {
                    throw new RuntimeException("Unknown Property: " + string);
                }
                if (++n >= n2) {
                    n = 0;
                }
                kvmSerializable.getPropertyInfo(n, this.properties, propertyInfo);
            } while (!(propertyInfo.namespace == null && string.equals(propertyInfo.name) || propertyInfo.name == null && n == 0) && (!string.equals(propertyInfo.name) || !xmlPullParser.getNamespace().equals(propertyInfo.namespace)));
            kvmSerializable.setProperty(n, this.read(xmlPullParser, kvmSerializable, n, null, null, propertyInfo));
        }
        xmlPullParser.require(3, null, null);
    }

    protected Object readUnknown(XmlPullParser xmlPullParser, String string, String string2) throws IOException, XmlPullParserException {
        String string3 = xmlPullParser.getName();
        String string4 = xmlPullParser.getNamespace();
        xmlPullParser.next();
        Object object = null;
        String string5 = null;
        if (xmlPullParser.getEventType() == 4) {
            string5 = xmlPullParser.getText();
            object = new SoapPrimitive(string, string2, string5);
            xmlPullParser.next();
        } else if (xmlPullParser.getEventType() == 3) {
            object = new SoapObject(string, string2);
        }
        if (xmlPullParser.getEventType() == 2) {
            if (string5 != null && string5.trim().length() != 0) {
                throw new RuntimeException("Malformed input: Mixed content");
            }
            SoapObject soapObject = new SoapObject(string, string2);
            while (xmlPullParser.getEventType() != 3) {
                soapObject.addProperty(xmlPullParser.getName(), this.read(xmlPullParser, soapObject, soapObject.getPropertyCount(), null, null, PropertyInfo.OBJECT_TYPE));
                xmlPullParser.nextTag();
            }
            object = soapObject;
        }
        xmlPullParser.require(3, string4, string3);
        return object;
    }

    private int getIndex(String string, int n, int n2) {
        if (string == null) {
            return n2;
        }
        return string.length() - n < 3 ? n2 : Integer.parseInt(string.substring(n + 1, string.length() - 1));
    }

    protected void readVector(XmlPullParser xmlPullParser, Vector vector, PropertyInfo propertyInfo) throws IOException, XmlPullParserException {
        int n;
        String string = null;
        String string2 = null;
        int n2 = vector.size();
        boolean bl = true;
        String string3 = xmlPullParser.getAttributeValue(this.enc, ARRAY_TYPE_LABEL);
        if (string3 != null) {
            n = string3.indexOf(58);
            int n3 = string3.indexOf("[", n);
            string2 = string3.substring(n + 1, n3);
            String string4 = n == -1 ? "" : string3.substring(0, n);
            string = xmlPullParser.getNamespace(string4);
            n2 = this.getIndex(string3, n3, -1);
            if (n2 != -1) {
                vector.setSize(n2);
                bl = false;
            }
        }
        if (propertyInfo == null) {
            propertyInfo = PropertyInfo.OBJECT_TYPE;
        }
        xmlPullParser.nextTag();
        n = this.getIndex(xmlPullParser.getAttributeValue(this.enc, "offset"), 0, 0);
        while (xmlPullParser.getEventType() != 3) {
            n = this.getIndex(xmlPullParser.getAttributeValue(this.enc, "position"), 0, n);
            if (bl && n >= n2) {
                n2 = n + 1;
                vector.setSize(n2);
            }
            vector.setElementAt(this.read(xmlPullParser, vector, n, string, string2, propertyInfo), n);
            ++n;
            xmlPullParser.nextTag();
        }
        xmlPullParser.require(3, null, null);
    }

    public Object read(XmlPullParser xmlPullParser, Object object, int n, String string, String string2, PropertyInfo propertyInfo) throws IOException, XmlPullParserException {
        Object object2;
        String string3 = xmlPullParser.getName();
        String string4 = xmlPullParser.getAttributeValue(null, HREF_LABEL);
        if (string4 != null) {
            if (object == null) {
                throw new RuntimeException("href at root level?!?");
            }
            object2 = this.idMap.get(string4 = string4.substring(1));
            if (object2 == null || object2 instanceof FwdRef) {
                FwdRef fwdRef = new FwdRef();
                fwdRef.next = (FwdRef)object2;
                fwdRef.obj = object;
                fwdRef.index = n;
                this.idMap.put(string4, fwdRef);
                object2 = null;
            }
            xmlPullParser.nextTag();
            xmlPullParser.require(3, null, string3);
        } else {
            String string5;
            String string6 = xmlPullParser.getAttributeValue(this.xsi, NIL_LABEL);
            String string7 = xmlPullParser.getAttributeValue(null, ID_LABEL);
            if (string6 == null) {
                string6 = xmlPullParser.getAttributeValue(this.xsi, NULL_LABEL);
            }
            if (string6 != null && SoapEnvelope.stringToBoolean(string6)) {
                object2 = null;
                xmlPullParser.nextTag();
                xmlPullParser.require(3, null, string3);
            } else {
                string5 = xmlPullParser.getAttributeValue(this.xsi, TYPE_LABEL);
                if (string5 != null) {
                    int n2 = string5.indexOf(58);
                    string2 = string5.substring(n2 + 1);
                    String string8 = n2 == -1 ? "" : string5.substring(0, n2);
                    string = xmlPullParser.getNamespace(string8);
                } else if (string2 == null && string == null) {
                    if (xmlPullParser.getAttributeValue(this.enc, ARRAY_TYPE_LABEL) != null) {
                        string = this.enc;
                        string2 = ARRAY_MAPPING_NAME;
                    } else {
                        Object[] objectArray = this.getInfo(propertyInfo.type, null);
                        string = (String)objectArray[0];
                        string2 = (String)objectArray[1];
                    }
                }
                object2 = this.readInstance(xmlPullParser, string, string2, propertyInfo);
                if (object2 == null) {
                    object2 = this.readUnknown(xmlPullParser, string, string2);
                }
            }
            if (string7 != null) {
                string5 = this.idMap.get(string7);
                if (string5 instanceof FwdRef) {
                    FwdRef fwdRef = (FwdRef)((Object)string5);
                    do {
                        if (fwdRef.obj instanceof KvmSerializable) {
                            ((KvmSerializable)fwdRef.obj).setProperty(fwdRef.index, object2);
                            continue;
                        }
                        ((Vector)fwdRef.obj).setElementAt(object2, fwdRef.index);
                    } while ((fwdRef = fwdRef.next) != null);
                } else if (string5 != null) {
                    throw new RuntimeException("double ID");
                }
                this.idMap.put(string7, object2);
            }
        }
        xmlPullParser.require(3, null, string3);
        return object2;
    }

    public Object readInstance(XmlPullParser xmlPullParser, String string, String string2, PropertyInfo propertyInfo) throws IOException, XmlPullParserException {
        Object object = this.qNameToClass.get(new SoapPrimitive(string, string2, null));
        if (object == null) {
            return null;
        }
        if (object instanceof Marshal) {
            return ((Marshal)object).readInstance(xmlPullParser, string, string2, propertyInfo);
        }
        if (object instanceof SoapObject) {
            object = ((SoapObject)object).newInstance();
        } else {
            try {
                object = ((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        if (object instanceof KvmSerializable) {
            this.readSerializable(xmlPullParser, (KvmSerializable)object);
        } else if (object instanceof Vector) {
            this.readVector(xmlPullParser, (Vector)object, propertyInfo.elementType);
        } else {
            throw new RuntimeException("no deserializer for " + object.getClass());
        }
        return object;
    }

    public Object[] getInfo(Object object, Object object2) {
        Object[] objectArray;
        if (object == null) {
            object = object2 instanceof SoapObject || object2 instanceof SoapPrimitive ? object2 : object2.getClass();
        }
        if (object instanceof SoapObject) {
            SoapObject soapObject = (SoapObject)object;
            return new Object[]{soapObject.getNamespace(), soapObject.getName(), null, null};
        }
        if (object instanceof SoapPrimitive) {
            SoapPrimitive soapPrimitive = (SoapPrimitive)object;
            return new Object[]{soapPrimitive.getNamespace(), soapPrimitive.getName(), null, DEFAULT_MARSHAL};
        }
        if (object instanceof Class && object != PropertyInfo.OBJECT_CLASS && (objectArray = (Object[])this.classToQName.get(((Class)object).getName())) != null) {
            return objectArray;
        }
        return new Object[]{this.xsd, ANY_TYPE_LABEL, null, null};
    }

    public void addMapping(String string, String string2, Class clazz, Marshal marshal) {
        this.qNameToClass.put(new SoapPrimitive(string, string2, null), marshal == null ? clazz : marshal);
        this.classToQName.put(clazz.getName(), new Object[]{string, string2, null, marshal});
    }

    public void addMapping(String string, String string2, Class clazz) {
        this.addMapping(string, string2, clazz, null);
    }

    public void addTemplate(SoapObject soapObject) {
        this.qNameToClass.put(new SoapPrimitive(soapObject.namespace, soapObject.name, null), soapObject);
    }

    public Object getResponse() throws SoapFault {
        if (this.bodyIn instanceof SoapFault) {
            throw (SoapFault)this.bodyIn;
        }
        KvmSerializable kvmSerializable = (KvmSerializable)this.bodyIn;
        return kvmSerializable.getPropertyCount() == 0 ? null : kvmSerializable.getProperty(0);
    }

    public Object getResult() {
        KvmSerializable kvmSerializable = (KvmSerializable)this.bodyIn;
        return kvmSerializable.getPropertyCount() == 0 ? null : kvmSerializable.getProperty(0);
    }

    public void writeBody(XmlSerializer xmlSerializer) throws IOException {
        this.multiRef = new Vector();
        this.multiRef.addElement(this.bodyOut);
        Object[] objectArray = this.getInfo(null, this.bodyOut);
        xmlSerializer.startTag(this.dotNet ? "" : (String)objectArray[0], (String)objectArray[1]);
        if (this.dotNet) {
            xmlSerializer.attribute(null, "xmlns", (String)objectArray[0]);
        }
        xmlSerializer.attribute(null, ID_LABEL, objectArray[2] == null ? "o0" : (String)objectArray[2]);
        xmlSerializer.attribute(this.enc, ROOT_LABEL, "1");
        this.writeElement(xmlSerializer, this.bodyOut, null, objectArray[3]);
        xmlSerializer.endTag(this.dotNet ? "" : (String)objectArray[0], (String)objectArray[1]);
    }

    public void writeObjectBody(XmlSerializer xmlSerializer, KvmSerializable kvmSerializable) throws IOException {
        PropertyInfo propertyInfo = new PropertyInfo();
        int n = kvmSerializable.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            kvmSerializable.getPropertyInfo(i, this.properties, propertyInfo);
            if ((propertyInfo.flags & 1) != 0) continue;
            xmlSerializer.startTag(propertyInfo.namespace, propertyInfo.name);
            this.writeProperty(xmlSerializer, kvmSerializable.getProperty(i), propertyInfo);
            xmlSerializer.endTag(propertyInfo.namespace, propertyInfo.name);
        }
    }

    protected void writeProperty(XmlSerializer xmlSerializer, Object object, PropertyInfo propertyInfo) throws IOException {
        if (object == null) {
            xmlSerializer.attribute(this.xsi, this.version >= 120 ? NIL_LABEL : NULL_LABEL, "true");
            return;
        }
        Object[] objectArray = this.getInfo(null, object);
        if (propertyInfo.multiRef || objectArray[2] != null) {
            int n = this.multiRef.indexOf(object);
            if (n == -1) {
                n = this.multiRef.size();
                this.multiRef.addElement(object);
            }
            xmlSerializer.attribute(null, HREF_LABEL, objectArray[2] == null ? "#o" + n : "#" + objectArray[2]);
        } else {
            if (!this.implicitTypes || object.getClass() != propertyInfo.type) {
                String string = xmlSerializer.getPrefix((String)objectArray[0], true);
                xmlSerializer.attribute(this.xsi, TYPE_LABEL, string + ":" + objectArray[1]);
            }
            this.writeElement(xmlSerializer, object, propertyInfo, objectArray[3]);
        }
    }

    private void writeElement(XmlSerializer xmlSerializer, Object object, PropertyInfo propertyInfo, Object object2) throws IOException {
        if (object2 != null) {
            ((Marshal)object2).writeInstance(xmlSerializer, object);
        } else if (object instanceof KvmSerializable) {
            this.writeObjectBody(xmlSerializer, (KvmSerializable)object);
        } else if (object instanceof Vector) {
            this.writeVectorBody(xmlSerializer, (Vector)object, propertyInfo.elementType);
        } else {
            throw new RuntimeException("Cannot serialize: " + object);
        }
    }

    protected void writeVectorBody(XmlSerializer xmlSerializer, Vector vector, PropertyInfo propertyInfo) throws IOException {
        if (propertyInfo == null) {
            propertyInfo = PropertyInfo.OBJECT_TYPE;
        }
        int n = vector.size();
        Object[] objectArray = this.getInfo(propertyInfo.type, null);
        xmlSerializer.attribute(this.enc, ARRAY_TYPE_LABEL, xmlSerializer.getPrefix((String)objectArray[0], false) + ":" + objectArray[1] + "[" + n + "]");
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (vector.elementAt(i) == null) {
                bl = true;
                continue;
            }
            xmlSerializer.startTag(null, ITEM_LABEL);
            if (bl) {
                xmlSerializer.attribute(this.enc, "position", "[" + i + "]");
                bl = false;
            }
            this.writeProperty(xmlSerializer, vector.elementAt(i), propertyInfo);
            xmlSerializer.endTag(null, ITEM_LABEL);
        }
    }
}

