/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class Constants {
    public static int CANVAS_WIDTH = 0;
    public static int CANVAS_HEIGHT = 0;
    public static final int UP_KEY = -1;
    public static final int DOWN_KEY = -2;
    public static final int RIGHT_KEY = -4;
    public static final int LEFT_KEY = -3;
    public static int OK_KEY = -5;
    public static final int RIGHT_SOFT_KEY = -7;
    public static final int LEFT_SOFT_KEY = -6;
    public static final int ZERO_KEY = 48;
    public static final int ONE_KEY = 49;
    public static final int TWO_KEY = 50;
    public static final int THREE_KEY = 51;
    public static final int FOUR_KEY = 52;
    public static final int FIVE_KEY = 53;
    public static final int SIX_KEY = 54;
    public static final int SEVEN_KEY = 55;
    public static final int EIGHT_KEY = 56;
    public static final int NINE_KEY = 57;
    public static final int ASTERIC_KEY = 42;
    public static final int HASH_KEY = 35;
    public static final int CLEAR_KEY = -8;
    public static final String MENU = "MENU";
    public static final String PROFILE = "PROFILE";
    public static final String PROFILE_NAME = "Name";
    public static final String CONFERENCE_NUMBER = "Number";
    public static final String CONFERENCE_CODE = "Code";
    public static final String LEADER_PIN = "Pin";
    public static final String NOTES = "Notes";
    public static final int[] CHARACTER_POSITION_ARRAY = new int[]{0, 2, 32, 36, 40, 44, 48, 52, 57, 61, 66, 69, 74, 76};
    public static final String SMALL_LATTER = " 0_$()\"'/&*@.?#-,:;%=+<>[]^`{!}1abc2def3ghi4jkl5mno6pqrs7tuv8wxyz9";
    public static final String HelpUS = "If you like our application please support us, by clicking the ads, to provide you with these kind of lovely application in future also. Please click on ads and enable us to keep you provide more application.";

    public static int getStringWidth(String str) {
        Font font = Font.getDefaultFont();
        int strWidth = font.stringWidth(str);
        return strWidth;
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        int size = rowsVector.size();
        String[] rowsArray = new String[size];
        for (int i = 0; i < size; ++i) {
            rowsArray[i] = rowsVector.elementAt(i).toString();
        }
        return rowsArray;
    }

    public static Image scale(Image src, int width, int height) {
        try {
            int scanline = src.getWidth();
            int srcw = src.getWidth();
            int srch = src.getHeight();
            int[] buf = new int[srcw * srch];
            src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
            int[] buf2 = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int c1 = y * width;
                int c2 = y * srch / height * scanline;
                for (int x = 0; x < width; ++x) {
                    buf2[c1 + x] = buf[c2 + x * srcw / width];
                }
            }
            Image img = Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
            System.gc();
            return img;
        }
        catch (Exception e) {
            return src;
        }
        catch (Error e) {
            System.gc();
            return src;
        }
    }
}

