/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TextWindow;
import javax.microedition.lcdui.Graphics;

public class TextWindows {
    public TextWindow tw1;
    public TextWindow tw2;
    private boolean active;
    private int index = 0;
    private int[] pos;

    public TextWindows(int sw, int sh, int y, String text1, String text2, Graphics gr, int columns) {
        int ww = sw / 2 - 4;
        if (columns == 2) {
            this.pos = new int[4];
            this.pos[0] = 2;
            this.pos[1] = 2 + ww;
            this.pos[2] = 2 + ww + 2;
            this.pos[3] = sw - 2;
            this.tw1 = new TextWindow(2, y, ww, sh - y - 2, "\u0422\u0435\u043a\u0441\u0442:", text1, gr);
            this.tw2 = new TextWindow(sw - ww - 2, y, ww, sh - y - 2, "\u041f\u0435\u0440\u0435\u0432\u043e\u0434:", text2, gr);
        } else {
            this.pos = new int[2];
            this.pos[0] = 0;
            this.pos[1] = 2 + sw - 4;
            this.tw1 = new TextWindow(2, y, sw - 4, sh - y - 2, "\u0422\u0435\u043a\u0441\u0442:", text1, gr);
            this.tw2 = null;
        }
        this.active = false;
        this.setActive(this.active);
    }

    protected final void draw() {
        this.tw1.draw();
        if (this.tw2 != null) {
            this.tw2.draw();
        }
    }

    protected final boolean getActive() {
        return this.active;
    }

    protected final int[] getPositions() {
        return this.pos;
    }

    protected final int getSelectedIndex() {
        return this.index;
    }

    protected final void setSelectedIndex(int ind) {
        int max = this.tw2 != null ? 1 : 0;
        if (ind > max) {
            ind = max;
        }
        if (ind < 0) {
            ind = 0;
        }
        this.index = ind;
    }

    protected final void setActive(boolean active) {
        this.active = active;
        if (active) {
            switch (this.index) {
                case 0: {
                    this.tw1.setActive(active);
                    break;
                }
                case 1: {
                    if (this.tw2 == null) break;
                    this.tw2.setActive(active);
                }
            }
        } else {
            this.tw1.setActive(active);
            if (this.tw2 != null) {
                this.tw2.setActive(active);
            }
        }
    }

    protected void moveRight() {
        if (this.index == 0 && this.tw2 != null) {
            this.index = 1;
        }
        if (this.active) {
            switch (this.index) {
                case 0: {
                    this.tw1.setActive(true);
                    if (this.tw2 == null) break;
                    this.tw2.setActive(false);
                    break;
                }
                case 1: {
                    this.tw1.setActive(false);
                    if (this.tw2 == null) break;
                    this.tw2.setActive(true);
                }
            }
        }
    }

    protected void moveLeft() {
        if (this.index == 1 && this.tw2 != null) {
            this.index = 0;
        }
        if (this.active) {
            switch (this.index) {
                case 0: {
                    this.tw1.setActive(true);
                    if (this.tw2 == null) break;
                    this.tw2.setActive(false);
                    break;
                }
                case 1: {
                    this.tw1.setActive(false);
                    if (this.tw2 == null) break;
                    this.tw2.setActive(true);
                }
            }
        }
    }
}

