/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public abstract class TXCanvas
extends Canvas {
    private long globalAmount = 100L;
    private long globalCount = 1L;
    private long lastTime = 0L;
    private int waitState = 1;
    private boolean exitThread = false;
    private int exitCode = -1;
    protected boolean needAll;

    protected abstract void onInit();

    protected abstract void onDone();

    protected abstract void onPaint(Graphics var1);

    protected abstract void onTick(long var1);

    protected abstract void onStart();

    private final void updateTime() {
        this.lastTime = System.currentTimeMillis() - this.globalAmount / this.globalCount;
    }

    protected final void paint(Graphics graphics) {
        this.onPaint(graphics);
    }

    private final synchronized void notifyEx() {
        ((Object)((Object)this)).notify();
    }

    private final synchronized void waitEx() throws InterruptedException {
        ((Object)((Object)this)).wait();
    }

    protected void showNotify() {
        this.notifyEx();
        this.needAll = true;
        TripleX.paused = false;
    }

    protected void hideNotify() {
        TripleX.paused = true;
    }

    public final int run() {
        try {
            this.exitCode = -1;
            if (Display.getDisplay((MIDlet)TripleX.getInstance()).getCurrent() != this) {
                this.waitEx();
            }
            this.updateTime();
            long l = System.currentTimeMillis();
            while (!this.exitThread) {
                TripleX tripleX = TripleX.getInstance();
                if (tripleX == null) break;
                long l2 = System.currentTimeMillis();
                long l3 = l2 - this.lastTime;
                this.lastTime = l2;
                this.globalAmount += l3;
                ++this.globalCount;
                this.waitState = 1;
                this.onTick(l3);
                if (this.waitState != 1) {
                    this.serviceRepaints();
                    l = System.currentTimeMillis();
                    while (TripleX.paused) {
                        Thread.sleep(100L);
                    }
                    this.lastTime += System.currentTimeMillis() - l;
                    continue;
                }
                this.waitState = 2;
            }
            this.onDone();
        }
        catch (InterruptedException interruptedException) {
            this.onDone();
            TripleX.getInstance().quit();
            return -1;
        }
        return this.exitCode;
    }

    public final int start() {
        this.onStart();
        this.onInit();
        this.exitThread = false;
        Display display = Display.getDisplay((MIDlet)TripleX.getInstance());
        if (display.getCurrent() != this) {
            display.setCurrent((Displayable)this);
        }
        while (display.getCurrent() != this) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.run();
        return this.exitCode;
    }

    public final void step() {
        boolean bl;
        boolean bl2 = bl = this.waitState == 2;
        if (bl) {
            this.updateTime();
        }
        this.waitState = 0;
        if (bl) {
            this.notifyEx();
        }
    }

    protected void exit(int n) {
        this.exitThread = true;
        this.exitCode = n;
    }
}

