/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class MenuCanvas {
    private static final int STANDARD_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 289 / 1000;
    private static final int SCROLL_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 289 / 1000;
    private static final int YESNO_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 462 / 1000;
    public static final int FONT_HEIGHT = BPFontReader.fontHeight[0];
    public static final int LINE_SPACING = FONT_HEIGHT + 4;
    public static final int BUTTON_POSY = CodenameCanvas.SCREEN_HEIGHT - FONT_HEIGHT - 1;
    public static final int MAX_TEXT_LINES = 6;
    private static final int SCROLLING_SPEED = 5;
    private static final int PAUSE_STANDARD_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 317 / 1000;
    private static final int PAUSE_SCROLL_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 289 / 1000;
    private static final int PAUSE_YESNO_MENU_OFFSET = CodenameCanvas.SCREEN_HEIGHT * 462 / 1000;
    private static final int PAUSE_MAX_TEXT_LINES = 6;
    public CodenameCanvas codenameCanvas;
    public int scroll = 0;
    public static final int IDContinue = 0;
    public static final int IDNewGame = 1;
    public static final int IDSettings = 2;
    public static final int IDControls = 3;
    public static final int IDHighscore = 4;
    public static final int IDAbout = 5;
    public static final int IDExitGame = 6;
    public static final int IDDifficultyEasy = 7;
    public static final int IDDifficultyMedium = 8;
    public static final int IDSoundOn = 9;
    public static final int IDSoundOff = 10;
    public static final int IDVibraOn = 11;
    public static final int IDVibraOff = 12;
    public static final int IDResetHighscore = 13;
    public static final int IDResetHighscoreText = 14;
    public static final int IDControlsText = 15;
    public static final int IDHighscoreText = 16;
    public static final int IDAboutText = 17;
    public static final int IDExitGameText = 18;
    public static final int IDPauseBackToMenu = 19;
    public static final int IDPauseBackToMenuText = 20;
    public static final int IDSelect = 21;
    public static final int IDBack = 22;
    public static final int IDYes = 23;
    public static final int IDNo = 24;
    public static final int IDSkip = 25;
    public static final int IDGameIntro = 26;
    public static final int IDGameEnd = 27;
    public static Menu activeMenu;
    public static MenuItem CONTINUE;
    public static MenuItem NEW_GAME;
    public static MenuItem SETTINGS;
    public static MenuItem CONTROLS;
    public static MenuItem HIGHSCORE;
    public static MenuItem ABOUT;
    public static MenuItem EXIT_GAME;
    public static MenuItem DIFFICULTY_EASY;
    public static MenuItem DIFFICULTY_MEDIUM;
    public static MenuItem SOUND;
    public static MenuItem VIBRA;
    public static MenuItem RESET_HIGHSCORE;
    public static MenuItem RESET_HIGHSCORE_TEXT;
    public static MenuItem CONTROLS_TEXT;
    public static MenuItem HIGHSCORE_TEXT;
    public static MenuItem ABOUT_TEXT;
    public static MenuItem EXIT_GAME_TEXT;
    public static MenuItem PAUSE_BACK_TO_MENU;
    public static MenuItem PAUSE_BACK_TO_MENU_TEXT;
    public static MenuItem GAME_INTRO;
    public static MenuItem GAME_END;
    public Menu mainMenu;
    public Menu newGameMenu;
    public Menu settingsMenu;
    public Menu controlsMenu;
    public Menu resetHighscoreMenu;
    public Menu highscoreMenu;
    public Menu aboutMenu;
    public Menu exitGameMenu;
    public Menu pauseMainMenu;
    public Menu pauseSettingsMenu;
    public Menu pauseControlsMenu;
    public Menu pauseExitToMenuMenu;
    public Menu pauseExitMenu;
    public Menu gameIntroMenu;
    public Menu gameEndMenu;

    MenuCanvas(CodenameCanvas _codenameCanvas) {
        this.codenameCanvas = _codenameCanvas;
        CONTINUE = new MenuItem(0);
        NEW_GAME = new MenuItem(1);
        SETTINGS = new MenuItem(2);
        CONTROLS = new MenuItem(3);
        HIGHSCORE = new MenuItem(4);
        ABOUT = new MenuItem(5);
        EXIT_GAME = new MenuItem(6);
        DIFFICULTY_EASY = new MenuItem(7);
        DIFFICULTY_MEDIUM = new MenuItem(8);
        SOUND = CodenameCanvas.sound ? new MenuItem(9) : new MenuItem(10);
        VIBRA = CodenameCanvas.vibra ? new MenuItem(11) : new MenuItem(12);
        RESET_HIGHSCORE = new MenuItem(13);
        RESET_HIGHSCORE_TEXT = new MenuItem(14);
        CONTROLS_TEXT = new MenuItem(15);
        HIGHSCORE_TEXT = new MenuItem(16);
        ABOUT_TEXT = new MenuItem(17);
        EXIT_GAME_TEXT = new MenuItem(18);
        PAUSE_BACK_TO_MENU = new MenuItem(19);
        PAUSE_BACK_TO_MENU_TEXT = new MenuItem(20);
        GAME_INTRO = new MenuItem(26);
        GAME_END = new MenuItem(27);
        this.mainMenu = new Menu();
        this.mainMenu.addItem(NEW_GAME);
        this.mainMenu.addItem(SETTINGS);
        this.mainMenu.addItem(CONTROLS);
        this.mainMenu.addItem(HIGHSCORE);
        this.mainMenu.addItem(ABOUT);
        this.mainMenu.addItem(EXIT_GAME);
        this.mainMenu.parent = null;
        this.newGameMenu = new Menu();
        this.newGameMenu.addItem(DIFFICULTY_EASY);
        this.newGameMenu.addItem(DIFFICULTY_MEDIUM);
        this.newGameMenu.parent = this.mainMenu;
        this.settingsMenu = new Menu();
        this.settingsMenu.addItem(SOUND);
        this.settingsMenu.addItem(VIBRA);
        this.settingsMenu.addItem(RESET_HIGHSCORE);
        this.settingsMenu.parent = this.mainMenu;
        this.resetHighscoreMenu = new Menu();
        this.resetHighscoreMenu.addItem(RESET_HIGHSCORE_TEXT);
        this.resetHighscoreMenu.parent = this.settingsMenu;
        this.controlsMenu = new Menu();
        this.controlsMenu.addItem(CONTROLS_TEXT);
        this.controlsMenu.parent = this.mainMenu;
        this.highscoreMenu = new Menu();
        this.highscoreMenu.addItem(HIGHSCORE_TEXT);
        this.highscoreMenu.parent = this.mainMenu;
        this.aboutMenu = new Menu();
        this.aboutMenu.addItem(ABOUT_TEXT);
        this.aboutMenu.parent = this.mainMenu;
        this.exitGameMenu = new Menu();
        this.exitGameMenu.addItem(EXIT_GAME_TEXT);
        this.exitGameMenu.parent = this.mainMenu;
        this.pauseMainMenu = new Menu();
        this.pauseMainMenu.addItem(CONTINUE);
        this.pauseMainMenu.addItem(SETTINGS);
        this.pauseMainMenu.addItem(CONTROLS);
        this.pauseMainMenu.addItem(PAUSE_BACK_TO_MENU);
        this.pauseMainMenu.addItem(EXIT_GAME);
        this.pauseMainMenu.parent = null;
        this.pauseSettingsMenu = new Menu();
        this.pauseSettingsMenu.addItem(SOUND);
        this.pauseSettingsMenu.addItem(VIBRA);
        this.pauseSettingsMenu.parent = this.pauseMainMenu;
        this.pauseControlsMenu = new Menu();
        this.pauseControlsMenu.addItem(CONTROLS_TEXT);
        this.pauseControlsMenu.parent = this.pauseMainMenu;
        this.pauseExitToMenuMenu = new Menu();
        this.pauseExitToMenuMenu.addItem(PAUSE_BACK_TO_MENU_TEXT);
        this.pauseExitToMenuMenu.parent = this.pauseMainMenu;
        this.pauseExitMenu = new Menu();
        this.pauseExitMenu.addItem(EXIT_GAME_TEXT);
        this.pauseExitMenu.parent = this.pauseMainMenu;
        this.gameIntroMenu = new Menu();
        this.gameIntroMenu.addItem(GAME_INTRO);
        this.gameIntroMenu.parent = null;
        this.gameEndMenu = new Menu();
        this.gameEndMenu.addItem(GAME_END);
        this.gameEndMenu.parent = this.mainMenu;
        activeMenu = this.mainMenu;
    }

    public void paintMenu(Graphics g) {
        int width;
        if (activeMenu != this.pauseMainMenu && activeMenu != this.pauseSettingsMenu && activeMenu != this.pauseControlsMenu && activeMenu != this.pauseExitMenu && activeMenu != this.pauseExitToMenuMenu) {
            g.setColor(0);
            g.drawImage(this.codenameCanvas.menu[0], 0, 0, 20);
        }
        if (activeMenu == this.mainMenu || activeMenu == this.newGameMenu || activeMenu == this.settingsMenu || activeMenu == this.highscoreMenu) {
            g.translate(0, STANDARD_MENU_OFFSET);
        } else if (activeMenu == this.controlsMenu || activeMenu == this.aboutMenu || activeMenu == this.gameEndMenu || activeMenu == this.gameIntroMenu) {
            g.translate(0, SCROLL_MENU_OFFSET);
        } else if (activeMenu == this.resetHighscoreMenu || activeMenu == this.exitGameMenu) {
            g.translate(0, YESNO_MENU_OFFSET);
        } else if (activeMenu == this.pauseMainMenu || activeMenu == this.pauseSettingsMenu) {
            g.translate(0, PAUSE_STANDARD_MENU_OFFSET);
        } else if (activeMenu == this.pauseControlsMenu) {
            g.translate(0, PAUSE_SCROLL_MENU_OFFSET);
        } else if (activeMenu == this.pauseExitMenu || activeMenu == this.pauseExitToMenuMenu) {
            g.translate(0, PAUSE_YESNO_MENU_OFFSET);
        }
        if (activeMenu == this.mainMenu || activeMenu == this.newGameMenu || activeMenu == this.settingsMenu || activeMenu == this.pauseMainMenu || activeMenu == this.pauseSettingsMenu) {
            MenuItem item = (MenuItem)MenuCanvas.activeMenu.items.elementAt(MenuCanvas.activeMenu.selected);
            int textWidth = BPFontReader.getGraphicTextWidth(item.textID, 0);
            int drawingPosX = 0;
            drawingPosX = activeMenu == this.pauseMainMenu || activeMenu == this.pauseSettingsMenu || activeMenu == this.pauseControlsMenu ? (CodenameCanvas.SCREEN_WIDTH - textWidth) / 2 : (CodenameCanvas.SCREEN_WIDTH + CodenameCanvas.SCREEN_WIDTH * 23 / 100 - textWidth) / 2;
            int mover = (int)(CodenameCanvas.menuCounter / 5L % 4L) - 2;
            int drawingPosY = MenuCanvas.activeMenu.selected * LINE_SPACING;
            int posx = drawingPosX - 4 + mover;
            int posy = drawingPosY - 3 + mover;
            g.drawImage(this.codenameCanvas.menu[1], posx, posy, 20);
            posx = drawingPosX + textWidth - 2 - mover;
            posy = drawingPosY - 3 + mover;
            g.drawImage(this.codenameCanvas.menu[2], posx, posy, 20);
            posx = drawingPosX + textWidth - 2 - mover;
            posy = drawingPosY + BPFontReader.fontHeight[0] - 3 - mover;
            g.drawImage(this.codenameCanvas.menu[3], posx, posy, 20);
            posx = drawingPosX - 4 + mover;
            posy = drawingPosY + BPFontReader.fontHeight[0] - 3 - mover;
            g.drawImage(this.codenameCanvas.menu[4], posx, posy, 20);
        }
        g.translate(0, this.scroll);
        for (int i = 0; i < MenuCanvas.activeMenu.items.size(); ++i) {
            MenuItem item = (MenuItem)MenuCanvas.activeMenu.items.elementAt(i);
            if (activeMenu == this.pauseControlsMenu && item.textLength > 6) {
                item.paint(g, LINE_SPACING, true);
                int scrolled = g.getTranslateY();
                g.translate(0, -scrolled + 1);
                g.setClip(0, 0, CodenameCanvas.SCREEN_WIDTH, PAUSE_SCROLL_MENU_OFFSET);
                this.codenameCanvas.paintGame(g);
                g.setClip(0, PAUSE_SCROLL_MENU_OFFSET + 6 * LINE_SPACING, CodenameCanvas.SCREEN_WIDTH, CodenameCanvas.SCREEN_HEIGHT - 6 * LINE_SPACING - PAUSE_SCROLL_MENU_OFFSET);
                this.codenameCanvas.paintGame(g);
            } else if (item.textLength > 6) {
                item.paint(g, LINE_SPACING, false);
                if (activeMenu == this.aboutMenu) {
                    String version = this.codenameCanvas.midlet.getAppProperty("MIDlet-Version");
                    int textWidth = BPFontReader.getTextWidth(version, 0, 0);
                    BPFontReader.drawGraphicText(version, (CodenameCanvas.SCREEN_WIDTH + CodenameCanvas.SCREEN_WIDTH * 23 / 100 - textWidth) / 2, LINE_SPACING * 8, 0, 0, g);
                }
                g.setClip(0, -this.scroll - SCROLL_MENU_OFFSET, CodenameCanvas.SCREEN_WIDTH, CodenameCanvas.SCREEN_HEIGHT);
                g.setClip(0, -this.scroll - SCROLL_MENU_OFFSET, CodenameCanvas.SCREEN_WIDTH, SCROLL_MENU_OFFSET);
                g.drawImage(this.codenameCanvas.menu[0], 0, -this.scroll - SCROLL_MENU_OFFSET, 20);
                g.setClip(0, -this.scroll + 6 * LINE_SPACING, CodenameCanvas.SCREEN_WIDTH, CodenameCanvas.SCREEN_HEIGHT - 6 * LINE_SPACING - SCROLL_MENU_OFFSET);
                g.drawImage(this.codenameCanvas.menu[0], 0, -this.scroll - SCROLL_MENU_OFFSET, 20);
            } else if (activeMenu == this.pauseMainMenu || activeMenu == this.pauseExitMenu || activeMenu == this.pauseExitToMenuMenu || activeMenu == this.pauseSettingsMenu || activeMenu == this.pauseControlsMenu) {
                item.paint(g, LINE_SPACING, true);
            } else {
                item.paint(g, LINE_SPACING, false);
            }
            g.translate(0, LINE_SPACING);
        }
        g.translate(0, -g.getTranslateY());
        if (activeMenu == this.mainMenu || activeMenu == this.newGameMenu || activeMenu == this.settingsMenu || activeMenu == this.pauseMainMenu || activeMenu == this.pauseSettingsMenu) {
            BPFontReader.drawGraphicText(21, 0, 1, BUTTON_POSY, g);
        } else if (activeMenu == this.resetHighscoreMenu || activeMenu == this.exitGameMenu || activeMenu == this.pauseExitMenu || activeMenu == this.pauseExitToMenuMenu) {
            BPFontReader.drawGraphicText(23, 0, 1, BUTTON_POSY, g);
        }
        if (activeMenu == this.newGameMenu || activeMenu == this.settingsMenu || activeMenu == this.controlsMenu || activeMenu == this.highscoreMenu || activeMenu == this.aboutMenu || activeMenu == this.pauseSettingsMenu || activeMenu == this.pauseControlsMenu) {
            width = BPFontReader.getGraphicTextWidth(22, 0);
            BPFontReader.drawGraphicText(22, 0, CodenameCanvas.SCREEN_WIDTH - width - 1, BUTTON_POSY, g);
        } else if (activeMenu == this.resetHighscoreMenu || activeMenu == this.exitGameMenu || activeMenu == this.pauseExitMenu || activeMenu == this.pauseExitToMenuMenu) {
            width = BPFontReader.getGraphicTextWidth(24, 0);
            BPFontReader.drawGraphicText(24, 0, CodenameCanvas.SCREEN_WIDTH - width - 1, BUTTON_POSY, g);
        }
        if (activeMenu == this.gameEndMenu || activeMenu == this.gameIntroMenu) {
            BPFontReader.drawGraphicText(25, 0, 1, BUTTON_POSY, g);
        }
        if (activeMenu == this.highscoreMenu) {
            int width2;
            int y;
            int x;
            for (x = 0; x < 3; ++x) {
                for (y = 0; y < 5; ++y) {
                    width2 = BPFontReader.getTextWidth("" + CodenameCanvas.nickName[x][y], 0, 0);
                    BPFontReader.drawGraphicText("" + CodenameCanvas.nickName[x][y], CodenameCanvas.SCREEN_WIDTH * 318 / 1000 + CodenameCanvas.SCREEN_WIDTH * 69 / 1000 * x - width2 / 2, CodenameCanvas.SCREEN_HEIGHT * 385 / 1000 + y * (LINE_SPACING + 1), 0, 1, g);
                }
            }
            for (x = 0; x < 6; ++x) {
                for (y = 0; y < 5; ++y) {
                    width2 = BPFontReader.getTextWidth("" + CodenameCanvas.highScore[x][y], 0, 0);
                    BPFontReader.drawGraphicText("" + CodenameCanvas.highScore[x][y], CodenameCanvas.SCREEN_WIDTH * 568 / 1000 + CodenameCanvas.SCREEN_WIDTH * 69 / 1000 * x + 6 - width2 / 2, CodenameCanvas.SCREEN_HEIGHT * 385 / 1000 + y * (LINE_SPACING + 1), 0, 1, g);
                }
            }
        }
    }

    public void menuKeyReact() {
        if (CodenameCanvas.pause && CodenameCanvas.keyDown != 0) {
            CodenameCanvas.pause = false;
            if (activeMenu != this.pauseMainMenu && activeMenu != this.pauseSettingsMenu && activeMenu != this.pauseControlsMenu && activeMenu != this.pauseExitToMenuMenu && activeMenu != this.pauseExitMenu) {
                CodenameSound.playSound(0);
            }
        }
        switch (CodenameCanvas.keyDown) {
            case -1: 
            case 50: {
                CodenameCanvas.menuCounter = 0L;
                if (activeMenu == this.controlsMenu || activeMenu == this.aboutMenu || activeMenu == this.pauseControlsMenu) {
                    int textLength = ((MenuItem)MenuCanvas.activeMenu.items.elementAt((int)0)).textLength;
                    if (activeMenu == this.pauseControlsMenu && textLength > 6) {
                        this.scroll += 6;
                        if (this.scroll < 0) break;
                        this.scroll = -(textLength - 6) * LINE_SPACING;
                        break;
                    }
                    if (textLength <= 6) break;
                    this.scroll += 6;
                    if (this.scroll < 0) break;
                    this.scroll = -(textLength - 6) * LINE_SPACING;
                    break;
                }
                activeMenu.decrement();
                CodenameCanvas.keyDown = 0;
                break;
            }
            case -2: 
            case 56: {
                CodenameCanvas.menuCounter = 0L;
                if (activeMenu == this.controlsMenu || activeMenu == this.aboutMenu || activeMenu == this.pauseControlsMenu) {
                    int textLength = ((MenuItem)MenuCanvas.activeMenu.items.elementAt((int)0)).textLength;
                    if (activeMenu == this.pauseControlsMenu && textLength > 6) {
                        this.scroll -= 5;
                        if (this.scroll > -(textLength - 6) * LINE_SPACING) break;
                        this.scroll = 0;
                        break;
                    }
                    if (textLength <= 6) break;
                    this.scroll -= 5;
                    if (this.scroll > -(textLength - 6) * LINE_SPACING) break;
                    this.scroll = 0;
                    break;
                }
                activeMenu.increment();
                CodenameCanvas.keyDown = 0;
                break;
            }
            case -6: 
            case -5: 
            case 53: {
                CodenameCanvas.menuCounter = 0L;
                this.changeMenu(activeMenu.getSelected());
                CodenameCanvas.keyDown = 0;
                break;
            }
            case -7: {
                CodenameCanvas.menuCounter = 0L;
                this.backwardMenu();
                CodenameCanvas.keyDown = 0;
                break;
            }
            case -3: 
            case 52: {
                if (activeMenu.getSelected() == VIBRA) {
                    this.changeMenu(activeMenu.getSelected());
                } else if (activeMenu.getSelected() == SOUND) {
                    this.changeBackwardSound();
                }
                CodenameCanvas.keyDown = 0;
                break;
            }
            case -4: 
            case 54: {
                if (activeMenu.getSelected() == SOUND || activeMenu.getSelected() == VIBRA) {
                    this.changeMenu(activeMenu.getSelected());
                }
                CodenameCanvas.keyDown = 0;
            }
        }
    }

    public void changeMenu(MenuItem sel) {
        this.scroll = 0;
        if (sel == CONTINUE) {
            CodenameCanvas.gameState = 6;
        } else if (sel == NEW_GAME) {
            activeMenu = this.newGameMenu;
        } else if (sel == SETTINGS) {
            activeMenu = activeMenu == this.pauseMainMenu ? this.pauseSettingsMenu : this.settingsMenu;
        } else if (sel == CONTROLS) {
            activeMenu = activeMenu == this.pauseMainMenu ? this.pauseControlsMenu : this.controlsMenu;
        } else if (sel == HIGHSCORE) {
            activeMenu = this.highscoreMenu;
        } else if (sel == ABOUT) {
            activeMenu = this.aboutMenu;
        } else if (sel == EXIT_GAME) {
            activeMenu = activeMenu == this.pauseMainMenu ? this.pauseExitMenu : this.exitGameMenu;
        } else if (sel == DIFFICULTY_EASY) {
            MenuCanvas.activeMenu.selected = 0;
            CodenameCanvas.difficultyLevel = 0;
            CodenameCanvas.playerAutoFire = true;
            activeMenu = this.gameIntroMenu;
        } else if (sel == DIFFICULTY_MEDIUM) {
            MenuCanvas.activeMenu.selected = 0;
            CodenameCanvas.difficultyLevel = 1;
            CodenameCanvas.playerAutoFire = true;
            activeMenu = this.gameIntroMenu;
        } else if (sel == SOUND) {
            if (MenuCanvas.SOUND.textID == 9) {
                MenuCanvas.SOUND.textID = 10;
                CodenameSound.stop();
                CodenameCanvas.sound = false;
            } else if (MenuCanvas.SOUND.textID == 10) {
                MenuCanvas.SOUND.textID = 9;
                CodenameCanvas.sound = true;
                if (activeMenu == this.settingsMenu) {
                    CodenameSound.playSound(0);
                }
            }
        } else if (sel == VIBRA) {
            if (MenuCanvas.VIBRA.textID == 11) {
                MenuCanvas.VIBRA.textID = 12;
                CodenameCanvas.vibra = false;
            } else {
                MenuCanvas.VIBRA.textID = 11;
                CodenameCanvas.vibra = true;
                CodenameSound.vibrate(200);
            }
        } else if (sel == RESET_HIGHSCORE) {
            activeMenu = this.resetHighscoreMenu;
        } else if (sel == RESET_HIGHSCORE_TEXT) {
            int j;
            int i;
            for (i = 0; i < CodenameCanvas.nickName.length; ++i) {
                for (j = 0; j < CodenameCanvas.nickName[i].length; ++j) {
                    CodenameCanvas.nickName[i][j] = 65;
                }
            }
            for (i = 0; i < CodenameCanvas.highScore.length; ++i) {
                for (j = 0; j < CodenameCanvas.highScore[i].length; ++j) {
                    CodenameCanvas.highScore[i][j] = 0;
                }
            }
            this.codenameCanvas.saveRMS();
            this.backwardMenu();
        } else if (sel == CONTROLS_TEXT) {
            this.backwardMenu();
        } else if (sel == HIGHSCORE_TEXT) {
            this.backwardMenu();
        } else if (sel == ABOUT_TEXT) {
            this.backwardMenu();
        } else if (sel == EXIT_GAME_TEXT) {
            CodenameCanvas.threadRunning = false;
        } else if (sel == PAUSE_BACK_TO_MENU) {
            activeMenu = this.pauseExitToMenuMenu;
        } else if (sel == PAUSE_BACK_TO_MENU_TEXT) {
            this.codenameCanvas.clearLevelData();
            this.pauseMainMenu.selected = 0;
            activeMenu = this.mainMenu;
            this.mainMenu.selected = 0;
            CodenameCanvas.gameState = 3;
            System.gc();
            CodenameSound.playSound(0);
        } else if (sel == GAME_END) {
            this.codenameCanvas.gameOverKeyReact();
        } else if (sel == GAME_INTRO) {
            CodenameCanvas.lastState = 6;
            CodenameCanvas.gameState = 4;
            CodenameCanvas.currentLevel = 1;
            CodenameCanvas.playerContinues = 3;
            this.codenameCanvas.loadConfiguration(CodenameCanvas.difficultyLevel);
            activeMenu = this.pauseMainMenu;
            CodenameSound.stop();
        }
    }

    public void backwardMenu() {
        if (MenuCanvas.activeMenu.parent != null) {
            if (activeMenu != this.mainMenu) {
                MenuCanvas.activeMenu.selected = 0;
            }
            activeMenu = MenuCanvas.activeMenu.parent;
            this.scroll = 0;
        } else {
            MenuCanvas.activeMenu.selected = MenuCanvas.activeMenu.items.size() - 1;
        }
    }

    public void changeBackwardSound() {
        if (MenuCanvas.SOUND.textID == 9) {
            MenuCanvas.SOUND.textID = 10;
            CodenameCanvas.sound = false;
            CodenameSound.stop();
        } else if (MenuCanvas.SOUND.textID == 10) {
            MenuCanvas.SOUND.textID = 9;
            CodenameCanvas.sound = true;
            if (activeMenu == this.settingsMenu) {
                CodenameSound.playSound(0);
            }
        }
    }

    public final class Menu {
        Menu parent;
        Vector items = new Vector();
        int selected = 0;

        public void addItem(MenuItem item) {
            this.items.addElement(item);
        }

        void increment() {
            this.selected = this.selected == this.items.size() - 1 ? 0 : ++this.selected;
        }

        void decrement() {
            this.selected = this.selected == 0 ? this.items.size() - 1 : --this.selected;
        }

        MenuItem getSelected() {
            return (MenuItem)this.items.elementAt(this.selected);
        }

        void setDefault(MenuItem item) {
            this.selected = this.items.indexOf(item);
        }
    }
}

