/*
 * Decompiled with CFR 0.152.
 */
package root;

import root.MyCanvas;
import root.Texts;
import root.Util;

public class HiScores {
    public static int nrWyboru;
    public static int wybranaKampania;
    public static int wybranaMisja;
    public static String[] difficultyString;
    public static final int liczbaWynikow = 3;
    public static final int liczbaWynikowRazy2 = 6;
    public short[][] wynikiKampania = new short[4][3];
    public short[][] wynikiMisja = new short[MyCanvas.liczbaMisji][3];
    int liczbaWszystkichWynikow = 24 + MyCanvas.liczbaMisji * 6;

    public HiScores() {
        nrWyboru = 0;
        wybranaKampania = 1;
        wybranaMisja = 0;
        this.wczytajHiScores();
    }

    public void wczytajHiScores() {
        byte[] odczyt = Util.loadBytesFromRMS("HiScores");
        int pol = 0;
        if (odczyt == null || odczyt.length != this.liczbaWszystkichWynikow) {
            this.wyczyscHiScores();
        } else {
            int i;
            for (int poziom = 0; poziom < 4; ++poziom) {
                i = 0;
                while (i < 3) {
                    this.wynikiKampania[poziom][i] = HiScores.bytesToShort(odczyt[pol], odczyt[pol + 1]);
                    ++i;
                    pol += 2;
                }
            }
            for (int misja = 0; misja < MyCanvas.liczbaMisji; ++misja) {
                i = 0;
                while (i < 3) {
                    this.wynikiMisja[misja][i] = HiScores.bytesToShort(odczyt[pol], odczyt[pol + 1]);
                    ++i;
                    pol += 2;
                }
            }
        }
    }

    public void zapiszHiScores() {
        byte[] zapis = new byte[this.liczbaWszystkichWynikow];
        int pol = 0;
        for (int poziom = 0; poziom < 4; ++poziom) {
            zapis[pol++] = (byte)((this.wynikiKampania[poziom][0] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiKampania[poziom][0] & 0xFF);
            zapis[pol++] = (byte)((this.wynikiKampania[poziom][1] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiKampania[poziom][1] & 0xFF);
            zapis[pol++] = (byte)((this.wynikiKampania[poziom][2] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiKampania[poziom][2] & 0xFF);
        }
        for (int misja = 0; misja < MyCanvas.liczbaMisji; ++misja) {
            zapis[pol++] = (byte)((this.wynikiMisja[misja][0] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiMisja[misja][0] & 0xFF);
            zapis[pol++] = (byte)((this.wynikiMisja[misja][1] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiMisja[misja][1] & 0xFF);
            zapis[pol++] = (byte)((this.wynikiMisja[misja][2] & 0xFF00) >> 8);
            zapis[pol++] = (byte)(this.wynikiMisja[misja][2] & 0xFF);
        }
        Util.writeBytesToRMS("HiScores", zapis, this.liczbaWszystkichWynikow);
    }

    public static short bytesToShort(byte b1, byte b2) {
        short wynik = b2 < 0 ? (short)(b2 + 256) : (short)b2;
        wynik = b1 < 0 ? (short)(wynik + (b1 + 256 << 8)) : (short)(wynik + (b1 << 8));
        return wynik;
    }

    public int sprawdzWynik(boolean wynikKampania, int pozycja, int liczbaPunktow) {
        int biezacaPozycja;
        short[] wynikiStare = wynikKampania ? this.wynikiKampania[pozycja] : this.wynikiMisja[pozycja];
        for (biezacaPozycja = 3; biezacaPozycja > 0 && wynikiStare[biezacaPozycja - 1] < liczbaPunktow; --biezacaPozycja) {
            if (biezacaPozycja != 3) {
                wynikiStare[biezacaPozycja] = wynikiStare[biezacaPozycja - 1];
            }
            wynikiStare[biezacaPozycja - 1] = (short)liczbaPunktow;
        }
        if (biezacaPozycja == 3) {
            return -1;
        }
        this.zapiszHiScores();
        return biezacaPozycja + 1;
    }

    public void wyczyscHiScores() {
        int j;
        int i;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.wynikiKampania[i][j] = 0;
            }
        }
        for (i = 0; i < MyCanvas.liczbaMisji; ++i) {
            for (j = 0; j < 3; ++j) {
                this.wynikiMisja[i][j] = 0;
            }
        }
        this.zapiszHiScores();
    }

    public String zwrocWynikiString() {
        if (nrWyboru == 0) {
            return "" + this.wynikiMisja[wybranaMisja][0] + Texts.POINTS + "\n" + this.wynikiMisja[wybranaMisja][1] + Texts.POINTS + "\n" + this.wynikiMisja[wybranaMisja][2] + Texts.POINTS;
        }
        return "" + this.wynikiKampania[wybranaKampania][0] + Texts.POINTS + "\n" + this.wynikiKampania[wybranaKampania][1] + Texts.POINTS + "\n" + this.wynikiKampania[wybranaKampania][2] + Texts.POINTS;
    }

    static {
        difficultyString = Texts.DIFFICULTY_STRINGS;
    }
}

