/*
 * Decompiled with CFR 0.152.
 */
package root;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import root.FileReader;
import root.IResourcesRequester;
import root.SimpleSprite;

public class ResourcesManager {
    public static final short DONT_NOTIFY = -1;
    private boolean[] isWorking = new boolean[5];
    private Vector freeIds;
    private static final short INITIAL_POOLS_COUNT = 5;
    private static ResourcesManager instance;
    private Hashtable[] pools = new Hashtable[5];

    private ResourcesManager() {
        this.freeIds = new Vector(5);
        short i = 0;
        while (true) {
            if (i >= 5) break;
            this.isWorking[i] = false;
            this.freeIds.addElement(new Short(i));
            i = (short)(i + 1);
        }
    }

    public void addResource(short poolId, String resourceName, Object obj) {
        if (poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null) {
            throw new RuntimeException("Attempt to add resource " + resourceName + " to empty pool with id: " + poolId + ".");
        }
        if (resourceName == null) {
            throw new RuntimeException("ResourceName can't be null.");
        }
        if (obj == null) {
            throw new RuntimeException("Can't add null object. Resource name: " + resourceName);
        }
        if (this.pools[poolId].put(resourceName, obj) != null) {
            throw new RuntimeException("Key " + resourceName + " alredy exists in pool.");
        }
    }

    public Thread createPool(IResourcesRequester resourcesRequester, String fileName, short notificationFrequency) {
        if (resourcesRequester == null) {
            throw new RuntimeException("You can't pass null as resourcesRequester! How would you know what's the id of created pool?");
        }
        try {
            short newPoolId = (Short)this.freeIds.elementAt(0);
            Thread thread = new Thread(new ResourcesLoader(resourcesRequester, fileName, newPoolId, notificationFrequency));
            this.freeIds.removeElementAt(0);
            this.pools[newPoolId] = new Hashtable();
            this.isWorking[newPoolId] = true;
            thread.start();
            return thread;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            resourcesRequester.onResourcesLoadingProgress((short)-1, (short)-1, "Maximum number of resources pools exceeded.");
            return null;
        }
    }

    public void createPoolSync(IResourcesRequester resourcesRequester, String fileName, short notificationFrequency) {
        Thread thread = this.createPool(resourcesRequester, fileName, notificationFrequency);
        try {
            thread.join();
        }
        catch (InterruptedException exc) {
            throw new RuntimeException("Resources loading thread has been interrupted!");
        }
    }

    public Thread createPool(IResourcesRequester resourcesRequester, String fileName) {
        return this.createPool(resourcesRequester, fileName, (short)5);
    }

    public void createPoolSync(IResourcesRequester resourcesRequester, String fileName) {
        this.createPoolSync(resourcesRequester, fileName, (short)5);
    }

    public static ResourcesManager getInstance() {
        if (instance == null) {
            instance = new ResourcesManager();
        }
        return instance;
    }

    public Object getResource(String resourceName, short poolId) {
        if (poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null) {
            throw new RuntimeException("Attempt to get resource '" + resourceName + "' from non-existing pool (" + poolId + ").");
        }
        try {
            return this.pools[poolId].get(resourceName);
        }
        catch (NullPointerException exc) {
            throw new RuntimeException("Specified key can't be null.");
        }
    }

    public final Enumeration getPoolKeys(short poolId) {
        if (this.poolEmpty(poolId)) {
            throw new RuntimeException("Attempt to access an empty pool with id: " + poolId + ".");
        }
        return this.pools[poolId].keys();
    }

    public final boolean poolEmpty(short poolId) {
        return poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null;
    }

    public void removePool(short poolId) {
        if (this.isWorking[poolId]) {
            throw new RuntimeException("Couldn't remove the pool: it hasn't loaded yet!");
        }
        this.pools[poolId].clear();
        this.pools[poolId] = null;
        this.freeIds.addElement(new Short(poolId));
        System.gc();
    }

    public void setPoolsCount(short poolsCount) {
        Hashtable[] temp;
        short highDataIndex;
        boolean dataCounter = false;
        for (highDataIndex = (short)(this.pools.length - 1); highDataIndex >= 0 && this.pools[highDataIndex] == null; highDataIndex = (short)(highDataIndex - 1)) {
        }
        if (poolsCount > highDataIndex) {
            short i;
            boolean[] tmp = new boolean[poolsCount];
            temp = new Hashtable[poolsCount];
            for (i = 0; i <= highDataIndex; i = (short)(i + 1)) {
                tmp[i] = this.isWorking[i];
                temp[i] = this.pools[i];
            }
            for (i = (short)this.pools.length; i < poolsCount; i = (short)(i + 1)) {
                this.freeIds.addElement(new Short(i));
            }
        } else {
            throw new RuntimeException("Shrinking pools table to " + poolsCount + " is impossible.");
        }
        this.pools = temp;
        System.gc();
    }

    private void onResourcesLoadingFinished(short poolId) {
        this.isWorking[poolId] = false;
    }

    private class ResourcesLoader
    implements Runnable {
        private IResourcesRequester resourcesRequester;
        private String filename;
        private short poolId;
        private short notificationFrequency = (short)5;

        public ResourcesLoader(IResourcesRequester resourcesRequester, String fileName, short poolId, short notificationFrequency) {
            this.poolId = poolId;
            this.filename = fileName;
            this.resourcesRequester = resourcesRequester;
            this.notificationFrequency = notificationFrequency;
        }

        private Object loadResource(String resourceName, String resourceType, String resourceFileName, String paramsString) {
            if (resourceType.equals("IMG")) {
                try {
                    return Image.createImage((String)resourceFileName);
                }
                catch (IOException exc) {
                    return null;
                }
            }
            if (resourceType.equals("SIMPLE_SPRITE")) {
                try {
                    int framesCount = Integer.parseInt(paramsString);
                    Image image = Image.createImage((String)resourceFileName);
                    return new SimpleSprite(image, framesCount);
                }
                catch (IOException exc) {
                    return null;
                }
            }
            if (resourceType.equals("FONT")) {
                try {
                    int charactersCount = Integer.parseInt(paramsString);
                    Image image = Image.createImage((String)resourceFileName);
                    return new SimpleSprite(image, charactersCount);
                }
                catch (IOException exc) {
                    return null;
                }
            }
            return this.resourcesRequester.loadUnknownResource(this.poolId, resourceName, resourceType, resourceFileName, paramsString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileReader resDescriptionFile = null;
            try {
                int resCounter;
                String resCounterStr;
                resDescriptionFile = new FileReader(this.filename);
                while ((resCounterStr = resDescriptionFile.readNextLine()).equals("") || resCounterStr.charAt(0) == '#') {
                }
                try {
                    resCounter = Short.parseShort(resCounterStr);
                }
                catch (NumberFormatException exc) {
                    throw new RuntimeException("Wrong file format: " + resCounterStr + " is not a number.");
                }
                for (int i = 0; i < resCounter; ++i) {
                    String resFile;
                    String resType;
                    String resName;
                    while ((resName = resDescriptionFile.readNextLine()).equals("") || resName.charAt(0) == '#') {
                    }
                    while ((resType = resDescriptionFile.readNextLine()).equals("") || resType.charAt(0) == '#') {
                    }
                    String paramsString = "";
                    int index = resType.indexOf(" ");
                    if (index != -1 && index + 1 < resType.length()) {
                        paramsString = resType.substring(index + 1);
                        resType = resType.substring(0, index);
                    }
                    while ((resFile = resDescriptionFile.readNextLine()).equals("") || resFile.charAt(0) == '#') {
                    }
                    ResourcesManager.getInstance().addResource(this.poolId, resName, this.loadResource(resName, resType, resFile, paramsString));
                    if (this.notificationFrequency == -1 || i % this.notificationFrequency != 0) continue;
                    this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)(100 * i / resCounter), null);
                }
                ResourcesManager.this.onResourcesLoadingFinished(this.poolId);
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)100, null);
            }
            catch (IOException exc) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, "IOException has been thrown while reading from " + this.filename + ": " + exc.getMessage());
            }
            catch (Error err) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, err != null ? err.toString() + ": " + (err.getMessage() != null ? err.getMessage() : "no message") : "err == null");
            }
            catch (Exception exc) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, exc != null ? exc.toString() + ": " + (exc.getMessage() != null ? exc.getMessage() : "no message") : "exc == null");
            }
            finally {
                if (resDescriptionFile != null) {
                    resDescriptionFile.close();
                }
            }
        }
    }
}

