/*
 * Decompiled with CFR 0.152.
 */
package root;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import menu.Element;
import root.Kokpit;
import root.MyCanvas;
import root.TextRenderer;
import root.Texts;
import root.Util;

public class Tutorial {
    String[] tekstTutorial;
    int[] polozenieTekstuY;
    int[] polozenieZnacznikaX;
    int[] polozenieZnacznikaY;
    int[] szerokoscZnacznika;
    int[] wysokoscZnacznika;
    int[] rysowacZnacznik;
    int liczbaCzesciTutoriala;
    int czescBiezaca;
    Font czcionkaTutorial;
    MyCanvas canvas;
    int wielkoscCzcionki;
    int czasTutoriala = 0;
    int czasEkranu;
    int szerokoscTekstu = MyCanvas.maxX - 8;
    private TextRenderer renderer = TextRenderer.getInstance();
    int kolorTla = 0;
    int kolorObwoduTla = 0x3355AA;
    int kolorTekstu = 0xCCAAFF;
    int kolorObwodki = 0xFFFF22;
    String[] linieTekstu;
    int liczbaLiniiOpisu;
    int tekstZawiniety;

    public Tutorial(MyCanvas canvas, Font czcionka) {
        this.canvas = canvas;
        this.czcionkaTutorial = czcionka;
        this.wielkoscCzcionki = this.renderer.getStringHeight(1);
        try {
            String tutorialCaly = Texts.TUTORIAL_TEXT;
            String[] tutorialString = Util.getNextValue(tutorialCaly, '@');
            this.liczbaCzesciTutoriala = Util.stringToInt(tutorialString[0]);
            this.tekstTutorial = new String[this.liczbaCzesciTutoriala];
            this.rysowacZnacznik = new int[this.liczbaCzesciTutoriala];
            this.polozenieTekstuY = new int[this.liczbaCzesciTutoriala];
            this.czescBiezaca = 0;
            for (int i = 0; i < this.liczbaCzesciTutoriala; ++i) {
                String[] czescString = Util.getNextValue(tutorialString[i + 1], ';');
                this.tekstTutorial[i] = czescString[0];
                this.rysowacZnacznik[i] = Util.stringToInt(czescString[1]);
                this.polozenieTekstuY[i] = Util.stringToInt(czescString[2]);
            }
            this.tekstZawiniety = -1;
        }
        catch (Exception e) {
            Util.critical(e, "init tutorial");
        }
    }

    public void paint(Graphics g) {
        if (this.tekstZawiniety != this.czescBiezaca) {
            this.tekstZawiniety = this.czescBiezaca;
            this.linieTekstu = Element.zawinTekst(this.tekstTutorial[this.czescBiezaca], this.szerokoscTekstu, this.czcionkaTutorial);
            this.liczbaLiniiOpisu = this.linieTekstu.length;
        }
        Kokpit.odrysowacCaly = true;
        MyCanvas.kokpit.paint(g);
        if (this.rysowacZnacznik[this.czescBiezaca] != 0) {
            g.setColor(this.kolorObwodki);
            switch (this.rysowacZnacznik[this.czescBiezaca]) {
                case 1: {
                    g.drawRect(Kokpit.polozenieXPaskaPaliwa - 1, Kokpit.polozenieYPaskaPaliwa - 1, Kokpit.szerokoscPaskaPaliwa + 2, Kokpit.wysokoscPaskaPaliwa + 2);
                    break;
                }
                case 2: {
                    g.drawRect(Kokpit.polozenieXStanu - 1, Kokpit.polozenieYStanu - 1, Kokpit.szerokoscStanImage + 2, Kokpit.wysokoscStanImage + 2);
                    break;
                }
                case 3: {
                    g.drawRect(Kokpit.polozenieXMapyWizualizacji - 1, Kokpit.polozenieYMapyWizualizacji - 1, 44, 44);
                    break;
                }
                case 4: {
                    g.drawRect(Kokpit.polozenieXDiody[0] - 1, Kokpit.polozenieYDiody[0] - 1, Kokpit.szerokoscDiod + 2, Kokpit.wysokoscDiod + 2);
                }
            }
        }
        int wysokoscCalegoTekstu = this.liczbaLiniiOpisu * this.wielkoscCzcionki;
        int polozenieY = 0;
        switch (this.polozenieTekstuY[this.czescBiezaca]) {
            case 0: {
                polozenieY = 2;
                break;
            }
            case 1: {
                polozenieY = 220 - wysokoscCalegoTekstu >> 1;
                break;
            }
            case 2: {
                polozenieY = 220 - wysokoscCalegoTekstu - 1;
            }
        }
        int polozenieX = 4 - MyCanvas.translateX;
        g.setClip(-MyCanvas.translateX, -MyCanvas.translateY, MyCanvas.maxX, MyCanvas.maxY);
        g.setColor(this.kolorTla);
        g.fillRect(polozenieX - 4, polozenieY - 4, this.szerokoscTekstu + 8, wysokoscCalegoTekstu + 8);
        g.setColor(this.kolorObwoduTla);
        g.drawRect(polozenieX - 4, polozenieY - 4, this.szerokoscTekstu + 8, wysokoscCalegoTekstu + 8);
        g.setColor(this.kolorTekstu);
        for (int i = 0; i < this.liczbaLiniiOpisu; ++i) {
            int centerX = 88 - (this.renderer.getStringWidth(this.linieTekstu[i].length()) >> 1);
            this.renderer.renderText(g, centerX, polozenieY, new StringBuffer(this.linieTekstu[i]));
            polozenieY += this.renderer.getStringHeight(1);
        }
    }

    public void nextStep() {
        this.czasTutoriala += MyCanvas.intervalTime;
        this.czasEkranu += MyCanvas.intervalTime;
        this.klawiszeObsluga();
    }

    public void klawiszeObsluga() {
        int inputKey = this.canvas.getCurrentKey();
        if (this.canvas.keyUsed || inputKey == 0) {
            return;
        }
        this.canvas.wyczyscKlawisze();
        switch (inputKey) {
            case -6: 
            case -5: 
            case -4: 
            case 53: 
            case 54: {
                ++this.czescBiezaca;
                this.czasEkranu = 0;
                if (this.czescBiezaca < this.liczbaCzesciTutoriala) break;
            }
            case -7: {
                this.canvas.changeGameState(10);
                break;
            }
            case -3: 
            case 52: {
                if (this.czescBiezaca <= 0) break;
                --this.czescBiezaca;
            }
        }
    }
}

