/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.io.DataInputStream;
import math.Math;
import root.Util;
import world.MenadzerRozkladow;
import world.Rozklad;
import world.TerrainTexture;
import world.Tile;

public class TerrainTileMap {
    public byte mapLevels;
    public byte[] terrainHeight;
    public int mapWidth;
    public int mapHeight;
    public int mapHeightMask;
    public int mapWidthMask;
    public int mapSize;
    public int tileWidth;
    public int tileWidthLog;
    public int tileWidthSqr;
    public int tileWidthMask;
    int tileWidthLogM16;
    int tileWidthDiv2;
    int tileWidthLogMinus1;
    private Tile[] localTiles;
    int localX;
    int localY;
    int localWidth;
    int localWidthDiv2;
    int localSize;
    int localSizeDiv2;
    public byte[] terrainDeltaY;
    public byte[] terrainDeltaX;
    public int waterLevel;
    TerrainTexture waterTexture;
    TerrainTexture terrainTexture;
    int textureWidth;
    int textureTilesMask;
    private int freeTilesTableSize = 50;
    private Tile[] freeTilesTable = new Tile[this.freeTilesTableSize];
    private int currentFreeTile = 0;

    public TerrainTileMap(String mapFile, int waterLevel, int tileWidth, boolean loadStaticObjectTable) throws Exception {
        int doOdczytu;
        this.waterLevel = waterLevel;
        this.tileWidth = tileWidth;
        this.tileWidthSqr = tileWidth * tileWidth;
        this.tileWidthLog = Math.log(tileWidth);
        this.tileWidthMask = tileWidth - 1;
        this.tileWidthLogM16 = 16 - this.tileWidthLog;
        this.tileWidthDiv2 = tileWidth >> 1;
        this.tileWidthLogMinus1 = this.tileWidthLog - 1;
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(mapFile));
        this.mapWidth = dis.readShort();
        this.mapHeight = dis.readShort();
        byte liczbaBitowPrzesuniecia = dis.readByte();
        int lengthBits = liczbaBitowPrzesuniecia + 1;
        int heightBits = 8 - lengthBits;
        int heightMask = (1 << heightBits) - 1;
        int lengthMask = (1 << lengthBits) - 1 << heightBits;
        int lengthAdd = 1 << lengthBits;
        this.mapSize = this.mapWidth * this.mapHeight;
        this.mapWidthMask = this.mapWidth - 1;
        this.mapHeightMask = this.mapHeight - 1;
        if (this.tileWidthLog <= 0 || Math.log(this.mapWidth) <= 4 || Math.log(this.mapHeight) <= 4) {
            throw new IllegalArgumentException("non logarithm value");
        }
        this.terrainHeight = new byte[this.mapSize];
        int dlugoscZapisuPowtorzenia = dis.readInt();
        int dlugoscZapisu = dis.readInt();
        byte[] powtorzeniaWysokosc = new byte[dlugoscZapisuPowtorzenia];
        byte[] daneWysokosc = new byte[dlugoscZapisu];
        int odczytano = 0;
        for (doOdczytu = dlugoscZapisuPowtorzenia; doOdczytu > 0; doOdczytu -= odczytano) {
            odczytano = dis.read(powtorzeniaWysokosc, dlugoscZapisuPowtorzenia - doOdczytu, doOdczytu);
        }
        for (doOdczytu = dlugoscZapisu; doOdczytu > 0; doOdczytu -= odczytano) {
            odczytano = dis.read(daneWysokosc, dlugoscZapisu - doOdczytu, doOdczytu);
        }
        int index = 0;
        int liczbaPowtorzen = 0;
        int pol = 0;
        int wysokoscDolna = 10;
        int przedzialLosowania = 128 - waterLevel - wysokoscDolna;
        for (int i = 0; i < dlugoscZapisu; ++i) {
            int height = daneWysokosc[i];
            if ((height & lengthMask) != 0) {
                liczbaPowtorzen = height >> heightBits;
                if (liczbaPowtorzen < 0) {
                    liczbaPowtorzen = (byte)(lengthAdd - liczbaPowtorzen);
                }
                height &= heightMask;
            } else {
                liczbaPowtorzen = powtorzeniaWysokosc[pol++];
            }
            height <<= liczbaBitowPrzesuniecia;
            if ((height -= waterLevel) < 0) {
                height = 0;
            }
            for (int j = 0; j < liczbaPowtorzen; ++j) {
                this.terrainHeight[index++] = (byte)height;
            }
        }
        dis.close();
        this.createDeltaTable();
    }

    public void createDeltaTable() {
        this.terrainDeltaX = new byte[this.mapSize];
        this.terrainDeltaY = new byte[this.mapSize];
        for (int y = 1; y < this.mapHeightMask; ++y) {
            int pointer = y * this.mapWidth + 1;
            int x = 1;
            while (x < this.mapWidthMask) {
                this.terrainDeltaX[pointer] = (byte)(this.terrainHeight[pointer - 1] - this.terrainHeight[pointer + 1] >> 1);
                this.terrainDeltaY[pointer] = (byte)(this.terrainHeight[pointer - this.mapWidth] - this.terrainHeight[pointer + this.mapWidth] >> 1);
                ++x;
                ++pointer;
            }
        }
    }

    public int returnHeightTile16(int xTile16, int yTile16) {
        return this.returnHeight(xTile16 >> this.tileWidthLogM16, yTile16 >> this.tileWidthLogM16);
    }

    public int returnHeight(int xPoints, int yPoints) {
        int localIndex;
        int tileX = xPoints >> this.tileWidthLog;
        int tileY = yPoints >> this.tileWidthLog;
        if (tileX >= this.mapWidth - 1 || tileY >= this.mapHeight - 1 || tileX <= 0 || tileY <= 0) {
            return 128;
        }
        int xTile = xPoints & this.tileWidthMask;
        int yTile = yPoints & this.tileWidthMask;
        int deltaX = tileX - this.localX;
        Tile tile = null;
        if (this.localTiles != null && deltaX > -this.localWidthDiv2 && deltaX < this.localWidthDiv2 && (localIndex = this.localSizeDiv2 + deltaX + this.localWidth * (tileY - this.localY)) >= 0 && localIndex < this.localSize) {
            tile = this.localTiles[localIndex];
        }
        if (tile == null) {
            int tileXPlus = tileX + 1 & this.mapWidthMask;
            int tileYPlus = tileY + 1 & this.mapHeightMask;
            byte height1 = this.terrainHeight[tileX + tileY * this.mapWidth];
            byte height2 = this.terrainHeight[tileXPlus + tileY * this.mapWidth];
            byte height3 = this.terrainHeight[tileX + tileYPlus * this.mapWidth];
            byte height4 = this.terrainHeight[tileXPlus + tileYPlus * this.mapWidth];
            int wsp1 = xTile;
            int wsp2 = yTile;
            int height = (height1 * (this.tileWidth - wsp1) + height2 * wsp1) * (this.tileWidth - wsp2) + (height3 * (this.tileWidth - wsp1) + height4 * wsp1) * wsp2;
            return height >> 2 * this.tileWidthLog;
        }
        return tile.returnHeight(xTile + (yTile << this.tileWidthLog));
    }

    public void setLocalTiles(Tile[] localTiles, int width) {
        this.localTiles = localTiles;
        this.localWidth = width;
        this.localWidthDiv2 = this.localWidth >> 1;
        this.localSize = width * width;
        this.localSizeDiv2 = this.localSize >> 1;
    }

    public void setLocalCenter(int x, int y) {
        this.localX = x;
        this.localY = y;
    }

    public Tile returnTile(int x, int y) {
        int localIndex;
        Tile tile = null;
        int deltaX = this.localX - x;
        if (this.localTiles != null && deltaX > -this.localWidthDiv2 && deltaX < this.localWidthDiv2 && (localIndex = this.localSizeDiv2 + deltaX + this.localWidth * (this.localY - y)) >= 0 && localIndex < this.localSize) {
            tile = this.localTiles[localIndex];
        }
        return tile;
    }

    public void setTexture(TerrainTexture terrainTexture, TerrainTexture waterTexture) throws Exception {
        this.terrainTexture = terrainTexture;
        this.waterTexture = waterTexture;
        this.textureWidth = terrainTexture.textureWidth;
        this.textureTilesMask = this.textureWidth / this.tileWidth - 1;
        if (waterTexture == null) {
            return;
        }
    }

    public void removeTile(Tile tile) {
        if (this.currentFreeTile >= this.freeTilesTableSize) {
            tile.terrainHeight = null;
            tile = null;
            return;
        }
        tile.rozklad = null;
        this.freeTilesTable[this.currentFreeTile++] = tile;
    }

    public Tile createTile(int tileX, int tileY) {
        int x;
        int height;
        int intervalValueTemp;
        int intervalDeltaPrawa;
        int intervalDeltaLewa;
        int deltaSrodka;
        int y;
        Tile tile;
        byte[] heightTable;
        tileX &= this.mapWidthMask;
        tileY &= this.mapHeightMask;
        if (this.currentFreeTile == 0) {
            heightTable = new byte[this.tileWidthSqr];
            tile = new Tile(heightTable, this.tileWidthLog);
        } else {
            tile = this.freeTilesTable[--this.currentFreeTile];
            heightTable = tile.terrainHeight;
        }
        int p1 = tileX + tileY * this.mapWidth;
        int p2 = (tileX + 1 & this.mapWidthMask) + tileY * this.mapWidth;
        int p3 = tileX + (tileY + 1 & this.mapHeightMask) * this.mapWidth;
        int p4 = (tileX + 1 & this.mapWidthMask) + (tileY + 1 & this.mapHeightMask) * this.mapWidth;
        int power = 16 - this.tileWidthLog;
        byte height1 = this.terrainHeight[p1];
        byte height2 = this.terrainHeight[p2];
        byte height3 = this.terrainHeight[p3];
        byte height4 = this.terrainHeight[p4];
        int deltaX1 = this.terrainDeltaX[p1] << power;
        int deltaX2 = this.terrainDeltaX[p2] << power;
        int deltaX3 = this.terrainDeltaX[p3] << power;
        int deltaX4 = this.terrainDeltaX[p4] << power;
        int deltaY1 = this.terrainDeltaY[p1] << power;
        int deltaY2 = this.terrainDeltaY[p2] << power;
        int deltaY3 = this.terrainDeltaY[p3] << power;
        int deltaY4 = this.terrainDeltaY[p4] << power;
        int deltaSrodkaPrawaY = (height2 - height4 << power + 1) - (deltaY2 + deltaY4 >> 1);
        int intervalDeltaDolPrawa = deltaSrodkaPrawaY - deltaY4 >> this.tileWidthLogMinus1;
        int intervalDeltaGoraPrawa = deltaY2 - deltaSrodkaPrawaY >> this.tileWidthLogMinus1;
        int deltaPrawaY = deltaY4;
        int heightP = height4 << 16;
        int deltaSrodkaLewaY = (height1 - height3 << power + 1) - (deltaY1 + deltaY3 >> 1);
        int intervalDeltaDolLewa = deltaSrodkaLewaY - deltaY3 >> this.tileWidthLogMinus1;
        int intervalDeltaGoraLewa = deltaY1 - deltaSrodkaLewaY >> this.tileWidthLogMinus1;
        int deltaLewaY = deltaY3;
        int heightL = height3 << 16;
        int pointer = this.tileWidthSqr - 1;
        int deltaPrawaChange = deltaX2 - deltaX4 >> this.tileWidthLog;
        int deltaLewaChange = deltaX1 - deltaX3 >> this.tileWidthLog;
        int deltaPrawa = deltaX4;
        int deltaLewa = deltaX3;
        for (y = this.tileWidth - 1; y >= this.tileWidthDiv2; --y) {
            deltaSrodka = (heightL - heightP >> this.tileWidthLogMinus1) - (deltaPrawa + deltaLewa >> 1);
            intervalDeltaLewa = deltaSrodka - deltaPrawa >> this.tileWidthLogMinus1;
            intervalDeltaPrawa = deltaLewa - deltaSrodka >> this.tileWidthLogMinus1;
            intervalValueTemp = deltaPrawa;
            height = heightP;
            x = this.tileWidth - 1;
            while (x >= this.tileWidthDiv2) {
                heightTable[pointer] = (byte)(height >> 16);
                --x;
                height += intervalValueTemp;
                --pointer;
                intervalValueTemp += intervalDeltaLewa;
            }
            while (x >= 0) {
                heightTable[pointer] = (byte)(height >> 16);
                --x;
                height += intervalValueTemp;
                --pointer;
                intervalValueTemp += intervalDeltaPrawa;
            }
            deltaLewa += deltaLewaChange;
            deltaPrawa += deltaPrawaChange;
            heightP += deltaPrawaY;
            heightL += deltaLewaY;
            deltaPrawaY += intervalDeltaDolPrawa;
            deltaLewaY += intervalDeltaDolLewa;
        }
        while (y >= 0) {
            deltaSrodka = (heightL - heightP >> this.tileWidthLogMinus1) - (deltaPrawa + deltaLewa >> 1);
            intervalDeltaLewa = deltaSrodka - deltaPrawa >> this.tileWidthLogMinus1;
            intervalDeltaPrawa = deltaLewa - deltaSrodka >> this.tileWidthLogMinus1;
            intervalValueTemp = deltaPrawa;
            height = heightP;
            x = this.tileWidth - 1;
            while (x >= this.tileWidthDiv2) {
                heightTable[pointer] = (byte)(height >> 16);
                --x;
                height += intervalValueTemp;
                --pointer;
                intervalValueTemp += intervalDeltaLewa;
            }
            while (x >= 0) {
                heightTable[pointer] = (byte)(height >> 16);
                --x;
                height += intervalValueTemp;
                --pointer;
                intervalValueTemp += intervalDeltaPrawa;
            }
            deltaLewa += deltaLewaChange;
            deltaPrawa += deltaPrawaChange;
            heightP += deltaPrawaY;
            heightL += deltaLewaY;
            deltaPrawaY += intervalDeltaGoraPrawa;
            deltaLewaY += intervalDeltaGoraLewa;
            --y;
        }
        int t = Util.random(20);
        if (height1 == 0 || height2 == 0 || height3 == 0 || height4 == 0) {
            t = 0;
        }
        if (t >= 6) {
            t = 0;
        }
        tile.rozklad = new Rozklad(tile, MenadzerRozkladow.zwrocRozklad(t));
        return tile;
    }
}

