/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.io.DataInputStream;
import java.io.InputStream;
import jednostki.Jednostka;
import jednostki.JednostkaAktywna;
import jednostki.JednostkaDynamiczna;
import jednostki.Pocisk;
import math.Math;
import root.Kokpit;
import root.Misja;
import root.MyCanvas;
import root.Texts;
import root.Util;
import world.Sprite2D;
import world.TerrainCamera;

public class Trasa {
    byte[] mapaWysokosci;
    int szerokosc;
    int wysokosc = 0;
    public int xStartu;
    public int yStartu;
    public int xKierunkuStartu;
    public int yKierunkuStartu;
    public int xKonca;
    public int yKonca;
    public static int liczbaHelikopterow;
    public static int liczbaStatkow;
    public static int liczbaCzolgow;
    public static int liczbaBeczek;
    public static int liczbaMin;
    public static int liczbaCheckpointow;
    public int[] xCheckpointu;
    public int[] yCheckpointu;
    public int[] odlegloscCheckpointu;
    public int[] stanCheckpointu;
    public int rodzajCeluDodatkowego;
    public int liczbaRakietPoziom;
    public String celMisji;
    public static int xCelu;
    public static int yCelu;
    public static int nrCelu;
    public static int poziomTrudnosci;
    Pocisk[] rakietyWlasne;
    public Jednostka[] beczki;
    public Jednostka[] miny;
    public JednostkaDynamiczna[] helikoptery;
    public JednostkaAktywna[] czolgi;
    public JednostkaAktywna[] statki;
    int liczbaRakietWlasnych;
    public static final byte HELIKOPTER = 1;
    public static final byte CZOLG = 2;
    public static final byte STATEK = 3;
    public static final byte RAKIETA = 4;
    public static final byte EKSPLOZJA = 5;
    public static final byte PALIWO = 6;
    public static final byte MINA = 7;
    public static final byte RAKIETA_WLASNA = 8;
    public static Sprite2D[] sprites;
    MyCanvas canvas;
    public int numerTekstury;
    public int numerGradientuNieba;
    public int kolorDocelowy;
    public int wylosowacTeren;
    public int wspolczynnikWysokosciTerenu;
    public int wysokoscPojazdu;
    public int[] czasP = new int[4];
    public int[] liczbaRakietP = new int[4];
    public String nazwaMapy;
    static short[] katyPoziomHelikopter;
    static short[] katyPoziomRakieta;
    static short[] katyPoziomCzolg;
    static short[] katyPoziomStatek;
    static short[] katyPoziomEksplozja;
    int xPojazdu;
    int yPojazdu;
    int katPojazdu;
    public static int intervalPeriodTime;
    public static int applicationTime;
    public static int czasPoziomu;
    public static int czasMisji;
    int sinusKamery;
    int cosinusKamery;
    TerrainCamera camera;
    public static final int ODLEGLOSC_ZASIEGU = 768000;
    public static final int ODLEGLOSC_ZASIEGU_2 = 1024000;
    public static int helikopteryZniszczone;
    public static int czolgiZniszczone;
    public static int statkiZniszczone;
    public int odlegloscLiniowa;

    /*
     * WARNING - void declaration
     */
    public Trasa(MyCanvas canv, int nrMisji, int poziomTrudnosci) {
        this.canvas = canv;
        Trasa.poziomTrudnosci = poziomTrudnosci;
        applicationTime = MyCanvas.applicationTime;
        try {
            int j;
            short[] tablicaY;
            short[] tablicaX;
            byte parametry;
            int i;
            void var14_16;
            String[] mapaString = Util.getNextValue("nil-01;nil-01;90;200;320;240;140;120;20;20;15;10;0#nil-02;nil-02-02;40;200;240;200;140;120;50;40;35;30;2#nil-02;nil-03-02;40;200;240;200;140;120;40;30;25;20;2#nil-03;nil-04-03;40;200;160;120;100;90;30;30;25;20;0#nil-04;nil-05-04;40;200;300;200;140;120;50;40;35;30;3#nil-04;nil-06-04;40;200;300;200;140;120;50;40;35;30;1#nil-05;nil-07-05;40;200;240;200;140;120;40;30;25;20;1#nil-05;nil-08-05;40;200;240;200;140;120;40;30;25;20;0#nil-06;nil-09-06;40;200;300;200;140;120;40;30;25;20;4#nil-05;nil-10-05;40;200;240;200;140;120;40;30;25;20;0#nil-05;nil-11-05;40;200;90;90;90;90;20;20;15;10;0#nil-07;nil-12-07;40;200;240;200;140;120;40;30;25;20;0#nil-07;nil-13-07;40;200;240;200;140;120;40;30;25;20;0#nil-08;nil-14-08;40;200;200;160;120;100;40;30;25;20;0#nil-07;nil-15-07;40;200;240;200;140;120;40;30;25;20;0#nil-09;nil-16-09;40;200;240;200;140;120;60;50;40;35;0#nil-09;nil-17-09;40;200;240;200;140;120;60;50;40;35;0#nil-10;nil-18-10;40;200;160;140;120;100;50;40;35;30;0#nil-11;nil-19-11;40;200;330;300;240;200;100;80;65;50;0#", '#');
            String[] mapaStr = nrMisji >= mapaString.length - 1 ? Util.getNextValue(mapaString[0], ';') : Util.getNextValue(mapaString[nrMisji], ';');
            mapaString = null;
            int pozycja = 0;
            this.nazwaMapy = "/" + mapaStr[pozycja++] + ".hei";
            String nazwaTrasy = "/" + mapaStr[pozycja++] + ".chk";
            this.wysokoscPojazdu = Util.stringToInt(mapaStr[pozycja++]) + 24;
            this.wspolczynnikWysokosciTerenu = Util.stringToInt(mapaStr[pozycja++]);
            this.czasP[0] = Util.stringToInt(mapaStr[pozycja++]);
            this.czasP[1] = Util.stringToInt(mapaStr[pozycja++]);
            this.czasP[2] = Util.stringToInt(mapaStr[pozycja++]);
            this.czasP[3] = Util.stringToInt(mapaStr[pozycja++]);
            this.liczbaRakietP[0] = Util.stringToInt(mapaStr[pozycja++]);
            this.liczbaRakietP[1] = Util.stringToInt(mapaStr[pozycja++]);
            this.liczbaRakietP[2] = Util.stringToInt(mapaStr[pozycja++]);
            this.liczbaRakietP[3] = Util.stringToInt(mapaStr[pozycja++]);
            this.rodzajCeluDodatkowego = Util.stringToInt(mapaStr[pozycja++]);
            short x = 0;
            short y = 0;
            InputStream is = this.getClass().getResourceAsStream(nazwaTrasy);
            DataInputStream dis = new DataInputStream(is);
            dis.readShort();
            dis.readShort();
            int potega = 2;
            this.xStartu = dis.readShort() << potega;
            this.yStartu = dis.readShort() << potega;
            this.xKierunkuStartu = dis.readShort() << potega;
            this.yKierunkuStartu = dis.readShort() << potega;
            this.xKonca = dis.readShort() << potega;
            this.yKonca = dis.readShort() << potega;
            liczbaCheckpointow = dis.readByte() + 1;
            this.xCheckpointu = new int[liczbaCheckpointow];
            this.yCheckpointu = new int[liczbaCheckpointow];
            this.odlegloscCheckpointu = new int[liczbaCheckpointow];
            this.stanCheckpointu = new int[liczbaCheckpointow];
            int odlCheckpointu = 6400;
            boolean bl = false;
            while (var14_16 < liczbaCheckpointow - 1) {
                this.xCheckpointu[var14_16] = dis.readShort() << potega;
                this.yCheckpointu[var14_16] = dis.readShort() << potega;
                this.odlegloscCheckpointu[var14_16] = odlCheckpointu;
                ++var14_16;
            }
            this.xCheckpointu[Trasa.liczbaCheckpointow - 1] = this.xKonca;
            this.yCheckpointu[Trasa.liczbaCheckpointow - 1] = this.yKonca;
            this.odlegloscCheckpointu[Trasa.liczbaCheckpointow - 1] = odlCheckpointu;
            xCelu = this.xCheckpointu[0];
            yCelu = this.yCheckpointu[0];
            this.stanCheckpointu[0] = 1;
            nrCelu = 0;
            this.celMisji = Texts.MISSION_STRING[nrMisji];
            liczbaHelikopterow = dis.readByte();
            helikopteryZniszczone = 0;
            this.helikoptery = new JednostkaDynamiczna[liczbaHelikopterow];
            for (i = 0; i < liczbaHelikopterow; ++i) {
                int n = dis.readByte();
                parametry = dis.readByte();
                tablicaX = new short[n];
                tablicaY = new short[n];
                for (j = 0; j < n; ++j) {
                    tablicaX[j] = (short)(dis.readShort() << potega);
                    tablicaY[j] = (short)(dis.readShort() << potega);
                }
                this.helikoptery[i] = new JednostkaDynamiczna((byte)n, tablicaX, tablicaY, 8192, 7, this.wysokoscPojazdu, parametry);
            }
            liczbaCzolgow = dis.readByte();
            czolgiZniszczone = 0;
            this.czolgi = new JednostkaAktywna[liczbaCzolgow];
            for (i = 0; i < liczbaCzolgow; ++i) {
                byte by = dis.readByte();
                parametry = dis.readByte();
                tablicaX = new short[by];
                tablicaY = new short[by];
                for (j = 0; j < by; ++j) {
                    tablicaX[j] = (short)(dis.readShort() << potega);
                    tablicaY[j] = (short)(dis.readShort() << potega);
                }
                this.czolgi[i] = new JednostkaAktywna(by, tablicaX, tablicaY, 0);
            }
            liczbaStatkow = dis.readByte();
            statkiZniszczone = 0;
            this.statki = new JednostkaAktywna[liczbaStatkow];
            for (i = 0; i < liczbaStatkow; ++i) {
                byte by = dis.readByte();
                parametry = dis.readByte();
                tablicaX = new short[by];
                tablicaY = new short[by];
                for (j = 0; j < by; ++j) {
                    tablicaX[j] = (short)(dis.readShort() << potega);
                    tablicaY[j] = (short)(dis.readShort() << potega);
                }
                this.statki[i] = new JednostkaAktywna(by, tablicaX, tablicaY, 0);
            }
            liczbaBeczek = dis.readShort();
            this.beczki = new Jednostka[liczbaBeczek];
            for (i = 0; i < liczbaBeczek; ++i) {
                x = (short)(dis.readShort() << potega);
                y = (short)(dis.readShort() << potega);
                this.beczki[i] = new Jednostka(x, y, this.wysokoscPojazdu);
            }
            liczbaMin = 0;
            liczbaMin = dis.readShort();
            this.miny = new Jednostka[liczbaMin];
            for (i = 0; i < liczbaMin; ++i) {
                x = (short)(dis.readShort() << potega);
                y = (short)(dis.readShort() << potega);
                this.miny[i] = new Jednostka(x, y, this.wysokoscPojazdu);
            }
            this.ustawPoziom();
            czasMisji = 0;
            Kokpit.firstLoop = true;
        }
        catch (Exception e) {
            Util.critical(e, "wczytywanie trasy z obiektami");
        }
    }

    public static void stworzPotrzebneObiekty() {
        try {
            Trasa.sprites[1] = new Sprite2D("/mi24.sprite", 50, katyPoziomHelikopter, null, true, false);
            Trasa.sprites[3] = new Sprite2D("/boat.sprite", 75, katyPoziomStatek, null, true, false);
            Trasa.sprites[2] = new Sprite2D("/tank.sprite", 50, katyPoziomCzolg, null, true, false);
            Trasa.sprites[5] = new Sprite2D("/blowsmoke.sprite", 70, katyPoziomEksplozja, null, true, false);
            Trasa.sprites[4] = new Sprite2D("/rakieta.sprite", 20, katyPoziomRakieta, null, true, false);
            Trasa.sprites[8] = sprites[4];
            Trasa.sprites[6] = new Sprite2D("/beczka.sprite", 40, null, null, true, false);
            Trasa.sprites[7] = new Sprite2D("/mina.sprite", 40, null, null, true, false);
        }
        catch (Exception e) {
            Util.critical(e, "creating sprites");
        }
    }

    public void narysujObiekty(TerrainCamera camera, int xP, int yP, int katP) throws Exception {
        int liczbaPociskow;
        int i;
        int nrPocisku;
        Pocisk[] pociski;
        int odleglosc;
        Jednostka jednostka;
        int i2;
        this.camera = camera;
        this.cosinusKamery = Math.cos(90 - katP);
        this.sinusKamery = Math.sin(90 - katP);
        intervalPeriodTime = MyCanvas.applicationTime - applicationTime;
        if (intervalPeriodTime > 200) {
            intervalPeriodTime = 200;
        }
        if (intervalPeriodTime < 1) {
            intervalPeriodTime = 1;
        }
        applicationTime = MyCanvas.applicationTime;
        czasPoziomu -= intervalPeriodTime;
        czasMisji += intervalPeriodTime;
        this.rakietyWlasne = MyCanvas.pojazd.zwrocRakiety();
        this.liczbaRakietWlasnych = this.rakietyWlasne == null ? 0 : this.rakietyWlasne.length;
        this.xPojazdu = xP;
        this.yPojazdu = yP;
        this.katPojazdu = katP;
        for (i2 = 0; i2 < liczbaBeczek; ++i2) {
            jednostka = this.beczki[i2];
            if (jednostka == null) continue;
            if (jednostka.stanJednostki == -3) {
                this.beczki[i2] = null;
                continue;
            }
            jednostka.ustawStanJednostki(intervalPeriodTime, 0);
            odleglosc = this.wyliczJednostke(jednostka, 6, camera);
            if (odleglosc >= 768000) continue;
            this.detekcjeKolizjiRakieta(jednostka);
        }
        for (i2 = 0; i2 < liczbaMin; ++i2) {
            jednostka = this.miny[i2];
            if (jednostka == null) continue;
            if (jednostka.stanJednostki == -3) {
                this.miny[i2] = null;
                continue;
            }
            jednostka.ustawStanJednostki(intervalPeriodTime, 0);
            odleglosc = this.wyliczJednostke(jednostka, 7, camera);
            if (odleglosc >= 768000) continue;
            this.detekcjeKolizjiRakieta(jednostka);
        }
        for (int i3 = 0; i3 < liczbaHelikopterow; ++i3) {
            JednostkaDynamiczna jednostkaDynamiczna = this.helikoptery[i3];
            if (jednostkaDynamiczna == null) continue;
            if (jednostkaDynamiczna.stanJednostki == -3) {
                this.helikoptery[i3] = null;
                continue;
            }
            jednostkaDynamiczna.ustawPolozenieDynamiczna(applicationTime, intervalPeriodTime);
            odleglosc = this.wyliczJednostke(jednostkaDynamiczna, 1, camera);
            if (odleglosc >= 1024000) continue;
            if (jednostkaDynamiczna.stanJednostki != -2) {
                this.detekcjeKolizjiRakieta(jednostkaDynamiczna);
            }
            if ((pociski = jednostkaDynamiczna.zwrocRakiety()) == null) continue;
            int liczbaPociskow2 = pociski.length;
            for (nrPocisku = 0; nrPocisku < liczbaPociskow2; ++nrPocisku) {
                odleglosc = this.wyliczJednostke(pociski[nrPocisku], 4, camera);
                if (odleglosc >= 768000) continue;
                this.detekcjeKolizjiRakieta(pociski[nrPocisku]);
            }
        }
        for (i = 0; i < liczbaCzolgow; ++i) {
            JednostkaAktywna jednostkaAktywna = this.czolgi[i];
            if (jednostkaAktywna == null) continue;
            if (jednostkaAktywna.stanJednostki == -3) {
                this.czolgi[i] = null;
                continue;
            }
            jednostkaAktywna.ustawPolozenie(applicationTime, intervalPeriodTime, false);
            odleglosc = this.wyliczJednostke(jednostkaAktywna, 2, camera);
            if (odleglosc >= 1024000) continue;
            if (jednostkaAktywna.stanJednostki != -2) {
                this.detekcjeKolizjiRakieta(jednostkaAktywna);
            }
            if ((pociski = jednostkaAktywna.zwrocRakiety()) == null) continue;
            liczbaPociskow = pociski.length;
            for (nrPocisku = 0; nrPocisku < liczbaPociskow; ++nrPocisku) {
                odleglosc = this.wyliczJednostke(pociski[nrPocisku], 4, camera);
                if (odleglosc >= 768000) continue;
                this.detekcjeKolizjiRakieta(pociski[nrPocisku]);
            }
        }
        for (i = 0; i < liczbaStatkow; ++i) {
            JednostkaAktywna jednostkaAktywna = this.statki[i];
            if (jednostkaAktywna == null) continue;
            if (jednostkaAktywna.stanJednostki == -3) {
                this.statki[i] = null;
                continue;
            }
            jednostkaAktywna.ustawPolozenie(applicationTime, intervalPeriodTime, false);
            odleglosc = this.wyliczJednostke(jednostkaAktywna, 3, camera);
            if (odleglosc >= 1024000) continue;
            if (jednostkaAktywna.stanJednostki != -2) {
                this.detekcjeKolizjiRakieta(jednostkaAktywna);
            }
            if ((pociski = jednostkaAktywna.zwrocRakiety()) == null) continue;
            liczbaPociskow = pociski.length;
            for (nrPocisku = 0; nrPocisku < liczbaPociskow; ++nrPocisku) {
                odleglosc = this.wyliczJednostke(pociski[nrPocisku], 4, camera);
                if (odleglosc >= 768000) continue;
                this.detekcjeKolizjiRakieta(pociski[nrPocisku]);
            }
        }
        for (i = 0; i < this.liczbaRakietWlasnych; ++i) {
            jednostka = this.rakietyWlasne[i];
            odleglosc = this.wyliczJednostke(jednostka, 8, camera);
        }
        int klatkaWybuchu = MyCanvas.pojazd.wybuchPojazd();
        if (klatkaWybuchu >= 0) {
            camera.narysujObiekt(sprites[5], 5, MyCanvas.maxX >> 1, MyCanvas.pojazd.wysokosc, 10 * klatkaWybuchu);
        }
    }

    public void uzupelnijWysokosci() {
        int i;
        for (i = 0; i < liczbaCzolgow; ++i) {
            this.czolgi[i].wysokosc = MyCanvas.mapa.returnHeight(this.czolgi[i].x, this.czolgi[i].y) + 5;
        }
        for (i = 0; i < liczbaStatkow; ++i) {
            this.statki[i].wysokosc = MyCanvas.mapa.waterLevel + 2;
        }
    }

    public int wyliczJednostke(Jednostka jednostka, int rodzajJednostki, TerrainCamera camera) throws Exception {
        int deltaX = jednostka.x - this.xPojazdu;
        int deltaY = jednostka.y - this.yPojazdu;
        int odlegloscK = deltaX * deltaX + deltaY * deltaY << 4;
        if (odlegloscK >= 768000 || odlegloscK < 0) {
            return odlegloscK;
        }
        if (jednostka.stanJednostki == -2) {
            return odlegloscK;
        }
        int katPoziom = Math.arcTg(deltaX, deltaY);
        int odlegloscKolizji = 384 + 1024;
        if (odlegloscK < odlegloscKolizji && rodzajJednostki != 8) {
            int roznicaKatow = katPoziom - this.katPojazdu;
            MyCanvas.pojazd.kolizja(rodzajJednostki, jednostka, (odlegloscK << 8) / odlegloscKolizji, roznicaKatow);
        }
        int xWspolrzedneKamery = deltaY * this.sinusKamery + deltaX * this.cosinusKamery;
        int yWspolrzedneKamery = -(deltaY * this.cosinusKamery - deltaX * this.sinusKamery);
        int slice = yWspolrzedneKamery >> 10;
        if (slice <= 6 || slice >= camera.maxSlice) {
            return odlegloscK;
        }
        int promien = (xWspolrzedneKamery * camera.sliceRayFactor[slice] >> 18) + camera.renderWidthDiv2;
        if (promien < -camera.renderWidthDiv2 || promien > camera.renderWidth3Div2) {
            return odlegloscK;
        }
        if (jednostka.stanJednostki == 1 || jednostka.stanJednostki == -1 && rodzajJednostki != 4 && rodzajJednostki != 8 && jednostka.klatkaWybuchu <= 8) {
            int katR = rodzajJednostki == 3 ? -(jednostka.kat - katPoziom) : (rodzajJednostki == 4 || rodzajJednostki == 8 ? jednostka.kat - katPoziom : 180 - (katPoziom - jednostka.kat));
            camera.narysujObiekt(sprites[rodzajJednostki], slice, promien, jednostka.wysokosc, katR);
        }
        if (jednostka.stanJednostki == -1) {
            camera.narysujObiekt(sprites[5], slice - 1, promien, jednostka.wysokosc, 10 * jednostka.klatkaWybuchu);
        }
        return odlegloscK;
    }

    public void detekcjeKolizjiRakieta(Jednostka jednostka) {
        if (this.liczbaRakietWlasnych == 0) {
            return;
        }
        for (int i = 0; i < this.liczbaRakietWlasnych; ++i) {
            Pocisk rakieta = this.rakietyWlasne[i];
            int deltaX = rakieta.x - jednostka.x;
            int deltaY = rakieta.y - jednostka.y;
            int odleglosc = deltaX * deltaX + deltaY * deltaY << 2;
            int odlegloscKolizji = 1024 + 1024;
            if (odleglosc >= odlegloscKolizji) continue;
            rakieta.wybuch();
            jednostka.trafienieRakieta();
        }
    }

    public void wyliczZniszczenia() {
        int i;
        helikopteryZniszczone = 0;
        czolgiZniszczone = 0;
        statkiZniszczone = 0;
        for (i = 0; i < liczbaHelikopterow; ++i) {
            if (this.helikoptery[i] != null && this.helikoptery[i].stanJednostki == 1) continue;
            ++helikopteryZniszczone;
        }
        for (i = 0; i < liczbaCzolgow; ++i) {
            if (this.czolgi[i] != null && this.czolgi[i].stanJednostki == 1) continue;
            ++czolgiZniszczone;
        }
        for (i = 0; i < liczbaStatkow; ++i) {
            if (this.statki[i] != null && this.statki[i].stanJednostki == 1) continue;
            ++statkiZniszczone;
        }
    }

    public void ustawPoziom() {
        czasPoziomu = this.czasP[poziomTrudnosci] * 1000;
        this.liczbaRakietPoziom = this.liczbaRakietP[poziomTrudnosci];
    }

    public void zwolnijZasoby() {
        int i;
        for (i = 0; i < liczbaHelikopterow; ++i) {
            this.helikoptery[i].zwolnijZasoby();
        }
        this.helikoptery = null;
        liczbaHelikopterow = 0;
        for (i = 0; i < liczbaCzolgow; ++i) {
            this.czolgi[i].zwolnijZasoby();
        }
        this.czolgi = null;
        liczbaCzolgow = 0;
        for (i = 0; i < liczbaStatkow; ++i) {
            this.statki[i].zwolnijZasoby();
        }
        this.statki = null;
        liczbaStatkow = 0;
        this.rakietyWlasne = null;
        this.liczbaRakietWlasnych = 0;
        this.beczki = null;
        liczbaBeczek = 0;
        this.miny = null;
        liczbaMin = 0;
    }

    public int sprawdzCel(int x, int y) {
        int deltaX = x - xCelu >> 2;
        int deltaY = y - yCelu >> 2;
        int odleglosc = deltaX * deltaX + deltaY * deltaY << 4;
        this.odlegloscLiniowa = deltaX < 0 ? -deltaX : deltaX;
        this.odlegloscLiniowa = deltaY < 0 ? (this.odlegloscLiniowa -= deltaY) : (this.odlegloscLiniowa += deltaY);
        if (nrCelu == liczbaCheckpointow) {
            Misja cfr_ignored_0 = this.canvas.misja;
            if (!Misja.celOsiagniety && odleglosc < this.odlegloscCheckpointu[nrCelu - 1]) {
                MyCanvas.wstawInformacje(Texts.FINISH_MISSION, 2000, 0, 0, true);
            }
        }
        if (nrCelu < liczbaCheckpointow && odleglosc < this.odlegloscCheckpointu[nrCelu]) {
            if (!MyCanvas.pojazd.zniszczony) {
                this.stanCheckpointu[Trasa.nrCelu] = 2;
                if (++nrCelu >= liczbaCheckpointow) {
                    return odleglosc;
                }
                this.stanCheckpointu[Trasa.nrCelu] = 1;
                xCelu = this.xCheckpointu[nrCelu];
                yCelu = this.yCheckpointu[nrCelu];
                deltaX = x - xCelu;
                deltaY = y - yCelu;
                odleglosc = deltaX * deltaX + deltaY * deltaY << 4;
                MyCanvas.wstawInformacje(Texts.CHECKPOINT_STRING + nrCelu, 2000, 0, 0xCCFF99, false);
            }
        }
        if (this.canvas.misja.wyliczWynik() && nrCelu >= liczbaCheckpointow) {
            if (Misja.nrMisji >= Misja.wczytanyNrMisji) {
                this.canvas.misja.zapiszMisje(0);
            }
            this.canvas.misja.gratulacje();
        }
        return odleglosc;
    }

    public void noweZycie() {
        int i;
        for (i = 0; i < liczbaCzolgow; ++i) {
            if (this.czolgi[i] == null) continue;
            this.czolgi[i].zniszczRakiety();
            if (this.czolgi[i].stanJednostki == 1) continue;
            this.czolgi[i] = null;
        }
        for (i = 0; i < liczbaHelikopterow; ++i) {
            if (this.helikoptery[i] == null) continue;
            this.helikoptery[i].zniszczRakiety();
            if (this.helikoptery[i].stanJednostki == 1) continue;
            this.helikoptery[i] = null;
        }
        for (i = 0; i < liczbaStatkow; ++i) {
            if (this.statki[i] == null) continue;
            this.statki[i].zniszczRakiety();
            if (this.statki[i].stanJednostki == 1) continue;
            this.statki[i] = null;
        }
        for (i = 0; i < liczbaMin; ++i) {
            if (this.miny[i] == null || this.miny[i].stanJednostki == 1) continue;
            this.miny[i] = null;
        }
        this.ustawPoziom();
    }

    static {
        sprites = new Sprite2D[9];
        katyPoziomHelikopter = new short[]{0, 30, 70, 110, 150, 180};
        katyPoziomRakieta = new short[]{10, 35, 60, 90, 110, 140, 165};
        katyPoziomCzolg = new short[]{10, 35, 60, 110};
        katyPoziomStatek = new short[]{10, 35, 60, 90, 110, 140, 165};
        katyPoziomEksplozja = new short[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90};
        helikopteryZniszczone = 0;
        czolgiZniszczone = 0;
        statkiZniszczone = 0;
    }
}

