/*
 * Decompiled with CFR 0.152.
 */
package math;

public class Math {
    int precyzjaWartosci;
    public static short[] sinTablica = new short[]{0, 17, 36, 53, 72, 89, 108, 125, 142, 160, 178, 196, 213, 225, 248, 265, 283, 299, 316, 334, 350, 366, 384, 400, 417, 433, 448, 465, 480, 495, 512, 527, 543, 558, 572, 588, 602, 616, 631, 644, 658, 672, 685, 698, 712, 724, 736, 748, 761, 773, 784, 795, 807, 818, 828, 838, 849, 859, 868, 877, 887, 896, 904, 912, 920, 928, 935, 942, 949, 956, 962, 968, 974, 979, 984, 989, 993, 997, 1001, 1005, 1008, 1012, 1014, 1017, 1019, 1020, 1022, 1023, 1023, 1024, 1024};
    public static short[] arcTgTablica = new short[257];
    public static short[] sin360;
    public static short[] cos360;
    public static int[] tg360;

    public Math() {
        Math.stworzTablice360();
        Math.przygotujArcTg();
    }

    private static void stworzTablice360() {
        sin360 = new short[360];
        cos360 = new short[360];
        tg360 = new int[360];
        for (int kat = 0; kat < 360; ++kat) {
            int sin = Math.sinPomocniczy(kat);
            int cos = Math.cosPomocniczy(kat);
            int tg = cos == 0 ? sin << 10 : (sin << 10) / cos;
            Math.sin360[kat] = (short)sin;
            Math.cos360[kat] = (short)cos;
            Math.tg360[kat] = tg;
        }
    }

    public static void przygotujArcTg() {
        int obecnyKat = 0;
        int wartosc = Math.tg(0);
        for (int i = 0; i <= 256; ++i) {
            if (wartosc < i) {
                obecnyKat = (short)(obecnyKat + 1);
                wartosc = Math.tg(obecnyKat) >> 2;
            }
            Math.arcTgTablica[i] = obecnyKat;
        }
    }

    public static int sin(int kat) {
        while (kat < 0) {
            kat += 360;
        }
        return sin360[kat %= 360];
    }

    public static int cos(int kat) {
        while (kat < 0) {
            kat += 360;
        }
        return cos360[kat %= 360];
    }

    public static int tg(int kat) {
        while (kat < 0) {
            kat += 360;
        }
        return tg360[kat %= 360];
    }

    private static int sinPomocniczy(int kat) {
        if (kat > 270) {
            return -sinTablica[90 - (kat - 270)];
        }
        if (kat > 180) {
            return -sinTablica[kat - 180];
        }
        if (kat > 90) {
            return sinTablica[90 - (kat - 90)];
        }
        return sinTablica[kat];
    }

    private static int cosPomocniczy(int kat) {
        if (kat > 270) {
            return sinTablica[kat - 270];
        }
        if (kat > 180) {
            return -sinTablica[90 - (kat - 180)];
        }
        if (kat > 90) {
            return -sinTablica[kat - 90];
        }
        return sinTablica[90 - kat];
    }

    public static int arcTg(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return 0;
        }
        int kat = deltaY <= 0 ? (deltaX > 0 ? (deltaX >= -deltaY ? arcTgTablica[(-deltaY << 8) / deltaX] : 90 - arcTgTablica[(deltaX << 8) / -deltaY]) : (deltaX <= deltaY ? 180 - arcTgTablica[(deltaY << 8) / deltaX] : 90 + arcTgTablica[(deltaX << 8) / deltaY])) : (deltaX >= 0 ? (deltaX > deltaY ? 360 - arcTgTablica[(deltaY << 8) / deltaX] : 270 + arcTgTablica[(deltaX << 8) / deltaY]) : (-deltaX >= deltaY ? 180 + arcTgTablica[(deltaY << 8) / -deltaX] : 270 - arcTgTablica[(-deltaX << 8) / deltaY]));
        if (kat == 360) {
            kat = 0;
        }
        return kat;
    }

    public static int log(int liczba) {
        int potega;
        if (liczba == 0) {
            return 0;
        }
        int maska = 1;
        for (potega = 0; potega < 32 && liczba != maska; maska <<= 1, ++potega) {
        }
        if (potega == 32) {
            return -1;
        }
        return potega;
    }
}

