/*
 * Decompiled with CFR 0.152.
 */
package root;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.Element;
import menu.MyMenu2;
import root.HiScores;
import root.MyCanvas;
import root.Pojazd;
import root.Properties;
import root.TextRenderer;
import root.Texts;
import root.Util;
import root.UtilGraphics;
import world.Trasa;

public class Misja {
    public static final byte EKRAN_WSTEPNY = 1;
    public static final byte EKRAN_KONCOWY_GRATULACJE = 3;
    public static final byte EKRAN_KONCOWY_GAMEOVER = 4;
    public static final byte EKRAN_DESTROYED = 8;
    public static final byte PROPOZYCJA_TUTORIALU = 10;
    public static final byte EKRAN_KONCOWY_KAMPANIA = 11;
    public static byte stanMisji;
    public static byte nrStronyEkranuWstepnego;
    public static byte rodzajEkranuKoncowego;
    public boolean kampania;
    public boolean ostatniaMisjaZakonczona;
    public boolean mapaWstepnaWyliczona;
    public boolean trzebaRysowac;
    public static final byte NASTEPNA_MISJA = 0;
    public static final byte ZAPISZ_KAMPANIE = 1;
    public static final byte POWTORZ_MISJE = 2;
    public static final byte POWROT_DO_MENU = 3;
    public static byte aktywnyWyborKampania;
    public static int nrMisji;
    public static int wczytanyNrMisji;
    String nazwaMisji;
    String celMisji;
    public String[] nazwyMisji;
    public String[] nazwyMisjiNumer;
    MyCanvas canvas;
    public Image imageStart;
    public Image softImg;
    public Image imageGameOver;
    public Image imageMapMenuNapis;
    public Image imageNapisy;
    public static Image[] imageCheckpointy;
    int napisyHeight;
    int napisyWidth;
    public static final int liczbaNapisow = 7;
    int[] xButonu = new int[]{10, 10, 10, 10};
    int[] yButonu = new int[]{29, 52, 75, 115};
    public int liczbaZyc;
    public int liczbaZycStraconych;
    public int liczbaPunktowKampania;
    public int liczbaPunktow;
    public int poziomTrudnosci;
    int liczbaPunktowJednostki;
    int liczbaPunktowCzas;
    int liczbaPunktowUszkodzenia;
    int liczbaPunktowTarget;
    String stringCzas;
    int miejsceKampania;
    int nrStronyGratulacje;
    public static boolean celOsiagniety;
    private TextRenderer renderer;
    int[] secondaryTarget;
    int[] secondaryTargetPoints;
    int[] mnoznikTimeBonus;
    int pozycjaTekstu;
    int liczbaLiniiTekstu;
    int liczbaRysowanychLinii;
    String[] tablicaLiniiTekstu;
    public static final int kolorSoftkeyLabels = 0xDDDDEE;

    public Misja(MyCanvas canv) {
        this.canvas = canv;
        this.renderer = TextRenderer.getInstance();
        try {
            String[] mString = Util.getNextValue(Texts.MISSION_TEXT, '#');
            MyCanvas.liczbaMisji = Util.stringToInt(mString[0]);
            this.nazwyMisji = new String[MyCanvas.liczbaMisji];
            this.nazwyMisjiNumer = new String[MyCanvas.liczbaMisji];
            this.secondaryTarget = new int[MyCanvas.liczbaMisji];
            this.secondaryTargetPoints = new int[MyCanvas.liczbaMisji];
            this.mnoznikTimeBonus = new int[MyCanvas.liczbaMisji];
            for (int i = 0; i < MyCanvas.liczbaMisji; ++i) {
                this.nazwyMisji[i] = mString[4 * i + 1];
                this.nazwyMisjiNumer[i] = this.nazwyMisji[i] + " (" + (i + 1) + ")";
                this.secondaryTarget[i] = Util.stringToInt(mString[4 * i + 2]);
                this.secondaryTargetPoints[i] = Util.stringToInt(mString[4 * i + 3]);
                this.mnoznikTimeBonus[i] = Util.stringToInt(mString[4 * i + 4]);
            }
            this.softImg = Image.createImage((String)"/softy.png");
            this.imageStart = Image.createImage((String)"/start.png");
            imageCheckpointy = UtilGraphics.loadImageTable("/check.png", 9, 3);
            this.imageGameOver = Image.createImage((String)"/over.jpg");
        }
        catch (Exception e) {
            Util.critical(e, "Misja");
        }
    }

    public void loadMissionNames() {
        String[] mString = Util.getNextValue(Texts.MISSION_TEXT, '#');
        for (int i = 0; i < MyCanvas.liczbaMisji; ++i) {
            this.nazwyMisji[i] = mString[4 * i + 1];
            System.out.println("laduje: " + this.nazwyMisji[i]);
        }
        mString = null;
    }

    public void rozpocznijMisje(int nrMisji, boolean kampania, int poziom, int liczbaZyc, int liczbaP) {
        this.poziomTrudnosci = poziom;
        this.nazwaMisji = this.nazwyMisji[nrMisji];
        this.celMisji = MyCanvas.trasa.celMisji;
        this.kampania = kampania;
        Misja.nrMisji = nrMisji;
        this.trzebaRysowac = true;
        this.mapaWstepnaWyliczona = false;
        nrStronyEkranuWstepnego = 0;
        this.liczbaZyc = liczbaZyc;
        this.liczbaPunktowKampania = liczbaP;
        this.liczbaPunktow = 0;
        this.liczbaZycStraconych = 0;
        this.canvas.wyczyscKlawisze();
        if (this.canvas.zaproponowacTutorial == 1) {
            this.ustawTekstEkranu(Texts.TUTORIAL_QUESTION);
            this.canvas.zaproponowacTutorial = 0;
            stanMisji = (byte)10;
            return;
        }
        this.wstawTekstOpisuMisji();
        stanMisji = 1;
    }

    public void wstawTekstOpisuMisji() {
        String sb = Texts.MISSION + " ";
        sb = nrMisji < 9 ? sb + "0" + (nrMisji + 1) : sb + (nrMisji + 1);
        sb = sb + "\n" + this.nazwaMisji;
        sb = sb + "\n\n" + Texts.TARGETS;
        sb = sb + ":\n" + this.celMisji;
        this.ustawTekstEkranu(sb);
    }

    public void gameOver() {
        this.canvas.wyczyscKlawisze();
        this.canvas.blokujKlawisze(500);
        if (this.liczbaZyc > 1) {
            --this.liczbaZyc;
            ++this.liczbaZycStraconych;
            this.canvas.kontynujMisje();
            stanMisji = (byte)8;
            this.canvas.changeGameState(200);
        } else {
            this.ostatniaMisjaZakonczona = false;
            aktywnyWyborKampania = (byte)2;
            stanMisji = (byte)4;
            this.canvas.changeGameState(200);
        }
    }

    public boolean wyliczWynik() {
        int liczbaJednostekZniszczonych = 0;
        int liczbaWszystkichJednostek = 0;
        int procent = 0;
        MyCanvas.trasa.wyliczZniszczenia();
        switch (this.secondaryTarget[nrMisji]) {
            case 1: {
                liczbaJednostekZniszczonych = Trasa.helikopteryZniszczone + Trasa.czolgiZniszczone + Trasa.statkiZniszczone;
                liczbaWszystkichJednostek = Trasa.liczbaHelikopterow + Trasa.liczbaCzolgow + Trasa.liczbaStatkow;
                procent = liczbaJednostekZniszczonych * 100 / liczbaWszystkichJednostek;
                break;
            }
            case 2: {
                liczbaJednostekZniszczonych = Trasa.statkiZniszczone;
                liczbaWszystkichJednostek = Trasa.liczbaStatkow;
                procent = liczbaJednostekZniszczonych * 100 / liczbaWszystkichJednostek;
                break;
            }
            case 3: {
                liczbaJednostekZniszczonych = Trasa.czolgiZniszczone;
                liczbaWszystkichJednostek = Trasa.liczbaCzolgow;
                procent = liczbaJednostekZniszczonych * 100 / liczbaWszystkichJednostek;
                break;
            }
            case 4: {
                liczbaJednostekZniszczonych = Trasa.helikopteryZniszczone;
                liczbaWszystkichJednostek = Trasa.liczbaHelikopterow;
                procent = liczbaJednostekZniszczonych * 100 / liczbaWszystkichJednostek;
            }
        }
        celOsiagniety = this.secondaryTarget[nrMisji] != 0 && procent >= 80;
        if (this.secondaryTarget[nrMisji] == 0) {
            celOsiagniety = true;
        }
        return celOsiagniety;
    }

    public void gratulacje() {
        this.canvas.wyczyscKlawisze();
        this.canvas.blokujKlawisze(500);
        MyCanvas.trasa.wyliczZniszczenia();
        aktywnyWyborKampania = 0;
        stanMisji = (byte)3;
        this.canvas.changeGameState(200);
        this.liczbaPunktowJednostki = Trasa.helikopteryZniszczone * 10 + Trasa.czolgiZniszczone * 10 + Trasa.statkiZniszczone * 20;
        this.liczbaPunktowCzas = (MyCanvas.trasa.czasP[this.poziomTrudnosci] - Trasa.czasMisji / 1000) * this.mnoznikTimeBonus[nrMisji] / 10;
        if (this.liczbaPunktowCzas < 0) {
            this.liczbaPunktowCzas = 0;
        }
        this.liczbaPunktowUszkodzenia = this.liczbaZycStraconych * 100;
        for (int i = 0; i < 4; ++i) {
            this.liczbaPunktowUszkodzenia += Pojazd.stanPojazdu[i] * 10;
        }
        int wspolczynnikMnozenia = (this.poziomTrudnosci + 1) * 10 >> 1;
        this.wyliczWynik();
        this.liczbaPunktow = (this.liczbaPunktowJednostki + this.liczbaPunktowCzas + -this.liczbaPunktowUszkodzenia) * wspolczynnikMnozenia / 10;
        this.canvas.hiScores.sprawdzWynik(false, nrMisji, this.liczbaPunktow);
        int czasMisji = Trasa.czasMisji / 1000;
        int liczbaMinut = czasMisji / 60;
        int liczbaSekund = czasMisji - liczbaMinut * 60;
        this.stringCzas = liczbaSekund < 10 ? liczbaMinut + ":0" + liczbaSekund : liczbaMinut + ":" + liczbaSekund;
        if (this.kampania && nrMisji == MyCanvas.liczbaMisji - 1) {
            this.miejsceKampania = this.canvas.hiScores.sprawdzWynik(true, this.poziomTrudnosci, this.liczbaPunktow + this.liczbaPunktowKampania);
        }
        String sb = Texts.MISSION + " " + (nrMisji + 1) + " ";
        sb = celOsiagniety ? sb + Texts.COMPLETED : sb + Texts.UNCOMPLETED;
        sb = sb + "\n\n" + Texts.MISSION1_STRING;
        sb = sb + "\n" + Texts.MISSION2_STRING + Trasa.helikopteryZniszczone + "/" + Trasa.liczbaHelikopterow;
        sb = sb + "\n" + Texts.MISSION3_STRING + Trasa.statkiZniszczone + "/" + Trasa.liczbaStatkow;
        sb = sb + "\n" + Texts.MISSION4_STRING + Trasa.czolgiZniszczone + "/" + Trasa.liczbaCzolgow;
        if (this.secondaryTarget[nrMisji] != 0) {
            // empty if block
        }
        sb = sb + "\n\n" + Texts.MISSION6_STRING + this.stringCzas;
        sb = sb + "\n\n" + Texts.MISSION7_STRING;
        sb = sb + "\n" + Texts.MISSION8_STRING + this.liczbaPunktowJednostki;
        sb = sb + "\n" + Texts.MISSION10_STRING + this.liczbaPunktowCzas;
        sb = sb + "\n" + Texts.MISSION11_STRING + this.liczbaPunktowUszkodzenia;
        int czescCalkowita = wspolczynnikMnozenia / 10;
        int czescUlamkowa = wspolczynnikMnozenia % 10;
        sb = sb + "\n" + Texts.MISSION12_STRING + czescCalkowita + "." + czescUlamkowa;
        sb = sb + "\n\n" + Texts.MISSION13_STRING + this.liczbaPunktow;
        if (this.kampania) {
            sb = sb + "\n" + Texts.MISSION14_STRING + (this.liczbaPunktowKampania + this.liczbaPunktow);
            sb = sb + "\n" + Texts.MISSION15_STRING + this.liczbaZyc;
        }
        sb = sb + " \n ";
        this.ustawTekstEkranu(sb);
    }

    public void rozpocznijLot() {
        this.canvas.changeGameState(20);
    }

    public void paint(Graphics g) {
        if (!this.trzebaRysowac) {
            return;
        }
        this.trzebaRysowac = false;
        g.setClip(0, 0, MyCanvas.maxX, MyCanvas.maxY);
        g.drawImage(this.canvas.imageKomputer, 0, 0, 20);
        switch (stanMisji) {
            case 1: {
                this.paintTekstEkranu(g);
                this.paintNapis(g, Texts.CONTINUE, Texts.MENU);
                break;
            }
            case 3: {
                this.paintTekstEkranu(g);
                this.paintNapis(g, Texts.CONTINUE, null);
                break;
            }
            case 4: {
                g.setClip(0, 0, MyCanvas.maxX, MyCanvas.maxY);
                g.drawImage(this.imageGameOver, 0, 0, 20);
                g.setColor(0xEECC33);
                int width = this.renderer.getStringWidth(Texts.GAME_OVER_STRING.length());
                g.setColor(0);
                g.fillRect(0, MyCanvas.maxY - 15 * MyCanvas.maxY / 100 - 5, MyCanvas.maxX, this.renderer.getStringHeight(1) + 10);
                this.renderer.renderText(g, (MyCanvas.maxX >> 1) - (width >> 1), MyCanvas.maxY - 15 * MyCanvas.maxY / 100, new StringBuffer(Texts.GAME_OVER_STRING));
                this.paintNapis(g, Texts.CONTINUE, null);
                break;
            }
            case 8: {
                g.setClip(0, 0, MyCanvas.maxX, MyCanvas.maxY);
                g.drawImage(this.imageGameOver, 0, 0, 20);
                g.setColor(0xEECC33);
                if (this.liczbaZyc == 1) {
                    int width2 = this.renderer.getStringWidth(Texts.LAST_LIFE_STRING.length());
                    g.setColor(0);
                    g.fillRect(0, MyCanvas.maxY - 15 * MyCanvas.maxY / 100 - 5, MyCanvas.maxX, this.renderer.getStringHeight(1) + 10);
                    this.renderer.renderText(g, (MyCanvas.maxX >> 1) - (width2 >> 1), MyCanvas.maxY - 15 * MyCanvas.maxY / 100, new StringBuffer(Texts.LAST_LIFE_STRING));
                } else {
                    int width3 = this.renderer.getStringWidth((Texts.LIFE_LEFT1_STRING + this.liczbaZyc + Texts.LIFE_LEFT2_STRING).length());
                    g.setColor(0);
                    g.fillRect(0, MyCanvas.maxY - 15 * MyCanvas.maxY / 100 - 5, MyCanvas.maxX, this.renderer.getStringHeight(1) + 10);
                    this.renderer.renderText(g, (MyCanvas.maxX >> 1) - (width3 >> 1), MyCanvas.maxY - 15 * MyCanvas.maxY / 100, new StringBuffer(Texts.LIFE_LEFT1_STRING + this.liczbaZyc + Texts.LIFE_LEFT2_STRING));
                }
                this.paintNapis(g, Texts.CONTINUE, null);
                break;
            }
            case 10: {
                this.paintTekstEkranu(g);
                this.paintNapis(g, Texts.YES, Texts.NO);
                break;
            }
            case 11: {
                this.paintTekstEkranu(g);
                this.paintNapis(g, Texts.CONTINUE, null);
            }
        }
    }

    public void nextStep() {
        this.klawiszeObsluga();
    }

    public void klawiszeObsluga() {
        int keyCode = this.canvas.getCurrentKey();
        if (this.canvas.keyUsed || keyCode == 0) {
            return;
        }
        this.canvas.wyczyscKlawisze();
        switch (stanMisji) {
            case 1: {
                switch (keyCode) {
                    case -7: {
                        this.canvas.rozpocznijMenuMisja(40);
                        return;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        MyCanvas.ekranMapy.rozpocznijMape(false);
                        this.canvas.changeGameState(101);
                        return;
                    }
                }
                this.obslugaTekstEkranu(keyCode);
                break;
            }
            case 8: {
                if (keyCode == -5 || keyCode == -6 || keyCode == 53) {
                    this.canvas.changeGameState(20);
                    break;
                }
            }
            case 3: {
                if (keyCode == -6) {
                    if (this.kampania && nrMisji == MyCanvas.liczbaMisji - 1 && celOsiagniety) {
                        String sb = Texts.CONGRATULATION1_STRING + (this.liczbaPunktow + this.liczbaPunktowKampania) + Texts.POINTS + ".";
                        switch (this.miejsceKampania) {
                            case 1: {
                                sb = sb + Texts.BEST_RESULT_STRING + Texts.DIFFICULTY_STRINGS[this.poziomTrudnosci] + Texts.END_RESULT_STRING;
                                break;
                            }
                            case 2: {
                                sb = sb + Texts.SECOND_RESULT_STRING + Texts.DIFFICULTY_STRINGS[this.poziomTrudnosci] + Texts.END_RESULT_STRING;
                                break;
                            }
                            case 3: {
                                sb = sb + Texts.THIRD_RESULT_STRING + Texts.DIFFICULTY_STRINGS[this.poziomTrudnosci] + Texts.END_RESULT_STRING;
                            }
                        }
                        this.ustawTekstEkranu(sb);
                        this.canvas.blokujKlawisze(500);
                        stanMisji = (byte)11;
                        this.trzebaRysowac = true;
                        this.canvas.continueAktywny = 0;
                        break;
                    }
                    if (this.kampania) {
                        this.canvas.myMenu.odswiezMenu();
                        this.canvas.myMenu.wyzerujIndex();
                        this.canvas.rozpocznijMenuMisja(50);
                    } else {
                        this.canvas.powrotDoMenu();
                        this.canvas.zakonczSymulacje = true;
                    }
                }
                this.obslugaTekstEkranu(keyCode);
                break;
            }
            case 4: {
                if (keyCode != -6 && keyCode != -5 && keyCode != 53) break;
                if (this.kampania) {
                    this.canvas.rozpocznijMenuMisja(50);
                    break;
                }
                this.canvas.powrotDoMenu();
                this.canvas.zakonczSymulacje = true;
                break;
            }
            case 10: {
                if (keyCode == -6) {
                    this.canvas.rozpocznijTutorial();
                }
                if (keyCode == -7) {
                    this.trzebaRysowac = true;
                    this.canvas.blokujKlawisze(500);
                    this.wstawTekstOpisuMisji();
                    stanMisji = 1;
                }
                this.obslugaTekstEkranu(keyCode);
                break;
            }
            case 11: {
                if (keyCode == -5 || keyCode == -6 || keyCode == -7 || keyCode == 53) {
                    this.canvas.powrotDoMenu();
                    this.canvas.zakonczSymulacje = true;
                }
                this.obslugaTekstEkranu(keyCode);
            }
        }
    }

    public void ustawTekstEkranu(String s) {
        this.pozycjaTekstu = 0;
        this.tablicaLiniiTekstu = Element.zawinTekst(s, 158, Properties.standardFont);
        this.liczbaLiniiTekstu = this.tablicaLiniiTekstu.length;
        this.liczbaRysowanychLinii = 168 / this.renderer.getStringHeight(1);
        if (this.liczbaLiniiTekstu > this.liczbaRysowanychLinii) {
            this.tablicaLiniiTekstu = Element.zawinTekst(s, 144, Properties.standardFont);
            this.liczbaLiniiTekstu = this.tablicaLiniiTekstu.length;
        }
    }

    public void paintTekstEkranu(Graphics g) {
        int y = 9;
        int x = MyCanvas.maxX >> 1;
        if (this.liczbaLiniiTekstu > this.liczbaRysowanychLinii) {
            x -= 7;
            g.drawImage(MyMenu2.upImage, 164, 16, 33);
            g.drawImage(MyMenu2.downImage, 164, 170, 17);
            g.drawImage(MyMenu2.barImage, 164, MyMenu2.poczatekObszaruBar + this.pozycjaTekstu * MyMenu2.obszarBar / (this.liczbaLiniiTekstu - this.liczbaRysowanychLinii), 3);
        }
        g.setColor(0x666688);
        for (int i = this.pozycjaTekstu; i < this.liczbaLiniiTekstu && i < this.pozycjaTekstu + this.liczbaRysowanychLinii; ++i) {
            int width1 = this.renderer.getStringWidth(this.tablicaLiniiTekstu[i].length());
            this.renderer.renderText(g, 88 - (width1 >> 1), y, new StringBuffer(this.tablicaLiniiTekstu[i]));
            y += this.renderer.getStringHeight(1);
        }
    }

    public void obslugaTekstEkranu(int keyCode) {
        if (keyCode == -1 || keyCode == 50) {
            --this.pozycjaTekstu;
        }
        if (keyCode == -2 || keyCode == 56 || keyCode == -5 || keyCode == 53) {
            ++this.pozycjaTekstu;
        }
        this.trzebaRysowac = true;
        if (this.pozycjaTekstu > this.liczbaLiniiTekstu - this.liczbaRysowanychLinii) {
            this.pozycjaTekstu = this.liczbaLiniiTekstu - this.liczbaRysowanychLinii;
        }
        if (this.pozycjaTekstu < 0) {
            this.pozycjaTekstu = 0;
        }
    }

    public void nextMission() {
        this.canvas.rozpocznijMisje(nrMisji + 1, true, this.poziomTrudnosci, this.liczbaZyc, this.liczbaPunktowKampania + this.liczbaPunktow);
    }

    public void restartMission() {
        this.canvas.rozpocznijMisje(nrMisji, this.kampania, this.poziomTrudnosci, this.liczbaZyc + this.liczbaZycStraconych, this.liczbaPunktowKampania);
    }

    public void zapiszMisje(int slot) {
        byte[] zapis = new byte[5];
        zapis[0] = (byte)this.poziomTrudnosci;
        if (nrMisji < MyCanvas.liczbaMisji) {
            zapis[1] = (byte)(nrMisji + 1);
        }
        zapis[2] = (byte)this.liczbaZyc;
        short liczbaPunktowZapisu = (short)(this.liczbaPunktowKampania + this.liczbaPunktow);
        zapis[3] = (byte)((liczbaPunktowZapisu & 0xFF00) >> 8);
        zapis[4] = (byte)(liczbaPunktowZapisu & 0xFF);
        System.out.println("zapisuje save nr misji: " + (nrMisji + 1));
        Util.writeBytesToRMS("Misja" + slot, zapis, 5);
        this.canvas.continueAktywny = 1;
    }

    public void wczytajMisje(int nrKolejnegoZapisu, boolean load) {
        int nr = nrKolejnegoZapisu + 1;
        int slot = 0;
        byte[] odczyt = null;
        byte lastOdczyt = 0;
        if (!load) {
            for (int k = 0; k < 4; ++k) {
                odczyt = Util.loadBytesFromRMS("Misja" + k);
                if (odczyt == null) continue;
                if (odczyt[1] > lastOdczyt) {
                    nrMisji = odczyt[1];
                }
                lastOdczyt = odczyt[1];
            }
        }
        while (nr != 0 && slot < 4) {
            odczyt = Util.loadBytesFromRMS("Misja" + slot);
            if (odczyt != null && odczyt.length == 5) {
                --nr;
            }
            ++slot;
        }
        if (nr == 0) {
            this.poziomTrudnosci = odczyt[0];
            if (load) {
                nrMisji = odczyt[1];
            }
            wczytanyNrMisji = odczyt[1];
            this.liczbaZyc = odczyt[2];
            this.liczbaPunktowKampania = HiScores.bytesToShort(odczyt[3], odczyt[4]);
            if (load) {
                this.canvas.rozpocznijMisje(nrMisji, true, this.poziomTrudnosci, this.liczbaZyc, this.liczbaPunktowKampania);
            }
        }
    }

    public String[] zwrocListeZapisow() {
        int liczbaSaveow = 0;
        String[] listaZapisow = null;
        for (int i = 0; i < 4; ++i) {
            byte[] odczyt = Util.loadBytesFromRMS("Misja" + i);
            if (odczyt == null || odczyt.length != 5) continue;
            ++liczbaSaveow;
        }
        if (liczbaSaveow == 0) {
            listaZapisow = new String[]{Texts.NO_SAVE_STRING};
        } else {
            listaZapisow = new String[liczbaSaveow];
            int temp = 0;
            for (int i = 0; i < 4; ++i) {
                byte[] odczyt = Util.loadBytesFromRMS("Misja" + i);
                if (odczyt == null || odczyt.length != 5) continue;
                listaZapisow[temp] = Texts.MISSION + " " + (odczyt[1] + 1);
                if (i == 0) {
                    int n = temp;
                    listaZapisow[n] = listaZapisow[n] + Texts.AUTOSAVE_STRING;
                }
                ++temp;
            }
        }
        return listaZapisow;
    }

    public String[] zwrocListeDoZapisu() {
        String[] listaZapisow = new String[3];
        for (int i = 1; i < 4; ++i) {
            byte[] odczyt = Util.loadBytesFromRMS("Misja" + i);
            listaZapisow[i - 1] = odczyt == null || odczyt.length != 5 ? Texts.SLOT_STRING + i : Texts.MISSION + " " + (odczyt[1] + 1);
        }
        return listaZapisow;
    }

    public void paintNapis(Graphics g, String napis1, String napis2) {
        this.renderer.setCurrentFont(this.renderer.getFont("FONT_NORMAL"));
        int przesuniecieX = 0;
        if (napis1 != null) {
            int width1 = this.renderer.getStringWidth(napis1.length());
            g.drawImage(this.softImg, -przesuniecieX, 220 - this.softImg.getHeight() + 4, 0);
            this.renderer.renderText(g, this.softImg.getWidth() - width1 >> 1 + przesuniecieX, 220 - (this.softImg.getHeight() - this.renderer.getStringHeight(1)) / 2 - this.renderer.getStringHeight(1), new StringBuffer(napis1));
        }
        if (napis2 != null) {
            int width2 = this.renderer.getStringWidth(napis2.length());
            g.drawImage(this.softImg, 176 - this.softImg.getWidth() + przesuniecieX, 220 - this.softImg.getHeight() + 4, 0);
            this.renderer.renderText(g, 176 - width2 - (this.softImg.getWidth() - width2) / 2 - przesuniecieX, 220 - (this.softImg.getHeight() - this.renderer.getStringHeight(1)) / 2 - this.renderer.getStringHeight(1), new StringBuffer(napis2));
        }
    }

    static {
        wczytanyNrMisji = 0;
    }
}

