/*
 * Decompiled with CFR 0.152.
 */
package root;

import jednostki.Jednostka;
import jednostki.Pocisk;
import math.Math;
import root.Kokpit;
import root.MyCanvas;
import root.Texts;
import root.Util;
import world.Rozklad;
import world.TerrainTileMap;
import world.Tile;
import world.Trasa;

public class Pojazd {
    public static final int MAX_INTERVAL_TIME = 200;
    public int xPojazdu;
    public int yPojazdu;
    public int xPojazduP;
    public int yPojazduP;
    public int kafelX;
    public int kafelY;
    public int maskaX;
    public int maskaY;
    public int wysokosc;
    public int katPoziom;
    public int katPion;
    public int katPoziomP;
    public int staryKatPoziomP;
    public int katPoruszania;
    public int katPoruszaniaTemp;
    public int predkosc;
    public int predkoscX;
    public int predkoscY;
    public int mocPojazdu;
    public int skret;
    public int skretWidoczny;
    public int przyrostMocy;
    public int zmniejszenieMocy;
    public int mocMax;
    public int mocMin;
    public int przyrostSkretu;
    public int powrotSkretu;
    public int skretMax;
    public int skretMin;
    public int znoszenie;
    public static int wysokoscStandardowaPojazdu;
    int paliwo = 65536;
    int paliwoMax = 65536;
    int przyrostPaliwa = 24576;
    int[] zuzyciePaliwa = new int[]{1024, 1280, 1536};
    int liczbaPunktowDetekcji;
    int[] yPunktuDetekcji;
    int[] xPunktuDetekcji;
    int[] wysokoscPunktuDetekcji;
    int[] xPunktuDetekcjiKat;
    int[] yPunktuDetekcjiKat;
    int[] poziomKolizji;
    int[] zniszczenia;
    public static final int promienDetekcjiKwadrat = 384;
    public long newPeriodTime;
    public long periodTime;
    public int intervalPeriodTime;
    public int[] stanKlawisza = new int[11];
    public int[] czasKlawisza = new int[11];
    public long[] momentWcisnieciaKlawisza = new long[11];
    public long[] momentPuszczeniaKlawisza = new long[11];
    public int czasSkretu;
    public int czasPrzyspieszania;
    public static int odlegloscCel;
    public boolean zniszczony;
    public boolean isStrafeLeft;
    public boolean isStrafeRight = false;
    public MyCanvas canvas;
    public TerrainTileMap mapa;
    int wysokoscBrakuPaliwa;
    public boolean wyzerujKlawisze = true;
    boolean wystrzelicPocisk;
    int kolizjaDrzewa = 0;
    public int staryKatPoruszania = -1000;
    public int staraDetekcjaPod;
    public int tymczasowaZmianaSkretu = 0;
    public int zmniejszenieMocyPojazdu = 0;
    public int xPojazduTemp;
    public int yPojazduTemp;
    public int maksymalnaZmianaKata;
    int calkowityPoziomKolizji = 0;
    Pocisk[] rakiety = new Pocisk[10];
    int nrNastepnegoPocisku = 0;
    int minimalnaPrzerwaPoWystrzale = 800;
    int czasWystrzalu;
    public static int liczbaRakiet;
    int uszkodzeniaRakieta = 65536;
    int uszkodzeniaEksplozja = 8192;
    int uszkodzeniaMina = 49152;
    boolean kolizja = false;
    boolean wybuch = false;
    public int czasWybuchu = 0;
    public int klatkaWybuchu = 0;
    public int promienWybuchu;
    public static final byte SYSTEM_WIRNIKA = 0;
    public static final byte SYSTEM_PALIWA = 1;
    public static final byte SYSTEM_ELEKTRONIKI = 2;
    public static final byte SYSTEM_UZBROJENIA = 3;
    public static final byte SYSTEM_STEROW = 4;
    public static final byte OK = 0;
    public static final byte USZKODZONY = 1;
    public static final byte KRYTYCZNY = 2;
    public static final byte ZNISZCZONY = 3;
    public static final byte liczbaSystemow = 5;
    public byte[] stanSystemu = new byte[5];
    public boolean[] zmianaStanuSystemu = new boolean[5];
    public static final byte PRZOD = 0;
    public static final byte LEWO = 1;
    public static final byte PRAWO = 2;
    public static final byte TYL = 3;
    public int[] przeksztalceniePrzedzialu = new int[]{0, 1, 3, 2};
    public static final byte liczbaCzesciPojazdu = 4;
    public static int[] uszkodzeniaPojazdu;
    public static byte[] stanPojazdu;
    public boolean[] zmianaStanuPojazdu = new boolean[4];
    public int poziomUszkodzen = 65536;

    public Pojazd(MyCanvas canv, int poziomTrudnosci) {
        this.canvas = canv;
        this.mapa = MyCanvas.mapa;
        this.maskaX = (MyCanvas.mapa.mapWidth << 21) - 1;
        this.maskaY = (MyCanvas.mapa.mapHeight << 21) - 1;
        try {
            int xStartu = MyCanvas.trasa.xStartu;
            int yStartu = MyCanvas.trasa.yStartu;
            int kat = Math.arcTg(MyCanvas.trasa.xKierunkuStartu - xStartu, MyCanvas.trasa.yKierunkuStartu - yStartu);
            this.ustawPoczatek(1, xStartu << 16, yStartu << 16, wysokoscStandardowaPojazdu, kat << 16, 0);
            this.naprawPojazd();
            this.ustawParametryPoziomuTrudnosci(poziomTrudnosci);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ustawPoczatek(int rodzajPojazdu, int x, int y, int wys, int kat, int moc) {
        liczbaRakiet = MyCanvas.trasa.liczbaRakietPoziom;
        this.periodTime = System.currentTimeMillis();
        this.zniszczony = false;
        this.wysokoscBrakuPaliwa = wys;
        this.ustawParametryPojazdu(rodzajPojazdu);
        this.wyliczPunktyDetekcji();
        this.wyzerujKlawisze();
        this.xPojazdu = x & this.maskaX;
        this.yPojazdu = y & this.maskaY;
        this.xPojazduP = this.xPojazdu >> 16;
        this.yPojazduP = this.yPojazdu >> 16;
        this.wysokosc = wys;
        this.katPoziom = kat;
        this.katPoruszania = kat;
        this.katPoziomP = kat >> 16;
        this.katPoziomP %= 360;
        if (this.katPoziomP < 0) {
            this.katPoziomP += 360;
        }
        this.mocPojazdu = moc;
        this.skret = 0;
        this.katPion = 0;
    }

    public void ustawPoczatekTutoriala() {
        this.stanSystemu[1] = 2;
        this.stanSystemu[3] = 1;
        Pojazd.stanPojazdu[1] = 1;
        Pojazd.stanPojazdu[3] = 2;
        this.paliwo = this.paliwoMax * 2 / 3;
        this.xPojazduP = 696;
        this.yPojazduP = 1848;
        this.xPojazdu = this.xPojazduP << 16;
        this.yPojazdu = this.yPojazduP << 16;
        this.katPoziomP = 45;
        this.katPoziom = this.katPoziomP << 16;
    }

    public void wyzerujKlawisze() {
        for (int i = 0; i < 11; ++i) {
            this.stanKlawisza[i] = 0;
            this.czasKlawisza[i] = 0;
        }
    }

    public void ustawParametryPojazdu(int rodzajPojazdu) {
        switch (rodzajPojazdu) {
            case 1: {
                this.przyrostMocy = 1536;
                this.zmniejszenieMocy = 2560;
                this.mocMax = 24576;
                this.mocMin = -10240;
                wysokoscStandardowaPojazdu = MyCanvas.trasa.wysokoscPojazdu;
                this.przyrostSkretu = 3328;
                this.powrotSkretu = 1536;
                this.skretMax = 0x280000;
                this.skretMin = -2621440;
                this.znoszenie = Util.randomWithMinus(768);
            }
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 49: {
                this.isStrafeLeft = true;
                break;
            }
            case 51: {
                this.isStrafeRight = true;
            }
        }
    }

    public void keyRelased(int keyCode) {
        switch (keyCode) {
            case 49: {
                this.isStrafeLeft = false;
                break;
            }
            case 51: {
                this.isStrafeRight = false;
            }
        }
    }

    public void nextStep(int keyStates) {
        for (int i = 0; i < 10; ++i) {
            this.stanKlawisza[i] = 0;
        }
        if (this.wyzerujKlawisze) {
            this.wyzerujKlawisze = false;
            return;
        }
        if ((keyStates & 2) != 0) {
            this.stanKlawisza[2] = 2;
        }
        if ((keyStates & 4) != 0) {
            this.stanKlawisza[4] = 2;
        }
        if ((keyStates & 0x20) != 0) {
            this.stanKlawisza[6] = 2;
        }
        if ((keyStates & 0x40) != 0) {
            this.stanKlawisza[8] = 2;
        }
        if ((keyStates & 0x100) != 0) {
            this.stanKlawisza[5] = 2;
            this.wystrzelicPocisk = true;
        }
        try {
            this.wyliczStanPojazdu();
            this.przemiescRakiety();
        }
        catch (Exception e) {
            Util.critical(e, "Blad pojazdu");
        }
    }

    public void nextStepTutorial() {
        this.wysokosc = wysokoscStandardowaPojazdu;
        odlegloscCel = MyCanvas.trasa.sprawdzCel(this.xPojazduP, this.yPojazduP);
        if (this.wysokoscBrakuPaliwa < this.wysokosc) {
            this.wysokoscBrakuPaliwa += 5;
            this.wysokosc = this.wysokoscBrakuPaliwa;
        }
    }

    public void wyliczCzasyKlawiszy() {
        this.newPeriodTime = System.currentTimeMillis();
        this.intervalPeriodTime = (int)(this.newPeriodTime - this.periodTime);
        if (this.intervalPeriodTime > 200) {
            this.intervalPeriodTime = 200;
        }
        if (this.intervalPeriodTime < 1) {
            this.intervalPeriodTime = 1;
        }
        block6: for (int key = 0; key <= 10; ++key) {
            switch (this.stanKlawisza[key]) {
                case 0: {
                    this.czasKlawisza[key] = 0;
                    continue block6;
                }
                case 1: {
                    this.czasKlawisza[key] = (int)(this.newPeriodTime - this.momentWcisnieciaKlawisza[key]);
                    this.stanKlawisza[key] = 2;
                    continue block6;
                }
                case 2: {
                    this.czasKlawisza[key] = this.intervalPeriodTime;
                    continue block6;
                }
                case 3: {
                    this.czasKlawisza[key] = (int)(this.momentPuszczeniaKlawisza[key] - this.periodTime);
                    this.stanKlawisza[key] = 0;
                }
            }
        }
        this.czasPrzyspieszania = this.czasKlawisza[10] + this.czasKlawisza[1] + this.czasKlawisza[2] + this.czasKlawisza[3] - (this.czasKlawisza[0] + this.czasKlawisza[7] + this.czasKlawisza[8] + this.czasKlawisza[9]);
        this.czasSkretu = this.czasKlawisza[3] + this.czasKlawisza[6] + this.czasKlawisza[9] - (this.czasKlawisza[1] + this.czasKlawisza[4] + this.czasKlawisza[7]);
        if (this.czasSkretu > this.intervalPeriodTime) {
            this.czasSkretu = this.intervalPeriodTime;
        }
        if (this.czasSkretu < -this.intervalPeriodTime) {
            this.czasSkretu = -this.intervalPeriodTime;
        }
        this.periodTime = this.newPeriodTime;
    }

    public void wyliczStanPojazdu() {
        int intervalKaty;
        this.wyliczCzasyKlawiszy();
        if (this.czasSkretu == 0) {
            if (this.skret > 0) {
                this.skret -= this.intervalPeriodTime * this.powrotSkretu;
                if (this.skret < 0) {
                    this.skret = 0;
                }
            } else if (this.skret < 0) {
                this.skret += this.intervalPeriodTime * this.powrotSkretu;
                if (this.skret > 0) {
                    this.skret = 0;
                }
            }
        }
        int wspolczynnikSterow = 8 - this.stanSystemu[4] * 2;
        this.skret += this.czasSkretu * this.przyrostSkretu * wspolczynnikSterow >> 3;
        if (this.stanSystemu[0] == 1) {
            this.skret += Util.randomWithMinus(5) << 16;
        }
        if (this.stanSystemu[0] == 2) {
            this.skret += Util.randomWithMinus(7) << 16;
        }
        if (this.skret > this.skretMax) {
            this.skret = this.skretMax;
        }
        if (this.skret < this.skretMin) {
            this.skret = this.skretMin;
        }
        this.mocPojazdu = this.czasPrzyspieszania > 0 && (this.kolizjaDrzewa <= 0 || this.mocPojazdu <= this.mocMax >> 2) ? (this.mocPojazdu += this.czasPrzyspieszania * this.przyrostMocy * wspolczynnikSterow >> 10) : (this.mocPojazdu += this.czasPrzyspieszania * this.zmniejszenieMocy * wspolczynnikSterow >> 10);
        if (this.kolizjaDrzewa > 0) {
            this.kolizjaDrzewa -= this.intervalPeriodTime;
        }
        if (this.mocPojazdu > this.mocMax) {
            this.mocPojazdu = this.mocMax;
        }
        if (this.mocPojazdu < this.mocMin) {
            this.mocPojazdu = this.mocMin;
        }
        this.paliwo -= this.zuzyciePaliwa[this.stanSystemu[1]] * (8 + 8 * this.mocPojazdu / this.mocMax) * this.intervalPeriodTime >> 14;
        this.katPoziom -= this.skret * this.intervalPeriodTime >> 9;
        this.katPoziomP = this.katPoziom >> 16;
        this.katPoziomP %= 360;
        if (this.katPoziomP < 0) {
            this.katPoziomP += 360;
        }
        this.katPoruszania -= this.skret * this.intervalPeriodTime >> 9;
        this.katPoruszaniaTemp = this.katPoruszania;
        this.tymczasowaZmianaSkretu = this.tymczasowaZmianaSkretu > 1 ? -this.tymczasowaZmianaSkretu + 2 : (this.tymczasowaZmianaSkretu < -1 ? -this.tymczasowaZmianaSkretu - 2 : 0);
        this.detekcjaKolizji();
        this.mocPojazdu -= this.zmniejszenieMocyPojazdu;
        if (this.mocPojazdu > 0) {
            this.katPion = -(this.mocPojazdu << 7);
            if (this.katPion < -1638400) {
                this.katPion = -1638400;
            }
        } else {
            this.katPion = -(this.mocPojazdu << 6);
        }
        this.wysokosc = wysokoscStandardowaPojazdu;
        this.xPojazdu = this.xPojazduTemp;
        this.xPojazdu &= this.maskaX;
        this.xPojazduP = this.xPojazdu >> 16;
        this.kafelX = this.xPojazduP >> this.mapa.tileWidthLog;
        this.yPojazdu = this.yPojazduTemp;
        this.yPojazdu &= this.maskaY;
        this.yPojazduP = this.yPojazdu >> 16;
        this.kafelY = this.yPojazduP >> this.mapa.tileWidthLog;
        odlegloscCel = MyCanvas.trasa.sprawdzCel(this.xPojazduP, this.yPojazduP);
        if (this.paliwo < 0 || Trasa.czasPoziomu < 0 || this.zniszczony) {
            if (this.wysokoscBrakuPaliwa < this.mapa.returnHeight(this.xPojazduP, this.yPojazduP) + 5 || this.wysokoscBrakuPaliwa < this.mapa.waterLevel + 5) {
                this.canvas.misja.gameOver();
            } else {
                this.wysokoscBrakuPaliwa -= 5;
                this.wysokosc = this.wysokoscBrakuPaliwa;
            }
            if (this.paliwo < 0) {
                MyCanvas.wstawInformacje(Texts.OUT_OF_FUEL_STRING, 500, 0, 0xCCFF99, true);
            }
            if (Trasa.czasPoziomu < 0) {
                MyCanvas.wstawInformacje(Texts.TIMES_UP_STRING, 500, 0, 0xCCFF99, true);
            }
        } else if (this.wysokoscBrakuPaliwa < this.wysokosc) {
            this.wysokoscBrakuPaliwa += 5;
            this.wysokosc = this.wysokoscBrakuPaliwa;
        }
        this.katPoruszania = this.katPoruszaniaTemp;
        Tile tile = this.mapa.returnTile(this.kafelX, this.kafelY);
        if (tile != null) {
            this.wyliczKolizjeDrzewa(tile);
        }
        if ((intervalKaty = this.katPoruszania - this.katPoziom) != 0) {
            if (intervalKaty > -327680 && intervalKaty < 327680) {
                this.katPoruszania -= intervalKaty >> 1;
                this.katPoziom = this.katPoruszania;
            } else if (intervalKaty > -3145728 && intervalKaty < 0x300000) {
                this.katPoruszania -= intervalKaty >> 2;
                this.katPoziom += intervalKaty >> 2;
            } else if (intervalKaty < 0) {
                this.katPoruszania += 0x100000;
                this.katPoziom -= 0x100000;
            } else {
                this.katPoruszania -= 0x100000;
                this.katPoziom += 0x100000;
            }
        }
        this.katPoziomP = this.katPoziom >> 16;
        this.katPoziomP %= 360;
        if (this.katPoziomP < 0) {
            this.katPoziomP += 360;
        }
        if (this.wystrzelicPocisk) {
            this.wystrzelPocisk();
        }
        this.wystrzelicPocisk = false;
    }

    public void wyliczKolizjeDrzewa(Tile tile) {
        int xPojazduKafel = this.xPojazduP & this.mapa.tileWidthMask;
        int yPojazduKafel = this.yPojazduP & this.mapa.tileWidthMask;
        Rozklad rozklad = tile.rozklad;
        int liczbaObiektow = rozklad.liczbaObiektow;
        for (int i = 0; i < liczbaObiektow; ++i) {
            int deltaX = rozklad.polozenieObiektuX[i] - xPojazduKafel;
            int deltaY = rozklad.polozenieObiektuY[i] - yPojazduKafel;
            int odlegloscK = deltaX * deltaX + deltaY * deltaY;
            int odlegloscKolizji = 64;
            if (odlegloscK >= odlegloscKolizji || this.wysokosc <= rozklad.wysokoscObiektu[i]) continue;
            if (this.mocPojazdu > this.mocMax >> 3) {
                this.mocPojazdu >>= 1;
                this.kolizjaDrzewa = 1000;
            }
            this.tymczasowaZmianaSkretu = this.tymczasowaZmianaSkretu <= 0 ? 10 : -10;
            int roznicaKatow = Math.arcTg(deltaX, deltaY) - this.katPoziomP;
            if (roznicaKatow < -180) {
                roznicaKatow += 360;
            }
            if (roznicaKatow > 180) {
                roznicaKatow -= 360;
            }
            if (roznicaKatow > -90 && roznicaKatow < -15) {
                this.katPoruszania += (4 * (odlegloscKolizji - odlegloscK) << 16) * this.mocPojazdu / this.mocMax;
            }
            if (roznicaKatow <= 15 || roznicaKatow >= 90) continue;
            this.katPoruszania -= (4 * (odlegloscKolizji - odlegloscK) << 16) * this.mocPojazdu / this.mocMax;
        }
    }

    public void wyliczPunktyDetekcjiKat() {
        if (this.staryKatPoruszania == this.katPoruszaniaTemp >> 16) {
            return;
        }
        this.staryKatPoruszania = this.katPoruszaniaTemp >> 16;
        int cosinus = Math.cos(this.staryKatPoruszania);
        int sinus = Math.sin(this.staryKatPoruszania);
        for (int i = 0; i < this.liczbaPunktowDetekcji; ++i) {
            this.xPunktuDetekcjiKat[i] = this.xPunktuDetekcji[i] * cosinus + this.yPunktuDetekcji[i] * sinus >> 10;
            this.yPunktuDetekcjiKat[i] = this.yPunktuDetekcji[i] * cosinus + this.xPunktuDetekcji[i] * sinus >> 10;
        }
    }

    public void detekcjaKolizji() {
        this.staraDetekcjaPod = this.mapa.returnHeight(this.xPojazdu >> 16, this.yPojazdu >> 16) + 5 - this.wysokosc;
        this.katPoruszaniaTemp = this.katPoruszania;
        this.zmniejszenieMocyPojazdu = 0;
        if (this.mocPojazdu == 0) {
            this.xPojazduTemp = this.xPojazdu;
            this.yPojazduTemp = this.yPojazdu;
            return;
        }
        int strafe = 0;
        this.wyliczPunktyDetekcjiKat();
        int zwiekszenieMocyPojazdu = 0;
        if (this.mocPojazdu > 0) {
            if (this.isStrafeLeft) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = 60;
            }
            if (this.isStrafeRight) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = -60;
            }
        } else {
            if (this.isStrafeLeft) {
                zwiekszenieMocyPojazdu = -this.mocMax / 2;
                strafe = -60;
            }
            if (this.isStrafeRight) {
                zwiekszenieMocyPojazdu = -this.mocMax / 2;
                strafe = 60;
            }
        }
        this.predkoscX = (this.mocPojazdu - this.zmniejszenieMocyPojazdu + zwiekszenieMocyPojazdu) * Math.cos((this.katPoruszaniaTemp >> 16) + strafe) >> 10;
        this.predkoscY = (this.mocPojazdu - this.zmniejszenieMocyPojazdu + zwiekszenieMocyPojazdu) * Math.sin((this.katPoruszaniaTemp >> 16) + strafe) >> 10;
        this.xPojazduTemp = this.xPojazdu + (this.predkoscX * this.intervalPeriodTime >> 2);
        this.yPojazduTemp = this.yPojazdu - (this.predkoscY * this.intervalPeriodTime >> 2);
        this.maksymalnaZmianaKata = this.mocPojazdu >= this.mocMax >> 1 ? 0x5A0000 : 90 * this.mocPojazdu / (this.mocMax << 1) << 16;
        int katMinimumPrzod = -1;
        int katMaximumPrzod = -1;
        int nrPunktuDetekcjiLewo = this.liczbaPunktowDetekcji >> 1;
        int calkowityPoziomKolizjiTemp = 0;
        for (int i = 0; i <= nrPunktuDetekcjiLewo; ++i) {
            int x = this.xPojazduTemp + this.xPunktuDetekcjiKat[i] >> 16;
            int y = this.yPojazduTemp + this.yPunktuDetekcjiKat[i] >> 16;
            int wysokoscMapa = this.mapa.returnHeight(x, y);
            this.poziomKolizji[i] = wysokoscMapa + this.wysokoscPunktuDetekcji[i] - this.wysokosc;
            if (wysokoscMapa == 128) {
                MyCanvas.wstawInformacje(Texts.END_OF_MAP_STRING, 500, 0, 0xCCFF99, true);
            }
            if (this.poziomKolizji[i] <= 0) continue;
            calkowityPoziomKolizjiTemp += this.poziomKolizji[i];
            if (katMinimumPrzod == -1) {
                katMinimumPrzod = i * 30;
                continue;
            }
            katMaximumPrzod = i * 30;
        }
        int detekcjaPod = this.mapa.returnHeight(this.xPojazduTemp >> 16, this.yPojazduTemp >> 16) + 5 - this.wysokosc;
        if (calkowityPoziomKolizjiTemp == 0 && detekcjaPod <= 0 || this.mocPojazdu < this.mocMax >> 3 && detekcjaPod <= this.staraDetekcjaPod) {
            this.calkowityPoziomKolizji = calkowityPoziomKolizjiTemp;
            return;
        }
        int katZderzenia = katMaximumPrzod == -1 ? katMinimumPrzod : katMinimumPrzod + katMaximumPrzod >> 1;
        if (katMinimumPrzod < 60 && katMaximumPrzod > 120 || katZderzenia > 75 && katZderzenia < 105) {
            this.xPojazduTemp = this.xPojazdu;
            this.yPojazduTemp = this.yPojazdu;
            this.zmniejszenieMocyPojazdu = this.mocPojazdu;
            this.katPoruszaniaTemp = this.katPoruszania;
            MyCanvas.shakeTime = 200L;
            this.wstawUszkodzenia(this.uszkodzeniaRakieta * 334 >> 13, 0, 0);
            return;
        }
        this.detekcjaKolizji(1, katZderzenia);
        this.wstawUszkodzenia(this.uszkodzeniaRakieta * 334 >> 13, 0, 0);
        MyCanvas.shakeTime = 200L;
    }

    public void detekcjaKolizji(int wspolczynnikPoziomuDetekcji, int katKolizji) {
        if (wspolczynnikPoziomuDetekcji > 9) {
            this.xPojazduTemp = this.xPojazdu;
            this.yPojazduTemp = this.yPojazdu;
            this.zmniejszenieMocyPojazdu = this.mocPojazdu;
            this.katPoruszaniaTemp = this.katPoruszania;
            return;
        }
        int katSpowolnienia = 90 - katKolizji;
        if (katSpowolnienia < 0) {
            katSpowolnienia = -katSpowolnienia;
        }
        this.zmniejszenieMocyPojazdu = wspolczynnikPoziomuDetekcji * ((50 + (90 - katSpowolnienia) * 3) * this.mocPojazdu) >> 11;
        int zmianaKata = wspolczynnikPoziomuDetekcji * 10 << 16;
        if (zmianaKata > this.maksymalnaZmianaKata) {
            zmianaKata = this.maksymalnaZmianaKata;
        }
        if (katKolizji <= 90) {
            this.katPoruszaniaTemp = this.katPoruszania + zmianaKata;
            this.tymczasowaZmianaSkretu = 3 + (wspolczynnikPoziomuDetekcji >> 1);
        }
        if (katKolizji > 90) {
            this.katPoruszaniaTemp = this.katPoruszania - zmianaKata;
            this.tymczasowaZmianaSkretu = -3 - (wspolczynnikPoziomuDetekcji >> 1);
        }
        int strafe = 0;
        this.wyliczPunktyDetekcjiKat();
        int zwiekszenieMocyPojazdu = 0;
        if (this.mocPojazdu > 0) {
            if (this.isStrafeLeft) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = 60;
            }
            if (this.isStrafeRight) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = -60;
            }
        } else {
            if (this.isStrafeLeft) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = -60;
            }
            if (this.isStrafeRight) {
                zwiekszenieMocyPojazdu = this.mocMax / 2;
                strafe = 60;
            }
        }
        this.predkoscX = (this.mocPojazdu - this.zmniejszenieMocyPojazdu + zwiekszenieMocyPojazdu) * Math.cos((this.katPoruszaniaTemp >> 16) + strafe) >> 10;
        this.predkoscY = (this.mocPojazdu - this.zmniejszenieMocyPojazdu + zwiekszenieMocyPojazdu) * Math.sin((this.katPoruszaniaTemp >> 16) + strafe) >> 10;
        this.xPojazduTemp = this.xPojazdu + (this.predkoscX * this.intervalPeriodTime >> 2);
        this.yPojazduTemp = this.yPojazdu - (this.predkoscY * this.intervalPeriodTime >> 2);
        int katMinimumPrzod = -1;
        int katMaximumPrzod = -1;
        int nrPunktuDetekcjiLewo = this.liczbaPunktowDetekcji >> 1;
        int calkowityPoziomKolizjiTemp = 0;
        for (int i = 0; i <= nrPunktuDetekcjiLewo; ++i) {
            int x = this.xPojazduTemp + this.xPunktuDetekcjiKat[i] >> 16;
            int y = this.yPojazduTemp + this.yPunktuDetekcjiKat[i] >> 16;
            this.poziomKolizji[i] = this.mapa.returnHeight(x, y) + this.wysokoscPunktuDetekcji[i] - this.wysokosc;
            if (this.poziomKolizji[i] <= 0) continue;
            calkowityPoziomKolizjiTemp += this.poziomKolizji[i];
        }
        int detekcjaPod = this.mapa.returnHeight(this.xPojazduTemp >> 16, this.yPojazduTemp >> 16) + 5 - this.wysokosc;
        if (calkowityPoziomKolizjiTemp == 0 && detekcjaPod <= 0 || this.mocPojazdu < this.mocMax >> 3 && detekcjaPod <= this.staraDetekcjaPod) {
            this.calkowityPoziomKolizji = calkowityPoziomKolizjiTemp;
            return;
        }
        this.detekcjaKolizji(++wspolczynnikPoziomuDetekcji, katKolizji);
    }

    public void wyliczPunktyDetekcji() {
        this.liczbaPunktowDetekcji = 12;
        this.xPunktuDetekcji = new int[this.liczbaPunktowDetekcji];
        this.yPunktuDetekcji = new int[this.liczbaPunktowDetekcji];
        this.xPunktuDetekcjiKat = new int[this.liczbaPunktowDetekcji];
        this.yPunktuDetekcjiKat = new int[this.liczbaPunktowDetekcji];
        this.poziomKolizji = new int[this.liczbaPunktowDetekcji];
        this.zniszczenia = new int[this.liczbaPunktowDetekcji];
        this.wysokoscPunktuDetekcji = new int[this.liczbaPunktowDetekcji];
        int promienDetekcji = 327680;
        int kat = 0;
        int punkt = 0;
        punkt = 0;
        while (punkt < 12) {
            this.xPunktuDetekcji[punkt] = promienDetekcji * Math.cos(kat - 90) >> 10;
            this.yPunktuDetekcji[punkt] = -promienDetekcji * Math.sin(kat - 90) >> 10;
            this.wysokoscPunktuDetekcji[punkt] = 40;
            ++punkt;
            kat += 30;
        }
    }

    public void wystrzelPocisk() {
        block5: {
            block4: {
                if (liczbaRakiet <= 0 || this.stanSystemu[3] > 1) break block4;
                if (MyCanvas.applicationTime >= this.czasWystrzalu + (this.minimalnaPrzerwaPoWystrzale << this.stanSystemu[3])) break block5;
            }
            return;
        }
        --liczbaRakiet;
        Kokpit.rysowacRakiety = true;
        this.czasWystrzalu = MyCanvas.applicationTime;
        this.rakiety[this.nrNastepnegoPocisku++] = new Pocisk(this.xPojazduP, this.yPojazduP, this.katPoziomP, this.wysokosc - 10, 3);
        if (this.nrNastepnegoPocisku >= 10) {
            this.nrNastepnegoPocisku = 0;
        }
    }

    public void przemiescRakiety() {
        for (int i = 0; i < 10; ++i) {
            if (this.rakiety[i] == null) continue;
            this.rakiety[i].nextStep(this.intervalPeriodTime);
            if (this.rakiety[i].stanJednostki == -2) {
                this.rakiety[i] = null;
                continue;
            }
            if (this.rakiety[i].stanJednostki == -1 || this.mapa.returnHeight(this.rakiety[i].x, this.rakiety[i].y) <= this.rakiety[i].wysokosc - 3) continue;
            this.rakiety[i].wybuch();
        }
    }

    public void wyczyscRakiety() {
        for (int i = 0; i < 10; ++i) {
            this.rakiety[i] = null;
        }
    }

    public Pocisk[] zwrocRakiety() {
        Pocisk[] rakietyAktywne = new Pocisk[10];
        int liczbaRakietAktywnych = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.rakiety[i] == null || this.rakiety[i].stanJednostki == -2) continue;
            rakietyAktywne[liczbaRakietAktywnych] = this.rakiety[i];
            ++liczbaRakietAktywnych;
        }
        if (liczbaRakietAktywnych == 0) {
            return null;
        }
        Pocisk[] doPrzekazania = new Pocisk[liczbaRakietAktywnych];
        System.arraycopy(rakietyAktywne, 0, doPrzekazania, 0, liczbaRakietAktywnych);
        return doPrzekazania;
    }

    public int wybuchPojazd() {
        if (this.wybuch) {
            this.czasWybuchu += this.intervalPeriodTime;
            this.klatkaWybuchu = (byte)(this.czasWybuchu >> 7);
            if (this.klatkaWybuchu >= 5) {
                this.wybuch = false;
                return -1;
            }
            return this.klatkaWybuchu;
        }
        return -1;
    }

    public void kolizja(int rodzajObiektu, Jednostka jednostka, int glebokoscKolizji, int roznicaKatow) {
        if ((roznicaKatow -= 22) < 0) {
            roznicaKatow += 360;
        }
        int przedzialKata = roznicaKatow / 45;
        if (jednostka.stanJednostki == -2 || jednostka.stanJednostki == -3) {
            return;
        }
        if (jednostka.stanJednostki == -1) {
            rodzajObiektu = 5;
        }
        int uszkodzenia = 0;
        switch (rodzajObiektu) {
            case 1: {
                uszkodzenia += this.uszkodzeniaRakieta * (128 + (256 - glebokoscKolizji)) >> 10;
                MyCanvas.shakeTime = 300L;
                this.kolizja = true;
                break;
            }
            case 5: {
                MyCanvas.shakeTime = 300L;
                if (glebokoscKolizji <= 128) {
                    uszkodzenia += this.uszkodzeniaEksplozja;
                    break;
                }
                uszkodzenia += this.uszkodzeniaEksplozja * (128 + (256 - glebokoscKolizji)) >> 8;
                break;
            }
            case 4: {
                MyCanvas.shakeTime = 300L;
                uszkodzenia = glebokoscKolizji <= 128 ? (uszkodzenia += this.uszkodzeniaRakieta) : (uszkodzenia += this.uszkodzeniaRakieta * (128 + (256 - glebokoscKolizji)) >> 8);
                jednostka.stanJednostki = (byte)-2;
                if (this.wybuch && this.czasWybuchu <= 500) break;
                this.wybuch = true;
                this.czasWybuchu = 64;
                break;
            }
            case 6: {
                this.paliwo += this.przyrostPaliwa;
                if (this.paliwo > this.paliwoMax) {
                    this.paliwo = this.paliwoMax;
                }
                jednostka.stanJednostki = (byte)-3;
                break;
            }
            case 7: {
                MyCanvas.shakeTime = 300L;
                if (jednostka.stanJednostki != 1) break;
                uszkodzenia = glebokoscKolizji <= 128 ? (uszkodzenia += this.uszkodzeniaMina) : (uszkodzenia += this.uszkodzeniaMina * (128 + (256 - glebokoscKolizji)) >> 8);
                jednostka.stanJednostki = (byte)-2;
                if (this.wybuch && this.czasWybuchu <= 500) break;
                this.wybuch = true;
                this.czasWybuchu = 64;
            }
        }
        if (uszkodzenia > 0) {
            if ((przedzialKata & 1) == 0) {
                this.wstawUszkodzenia(uszkodzenia, this.przeksztalceniePrzedzialu[przedzialKata >> 1], rodzajObiektu);
            } else {
                this.wstawUszkodzenia(uszkodzenia * 3 >> 2, this.przeksztalceniePrzedzialu[przedzialKata >> 1], rodzajObiektu);
                this.wstawUszkodzenia(uszkodzenia * 3 >> 2, this.przeksztalceniePrzedzialu[(przedzialKata >> 1) + 1 & 3], rodzajObiektu);
            }
        }
    }

    public void wstawUszkodzenia(int uszkodzenia, int czescPojazdu, int rodzajObiektu) {
        int n = czescPojazdu;
        uszkodzeniaPojazdu[n] = uszkodzeniaPojazdu[n] + uszkodzenia * 2;
        byte staryStanPojazdu = stanPojazdu[czescPojazdu];
        Pojazd.stanPojazdu[czescPojazdu] = (byte)(uszkodzeniaPojazdu[czescPojazdu] / this.poziomUszkodzen);
        if (stanPojazdu[czescPojazdu] >= 3) {
            this.zmianaStanuPojazdu[czescPojazdu] = true;
            this.zniszczony = true;
            Pojazd.stanPojazdu[czescPojazdu] = 2;
            return;
        }
        if (stanPojazdu[czescPojazdu] != staryStanPojazdu) {
            this.zmianaStanuPojazdu[czescPojazdu] = true;
            int zmiana = Util.random(stanPojazdu[czescPojazdu] + 1);
            int system = Util.random(5);
            this.zmienStanSystemu(system, zmiana);
        }
    }

    public void zmienStanSystemu(int system, int zmiana) {
        int n = system;
        this.stanSystemu[n] = (byte)(this.stanSystemu[n] + zmiana);
        if (this.stanSystemu[system] > 2) {
            this.stanSystemu[system] = 2;
        }
        if (system == 2 && this.stanSystemu[system] == 2) {
            MyCanvas.kokpit.systemElektronikiZniszczony();
        }
        if (system == 3) {
            if (this.stanSystemu[system] == 1) {
                liczbaRakiet >>= 1;
            }
            if (this.stanSystemu[system] == 2) {
                liczbaRakiet = 0;
            }
            Kokpit.rysowacRakiety = true;
        }
        this.zmianaStanuSystemu[system] = true;
    }

    public void zwolnijZasoby() {
        this.wyczyscRakiety();
        this.rakiety = null;
    }

    public void ustawParametryPoziomuTrudnosci(int poziom) {
        switch (poziom) {
            case 0: {
                this.poziomUszkodzen = 114688;
                this.zuzyciePaliwa[0] = 512;
                this.zuzyciePaliwa[1] = 768;
                this.zuzyciePaliwa[2] = 1024;
                break;
            }
            case 1: {
                this.poziomUszkodzen = 90112;
                this.zuzyciePaliwa[0] = 768;
                this.zuzyciePaliwa[1] = 1024;
                this.zuzyciePaliwa[2] = 1280;
                break;
            }
            case 2: {
                this.poziomUszkodzen = 65536;
                this.zuzyciePaliwa[0] = 1024;
                this.zuzyciePaliwa[1] = 1280;
                this.zuzyciePaliwa[2] = 1536;
                break;
            }
            case 3: {
                this.poziomUszkodzen = 49152;
                this.zuzyciePaliwa[0] = 1152;
                this.zuzyciePaliwa[1] = 1408;
                this.zuzyciePaliwa[2] = 1664;
            }
        }
    }

    public void naprawPojazd() {
        int i;
        this.paliwo = 65536;
        for (i = 0; i < 5; ++i) {
            this.stanSystemu[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            Pojazd.uszkodzeniaPojazdu[i] = 0;
            Pojazd.stanPojazdu[i] = 0;
        }
        this.kolizja = false;
        this.wybuch = false;
        this.wyczyscRakiety();
        this.wysokoscBrakuPaliwa = 40;
        this.mocPojazdu = 0;
        this.katPion = 0;
        MyCanvas.kokpit.systemElektronikiNaprawiony();
        this.czasWystrzalu = MyCanvas.applicationTime + 500;
        this.zniszczony = false;
        liczbaRakiet = MyCanvas.trasa.liczbaRakietPoziom;
    }

    static {
        uszkodzeniaPojazdu = new int[4];
        stanPojazdu = new byte[4];
    }
}

