/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class MainView
extends GameCanvas
implements Runnable {
    public static GameMIDlet midlet;
    public Thread gameThread;
    public static int WIDTH;
    public static int HEIGHT;
    public static int GAME_WIDTH;
    public static int GAME_HEIGHT;
    public static int GAME_MODE;
    public static long startTime;
    public static long duration;
    private static Random rand;
    boolean showInfo;
    private static int KEY;
    private static int counter;
    public long sTime;
    public long time;
    public long pauseTime;
    private static boolean isPaused;
    private static final int KEY_LEFT_SOFT = -6;
    private static final int KEY_RIGHT_SOFT = -7;
    public static byte TOP_LEFT;
    public Button buttonHome;
    public static final byte NEXTWAVE_LOGO = 0;
    public static final byte GAME_SPLASH = 1;
    public static final byte GAME_MENU = 6;
    public static final byte GAME_PLAY = 7;
    public static Image imgNextwaveLogo;
    public static Image imgSplash;
    public static Image imgGameMenuBg;
    public Image splashTitle;
    public Image splashAlien;
    public Image imgLine;
    public Image tit;
    public Image player;
    public GameView canvas;
    public MenuView menuView;
    public boolean vibrateEnabled = true;
    public boolean soundEnabled = true;
    private Player mp0;
    private Player mp1;
    InputStream Is0;
    InputStream Is1;
    public final short[] sinValue = new short[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384};
    public final short[] tanValue = new short[]{0, 18, 36, 54, 72, 90, 108, 126, 144, 162, 181, 199, 218, 236, 255, 274, 294, 313, 333, 353, 373, 393, 414, 435, 456, 477, 499, 522, 544, 568, 591, 615, 640, 665, 691, 717, 744, 772, 800, 829, 859, 890, 922, 955, 989, 1024};

    public MainView(GameMIDlet m) {
        super(false);
        this.setFullScreenMode(true);
        midlet = m;
        rand = new Random(System.currentTimeMillis());
        WIDTH = 240;
        HEIGHT = 320;
        GAME_WIDTH = 240;
        GAME_HEIGHT = 320;
        this.resetGameMode(0);
        this.canvas = new GameView(this);
        this.menuView = new MenuView(this);
        this.getSettings();
        this.startThread();
    }

    private void startThread() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    public void showGameView() {
        int previousMode = GAME_MODE;
        if (this.canvas.bg == null) {
            if (imgGameMenuBg != null) {
                imgGameMenuBg = null;
                this.menuView.clearImages();
            }
            this.canvas.loadImages1();
        }
        GAME_MODE = 7;
        this.buttonHome.setXY(183, 310);
        counter = 0;
    }

    public void showMenu(boolean hasContinue) {
        this.menuView.hasContinue = false;
        int previousMode = GAME_MODE;
        GAME_MODE = 6;
        this.menuView.loadImages();
        counter = 0;
    }

    public void resetGameMode(int toMode) {
        int previousMode = GAME_MODE;
        GAME_MODE = toMode;
        counter = 0;
        switch (GAME_MODE) {
            case 0: {
                try {
                    imgNextwaveLogo = Image.createImage((String)"/res/nextwavelogo.png");
                    this.buttonHome = new Button(0, 0, "/res/back.png", "/res/back1.png");
                }
                catch (Exception e) {}
                break;
            }
            case 1: {
                try {
                    imgNextwaveLogo = null;
                    imgSplash = Image.createImage((String)"/res/moon.png");
                    imgGameMenuBg = Image.createImage((String)"/res/menu-scr.png");
                    this.splashTitle = Image.createImage((String)"/res/Splash.png");
                    this.splashAlien = Image.createImage((String)"/res/splashAlien.png");
                    this.imgLine = Image.createImage((String)"/res/line.png");
                }
                catch (Exception e) {}
                break;
            }
            case 6: {
                imgSplash = null;
                imgGameMenuBg = null;
                this.splashAlien = null;
                this.splashTitle = null;
                try {
                    imgGameMenuBg = Image.createImage((String)"/res/menu-scr.png");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.menuView.butNewGame == null) {
                    this.menuView.reset(false);
                    break;
                }
                this.menuView.reset(true);
                break;
            }
            case 7: {
                imgGameMenuBg = null;
                this.canvas.loadImages1();
                if (this.canvas.bg == null) {
                    this.canvas.reset(true);
                    break;
                }
                this.canvas.reset(false);
            }
        }
    }

    public void playSound() {
        if (this.soundEnabled) {
            try {
                if (this.mp0 == null) {
                    this.Is0 = this.getClass().getResourceAsStream("/res/hit.mid");
                    this.mp0 = Manager.createPlayer((InputStream)this.Is0, (String)"audio/midi");
                    this.mp0.prefetch();
                }
                if (this.mp0.getState() == 400) {
                    this.mp0.stop();
                }
                this.mp0.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playSound1() {
        if (this.soundEnabled) {
            try {
                if (this.mp1 == null) {
                    this.Is1 = this.getClass().getResourceAsStream("/res/blast.mid");
                    this.mp1 = Manager.createPlayer((InputStream)this.Is1, (String)"audio/midi");
                    this.mp1.prefetch();
                }
                if (this.mp1.getState() != 400) {
                    this.mp1.stop();
                }
                this.mp1.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void vibrate() {
        if (this.vibrateEnabled) {
            Display.getDisplay((MIDlet)midlet).vibrate(300);
        }
    }

    protected void hideNotify() {
        if (GAME_MODE == 7) {
            if (this.canvas.state == 1) {
                this.menuView.hasContinue = true;
                this.resetGameMode(6);
            }
        }
    }

    public void showNotify() {
    }

    public final void run() {
        Thread currentThread = Thread.currentThread();
        while (this.gameThread == currentThread) {
            startTime = System.currentTimeMillis();
            if (this.getWidth() != 240) continue;
            try {
                ++counter;
                switch (GAME_MODE) {
                    case 0: {
                        if (counter <= 30) break;
                        this.resetGameMode(1);
                        break;
                    }
                    case 1: {
                        if (counter <= 30) break;
                        this.resetGameMode(6);
                        break;
                    }
                    case 6: {
                        this.menuView.run();
                        break;
                    }
                    case 7: {
                        this.canvas.run();
                    }
                }
                this.repaint();
                duration = System.currentTimeMillis() - startTime;
                if (duration >= 25L) continue;
                Thread.sleep(25L - duration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void paint(Graphics g) {
        if (this.gameThread != null) {
            if (this.getWidth() != 240) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(0);
                g.setFont(SystemFont.font0);
                SystemFont.drawText("Landscape view is not supported. Please switch back to Portrait view", g, 5, 110, 300, 20);
                return;
            }
            g.setFont(SystemFont.font2);
            switch (GAME_MODE) {
                case 0: {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
                    g.drawImage(imgNextwaveLogo, 30, 117, (int)TOP_LEFT);
                    break;
                }
                case 1: {
                    g.setColor(255, 255, 255);
                    g.drawImage(imgGameMenuBg, 0, 0, 0x10 | 4);
                    g.drawImage(imgSplash, 0, 0, 0x10 | 4);
                    g.drawImage(this.splashAlien, 114, 3, 0x10 | 4);
                    g.drawImage(this.splashTitle, 6, 117, 0x10 | 4);
                    g.drawImage(this.imgLine, -15, 75, 0x10 | 4);
                    g.drawImage(this.imgLine, -40, 200, 0x10 | 4);
                    break;
                }
                case 6: {
                    g.drawImage(imgGameMenuBg, 0, 0, 0x10 | 4);
                    this.menuView.paint(g);
                    break;
                }
                case 7: {
                    this.canvas.paint(g);
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.getWidth() != 240) {
            return;
        }
        switch (GAME_MODE) {
            case 6: {
                this.menuView.keyPressed(keyCode);
                break;
            }
            case 7: {
                this.canvas.keyPressed(keyCode);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.getWidth() != 240) {
            return;
        }
        switch (GAME_MODE) {
            case 6: {
                this.menuView.keyReleased(keyCode);
                break;
            }
            case 7: {
                this.canvas.keyReleased(keyCode);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.getWidth() != 240) {
            return;
        }
        switch (GAME_MODE) {
            case 6: {
                this.menuView.keyRepeated(keyCode);
                break;
            }
            case 7: {
                this.canvas.keyRepeated(keyCode);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.getWidth() != 240) {
            return;
        }
        switch (GAME_MODE) {
            case 6: {
                this.menuView.pointerPressed(x, y);
                break;
            }
            case 7: {
                this.canvas.pointerPressed(x, y);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.getWidth() != 240) {
            return;
        }
        switch (GAME_MODE) {
            case 6: {
                this.menuView.pointerReleased(x, y);
                break;
            }
            case 7: {
                this.canvas.pointerReleased(x, y);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        switch (GAME_MODE) {
            case 6: {
                this.menuView.pointerDragged(x, y);
                break;
            }
        }
    }

    public int sin(int degree) {
        if (degree < 0) {
            degree = degree % 360 + 360;
        } else if (degree > 360) {
            degree %= 360;
        }
        return degree < 91 ? this.sinValue[degree] : (degree < 181 ? this.sinValue[180 - degree] : (degree < 271 ? -this.sinValue[degree - 180] : -this.sinValue[360 - degree]));
    }

    public int cos(int degree) {
        return this.sin(90 - degree);
    }

    public int distance(int ox, int oy, int tx, int ty) {
        int ang = this.angle(ox, oy, tx, ty);
        int temp = (ang + 45) % 360 / 90;
        int dist = 0;
        dist = temp == 0 || temp == 2 ? (tx - ox << 14) / this.cos(ang) : (ty - oy << 14) / this.sin(ang);
        return Math.abs(dist);
    }

    public int angle(int ox, int oy, int tx, int ty) {
        int dx = Math.abs(tx - ox);
        int dy = Math.abs(ty - oy);
        int result = 0;
        int ratio = dx >= dy ? (dy << 10) / dx : (dx << 10) / dy;
        switch (ratio) {
            case 0: {
                result = ratio;
                break;
            }
            case 1024: {
                result = 45;
                break;
            }
            default: {
                result = ratio < 181 ? 1 : (ratio < 353 ? 10 : (ratio < 544 ? 19 : (ratio < 772 ? 28 : 37)));
                while (ratio > this.tanValue[result]) {
                    ++result;
                }
                break block0;
            }
        }
        int n = result = dx >= dy ? result : 90 - result;
        if (tx < ox) {
            result = 180 - result;
        }
        if (ty < oy) {
            result = 360 - result;
        }
        return result;
    }

    public void getSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SETTING", (boolean)true);
            byte[] set = new byte[]{1, 1};
            if (rs.getNumRecords() == 0) {
                rs.addRecord(set, 0, set.length);
                this.soundEnabled = true;
                this.vibrateEnabled = true;
            } else {
                set = rs.getRecord(1);
                this.soundEnabled = set[0] == 1;
                this.vibrateEnabled = set[1] == 1;
            }
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SETTING", (boolean)true);
            byte[] set = new byte[]{(byte)(this.soundEnabled ? 1 : 0), (byte)(this.vibrateEnabled ? 1 : 0)};
            rs.setRecord(1, set, 0, set.length);
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        KEY = 0;
        counter = 0;
        TOP_LEFT = (byte)20;
    }
}

