/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public final class GameEngine {
    MyGameCanvas canvas;
    GameMap map;
    GameRole role;
    Enemy[] enemy;
    static Vector roleShot = new Vector();
    static Vector enemyShot = new Vector();
    byte gameRank = 0;
    byte passNum = 0;
    byte money;
    int score = 0;
    static Random rnd = new Random();
    short[][] hostagePos;
    public byte[][] hostageOff = new byte[][]{{9, 9, 59, 0}, {13, 14, 56, 0}, {12, 10, 40, 0}, {12, 9, 40, 0}, {10, 10, 37, 0}, {17, 9, 39, 0}, {19, 9, 42, 0}, {18, 10, 40, 0}, {9, 15, 46, 0}, {9, 15, 45, -3}, {21, 24, 56, 0}, {22, 24, 56, 0}, {21, 25, 56, 0}};
    short[][] imgDatHostage = new short[][]{{0, 0, 18, 59}, {18, 0, 27, 56}, {45, 0, 24, 46}, {69, 0, 24, 42}, {93, 0, 22, 40}, {105, 41, 21, 40}, {84, 43, 20, 37}, {58, 46, 26, 39}, {100, 82, 28, 42}, {38, 56, 20, 20}, {0, 76, 45, 24}, {0, 100, 46, 28}, {52, 100, 46, 28}};
    short[][] planePos;
    byte planeInjureTime;
    short[][] you_tong;
    short[][] on_off;
    short[][] trapPos;
    public static final byte trap_X = 0;
    public static final byte trap_Y = 1;
    public static final byte trap_Type = 2;
    public static final byte trap_Temp = 3;
    public static final byte trap_StartX = 4;
    public static final byte trap_Distance = 5;
    boolean isMoveMF;
    byte[][] imgMuFa = new byte[][]{{0, 0, 100, 20}, {0, 20, 100, 20}, {0, 40, 100, 20}};
    Vector item = new Vector();
    byte[][] imgDatHp = new byte[][]{{0, 0, 23, 16}, {23, 0, 22, 16}, {45, 0, 24, 21}, {0, 16, 23, 17}, {23, 16, 10, 5}, {24, 22, 9, 9}, {35, 17, 5, 10}};
    byte passNum2 = 0;
    public static final byte EFFECT_AH = 0;
    public static final byte EFFECT_BOMB = 1;
    public static final byte EFFECT_DA = 2;
    public static final byte EFFECT_HONG = 3;
    public static final byte EFFECT_SA = 4;
    public static final byte EFFECT_BLOOD = 5;
    public static final byte EFFECT_PIECE = 6;
    public static final byte EFFECT_longGunH = 9;
    public static final byte EFFECT_longGunV = 10;
    public static final byte EFFECT_BOMBFOG = 11;
    public static final byte EFFECT_MISSILEEFF = 12;
    public static final byte EFFECT_SCORENUM = 13;
    public static Vector hitEffectV = new Vector();
    byte[][] imgDataFireEff1 = new byte[][]{{0, 0, 13, 9}, {0, 9, 17, 11}, {0, 21, 13, 5}, {17, 4, 9, 13}, {26, 0, 11, 17}, {38, 4, 5, 13}};
    byte[][] imgDataFireEff2 = new byte[][]{{0, 0, 10, 30}, {10, 0, 12, 36}, {22, 0, 14, 46}, {37, 0, 18, 49}, {55, 43, 29, 11}, {55, 31, 35, 12}, {55, 17, 45, 14}, {55, 0, 49, 16}};
    byte[][] imgDatAh = new byte[][]{{0, 0, 22, 21}, {22, 0, 19, 18}, {41, 0, 16, 16}};
    byte[][] imgDatBombEff = new byte[][]{{0, 0, 22, 20}, {0, 20, 69, 31}, {0, 51, 54, 33}, {69, 0, 62, 34}, {69, 34, 51, 26}, {55, 64, 45, 20}};
    byte[][] bombOff = new byte[][]{{-11, -9, -10, -14}, {18, 20, 11, 7}, {5, 7, 11, 11}, {9, 11, 11, 13}, {3, 6, 5, 7}, {3, 3, 2, 5}};
    byte[][] imgDatDa = new byte[][]{{0, 0, 25, 25}, {25, 6, 19, 19}, {44, 10, 15, 15}};
    byte[][] imgDatHong = new byte[][]{{0, 0, 53, 54}, {53, 0, 37, 36}, {53, 36, 28, 28}};
    public static final byte SHOT1_H = 0;
    public static final byte SHOT1_V = 1;
    public static final byte SHOT2_H = 2;
    public static final byte SHOT2_V = 3;
    public static final byte SHOT3_H = 4;
    public static final byte SHOT3_V = 5;
    public static final byte SHOT4_H = 6;
    public static final byte SHOT4_V = 7;
    public static final byte SHOT_BOMB = 8;
    public static final byte SHOT_BOMB1 = 9;
    public static final byte SHOT_MISSILE = 10;
    public static final byte SHOT_FLOWER = 11;
    public static final byte SHOT_HUOJIAN = 12;
    public static final byte SHOT_TANK = 13;
    int tempSpx;
    int tempSpy;
    public static byte[][] imgDatShot1 = new byte[][]{{0, 0, 18, 7}, {18, 0, 7, 18}};
    public static byte[][] imgDatShot2 = new byte[][]{{0, 0, 30, 7}, {30, 0, 7, 30}};
    public static short[][] imgDatShot3 = new short[][]{{0, 0, 39, 31}, {39, 0, 63, 47}, {0, 47, 66, 43}, {66, 54, 36, 28}, {102, 63, 31, 39}, {104, 0, 45, 63}, {149, 36, 43, 66}, {156, 0, 28, 36}};
    public static short[][] imgDatShot4 = new short[][]{{4, 0, 57, 10}, {0, 10, 61, 14}, {61, 0, 10, 57}, {71, 0, 14, 61}};
    public static short[][] imgDatShotBomb = new short[][]{{0, 0, 28, 22}, {28, 0, 23, 15}, {51, 0, 21, 26}, {72, 0, 25, 25}, {97, 0, 26, 22}, {123, 0, 22, 14}, {145, 0, 23, 25}, {168, 0, 15, 25}};
    RecordStore db;

    public GameEngine() {
        this.canvas = MyGameCanvas.me;
        this.map = new GameMap(360, 360);
    }

    public void ctrlReleased(int key) {
        this.role.ctrlReleased(key);
    }

    public void ctrl(int keyCode) {
        this.role.ctrl(keyCode);
    }

    public void initEnemy(int gameRank) {
        this.enemy = null;
        Object enemyData = null;
        switch (gameRank) {
            case 3: {
                enemyData = new short[][]{{200, 362, 0}, {690, 298, 5}, {1250, 298, 0}, {1420, 266, 5}, {2340, 234, 0}, {2730, 298, 5}, {3215, 234, 0}, {3450, 362, 0}, {1467, 274, 0}, {2234, 242, 0}, {282, 366, 5}, {1077, 312, 0}, {1377, 209, 5}, {2321, 245, 0}, {2654, 241, 5}, {3163, 240, 0}, {3227, 241, 5}, {3434, 274, 0}, {197, 306, 5}, {615, 313, 0}, {644, 313, 5}, {1141, 242, 0}, {1275, 207, 5}, {1639, 246, 5}, {2353, 179, 0}, {2602, 310, 0}, {187, 365, 5}, {346, 334, 0}, {1028, 306, 5}, {1856, 242, 0}, {3145, 341, 5}, {3396, 367, 0}, {3461, 365, 5}};
                break;
            }
            case 4: {
                enemyData = new short[][]{{1331, 395, 3}, {1368, 396, 3}, {1582, 399, 3}, {1619, 400, 3}, {1798, 400, 3}, {1835, 401, 3}, {1748, 400, 3}, {1983, 402, 3}, {2019, 403, 3}, {1995, 402, 3}, {2165, 406, 3}, {2197, 405, 3}, {1450, 383, 4}, {1650, 383, 4}, {1850, 383, 4}, {2050, 383, 4}, {2250, 383, 4}, {248, 300, 3}, {915, 306, 3}, {2834, 274, 3}, {2556, 303, 3}, {3139, 343, 3}, {1089, 300, 3}, {3488, 375, 3}, {3299, 300, 3}, {187, 379, 3}, {370, 380, 3}, {523, 378, 3}, {680, 304, 3}, {2724, 341, 3}, {2961, 343, 3}, {889, 374, 3}, {962, 374, 3}, {3404, 373, 3}, {3221, 378, 3}, {3453, 375, 3}};
                break;
            }
            case 5: {
                enemyData = new short[][]{{3365, 362, 0}, {3375, 362, 1}, {3385, 362, 2}, {3408, 362, 5}, {3428, 362, 5}, {3448, 362, 2}, {3468, 362, 1}, {3525, 362, 0}, {3548, 362, 1}, {3463, 362, 6}, {3511, 362, 6}, {3480, 362, 7}, {2100, 383, 4}, {2300, 383, 4}, {2500, 383, 4}, {473, 366, 6}, {1016, 306, 1}, {3005, 340, 1}, {359, 305, 2}, {651, 274, 2}, {933, 303, 0}, {1623, 238, 5}, {2820, 277, 0}, {1474, 207, 5}, {1289, 304, 0}, {212, 379, 1}};
                break;
            }
            default: {
                enemyData = GameEngine.getPosData("emy" + gameRank + ".dat");
            }
        }
        if (enemyData != null) {
            this.enemy = new Enemy[((short[][])enemyData).length];
            int i = 0;
            while (i < ((short[][])enemyData).length) {
                this.enemy[i] = new Enemy(this);
                this.enemy[i].initEnemy(enemyData[i][0], enemyData[i][1], enemyData[i][2]);
                ++i;
            }
        } else {
            System.out.println("Load Enemy Data Fail");
        }
    }

    public void enemyMove() {
        if (this.enemy != null) {
            int i = 0;
            while (i < this.enemy.length) {
                this.enemy[i].move();
                ++i;
            }
        }
    }

    public void drawEnemy(Graphics g) {
        if (this.enemy != null) {
            int i = 0;
            while (i < this.enemy.length) {
                this.enemy[i].paint();
                ++i;
            }
        }
    }

    public void initHostage() {
        this.hostagePos = null;
        switch (this.gameRank) {
            case 0: {
                this.hostagePos = new short[][]{{494, 202, 0, 0, 0, 0}, {1921, 192, 0, 0, 2, 0}, {434, 338, 1, 0, 3, 0}, {584, 338, 1, 0, 4, 0}, {1146, 225, 1, 0, 1, 0}, {2455, 338, 1, 0, 5, 0}};
                break;
            }
            case 1: {
                this.hostagePos = new short[][]{{372, 240, 0, 0, 0, 0}, {409, 263, 0, 0, 4, 0}, {3148, 239, 0, 0, 4, 0}, {648, 353, 1, 0, 3, 0}, {1517, 350, 1, 0, 1, 0}, {2004, 290, 1, 0, 2, 0}, {3197, 348, 1, 0, 5, 0}};
                break;
            }
            case 2: {
                this.hostagePos = new short[][]{{620, 218, 0, 0, 1, 0}, {673, 228, 0, 0, 4, 0}, {725, 199, 0, 0, 4, 0}, {302, 357, 1, 0, 3, 0}, {396, 355, 1, 0, 0, 0}, {496, 354, 1, 0, 3, 0}, {676, 320, 1, 0, 3, 0}, {1080, 351, 1, 0, 2, 0}, {1188, 352, 1, 0, 5, 0}};
                break;
            }
            case 3: {
                this.hostagePos = new short[][]{{1422, 126, 0, 0, 1, 0}, {1352, 140, 0, 0, 6, 0}, {2763, 211, 0, 0, 7, 0}, {2847, 206, 0, 0, 2, 0}, {496, 274, 1, 0, 3, 0}, {1680, 210, 1, 0, 4, 0}};
                break;
            }
            case 4: {
                this.hostagePos = new short[][]{{672, 338, 1, 0, 0, 0}, {1008, 338, 1, 0, 6, 0}, {2848, 306, 1, 0, 7, 0}, {2896, 306, 1, 0, 4, 0}, {3152, 306, 1, 0, 1, 0}, {587, 250, 0, 0, 3, 0}, {3051, 250, 0, 0, 4, 0}, {806, 250, 0, 0, 5, 0}};
                break;
            }
            case 5: {
                this.hostagePos = new short[][]{{880, 274, 1, 0, 1, 0}, {1680, 274, 1, 0, 5, 0}, {3376, 338, 1, 0, 2, 0}, {445, 259, 0, 0, 3, 0}, {2940, 254, 0, 0, 7, 0}};
            }
        }
    }

    public void moveHostage() {
        int i = 0;
        while (i < this.hostagePos.length) {
            switch (this.hostagePos[i][2]) {
                case 0: {
                    this.hostagePos[i][5] = 0;
                    break;
                }
                case 1: {
                    byte[] motion = new byte[]{8, 8, 9, 9};
                    this.hostagePos[i][5] = motion[this.hostagePos[i][3]];
                    short[] sArray = this.hostagePos[i];
                    sArray[3] = (short)(sArray[3] + 1);
                    if (sArray[3] < motion.length) break;
                    this.hostagePos[i][3] = 0;
                    break;
                }
                case 2: {
                    short[] sArray = this.hostagePos[i];
                    sArray[1] = (short)(sArray[1] + 10);
                    this.hostagePos[i][5] = 1;
                    if (this.map.canFall(this.hostagePos[i][0], this.hostagePos[i][1])) break;
                    this.hostagePos[i][1] = (short)(this.hostagePos[i][1] / GameMap.tileWidth * GameMap.tileWidth);
                    this.hostagePos[i][2] = 3;
                    break;
                }
                case 3: {
                    byte[] motion = new byte[]{2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3};
                    this.hostagePos[i][5] = motion[this.hostagePos[i][3]];
                    short[] sArray = this.hostagePos[i];
                    sArray[3] = (short)(sArray[3] + 1);
                    if (sArray[3] < motion.length) break;
                    this.hostagePos[i][3] = 0;
                    this.hostagePos[i][2] = 4;
                    break;
                }
                case 4: {
                    byte[] motion = new byte[]{2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 2, 2};
                    this.hostagePos[i][5] = motion[this.hostagePos[i][3]];
                    short[] sArray = this.hostagePos[i];
                    sArray[3] = (short)(sArray[3] + 1);
                    if (sArray[3] < motion.length) break;
                    this.hostagePos[i][3] = 0;
                    this.hostagePos[i][2] = 5;
                    this.addItem(this.hostagePos[i][4], this.hostagePos[i][0] - 18, this.hostagePos[i][1]);
                    break;
                }
                case 5: {
                    if (this.hostagePos[i][3] >= 5) {
                        this.hostagePos[i][5] = 2;
                    }
                    this.hostagePos[i][5] = (short)(this.hostagePos[i][3] % 2 == 0 ? 2 : -1);
                    short[] sArray = this.hostagePos[i];
                    sArray[3] = (short)(sArray[3] + 1);
                    if (sArray[3] < 15) break;
                    this.hostagePos[i][3] = 0;
                    this.hostagePos[i][2] = 6;
                    break;
                }
                case 6: {
                    this.hostagePos[i][5] = -1;
                    break;
                }
                case 7: {
                    byte[] motion = new byte[]{10, 11, 12};
                    this.hostagePos[i][5] = motion[this.hostagePos[i][3]];
                    short[] sArray = this.hostagePos[i];
                    sArray[3] = (short)(sArray[3] + 1);
                    if (sArray[3] < motion.length) break;
                    this.hostagePos[i][3] = 0;
                    this.hostagePos[i][2] = 2;
                }
            }
            ++i;
        }
    }

    public void drawHostage() {
        int i = 0;
        while (i < this.hostagePos.length) {
            if (this.hostagePos[i][5] >= 0) {
                this.drawFrame(this.hostagePos[i][0] - this.hostageOff[this.hostagePos[i][5]][0], this.hostagePos[i][1] + this.hostageOff[this.hostagePos[i][5]][3] + 18, this.hostagePos[i][5], false);
                if (this.hostagePos[i][5] == 0) {
                    int[] col = new int[]{0, 12630168, 0};
                    int j = 0;
                    while (j < 3) {
                        Tools.addObject((byte)3, this.hostagePos[i][0] - 2 + j, 0, this.hostagePos[i][0] - 2 + j, this.hostagePos[i][1] - 59 + 18, 20, col[j], 10);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void drawFrame(int x, int y, int index, boolean isLeft) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{0, 0, 0, 0, 0};
                break;
            }
            case 1: {
                data = new byte[]{1, 0, 0, 0, 0};
                break;
            }
            case 2: {
                data = new byte[]{4, 0, 0, 0, 0};
                break;
            }
            case 3: {
                data = new byte[]{5, 0, 0, 0, 0};
                break;
            }
            case 4: {
                data = new byte[]{6, 0, 0, 0, 0};
                break;
            }
            case 5: {
                data = new byte[]{7, 0, 0, 0, 0};
                break;
            }
            case 6: {
                data = new byte[]{8, 0, 0, 0, 0};
                break;
            }
            case 7: {
                data = new byte[]{4, 6, 0, 0, 0, 9, 0, 0, 8, 0};
                break;
            }
            case 8: {
                data = new byte[]{2, 0, 0, 0, 0};
                break;
            }
            case 9: {
                data = new byte[]{3, 0, 0, 0, 0};
                break;
            }
            case 10: {
                data = new byte[]{1, 8, 0, 10, 0, 10, 0, -9, 0, 0};
                break;
            }
            case 11: {
                data = new byte[]{1, 9, 0, 10, 0, 11, 0, -7, 0, 0};
                break;
            }
            case 12: {
                data = new byte[]{1, 8, 0, 11, 0, 12, 0, -7, 0, 0};
            }
        }
        int i = 0;
        while (i < data.length) {
            Tools.addObject(21, x + data[i + (isLeft ? 3 : 1)], y + data[i + 2], this.imgDatHostage[data[i]], 36, (byte)(isLeft ? data[i + 4] ^ 1 : data[i + 4]), 10);
            i += 5;
        }
    }

    public void lockSceen(int x1, int x2) {
        GameRole.sceen_min = x1;
        GameRole.sceen_max = x2;
    }

    public void unLockSceen() {
        GameRole.sceen_min = 0;
        GameRole.sceen_max = this.map.mapSize[0] * GameMap.tileWidth;
    }

    public void initPlane() {
        this.planePos = null;
        switch (this.gameRank) {
            case 0: {
                this.planePos = new short[][]{{1624, 48, 0, 0, 1, 10}, {2385, 206, 0, 0, 1, 10}};
                break;
            }
            case 1: {
                this.planePos = new short[][]{{1129, 180, 0, 0, 1, 10}, {2428, 180, 0, 0, 1, 10}};
                break;
            }
            case 2: {
                this.planePos = new short[][]{{1138, 213, 0, 0, 1, 10}};
                break;
            }
            case 5: {
                this.planePos = new short[][]{{3480, 213, 0, 0, 1, 10}, {3555, 213, 0, 0, 1, 10}};
            }
        }
    }

    public void movePlane() {
        if (this.planePos == null) {
            return;
        }
        int i = 0;
        while (i < this.planePos.length) {
            if (this.planePos[i][2] != 3) {
                switch (this.planePos[i][2]) {
                    case 0: {
                        if (Math.abs(this.planePos[i][0] - this.role.x) >= GameMap.SCREEN_WIDTH) break;
                        this.planePos[i][2] = 1;
                        this.lockSceen(GameMap.setOffX, this.planePos[i][0]);
                        break;
                    }
                    case 1: {
                        short[] sArray = this.planePos[i];
                        sArray[0] = (short)(sArray[0] + (this.planePos[i][4] == 0 ? 10 : -10));
                        if (this.planePos[i][0] + 100 < GameMap.setOffX) {
                            this.planePos[i][4] = 0;
                            this.planePos[i][3] = 0;
                        } else if (this.planePos[i][0] > GameMap.setOffX + GameMap.SCREEN_WIDTH + 30) {
                            this.planePos[i][4] = 1;
                            this.planePos[i][3] = 0;
                        }
                        if (this.planePos[i][3] < 2 && Math.abs(this.planePos[i][0] - this.role.x) < 10) {
                            this.addToVector(10, this.planePos[i][0] + 39 - 6, this.planePos[i][1] + 25, 0, enemyShot);
                            short[] sArray2 = this.planePos[i];
                            sArray2[3] = (short)(sArray2[3] + 1);
                        }
                        if (this.planePos[i][5] > 0) break;
                        this.planePos[i][2] = 2;
                        this.planePos[i][3] = 0;
                        this.unLockSceen();
                        break;
                    }
                    case 2: {
                        short[] sArray = this.planePos[i];
                        sArray[0] = (short)(sArray[0] + (this.planePos[i][4] == 0 ? 10 : -10));
                        short[] sArray3 = this.planePos[i];
                        sArray3[1] = (short)(sArray3[1] + 22);
                        GameEngine.AddBlastEffectList(this.planePos[i][0] + 39, this.planePos[i][1], 12, 0, 0);
                        short[] sArray4 = this.planePos[i];
                        sArray4[3] = (short)(sArray4[3] + 1);
                        if (sArray4[3] < 6) break;
                        GameMap.shakeTime = (byte)10;
                        this.planePos[i][2] = 3;
                    }
                }
            }
            ++i;
        }
    }

    public void drawPlane() {
        if (this.planePos == null) {
            return;
        }
        int i = 0;
        while (i < this.planePos.length) {
            if (this.planePos[i][2] != 3) {
                if (this.planeInjureTime > 0) {
                    Tools.addObject(33, this.planePos[i][0], this.planePos[i][1] + 3 - GameMIDlet.gameIndex % 4 / 2 * 3 + 18, 0, 40, 78, 40, 36, this.planePos[i][4] == 1 ? (byte)0 : 1, 100);
                } else {
                    Tools.addObject(33, this.planePos[i][0], this.planePos[i][1] + 3 - GameMIDlet.gameIndex % 4 / 2 * 3 + 18, 0, 0, 78, 40, 36, this.planePos[i][4] == 1 ? (byte)0 : 1, 100);
                }
            }
            ++i;
        }
    }

    public void initYou_tong() {
        this.you_tong = null;
        switch (this.gameRank) {
            case 0: {
                this.you_tong = new short[0][];
                break;
            }
            case 1: {
                this.you_tong = new short[0][];
                break;
            }
            case 2: {
                this.you_tong = new short[0][];
                break;
            }
            case 3: {
                this.you_tong = new short[][]{{1248, 304, 0}, {1568, 240, 0}, {2560, 304, 0}};
                break;
            }
            case 4: {
                this.you_tong = new short[][]{{480, 368, 0}, {880, 307, 0}, {2688, 336, 0}, {2912, 275, 0}, {3280, 304, 0}};
                break;
            }
            case 5: {
                this.you_tong = new short[][]{{976, 304, 0}, {1616, 304, 0}, {2848, 336, 0}};
            }
        }
    }

    public void drawYou_tong() {
        if (this.you_tong == null) {
            return;
        }
        int i = 0;
        while (i < this.you_tong.length) {
            if (this.you_tong[i][2] != 1) {
                Tools.addObject(47, this.you_tong[i][0], this.you_tong[i][1], 36, (byte)0, 10);
            }
            ++i;
        }
    }

    public void initOn_off() {
        this.on_off = null;
        switch (this.gameRank) {
            case 0: {
                this.on_off = new short[][]{{2769, 350, 0}};
                break;
            }
            case 1: {
                this.on_off = new short[][]{{3460, 350, 0}};
                break;
            }
        }
    }

    public void drawOn_off() {
        if (this.on_off == null) {
            return;
        }
        byte[][] imgDat = new byte[][]{{0, 0, 16, 39}, {16, 6, 27, 33}};
        int i = 0;
        while (i < this.on_off.length) {
            Tools.addObject(31, (int)this.on_off[i][0], this.on_off[i][1] + 18, imgDat[this.on_off[i][2] == 0 ? 0 : 1], 36, (byte)0, 10);
            ++i;
        }
    }

    public void initTrap() {
        this.trapPos = null;
        switch (this.gameRank) {
            case 0: {
                this.trapPos = new short[][]{{2755, 392, 0, 0, 0, 0}};
                break;
            }
            case 1: {
                this.trapPos = new short[][]{{3465, 390, 0, 0, 0, 0}};
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.trapPos = new short[][]{{1260, 383, 2, 0, 1260, 1060}};
                break;
            }
            case 5: {
                this.trapPos = new short[][]{{1930, 383, 2, 0, 1930, 520}};
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void moveTrap() {
        if (this.trapPos == null) {
            return;
        }
        int i = 0;
        while (i < this.trapPos.length) {
            switch (this.trapPos[i][2]) {
                case 0: {
                    if (!Tools.hit(this.trapPos[i][0] + 46, this.trapPos[i][1], 52, 135, this.role.x, this.role.y, this.role.w, this.role.h)) break;
                    this.role.Injure(1000);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    switch (this.trapPos[i][3]) {
                        case 0: {
                            if (!this.isMoveMF) break;
                            if (this.trapPos[i][0] > this.trapPos[i][4] + this.trapPos[i][5]) {
                                this.trapPos[i][3] = 1;
                                this.isMoveMF = false;
                                break;
                            }
                            short[] sArray = this.trapPos[i];
                            sArray[0] = (short)(sArray[0] + 4);
                            break;
                        }
                        case 1: {
                            if (!this.isMoveMF) break;
                            if (this.trapPos[i][0] < this.trapPos[i][4]) {
                                this.trapPos[i][3] = 0;
                                this.isMoveMF = false;
                                break;
                            }
                            short[] sArray = this.trapPos[i];
                            sArray[0] = (short)(sArray[0] - 4);
                        }
                    }
                    break;
                }
            }
            ++i;
        }
    }

    public void drawTrap() {
        if (this.trapPos == null) {
            return;
        }
        int i = 0;
        while (i < this.trapPos.length) {
            switch (this.trapPos[i][2]) {
                case 0: {
                    Tools.addObject(11, this.trapPos[i][0], this.trapPos[i][1], 0, 0, 55, 135, 36, (byte)0, 10);
                    Tools.addObject(11, this.trapPos[i][0] + 92, this.trapPos[i][1], 92, 0, 33, 135, 36, (byte)0, 100);
                    int j = 0;
                    while (j < 5) {
                        Tools.addObject((byte)3, this.trapPos[i][0] + 46, this.trapPos[i][1] - 98 + 13 * j, this.trapPos[i][0] + 95, this.trapPos[i][1] - 110 + 19 * j, 20, GameMIDlet.gameIndex % 2 == 0 ? 0xFF0000 : 0xFFFFFF, 100);
                        ++j;
                    }
                    break;
                }
                case 1: {
                    Tools.addObject(11, this.trapPos[i][0], this.trapPos[i][1], 0, 0, 55, 135, 36, (byte)0, 10);
                    Tools.addObject(11, this.trapPos[i][0] + 92, this.trapPos[i][1], 92, 0, 33, 135, 36, (byte)0, 100);
                    break;
                }
                case 2: {
                    byte[] motion = new byte[]{0, 0, 1, 1, 2, 2};
                    Tools.addObject(30, (int)this.trapPos[i][0], (int)this.trapPos[i][1], this.imgMuFa[motion[GameMIDlet.gameIndex % 6]], 36, (byte)0, 10);
                }
            }
            ++i;
        }
    }

    public int checkTrap(short[][] trapPos) {
        if (trapPos == null) {
            return -1;
        }
        int i = 0;
        while (i < trapPos.length) {
            switch (trapPos[i][2]) {
                case 2: {
                    if (!Tools.hit(this.role.x, this.role.y + 18, this.role.w, this.role.h, trapPos[i][0], trapPos[i][1] - 10, 100, 10)) break;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public void addItem(int type, int x, int y) {
        int[] temp = new int[]{x, y, type};
        this.item.addElement(temp);
    }

    public void getItem() {
        int len = this.item.size();
        int tmpNum = 0;
        int i = len - 1;
        while (i >= 0) {
            int[] temp = (int[])this.item.elementAt(i);
            if (Tools.hit(temp[0], temp[1], 20, 20, this.role.x, this.role.y, this.role.w, this.role.h)) {
                switch (temp[2]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.role.getWeapon(temp[2] + 1);
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, 30);
                        break;
                    }
                    case 3: {
                        tmpNum = 100;
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, tmpNum);
                        break;
                    }
                    case 4: {
                        tmpNum = 300;
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, tmpNum);
                        break;
                    }
                    case 5: {
                        tmpNum = 500;
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, tmpNum);
                        break;
                    }
                    case 6: {
                        tmpNum = 700;
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, tmpNum);
                        break;
                    }
                    case 7: {
                        tmpNum = 900;
                        GameEngine.AddBlastEffectList(this.role.x + this.role.w / 2 + (this.role.isLeft ? 0 : 0), this.role.y - 30, 13, 0, tmpNum);
                    }
                }
                this.score += tmpNum;
                this.item.removeElement(temp);
            }
            --i;
        }
    }

    public void drawItem() {
        int len = this.item.size();
        int i = len - 1;
        while (i >= 0) {
            int[] temp = (int[])this.item.elementAt(i);
            Tools.addObject(22, temp[0], temp[1] + 18, 20 * temp[2], 0, 20, 20, 36, (byte)0, 100);
            --i;
        }
    }

    public void drawGame(Graphics g, boolean isDrawRole) {
        g.translate(-GameMap.setOffX, -GameMap.setOffY);
        this.map.setMap(g);
        if (isDrawRole) {
            this.role.paint();
        }
        this.drawTrap();
        this.drawOn_off();
        this.drawYou_tong();
        this.drawPlane();
        this.drawItem();
        this.drawEnemy(g);
        this.drawHostage();
        if (MyGameCanvas.gameStatus == 7) {
            this.drawHitEffect();
            this.drawShot(roleShot);
            this.drawShot(enemyShot);
        }
        this.drawInterFace(g, GameMap.setOffX, GameMap.setOffY + 360, 1000);
    }

    public void rankEnd() {
        if (this.map.doorPos == null) {
            return;
        }
        int i = 0;
        while (i < this.map.doorPos.length) {
            if (Tools.hit(this.role.x, this.role.y, this.role.w, this.role.h, this.map.doorPos[i][0], this.map.doorPos[i][1], this.map.doorPos[i][2], this.map.doorPos[i][3])) {
                MyGameCanvas.setST((byte)15);
            }
            ++i;
        }
    }

    public void runGame() {
        if (this.planeInjureTime > 0) {
            this.planeInjureTime = (byte)(this.planeInjureTime - 1);
        }
        this.check();
        this.enemyMove();
        this.moveShot(roleShot);
        this.moveShot(enemyShot);
        this.map.moveIceBoard();
        this.role.move();
        this.getItem();
        this.moveTrap();
        this.movePlane();
        this.moveHostage();
        this.map.moveSrceen(this.role.x + this.role.w / 2, this.role.y, this.role.isLeft);
        this.rankEnd();
        this.map.screenShake();
        if (this.gameRank == 5 && this.planePos[0][2] == 3 && this.planePos[1][2] == 3) {
            this.passNum2 = (byte)2;
        }
    }

    public void toTalkStatus(int type) {
        MyGameCanvas.eventType = (byte)type;
        MyGameCanvas.eventCourse = 0;
        MyGameCanvas.initTalk();
        MyGameCanvas.setST((byte)10);
        this.role.setStatus((byte)5);
    }

    public void check() {
        this.checkAtt();
        this.checkShot();
    }

    public void checkAtt() {
        int i;
        if (this.role.curIndex == 46 || this.role.curIndex == 49 || this.role.curIndex == 52) {
            i = 0;
            while (i < this.enemy.length) {
                if (this.enemy[i].HP > 0 && this.enemy[i].type != 6 && this.enemy[i].type != 7 && Tools.hit(this.role.x + (this.role.isLeft ? -20 : this.role.w), this.role.y, 20, 30, this.enemy[i].x, this.enemy[i].y, this.enemy[i].w, this.enemy[i].h)) {
                    this.enemy[i].Injure(2);
                }
                ++i;
            }
            if (this.hostagePos != null) {
                int i2 = 0;
                while (i2 < this.hostagePos.length) {
                    if (this.hostagePos[i2][2] <= 1 && Tools.hit(this.hostagePos[i2][0] - 12, this.hostagePos[i2][1], 24, 46, this.role.x + (this.role.isLeft ? -20 : this.role.w), this.role.y, 20, 30)) {
                        this.hostagePos[i2][2] = (short)(this.hostagePos[i2][2] == 0 ? 2 : 7);
                        this.hostagePos[i2][3] = 0;
                    }
                    ++i2;
                }
            }
        }
        i = 0;
        while (i < this.enemy.length) {
            if (this.enemy[i].HP > 0) {
                if (this.enemy[i].type == 1 && this.enemy[i].curIndex == 11 && Tools.hit(this.role.x, this.role.y, this.role.w, this.role.h, this.enemy[i].x + (this.enemy[i].isLeft ? -20 : this.enemy[i].w), this.enemy[i].y, 20, 30)) {
                    this.role.Injure(2);
                }
                if (this.enemy[i].type == 4 && this.enemy[i].curIndex == 3 && Tools.hit(this.role.x, this.role.y, this.role.w, this.role.h, this.enemy[i].x, this.enemy[i].y, 36, 25)) {
                    this.role.Injure(1);
                }
            }
            ++i;
        }
    }

    public void checkShotVs() {
        int eSize = enemyShot.size();
        int i = eSize - 1;
        while (i >= 0) {
            int[] etemp = (int[])enemyShot.elementAt(i);
            int size = roleShot.size();
            if (etemp[9] == 0 && etemp[8] == 10) {
                int j = size - 1;
                while (j >= 0) {
                    int[] temp = (int[])roleShot.elementAt(j);
                    if (temp[9] == 0 && Tools.hit(temp[0], temp[1], temp[2], temp[3], etemp[0], etemp[1], etemp[2], etemp[3])) {
                        enemyShot.removeElement(etemp);
                        GameEngine.AddBlastEffectList(temp[0] + temp[2] / 2 - 24, temp[1] - temp[3] / 2 + 24 + 18, 12, 0, 0);
                        switch (temp[8]) {
                            case 4: 
                            case 5: {
                                temp[9] = 1;
                                break;
                            }
                            case 8: {
                                this.bomb(temp[0] + temp[2] / 2, temp[1], true);
                                roleShot.removeElement(temp);
                                break;
                            }
                            default: {
                                roleShot.removeElement(temp);
                                break;
                            }
                        }
                        break;
                    }
                    --j;
                }
            }
            --i;
        }
    }

    public void checkShot() {
        int size;
        int i;
        int[] temp;
        int j;
        int size2;
        int i2;
        this.checkShotVs();
        if (this.you_tong != null) {
            i2 = 0;
            while (i2 < this.you_tong.length) {
                if (this.you_tong[i2][2] == 0) {
                    size2 = roleShot.size();
                    j = size2 - 1;
                    while (j >= 0) {
                        temp = (int[])roleShot.elementAt(j);
                        if (temp[9] == 0 && Tools.hit(this.you_tong[i2][0], this.you_tong[i2][1] - 18, 32, 32, temp[0], temp[1], temp[2], temp[3])) {
                            GameEngine.AddBlastEffectList(this.you_tong[i2][0], this.you_tong[i2][1], 11, 0, 0);
                            GameEngine.AddBlastEffectList(this.you_tong[i2][0] + 16, this.you_tong[i2][1], 11, 0, 0);
                            int k = 0;
                            while (k < this.enemy.length) {
                                if (this.enemy[k].HP > 0 && Tools.hit(this.enemy[k].x, this.enemy[k].y, this.enemy[k].w, this.enemy[k].h, this.you_tong[i2][0] - 8, this.you_tong[i2][1], 48, 48)) {
                                    this.enemy[k].Injure(2);
                                }
                                ++k;
                            }
                            roleShot.removeElement(temp);
                            this.you_tong[i2][2] = 1;
                            GameMap.shakeTime = (byte)10;
                            break;
                        }
                        --j;
                    }
                }
                ++i2;
            }
        }
        if (this.on_off != null) {
            i2 = 0;
            while (i2 < this.on_off.length) {
                if (this.on_off[i2][2] == 0) {
                    size2 = roleShot.size();
                    j = size2 - 1;
                    while (j >= 0) {
                        temp = (int[])roleShot.elementAt(j);
                        if (temp[9] == 0 && Tools.hit(this.on_off[i2][0], this.on_off[i2][1], 16, 39, temp[0], temp[1], temp[2], temp[3])) {
                            switch (temp[8]) {
                                case 4: 
                                case 5: {
                                    temp[9] = 1;
                                    break;
                                }
                                case 8: {
                                    this.bomb(temp[0] + temp[2] / 2, temp[1], true);
                                    roleShot.removeElement(temp);
                                    break;
                                }
                                default: {
                                    roleShot.removeElement(temp);
                                }
                            }
                            this.on_off[i2][2] = 1;
                            this.trapPos[i2][2] = 1;
                            break;
                        }
                        --j;
                    }
                }
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.enemy.length) {
            if (this.enemy[i2].HP > 0) {
                size2 = roleShot.size();
                j = size2 - 1;
                while (j >= 0) {
                    temp = (int[])roleShot.elementAt(j);
                    if (temp[9] == 0 && Tools.hit(this.enemy[i2].x, this.enemy[i2].y, this.enemy[i2].w, this.enemy[i2].h, temp[0], temp[1], temp[2], temp[3])) {
                        switch (temp[8]) {
                            case 4: 
                            case 5: {
                                temp[9] = 1;
                                break;
                            }
                            case 8: {
                                this.bomb(temp[0] + temp[2] / 2, temp[1], true);
                                roleShot.removeElement(temp);
                                break;
                            }
                            default: {
                                roleShot.removeElement(temp);
                            }
                        }
                        this.enemy[i2].Injure(this.getAtt(temp[8]));
                        break;
                    }
                    --j;
                }
            }
            ++i2;
        }
        if (this.planePos != null) {
            i = 0;
            while (i < this.planePos.length) {
                if (this.planePos[i][5] > 0) {
                    size = roleShot.size();
                    int j2 = size - 1;
                    while (j2 >= 0) {
                        int[] temp2 = (int[])roleShot.elementAt(j2);
                        if (temp2[9] == 0 && Tools.hit(this.planePos[i][0], this.planePos[i][1], 78, 40, temp2[0], temp2[1], temp2[2], temp2[3])) {
                            short[] sArray = this.planePos[i];
                            sArray[5] = (short)(sArray[5] - this.getAtt(temp2[8]));
                            GameEngine.AddBlastEffectList(temp2[0] + temp2[2] / 2 - 24, temp2[1] - temp2[3] + 24 + 18, 12, 0, 0);
                            this.planeInjureTime = (byte)2;
                            switch (temp2[8]) {
                                case 4: 
                                case 5: {
                                    temp2[9] = 1;
                                    break;
                                }
                                case 8: {
                                    GameEngine.AddBlastEffectList(temp2[0] - 13, temp2[1] + 18, 11, 0, 0);
                                    roleShot.removeElement(temp2);
                                    break;
                                }
                                default: {
                                    roleShot.removeElement(temp2);
                                }
                            }
                        }
                        --j2;
                    }
                }
                ++i;
            }
        }
        if (this.hostagePos != null) {
            i = 0;
            while (i < this.hostagePos.length) {
                if (this.hostagePos[i][2] <= 1) {
                    size = roleShot.size();
                    int j3 = size - 1;
                    while (j3 >= 0) {
                        int[] temp3 = (int[])roleShot.elementAt(j3);
                        if (temp3[9] == 0 && Tools.hit(this.hostagePos[i][0] - 12, this.hostagePos[i][1], 24, 46, temp3[0], temp3[1], temp3[2], temp3[3])) {
                            this.hostagePos[i][2] = (short)(this.hostagePos[i][2] == 0 ? 2 : 7);
                            this.hostagePos[i][3] = 0;
                            switch (temp3[8]) {
                                case 4: 
                                case 5: {
                                    temp3[9] = 1;
                                    break;
                                }
                                case 8: {
                                    GameEngine.AddBlastEffectList(temp3[0] - 13, temp3[1] + 18, 11, 0, 0);
                                    GameMap.shakeTime = (byte)10;
                                    roleShot.removeElement(temp3);
                                    break;
                                }
                                default: {
                                    roleShot.removeElement(temp3);
                                }
                            }
                        }
                        --j3;
                    }
                }
                ++i;
            }
        }
        size2 = enemyShot.size();
        int i3 = size2 - 1;
        while (i3 >= 0) {
            int[] temp4 = (int[])enemyShot.elementAt(i3);
            if (Tools.hit(this.role.x, this.role.y, this.role.w, this.role.h, temp4[0], temp4[1], temp4[2], temp4[3])) {
                this.role.Injure(this.getAtt(temp4[8]));
                switch (temp4[8]) {
                    case 4: 
                    case 5: {
                        temp4[9] = 1;
                        break;
                    }
                    case 9: {
                        this.bomb(temp4[0] + temp4[2] / 2, temp4[1], false);
                        enemyShot.removeElement(temp4);
                        break;
                    }
                    case 10: {
                        GameEngine.AddBlastEffectList(temp4[0] + temp4[2] / 2 - 24, temp4[1] - temp4[3] / 2 + 24 + 18, 12, 0, 0);
                        enemyShot.removeElement(temp4);
                        break;
                    }
                    default: {
                        enemyShot.removeElement(temp4);
                    }
                }
                return;
            }
            --i3;
        }
    }

    public boolean checkHostage(int x, int y, int w, int h) {
        if (this.hostagePos == null) {
            return false;
        }
        int i = 0;
        while (i < this.hostagePos.length) {
            if (this.hostagePos[i][2] <= 1 && Tools.hit(this.hostagePos[i][0] - 12, this.hostagePos[i][1], 24, 46, x, y, w, h)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getAtt(int type) {
        switch (type) {
            case 11: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 3;
            }
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 5;
            }
            case 6: 
            case 7: {
                return 3;
            }
            case 8: 
            case 9: {
                return 3;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    final void drawInterFace(Graphics g, int x, int y, int lev) {
        Tools.addObject(45, x, y, 36, (byte)0, lev);
        GameEngine.drawNumber((byte)23, this.role.HP, x + 73, y - 7, 1, 0, lev);
        if (this.role.weaponType == 0) {
            Tools.addObject(24, x + 113, y - 10, 36, (byte)0, lev);
        } else {
            GameEngine.drawNumber((byte)46, GameRole.weapons[this.role.weaponType], x + 113, y - 7, 1, 0, lev);
        }
        GameEngine.drawNumber((byte)46, this.role.bombNum, x + 152, y - 7, 1, 0, lev);
        GameEngine.drawNumber((byte)35, this.score, x + 1, y - 360 + 20, 1, 0, lev);
    }

    public void initGame(byte type) {
        switch (type) {
            case 0: {
                Tools.removeAllImage();
                hitEffectV.removeAllElements();
                roleShot.removeAllElements();
                enemyShot.removeAllElements();
                this.item.removeAllElements();
                this.map.init(this.gameRank);
                break;
            }
            case 1: {
                this.role = new GameRole(this);
                this.role.init(this.gameRank);
                break;
            }
            case 2: {
                this.initEnemy(this.gameRank);
                this.initTrap();
                this.isMoveMF = false;
                this.initPlane();
                this.initOn_off();
                this.initYou_tong();
                this.initHostage();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void drawHitEffect() {
        int size = hitEffectV.size();
        int i = size - 1;
        while (i >= 0) {
            block13: {
                int[] temp = (int[])hitEffectV.elementAt(i);
                int imgIndex = -1;
                byte[] motion = null;
                Object var6_7 = null;
                byte[] adjustY = null;
                byte[] adjustDGY = null;
                byte[] adjustX = null;
                byte[] adjustDGX = null;
                int lev = 200;
                boolean isFrame = false;
                switch (temp[3]) {
                    case 13: {
                        motion = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        GameEngine.drawNumber2(GameMIDlet.gameIndex % 2 == 0 ? (byte)36 : 37, temp[5], temp[0], temp[1], 7, 36, lev);
                        temp[2] = temp[2] + 1;
                        if (temp[2] == motion.length) {
                            hitEffectV.removeElementAt(i);
                        }
                        break block13;
                    }
                    case 5: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 12, 8}, {12, 0, 12, 17}, {24, 0, 14, 19}, {38, 0, 11, 15}};
                        motion = new byte[]{0, 1, 2, 3};
                        adjustY = new byte[]{0, 0, -3, -6};
                        adjustDGY = new byte[]{0, 0, 0, 0};
                        adjustX = new byte[]{0, -9, -2, -5};
                        adjustDGX = new byte[]{0, 2, 2, 9};
                        imgIndex = 2;
                        break;
                    }
                    case 0: {
                        byte[][] byArray = this.imgDatAh;
                        motion = new byte[]{0, 1, 2, 2, 2, 2, 2};
                        adjustY = new byte[]{0, 0, 0, 2, -2, 2, -2};
                        adjustDGY = new byte[]{0, 0, 0, 0, 0, 0, 0};
                        adjustX = new byte[]{0, -11, -26, -26, -26, -26, -26};
                        adjustDGX = new byte[]{0, -15, -22, -22, -22, -22, -22};
                        imgIndex = 0;
                        this.drawAhFrame(temp[0] + adjustX[temp[2]], temp[1] + adjustY[temp[2]], motion[temp[2]], lev);
                        isFrame = true;
                        break;
                    }
                    case 9: {
                        byte[][] byArray = this.imgDataFireEff2;
                        motion = new byte[]{0, 1, 2, 3};
                        adjustY = new byte[]{0, 3, 9, 11};
                        adjustDGY = new byte[]{0, 3, 7, 8};
                        adjustX = new byte[]{0, 0, 0, -2};
                        adjustDGX = new byte[]{0, -2, -4, -5};
                        imgIndex = 17;
                        break;
                    }
                    case 10: {
                        byte[][] byArray = this.imgDataFireEff2;
                        motion = new byte[]{4, 5, 6, 7};
                        adjustY = new byte[]{0, 1, 2, 4};
                        adjustDGY = new byte[]{0, 0, 1, 1};
                        adjustX = new byte[]{0, -2, -7, -8};
                        adjustDGX = new byte[]{0, -4, -9, -12};
                        imgIndex = 17;
                        break;
                    }
                    case 11: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 26, 44}, {38, 0, 37, 71}, {77, 0, 36, 76}, {76, 77, 37, 76}, {38, 72, 37, 62}, {0, 45, 37, 55}, {0, 102, 38, 48}};
                        motion = new byte[]{0, 1, 2, 3, 4, 5, 6};
                        adjustY = new byte[]{0, -1, -1, -5, -21, -32, -44};
                        adjustDGY = new byte[]{0, 0, 0, 0, 0, 0, 0};
                        adjustX = new byte[]{0, -7, -7, -7, -6, -7, -6};
                        adjustDGX = new byte[]{0, -4, -3, -4, -5, -4, -6};
                        imgIndex = 4;
                        break;
                    }
                    case 12: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 48, 48}, {0, 48, 48, 48}, {48, 0, 60, 54}, {48, 55, 52, 57}, {101, 55, 40, 39}};
                        motion = new byte[]{0, 1, 2, 3, 4};
                        adjustY = new byte[]{0, 0, 2, -2, -26};
                        adjustDGY = new byte[]{0, 0, 0, 0, 0};
                        adjustX = new byte[]{0, 0, -8, -1, 2};
                        adjustDGX = new byte[]{0, 0, -4, -3, 6};
                        imgIndex = 28;
                    }
                }
                if (!isFrame) {
                    void var6_6;
                    Tools.addObject(imgIndex, temp[0] + (temp[4] == 1 ? adjustDGX[temp[2]] : adjustX[temp[2]]), temp[1] + (temp[4] == 2 ? adjustDGY[temp[2]] : adjustY[temp[2]]), (byte[])var6_6[motion[temp[2]]], 36, (byte)temp[4], lev);
                }
                if ((temp[2] = temp[2] + 1) == motion.length) {
                    hitEffectV.removeElementAt(i);
                }
            }
            --i;
        }
    }

    public static void AddBlastEffectList(int x, int y, int type, int trans, int scoreNum) {
        hitEffectV.addElement(new int[]{x, y, 0, type, trans, scoreNum});
    }

    public void drawAhFrame(int x, int y, int index, int lev) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{0, 0, 0, 0, 0};
                break;
            }
            case 1: {
                data = new byte[]{2, 32, -2, 0, 0, 2, 28, -2, 4, 0, 1, 18, -1, 11, 0, 1, 12, -1, 17, 0, 0, 0, 0, 26, 0};
                break;
            }
            case 2: {
                data = new byte[]{2, 54, -2, 0, 0, 2, 42, -2, 12, 0, 1, 26, -1, 25, 0, 1, 13, -1, 38, 0, 0, 0, 0, 48, 0};
            }
        }
        int i = 0;
        while (i < data.length) {
            Tools.addObject(0, x + data[i + 1], y + data[i + 2], this.imgDatAh[data[i]], 36, (byte)0, lev);
            i += 5;
        }
    }

    public void setBomb1(int speedx, int speedy) {
        this.tempSpx = speedx;
        this.tempSpy = speedy;
    }

    public void addToVector(int type, int x, int y, int trans, Vector shot) {
        int[] temp = new int[10];
        temp[0] = x;
        temp[1] = y;
        switch (type) {
            case 13: {
                temp[2] = 8;
                temp[3] = 8;
                temp[4] = trans == 0 ? 5 : -5;
                temp[5] = 0;
                break;
            }
            case 12: {
                temp[2] = 8;
                temp[3] = 8;
                temp[4] = trans == 0 ? 15 : -15;
                temp[5] = 0;
                break;
            }
            case 11: {
                temp[2] = 8;
                temp[3] = 8;
                temp[4] = trans == 0 ? 10 : -10;
                temp[5] = 0;
                break;
            }
            case 0: {
                temp[2] = 18;
                temp[3] = 7;
                temp[4] = trans == 0 ? 10 : -10;
                temp[5] = 0;
                break;
            }
            case 1: {
                temp[2] = 7;
                temp[3] = 18;
                temp[4] = 0;
                temp[5] = trans == 2 ? 15 : -15;
                break;
            }
            case 2: {
                temp[2] = 30;
                temp[3] = 7;
                temp[4] = trans == 0 ? 15 : -15;
                temp[5] = 0;
                break;
            }
            case 3: {
                temp[2] = 7;
                temp[3] = 30;
                temp[4] = 0;
                temp[5] = trans == 2 ? 15 : -15;
                break;
            }
            case 4: {
                temp[2] = 63;
                temp[3] = 47;
                temp[4] = 0;
                temp[5] = 0;
                break;
            }
            case 5: {
                temp[2] = 47;
                temp[3] = 63;
                temp[4] = 0;
                temp[5] = 0;
                break;
            }
            case 6: {
                temp[2] = 57;
                temp[3] = 10;
                temp[4] = trans == 0 ? 10 : -10;
                temp[5] = 0;
                break;
            }
            case 7: {
                temp[2] = 10;
                temp[3] = 57;
                temp[4] = 0;
                temp[5] = trans == 2 ? 10 : -10;
                break;
            }
            case 8: {
                temp[2] = 28;
                temp[3] = 22;
                temp[4] = trans == 0 ? 6 : -6;
                temp[5] = -8;
                break;
            }
            case 9: {
                temp[2] = 28;
                temp[3] = 22;
                temp[4] = this.tempSpx;
                temp[5] = this.tempSpy;
                break;
            }
            case 10: {
                temp[2] = 12;
                temp[3] = 25;
                temp[4] = 0;
                temp[5] = 4;
            }
        }
        temp[6] = trans;
        temp[7] = 0;
        temp[8] = type;
        temp[9] = 0;
        shot.addElement(temp);
    }

    public void moveShot(Vector shot) {
        int size = shot.size();
        int i = size - 1;
        while (i >= 0) {
            int[] temp = (int[])shot.elementAt(i);
            temp[0] = temp[0] + temp[4];
            temp[1] = temp[1] + temp[5];
            switch (temp[8]) {
                case 4: {
                    byte[] adjustX = new byte[]{0, 3, 2, 31};
                    byte[] adjustDGX = new byte[]{0, -27, -5, -1};
                    byte[] adjustY = new byte[]{0, 8, -1, -14};
                    byte[] w = new byte[]{39, 63, 66, 36};
                    byte[] h = new byte[]{31, 47, 43, 28};
                    temp[0] = temp[0] + (temp[6] == 0 ? adjustX[temp[7]] : adjustDGX[temp[7]]);
                    temp[1] = temp[1] + adjustY[temp[7]];
                    temp[2] = w[temp[7]];
                    temp[3] = h[temp[7]];
                    break;
                }
                case 5: {
                    byte[] adjustX = new byte[]{0, -6, 0, 6};
                    byte[] adjustY = new byte[]{0, -4, 2, -34};
                    byte[] adjustDGY = new byte[]{0, 28, 1, 4};
                    byte[] w = new byte[]{31, 47, 43, 28};
                    byte[] h = new byte[]{39, 63, 66, 36};
                    temp[0] = temp[0] + adjustX[temp[7]];
                    temp[1] = temp[1] + (temp[6] == 0 ? adjustY[temp[7]] : adjustDGY[temp[7]]);
                    temp[2] = w[temp[7]];
                    temp[3] = h[temp[7]];
                    break;
                }
                case 8: 
                case 9: {
                    temp[5] = temp[5] + 2;
                    temp[5] = Math.min(20, temp[5]);
                }
            }
            --i;
        }
    }

    public void drawShot(Vector shot) {
        int size = shot.size();
        int i = 0;
        while (i < size) {
            int[] temp = (int[])shot.elementAt(i);
            switch (temp[8]) {
                case 11: 
                case 12: 
                case 13: {
                    Tools.addObject(19, temp[0], temp[1] + 18, 113, 27, 8, 8, 36, (byte)temp[6], 100);
                    break;
                }
                case 0: {
                    Tools.addObject(38, temp[0], temp[1] + 18, imgDatShot1[0], 36, (byte)temp[6], 100);
                    break;
                }
                case 1: {
                    Tools.addObject(38, temp[0], temp[1] + 18, imgDatShot1[1], 36, (byte)temp[6], 100);
                    break;
                }
                case 2: {
                    Tools.addObject(39, temp[0], temp[1] + 18, imgDatShot2[0], 36, (byte)temp[6], 100);
                    break;
                }
                case 3: {
                    Tools.addObject(39, temp[0], temp[1] + 18, imgDatShot2[1], 36, (byte)temp[6], 100);
                    break;
                }
                case 4: {
                    byte[] motion = new byte[]{0, 1, 2, 3};
                    Tools.addObject(40, temp[0], temp[1] + 18, imgDatShot3[motion[temp[7]]], 36, (byte)temp[6], 100);
                    break;
                }
                case 5: {
                    byte[] motion = new byte[]{4, 5, 6, 7};
                    Tools.addObject(40, temp[0], temp[1] + 18, imgDatShot3[motion[temp[7]]], 36, (byte)temp[6], 100);
                    break;
                }
                case 6: {
                    Tools.addObject(41, temp[0], temp[1] + 18, imgDatShot4[temp[7] % 2], 36, (byte)temp[6], 100);
                    break;
                }
                case 7: {
                    Tools.addObject(41, temp[0], temp[1] + 18, imgDatShot4[2 + temp[7] % 2], 36, (byte)temp[6], 100);
                    break;
                }
                case 8: 
                case 9: {
                    byte[] adjustX = new byte[]{0, 6, 4, 11, 13, 13, 17, 15};
                    byte[] adjustDGX = new byte[]{0, -1, 3, -8, -11, -7, -12, -2};
                    byte[] adjustY = new byte[]{0, -10, -10, -10, -14, -12, -1, -1};
                    Tools.addObject(3, temp[0] + (temp[6] == 0 ? adjustX[temp[7] % 8] : adjustDGX[temp[7] % 8]), temp[1] + adjustY[temp[7] % 8] + 18, imgDatShotBomb[temp[7] % 8], 36, (byte)temp[6], 100);
                    break;
                }
                case 10: {
                    Tools.addObject(27, temp[0], temp[1] + 18, 36, (byte)temp[6], 100);
                }
            }
            ++i;
        }
        this.shotADD_REMOVE(shot);
    }

    /*
     * Unable to fully structure code
     */
    public void shotADD_REMOVE(Vector shot) {
        size = shot.size();
        i = size - 1;
        while (i >= 0) {
            temp = (int[])shot.elementAt(i);
            temp[7] = temp[7] + 1;
            switch (temp[8]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (temp[0] + temp[2] < GameMap.setOffX - 50) ** GOTO lbl18
                    if (temp[0] > GameMap.setOffX + GameMap.SCREEN_WIDTH + 50) ** GOTO lbl18
                    if (temp[1] < GameMap.setOffY - 50) ** GOTO lbl18
                    if (temp[1] - temp[3] <= GameMap.setOffY + GameMap.SCREEN_HEIGHT + 50) ** GOTO lbl21
lbl18:
                    // 4 sources

                    shot.removeElement(temp);
                    break;
lbl21:
                    // 1 sources

                    if (temp[5] > 0) {
                        if (this.map.canFall(temp[0] + temp[2] / 2, temp[1])) break;
                        if (temp[8] == 8 || temp[8] == 9 || temp[8] == 10) {
                            this.bomb(temp[0] + temp[2] / 2, temp[1], shot.equals(GameEngine.roleShot));
                        }
                        shot.removeElement(temp);
                        break;
                    }
                    if (temp[5] < 0) {
                        if (this.map.canUp(temp[0] + temp[2] / 2, temp[1] - temp[3])) break;
                        if (temp[8] == 8) {
                            this.bomb(temp[0] + temp[2] / 2, temp[1], shot.equals(GameEngine.roleShot));
                        }
                        shot.removeElement(temp);
                        break;
                    }
                    if (this.map.canRun(temp[0] + (temp[4] < 0 ? 0 : temp[2]), temp[1] - temp[3] / 2)) break;
                    if (temp[8] == 8) {
                        this.bomb(temp[0] + temp[2] / 2, temp[1], shot.equals(GameEngine.roleShot));
                    }
                    shot.removeElement(temp);
                    break;
                }
                case 4: 
                case 5: {
                    if (temp[7] < 4) break;
                    shot.removeElement(temp);
                }
            }
            --i;
        }
    }

    public void bomb(int x, int y, boolean isRole) {
        GameMap.shakeTime = (byte)10;
        GameEngine.AddBlastEffectList(x - 13, y + 18, 11, 0, 0);
        if (!isRole) {
            if (Tools.hit(this.role.x, this.role.y, this.role.w, this.role.h, x - 18, y, 36, 50)) {
                this.role.Injure(2);
            }
        } else {
            if (this.enemy == null) {
                return;
            }
            int i = 0;
            while (i < this.enemy.length) {
                if (this.enemy[i].HP > 0 && Tools.hit(this.enemy[i].x, this.enemy[i].y, this.enemy[i].w, this.enemy[i].h, x - 18, y, 36, 50)) {
                    this.enemy[i].Injure(2);
                }
                ++i;
            }
        }
    }

    public byte[][] readClipData(String name) {
        DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream("/dat/" + name));
        byte[][] clip = null;
        int clipLen = 0;
        try {
            clipLen = is.readShort();
            clip = new byte[clipLen][4];
            int i = 0;
            while (i < clipLen) {
                clip[i][0] = is.readByte();
                clip[i][1] = is.readByte();
                clip[i][2] = is.readByte();
                clip[i][3] = is.readByte();
                ++i;
            }
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return clip;
    }

    public byte[][] readFrameData(String name) {
        InputStream is = this.getClass().getResourceAsStream("/dat/" + name);
        DataInputStream dis = new DataInputStream(is);
        byte[][] dat = null;
        try {
            byte groupSize = 0;
            groupSize = dis.readByte();
            dat = new byte[groupSize][];
            int i = 0;
            while (i < dat.length) {
                byte num = dis.readByte();
                dat[i] = new byte[num * 5];
                int j = 0;
                while (j < dat[i].length) {
                    dat[i][j] = dis.readByte();
                    ++j;
                }
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    public static short[][] getPosData(String name) {
        InputStream is = "".getClass().getResourceAsStream("/dat/" + name);
        if (is == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(is);
        try {
            int len = dis.readShort();
            int poslen = dis.readShort();
            short[][] dat = new short[len][poslen];
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < poslen) {
                    dat[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
            return dat;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void drawNumber2(byte img, int number, int x, int y, int numWidth, int athor, int layer) {
        int numHeight = 11;
        int spacing = numWidth;
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        int i = 0;
        while (i < digitCounter) {
            Tools.addObject(img, x + i * spacing, y, digits[digitCounter - 1 - i] * numWidth, 0, numWidth, numHeight, athor, (byte)0, layer);
            ++i;
        }
    }

    public static void drawNumber(byte imgIndex, int number, int x, int y, int spacing, int isLeft, int level) {
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        int numWidth = Tools.getImage(imgIndex).getWidth() / 10;
        int numHeight = Tools.getImage(imgIndex).getHeight();
        switch (isLeft) {
            case 0: {
                int i = digitCounter - 1;
                while (i >= 0) {
                    Tools.addObject(imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, 36, (byte)0, level);
                    --i;
                    x += spacing + numWidth;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i <= digitCounter - 1) {
                    Tools.addObject(imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, 40, (byte)0, level);
                    ++i;
                    x -= spacing + numWidth;
                }
                break;
            }
        }
    }

    private void delDB() {
        try {
            this.db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)"SHOT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openDB() {
        try {
            this.db = RecordStore.openRecordStore((String)"SHOT", (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDB() {
        this.delDB();
        this.openDB();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(this.gameRank);
            dos.writeInt(this.score);
            byte[] data = baos.toByteArray();
            baos.close();
            dos.close();
            this.db.addRecord(data, 0, data.length);
            this.db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean readDB() {
        this.openDB();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.db.getRecord(1));
            DataInputStream dis = new DataInputStream(bais);
            this.gameRank = dis.readByte();
            this.score = dis.readInt();
            bais.close();
            dis.close();
            this.db.closeRecordStore();
            return true;
        }
        catch (Exception e) {
            try {
                this.db.closeRecordStore();
            }
            catch (Exception ex) {
                // empty catch block
            }
            e.printStackTrace();
            return false;
        }
    }
}

