/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.core;

import com.bgate.core.MyGame;
import com.bgate.core.View;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public abstract class Screen
extends Canvas {
    public static final int TYPE_SCREEN240x320 = 0;
    public static final int TYPE_SCREEN320x240 = 1;
    public static final int TYPE_SCREEN360x360 = 2;
    public MyGame game;
    public View view;
    public int width;
    public int height;
    public int delay;
    public int state;
    public int beforeState;
    public int type;
    public int kindSwitchScreen;
    public String strBuffer = "";

    public Screen(MyGame game) {
        this.game = game;
        this.width = this.game.getScreenWidth();
        this.height = this.game.getScreenHeight();
        this.delay = this.game.getDelay();
        this.type = this.width > 220 && this.height > 300 ? 0 : (this.width > 300 && this.height > 220 ? 1 : (this.width > 320 && this.height > 320 ? 2 : 0));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setState(int newState) {
        this.beforeState = this.state;
        this.state = newState;
    }

    public void setView(View view) {
        if (this.view != null) {
            this.view.pause();
            this.view.dispose();
        }
        this.view = null;
        Runtime.getRuntime().gc();
        this.view = view;
        this.view.resume();
        this.view.update();
    }

    public void showView() {
        this.view.show(true);
    }

    public void dismissView() {
        this.view.show(false);
    }

    public abstract void init();

    public abstract void update();

    public abstract void present(Graphics var1);

    public abstract void pause();

    public abstract void resume();

    public abstract void dispose();

    public abstract void handleSms(boolean var1);

    public abstract void switchScreen();

    public abstract void upKeyPressed();

    public abstract void downKeyPressed();

    public abstract void rightKeyPressed();

    public abstract void leftKeyPressed();

    public abstract void fireKeyPressed();

    public abstract void softKeyLeftPressed();

    public abstract void softKeyRightPressed();

    public abstract void numberKeyPressed(int var1);

    public abstract void upKeyRealeased();

    public abstract void downKeyRealeased();

    public abstract void rightKeyRealeased();

    public abstract void leftKeyRealeased();

    public abstract void upKeytRepeated();

    public abstract void downKeyRepeated();

    public abstract void rightKeyRepeated();

    public abstract void leftKeyRepeated();

    public abstract void pointerPressed(int var1, int var2);

    public abstract void pointerReleased(int var1, int var2);

    public abstract void pointerDragged(int var1, int var2);

    public boolean inBounds(int pointerX, int pointerY, int boxX, int boxY, int width, int height) {
        return pointerX > boxX && pointerX < boxX + width - 1 && pointerY > boxY && pointerY < boxY + height - 1;
    }
}

