/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.screen;

import com.bgate.core.Screen;
import com.bgate.game.MainGame;
import com.bgate.screen.Information;
import com.bgate.screen.StageScreen;
import com.bgate.utils.PiPoDesigner;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LevelScreen
extends Screen {
    public static int choice;
    public static int choice_level;
    int count;
    MainGame game;
    Image score;
    Image img;
    Image level;
    Image star;
    Image lock;

    public LevelScreen(MainGame game) {
        super(game);
        this.game = game;
        this.init();
    }

    public void init() {
        this.setData();
        try {
            this.level = Image.createImage((String)"/img/level.png");
            this.star = Image.createImage((String)"/img/star.png");
            this.lock = Image.createImage((String)"/img/lock.png");
            this.img = this.getHeight() > 260 ? Image.createImage((String)"/img/menu.png") : Image.createImage((String)"/img/menu2.png");
            this.score = Image.createImage((String)"/img/number.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setData() {
        choice = MainGame.user.getGameLevel()[MainGame.stage - 1];
        this.count = 0;
    }

    public void update() {
        ++this.count;
    }

    public void present(Graphics g) {
        g.drawImage(this.img, this.getWidth() / 2 - this.img.getWidth() / 2, this.getHeight() / 2 - this.img.getHeight() / 2, 0);
        PiPoDesigner.drawCenterString(g, "Back", -16777216, -1, this.getWidth() - 30, this.getHeight() - 20);
        PiPoDesigner.drawCenterString(g, "Start", -16777216, -1, this.getWidth() / 2, this.getHeight() - 20);
        for (int i = 0; i < 10; ++i) {
            int k = MainGame.highScoreScreen.Star(MainGame.stage, i + 1, MainGame.highScore.getValues()[(MainGame.stage - 1) * 10 + i]);
            if (i < 5) {
                g.drawImage(this.level, (i + 1) * this.getWidth() / 7, 2 * this.getHeight() / 6, 0);
                for (int j = 0; j < k; ++j) {
                    g.drawImage(this.star, (i + 1) * this.getWidth() / 7 + j * 9, 2 * this.getHeight() / 6, 0);
                }
                try {
                    this.drawAddScore(g, i + 1 + "", (i + 1) * this.getWidth() / 7 + 4, 2 * this.getHeight() / 6 + 10);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (i + 1 <= MainGame.user.getGameLevel()[MainGame.stage - 1]) continue;
                g.drawImage(this.lock, (i + 1) * this.getWidth() / 7 + 3, 2 * this.getHeight() / 6 + 10, 0);
                continue;
            }
            g.drawImage(this.level, (i - 4) * this.getWidth() / 7, 3 * this.getHeight() / 6, 0);
            for (int j = 0; j < k; ++j) {
                g.drawImage(this.star, (i - 4) * this.getWidth() / 7 + j * 9, 3 * this.getHeight() / 6, 0);
            }
            try {
                this.drawAddScore(g, i + 1 + "", (i - 4) * this.getWidth() / 7 + 4, 3 * this.getHeight() / 6 + 10);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (i + 1 <= MainGame.user.getGameLevel()[MainGame.stage - 1]) continue;
            g.drawImage(this.lock, (i - 4) * this.getWidth() / 7 + 3, 3 * this.getHeight() / 6 + 10, 0);
        }
        g.setColor(255, 255, 255);
        if (this.count % 4 != 0) {
            if (choice < 6) {
                g.drawRect(choice * this.getWidth() / 7, 2 * this.getHeight() / 6, 30, 33);
            } else {
                g.drawRect((choice - 5) * this.getWidth() / 7, 3 * this.getHeight() / 6, 30, 33);
            }
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        this.img = null;
        this.score = null;
        this.level = null;
        this.star = null;
        this.lock = null;
    }

    public void handleSms(boolean success) {
    }

    public void switchScreen() {
    }

    public void upKeyPressed() {
        if (choice == 1) {
            choice = 6;
        } else if (choice == 2) {
            choice = 7;
        } else if (choice == 3) {
            choice = 8;
        } else if (choice == 4) {
            choice = 9;
        } else if (choice == 5) {
            choice = 10;
        } else if (choice == 6) {
            choice = 1;
        } else if (choice == 7) {
            choice = 2;
        } else if (choice == 8) {
            choice = 3;
        } else if (choice == 9) {
            choice = 4;
        } else if (choice == 10) {
            choice = 5;
        }
    }

    public void downKeyPressed() {
        if (choice == 1) {
            choice = 6;
        } else if (choice == 2) {
            choice = 7;
        } else if (choice == 3) {
            choice = 8;
        } else if (choice == 4) {
            choice = 9;
        } else if (choice == 5) {
            choice = 10;
        } else if (choice == 6) {
            choice = 1;
        } else if (choice == 7) {
            choice = 2;
        } else if (choice == 8) {
            choice = 3;
        } else if (choice == 9) {
            choice = 4;
        } else if (choice == 10) {
            choice = 5;
        }
    }

    public void rightKeyPressed() {
        choice = choice < 10 ? ++choice : 1;
    }

    public void leftKeyPressed() {
        choice = choice > 1 ? --choice : 10;
    }

    public void fireKeyPressed() {
        if (choice <= MainGame.user.getGameLevel()[MainGame.stage - 1]) {
            this.kindSwitchScreen = choice;
        }
        if (choice <= MainGame.user.getGameLevel()[MainGame.stage - 1]) {
            this.dispose();
            this.game.setScreen(new Information(this.game));
        }
    }

    public void softKeyLeftPressed() {
    }

    public void softKeyRightPressed() {
        this.dispose();
        this.game.setScreen(new StageScreen(this.game));
    }

    public void numberKeyPressed(int keyCode) {
    }

    public void upKeyRealeased() {
    }

    public void downKeyRealeased() {
    }

    public void rightKeyRealeased() {
    }

    public void leftKeyRealeased() {
    }

    public void upKeytRepeated() {
    }

    public void downKeyRepeated() {
    }

    public void rightKeyRepeated() {
    }

    public void leftKeyRepeated() {
    }

    public void pointerPressed(int x, int y) {
        if (x > this.getWidth() / 7 && x <= this.getWidth() / 7 + 30 && y >= 2 * this.getHeight() / 6 - 3 && y <= 2 * this.getHeight() / 6 + 33) {
            choice = 1;
            this.fireKeyPressed();
        } else if (x > 2 * this.getWidth() / 7 && x <= 2 * this.getWidth() / 7 + 30 && y >= 2 * this.getHeight() / 6 - 3 && y <= 2 * this.getHeight() / 6 + 33) {
            choice = 2;
            this.fireKeyPressed();
        } else if (x > 3 * this.getWidth() / 7 && x <= 3 * this.getWidth() / 7 + 30 && y >= 2 * this.getHeight() / 6 - 3 && y <= 2 * this.getHeight() / 6 + 33) {
            choice = 3;
            this.fireKeyPressed();
        } else if (x > 4 * this.getWidth() / 7 && x <= 4 * this.getWidth() / 7 + 30 && y >= 2 * this.getHeight() / 6 - 3 && y <= 2 * this.getHeight() / 6 + 33) {
            choice = 4;
            this.fireKeyPressed();
        } else if (x > 5 * this.getWidth() / 7 && x <= 5 * this.getWidth() / 7 + 30 && y >= 2 * this.getHeight() / 6 - 3 && y <= 2 * this.getHeight() / 6 + 33) {
            choice = 5;
            this.fireKeyPressed();
        } else if (x > this.getWidth() / 7 && x <= this.getWidth() / 7 + 30 && y >= 3 * this.getHeight() / 6 - 3 && y <= 3 * this.getHeight() / 6 + 33) {
            choice = 6;
            this.fireKeyPressed();
        } else if (x > 2 * this.getWidth() / 7 && x <= 2 * this.getWidth() / 7 + 30 && y >= 3 * this.getHeight() / 6 - 3 && y <= 3 * this.getHeight() / 6 + 33) {
            choice = 7;
            this.fireKeyPressed();
        } else if (x > 3 * this.getWidth() / 7 && x <= 3 * this.getWidth() / 7 + 30 && y >= 3 * this.getHeight() / 6 - 3 && y <= 3 * this.getHeight() / 6 + 33) {
            choice = 8;
            this.fireKeyPressed();
        } else if (x > 4 * this.getWidth() / 7 && x <= 4 * this.getWidth() / 7 + 30 && y >= 3 * this.getHeight() / 6 - 3 && y <= 3 * this.getHeight() / 6 + 33) {
            choice = 9;
            this.fireKeyPressed();
        } else if (x > 5 * this.getWidth() / 7 && x <= 5 * this.getWidth() / 7 + 30 && y >= 3 * this.getHeight() / 6 - 3 && y <= 3 * this.getHeight() / 6 + 33) {
            choice = 10;
            this.fireKeyPressed();
        } else if (x >= this.getWidth() - 40 && x <= this.getWidth() && y >= this.getHeight() - 30 && y <= this.getHeight()) {
            this.softKeyRightPressed();
        } else if (x >= this.getWidth() / 2 - 15 && x <= this.getWidth() / 2 + 15 && y >= this.getHeight() - 30 && y <= this.getHeight()) {
            this.fireKeyPressed();
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    protected void paint(Graphics grphcs) {
        this.present(grphcs);
    }

    public void drawAddScore(Graphics g, String line, int x, int y) throws IOException {
        Image imgNoAddScore = this.score;
        int offset = imgNoAddScore.getWidth() / 12;
        for (int i = 0; i < line.length(); ++i) {
            char character = line.charAt(i);
            if (character == ' ') {
                x += offset;
                continue;
            }
            int srcX = 0;
            int srcWidth = 0;
            if (character == '+') {
                srcX = 0;
                srcWidth = offset;
            } else if (character == '-') {
                srcX = offset;
                srcWidth = offset;
            } else if (character == '$') {
                srcX = 12 * offset;
                srcWidth = offset;
            } else {
                srcX = (character - 48) * offset + 2 * offset;
                srcWidth = offset;
            }
            g.drawRegion(imgNoAddScore, srcX, 0, srcWidth, imgNoAddScore.getHeight(), 0, x, y, 20);
            x += srcWidth + 1;
        }
    }
}

