/*
 * Decompiled with CFR 0.152.
 */
class FGCheats {
    public static final int MAX_CHEATS = 20;
    public static final int MAX_CODE_LENGTH = 8;
    Code[] m_codes = new Code[20];
    public int[] m_lastKeystrokes = new int[8];
    int m_numCodes;
    int m_keysSinceReset;

    public FGCheats() {
        for (int i = 0; i < 20; ++i) {
            this.m_codes[i] = new Code();
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < 8; ++i) {
            this.m_lastKeystrokes[i] = -1;
        }
        this.m_keysSinceReset = 0;
    }

    public void registerCheat(String string, int n) {
        this.m_codes[this.m_numCodes].setSequence(string);
        this.m_codes[this.m_numCodes].m_ID = n;
        ++this.m_numCodes;
    }

    public int keyPressed(int n) {
        int n2;
        ++this.m_keysSinceReset;
        for (n2 = 0; n2 < 7; ++n2) {
            this.m_lastKeystrokes[n2] = this.m_lastKeystrokes[n2 + 1];
        }
        this.m_lastKeystrokes[7] = n;
        for (n2 = 0; n2 < this.m_numCodes; ++n2) {
            if (!this.m_codes[n2].compareTo(this.m_lastKeystrokes)) continue;
            return this.m_codes[n2].m_ID;
        }
        return -1;
    }

    public boolean onTrackSinceReset() {
        for (int i = 0; i < this.m_numCodes; ++i) {
            if (!this.m_codes[i].comparePartiallyTo(this.m_lastKeystrokes, this.m_keysSinceReset)) continue;
            return true;
        }
        return false;
    }

    class Code {
        public int[] m_code = new int[8];
        public int m_codeLength = 0;
        public int m_ID;

        public void setSequence(String string) {
            block9: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case 'U': 
                    case 'u': {
                        this.m_code[this.m_codeLength] = 1;
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case 'D': 
                    case 'd': {
                        this.m_code[this.m_codeLength] = 6;
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case 'L': 
                    case 'l': {
                        this.m_code[this.m_codeLength] = 2;
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case 'R': 
                    case 'r': {
                        this.m_code[this.m_codeLength] = 5;
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.m_code[this.m_codeLength] = 48 + (c - 48);
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case '*': {
                        this.m_code[this.m_codeLength] = 42;
                        ++this.m_codeLength;
                        continue block9;
                    }
                    case '#': {
                        this.m_code[this.m_codeLength] = 35;
                        ++this.m_codeLength;
                    }
                }
            }
        }

        public boolean compareTo(int[] nArray) {
            int n = 8 - this.m_codeLength;
            for (int i = 0; i < this.m_codeLength; ++i) {
                if (this.m_code[i] != nArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean comparePartiallyTo(int[] nArray, int n) {
            int n2 = 8 - n;
            for (int i = 0; i < n; ++i) {
                if (this.m_code[i] != nArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

