/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class FGWeb
implements Runnable {
    public static boolean VERBOSE = false;
    public static final int CHUNK_SIZE = 1024;
    public static final int FGWEB_IDLE = 0;
    public static final int FGWEB_RESOLVING_DNS = 1;
    public static final int FGWEB_CONNECTING = 2;
    public static final int FGWEB_SENDING = 3;
    public static final int FGWEB_RECEIVING = 4;
    public static final int FGWEB_ERROR = 5;
    public static final int FGWEB_DONE = 6;
    public static final int FGWEB_ABORTED = 7;
    public static final int NUM_FGWEB_STATES = 7;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_GETPAGE = 1;
    private static final int ACTION_TERMINATE = 2;
    private FGData m_data;
    private int m_state = 0;
    private int m_bytesRead;
    private int m_bytesToRead;
    private Thread m_pThread;
    private String m_url;
    private int m_nextAction = 0;
    private boolean m_bAbort;
    private boolean m_bSimulateFailure;
    private boolean m_bInitted;
    public int m_loopCounter;

    public void init() {
        this.m_state = 0;
        this.m_pThread = new Thread(this);
        this.m_pThread.start();
        this.m_bInitted = true;
    }

    public void terminate() {
        this.cancel();
        this.m_nextAction = 2;
    }

    public void getPage(String string, FGData fGData) {
        if (this.m_state == 1 || this.m_state == 2 || this.m_state == 3 || this.m_state == 4) {
            FGEngine.fatal("Attempt to use FGWeb while it's already in progress. Call cancel() to cancel previous req.");
            return;
        }
        this.m_state = 0;
        System.out.println(string);
        if (!this.m_bInitted) {
            FGEngine.fatal("FGWeb used without being initted.");
            return;
        }
        this.m_data = fGData;
        this.m_state = 1;
        this.m_bAbort = false;
        this.m_bytesRead = 0;
        this.m_url = new String(string);
        this.m_nextAction = 1;
    }

    public FGData getResult() {
        this.m_data.m_dataLength = this.getBytesRead();
        return this.m_data;
    }

    public void releaseBuffer() {
        this.m_data = null;
    }

    public FGString getResultString() {
        FGString fGString = new FGString();
        fGString.set(this.m_data, this.m_bytesRead);
        return fGString;
    }

    void cancel() {
        this.m_bAbort = true;
        this.m_bSimulateFailure = false;
        this.m_bytesRead = 0;
        this.m_bytesToRead = 0;
    }

    public int getStatus() {
        return this.m_state;
    }

    public void setTimeout(long l) {
    }

    public int getBytesRead() {
        return this.m_bytesRead;
    }

    public int getBytesToRead() {
        return this.m_bytesToRead;
    }

    public void simulateError() {
        this.m_bSimulateFailure = true;
    }

    private void doGetPage() {
        InputStream inputStream;
        HttpConnection httpConnection;
        block17: {
            String string = "http://" + this.m_url;
            if (this.m_url.startsWith("http://")) {
                string = this.m_url;
            }
            this.m_state = 2;
            httpConnection = null;
            inputStream = null;
            try {
                httpConnection = (HttpConnection)Connector.open((String)string);
                inputStream = httpConnection.openInputStream();
                int n = (int)httpConnection.getLength();
                this.m_state = 4;
                this.m_bytesToRead = 0;
                if (n > 0) {
                    this.m_bytesToRead = n;
                    if (n > this.m_data.m_allocated) {
                        throw new RuntimeException("FGWeb erroring out because there's more data to read than the buffer size: " + n + " vs. " + this.m_data.m_allocated);
                    }
                    this.m_bytesRead = 0;
                    while (this.m_bytesRead < n) {
                        int n2 = n - this.m_bytesRead;
                        int n3 = 1024;
                        if (n2 < n3) {
                            n3 = n2;
                        }
                        int n4 = inputStream.read(this.m_data.m_data, this.m_bytesRead, n3);
                        this.m_bytesRead += n4;
                        if (this.m_bAbort) {
                            throw new Exception("Aborted reading");
                        }
                        if (!this.m_bSimulateFailure) continue;
                        throw new Exception("Simulated Failure");
                    }
                } else {
                    this.m_bytesRead = 0;
                    boolean bl = false;
                    while (!bl) {
                        int n5 = inputStream.read();
                        if (n5 == -1) {
                            bl = true;
                            continue;
                        }
                        if (this.m_bytesRead >= this.m_data.m_data.length) {
                            throw new RuntimeException("FGWeb erroring out because there's more data to read than the buffer size");
                        }
                        this.m_data.m_data[this.m_bytesRead] = (byte)n5;
                        ++this.m_bytesRead;
                        if (this.m_bAbort) {
                            throw new Exception("Aborted reading");
                        }
                        if (!this.m_bSimulateFailure) continue;
                        throw new Exception("Simulated Failure");
                    }
                }
                this.m_state = 6;
                this.m_data.m_dataLength = this.getBytesRead();
            }
            catch (Exception exception) {
                this.m_state = this.m_bAbort ? 7 : 5;
                this.cancel();
                exception.printStackTrace();
                if (!VERBOSE) break block17;
                FGEngine.fatal(exception.toString());
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (true) {
            if (this.m_nextAction == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.m_loopCounter;
                continue;
            }
            switch (this.m_nextAction) {
                case 1: {
                    this.m_bAbort = false;
                    this.m_state = 2;
                    this.m_nextAction = 0;
                    this.doGetPage();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }
}

