/*
 * Decompiled with CFR 0.152.
 */
class CVUnit {
    public static final int TYPE_INFANTRY = 0;
    public static final int TYPE_RANGED = 1;
    public static final int TYPE_MOBILE = 2;
    public static final int TYPE_WALL = 3;
    public static final int TYPE_FORT = 4;
    public static final int NUM_UNIT_TYPES = 4;
    public static final int NUM_UNIT_GFX = 5;
    public static final int MODE_MOVING = 0;
    public static final int MODE_STILL = 1;
    public static final int MODE_DYING = 2;
    public static final int MODE_DEAD = 3;
    public static final int ANIM_NORMAL = 0;
    public static final int ANIM_ATTACK = 1;
    public static final int UNIT_ANIM_TIME = 250;
    public static final int SOURCE_ARTILLERY = -1;
    public static final int SOURCE_NAPALM = -2;
    public int m_type = -1;
    public int m_mode = 3;
    public int m_speed;
    public int m_side = -1;
    public int m_hp;
    public int m_fixX;
    public CVGameMode m_game;
    public CVArmy m_army;
    public FGTimer m_attackTimer = new FGTimer();
    public boolean m_bInSkirmish;
    public FGTimer m_deathTimer = new FGTimer();
    public FGAnimation m_attackAnim = new FGAnimation();
    public int m_animState;
    boolean m_bBlockFiring;
    CVUnit m_blockedBy;
    FGAnimation m_sparkleAnim = new FGAnimation();
    boolean m_bMaxPointHalted;
    boolean m_bLastAttackAgainstUnit;

    public static boolean unitKillsUnit(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        switch (n) {
            case 0: {
                if (n2 == 1) {
                    return true;
                }
                if (!bl || n2 != 2 || !bl2) break;
                return true;
            }
            case 2: {
                if (n2 == 0) {
                    return !bl || !bl3;
                }
                if (n2 != 1) break;
                return true;
            }
        }
        return false;
    }

    public void init(int n, int n2) {
        CVEngine cVEngine = (CVEngine)FGEngine.getEngine();
        this.m_game = cVEngine.m_gameMode;
        int n3 = this.m_game.m_armies[n2].m_unitsStart;
        this.init(n, n2, n3);
    }

    public void init(int n, int n2, int n3) {
        this.m_type = n;
        this.m_mode = 0;
        this.m_animState = 0;
        this.m_side = n2;
        CVEngine cVEngine = (CVEngine)FGEngine.getEngine();
        this.m_game = cVEngine.m_gameMode;
        this.m_army = this.m_game.m_armies[this.m_side];
        this.m_fixX = FGFixed.toFixed(n3);
        this.m_hp = this.isFortOrWall() ? this.m_game.getStartHP(this.m_type, this.m_side) : 1;
        this.m_bInSkirmish = false;
        this.m_attackAnim.init(this.m_army.m_unitAttackGFX[this.m_type]);
        if (cVEngine.isLarge()) {
            this.m_sparkleAnim.init(this.m_game.m_sparkleAnim);
        }
        this.checkRangedOverlap(-1000);
        this.m_bBlockFiring = false;
        this.m_bLastAttackAgainstUnit = false;
        this.m_blockedBy = null;
        if (cVEngine.isLarge() && this.m_game.m_mode == 3) {
            this.m_sparkleAnim.playOnce();
        }
    }

    public boolean isEarlyDrawer() {
        if (this.m_type == 2) {
            return true;
        }
        return this.isFortOrWall();
    }

    public boolean isFortOrWall() {
        if (this.m_type == 4) {
            return true;
        }
        return this.m_type == 3;
    }

    public void clear() {
        this.m_type = -1;
        this.m_mode = 3;
        this.m_side = -1;
    }

    public boolean isValid() {
        return this.m_mode != 3;
    }

    public void takeHit(int n, int n2) {
        int n3;
        if (this.isFortOrWall()) {
            if (this.m_game.hasTech(this.m_side, 7) && (n2 == 2 || n2 == 1)) {
                n3 = this.m_game.m_engine.m_techValues[7];
                int n4 = this.m_game.m_engine.rand() % 100;
                if (n4 < n3) {
                    this.addFloater(0);
                    return;
                }
            }
            n3 = this.m_game.getOtherSide(this.m_side);
            if (n2 == 0 && this.m_game.hasTech(n3, 25)) {
                n *= 2;
            }
            this.m_hp -= n;
            FGImage fGImage = this.m_game.m_armies[0].m_artillery.m_smokeAnims[0].getFrame(0);
            this.m_game.addFloater(this.getVisualCenter(), fGImage);
            if (this.m_hp > 0) {
                return;
            }
        }
        if (this.m_game.hasTech(this.m_side, 6) && this.m_type == 0 && n2 == -1) {
            n3 = this.m_game.m_engine.m_techValues[6];
            int n5 = this.m_game.m_engine.rand() % 100;
            if (n5 < n3) {
                this.addFloater(0);
                return;
            }
        }
        this.m_mode = 2;
        this.m_deathTimer.start(1000);
        this.m_game.unitDisappears(this);
        if (this.isFortOrWall()) {
            this.m_game.playSound(FGFixed.toInt(this.m_fixX), 12);
        } else if (n2 == 2 && this.m_game.m_era == 3) {
            this.m_game.playSound(FGFixed.toInt(this.m_fixX), 5);
        } else if (n2 == 1) {
            this.m_game.playSound(FGFixed.toInt(this.m_fixX), 7);
        } else {
            this.m_game.playSound(FGFixed.toInt(this.m_fixX), 2);
        }
        String string = null;
        if (this.isFortOrWall()) {
            string = this.m_type == 4 ? (this.m_side == 0 ? "STR_ALERT_PLR_FORT" : "STR_ALERT_OPP_FORT") : (this.m_side == 0 ? "STR_ALERT_PLR_WALL" : "STR_ALERT_OPP_WALL");
        }
        if (string != null) {
            this.m_game.popup(this.m_game.m_engine.m_strings.getString(string));
            int n6 = FGFixed.toInt(this.m_fixX);
            this.m_game.autoScroll(n6, 1);
        }
    }

    public void doAttackAnim() {
        this.m_animState = 1;
        this.m_attackAnim.playOnce();
    }

    public void tick() {
        if (this.m_animState == 1) {
            if (this.m_attackAnim.finishedPlaying()) {
                if (this.m_mode == 1 || this.m_bInSkirmish) {
                    this.finishAttack();
                }
                this.m_bLastAttackAgainstUnit = false;
                this.m_animState = 0;
            }
        } else if (this.m_bInSkirmish) {
            this.tryAttack();
        }
        switch (this.m_mode) {
            case 0: {
                this.move();
                break;
            }
            case 3: {
                return;
            }
            case 2: {
                if (this.m_deathTimer.isOver()) {
                    this.m_mode = 3;
                    if (this.m_type == 0 && this.m_game.hasTech(this.m_side, 12)) {
                        int n = this.m_game.getUnitCost(this.m_side, this.m_type);
                        n = this.m_game.percentifyTech(n, this.m_side, 12);
                        this.m_game.m_armies[this.m_side].m_food += n;
                        this.m_game.m_armies[this.m_side].capResources();
                        this.addFloater(1);
                    }
                }
                return;
            }
            case 1: {
                this.still();
            }
        }
        if (!this.isFortOrWall()) {
            int n = this.getVisualCenter();
            int n2 = this.m_game.getOtherSide(this.m_side);
            if (this.m_game.m_armies[n2].isInBurn(n)) {
                this.takeHit(1, -2);
            }
        }
    }

    public int getFixDesiredMovement() {
        CVEngine cVEngine = this.m_game.m_engine;
        if (this.m_game.hasTech(this.m_side, 27) && this.m_type == 2) {
            int n = cVEngine.m_unitPPS[this.m_type][0];
            if (this.isSatelliteTechApply()) {
                n = this.m_game.percentify(n, this.m_game.m_engine.m_satelliteTechSpeed);
            }
            return FGFixed.toFixed(n);
        }
        int n = this.m_game.getGridX(this.getX());
        int n2 = cVEngine.m_unitPPS[this.m_type][0];
        if (n < 0) {
            return FGFixed.toFixed(n2);
        }
        if (n >= 60) {
            return FGFixed.toFixed(n2);
        }
        if (this.m_game.m_terrainLeftHeights[n] == -1) {
            return FGFixed.toFixed(n2);
        }
        int n3 = 0;
        n3 = this.m_side == 0 ? this.m_game.m_terrainLeftHeights[n] - this.m_game.m_terrainRightHeights[n] : this.m_game.m_terrainRightHeights[n] - this.m_game.m_terrainLeftHeights[n];
        int n4 = 0;
        if (n3 > this.m_game.STEEP_HILL_HEIGHT) {
            n4 = 2;
        } else if (n3 > 0) {
            n4 = 1;
        }
        int n5 = cVEngine.m_unitPPS[this.m_type][n4];
        int n6 = 100;
        if (this.m_type == 2 && this.m_game.isInForest(this.m_fixX)) {
            n6 = 100 - cVEngine.m_mobileForestPenalty;
        }
        if (this.m_type == 0 && this.m_game.hasTech(this.m_side, 1)) {
            n6 = this.m_game.m_engine.m_techValues[1];
        }
        if (this.isSatelliteTechApply()) {
            n6 = this.m_game.m_engine.m_satelliteTechSpeed;
        }
        n5 = n5 * n6 / 100;
        return FGFixed.toFixed(n5);
    }

    public boolean isSatelliteTechApply() {
        return this.m_game.hasTech(this.m_side, 29) && this.m_game.m_armies[this.m_side].m_fwdMostUnit == this;
    }

    public void still() {
        if (this.isFortOrWall()) {
            return;
        }
        this.checkIntersections();
        if (this.m_mode == 2) {
            return;
        }
        this.skirmishCheck();
        if (this.m_bInSkirmish) {
            return;
        }
        int n = this.m_game.getOtherSide(this.m_side);
        if (this.m_type == 1) {
            if (this.m_bBlockFiring) {
                if (!this.m_blockedBy.mechanicallyExists()) {
                    this.m_bBlockFiring = false;
                }
                if (this.m_blockedBy.m_mode != 1) {
                    this.m_bBlockFiring = false;
                }
            }
            if (this.m_game.m_armies[n].m_fixForwardMost == -1L) {
                this.m_mode = 0;
                return;
            }
            int n2 = (int)((long)this.m_fixX - this.m_game.m_armies[n].m_fixForwardMost);
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n2 >= this.getFixRange()) {
                this.m_mode = 0;
                return;
            }
            this.tryAttack();
        } else {
            if (this.m_game.m_armies[n].m_fixForwardMost == -1L) {
                this.m_mode = 0;
                return;
            }
            CVUnit cVUnit = this.m_game.getForwardWall(n);
            if (cVUnit == null || cVUnit.m_fixX != this.m_fixX) {
                this.m_mode = 0;
                return;
            }
            this.tryAttack();
        }
        if (this.m_type == 0 && this.m_game.passed(this.m_fixX, this.m_game.m_fixBorderX, this.m_side)) {
            this.m_game.m_fixBorderX = this.m_fixX;
            this.m_game.m_bBorderMoved = true;
        }
    }

    public void tryAttack() {
        if (this.isSkirmishLeader()) {
            if (this.m_attackTimer.isOver()) {
                this.attack();
            }
            return;
        }
        if (this.m_bInSkirmish) {
            return;
        }
        if (this.m_type == 2 && !this.m_game.hasTech(this.m_side, 22)) {
            return;
        }
        if (this.m_attackTimer.isOver()) {
            this.attack();
        }
    }

    public void attack() {
        int n = this.m_game.getOtherSide(this.m_side);
        CVUnit cVUnit = null;
        cVUnit = this.m_type == 1 ? this.m_game.getForwardMostUnit(-1, n) : (this.isSkirmishLeader() ? this.m_game.m_armies[n].m_skirmishers[0] : this.m_game.getForwardWall(n));
        if (cVUnit == null) {
            return;
        }
        this.doAttackAnim();
        CVEngine cVEngine = this.m_game.m_engine;
        this.m_attackTimer.start(cVEngine.m_unitAttackTimes[this.m_type]);
    }

    private boolean isSkirmishLeader() {
        return this.m_bInSkirmish && this == this.m_game.m_armies[this.m_side].m_skirmishers[0];
    }

    public void finishAttack() {
        CVEngine cVEngine = this.m_game.m_engine;
        int n = this.m_game.getOtherSide(this.m_side);
        CVUnit cVUnit = null;
        if (this.isSkirmishLeader()) {
            int n2 = cVEngine.rand() % 100;
            int n3 = cVEngine.m_meleeOdds;
            if (this.isSatelliteTechApply()) {
                n3 += this.m_game.m_engine.m_techValues[29];
            }
            cVUnit = this.m_game.m_armies[n].m_skirmishers[0];
            if (n2 < n3 && cVUnit != null) {
                this.m_game.m_armies[n].m_skirmishers[0].takeHit(1, this.m_type);
            }
            return;
        }
        if (this.m_bInSkirmish) {
            return;
        }
        cVUnit = this.m_type == 1 ? this.m_game.getForwardMostUnit(-1, n) : this.m_game.getForwardWall(n);
        if (cVUnit == null) {
            return;
        }
        if (this.m_bLastAttackAgainstUnit) {
            return;
        }
        if (this.m_type == 1) {
            int n4 = cVEngine.rand() % 100;
            int n5 = cVEngine.m_rangedOdds;
            if (this.m_game.hasTech(this.m_side, 16)) {
                n5 = this.m_game.m_engine.m_techValues[16];
            }
            if (this.isSatelliteTechApply()) {
                n5 += this.m_game.m_engine.m_techValues[29];
            }
            if (n4 > n5) {
                return;
            }
        }
        cVUnit.takeHit(1, this.m_type);
        if (cVUnit.isFortOrWall() && this.m_type == 2 && this.m_game.hasTech(this.m_side, 22)) {
            this.addFloater(2);
        }
    }

    public void move() {
        int n;
        int n2;
        int n3;
        if (this.isFortOrWall()) {
            return;
        }
        if (this.m_bInSkirmish) {
            return;
        }
        CVEngine cVEngine = this.m_game.m_engine;
        int n4 = cVEngine.getTickTime();
        if (n4 > 1000) {
            n3 = 5;
        }
        n3 = this.getFixDesiredMovement();
        if (this.m_side == 1) {
            n3 = -n3;
        }
        int n5 = this.m_fixX;
        this.m_fixX = FGGeometry.applyPPSVel(this.m_fixX, n3, FGFixed.toFixed(n4));
        this.skirmishCheck();
        this.checkIntersections();
        if (this.m_mode == 2) {
            return;
        }
        this.m_bMaxPointHalted = false;
        if (this.m_type == 1) {
            this.checkRangedOverlap(n5);
            n2 = this.m_game.getOtherSide(this.m_side);
            if (this.m_game.m_armies[n2].m_fixForwardMost != -1L) {
                n = (int)((long)this.m_fixX - this.m_game.m_armies[n2].m_fixForwardMost);
                if (n < 0) {
                    n = -n;
                }
                if (n < this.getFixRange()) {
                    this.m_mode = 1;
                }
            }
        }
        n2 = this.m_game.getOtherSide(this.m_side);
        n = FGFixed.toFixed(this.m_game.m_armies[n2].m_unitsStart);
        if (this.m_game.passed(this.m_fixX, n, this.m_side)) {
            this.m_game.win(this.m_side);
        }
        if (this.m_type == 0 && this.m_game.passed(this.m_fixX, this.m_game.m_fixBorderX, this.m_side)) {
            this.m_game.m_fixBorderX = this.m_fixX;
            this.m_game.m_bBorderMoved = true;
        }
    }

    public void skirmishCheck() {
        if (this.m_game.m_bSkirmishExists && this.m_game.intersectsSkirmish(this.m_fixX, this.m_side) && this.m_game.m_skirmishUnitType == this.m_type) {
            this.m_game.addToSkirmish(this);
        }
    }

    public void checkIntersections() {
        int n = this.m_game.getOtherSide(this.m_side);
        for (int i = 0; i < 16; ++i) {
            CVUnit cVUnit = this.m_game.m_armies[n].m_units[i];
            if (!cVUnit.mechanicallyExists() || !this.m_game.passed(this.m_fixX, cVUnit.m_fixX, this.m_side)) continue;
            this.intersectEnemyUnit(cVUnit);
        }
    }

    public void checkRangedOverlap(int n) {
        if (this.m_type != 1) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            CVUnit cVUnit = this.m_game.m_armies[this.m_side].m_units[i];
            if (cVUnit == this || !cVUnit.mechanicallyExists() || cVUnit.m_type != 1) continue;
            int n2 = cVUnit.m_fixX;
            n2 = this.m_side == 0 ? (n2 -= FGFixed.toFixed(4)) : (n2 += FGFixed.toFixed(4));
            if (this.m_game.passed(n, n2, this.m_side) || !this.m_game.passed(this.m_fixX, n2, this.m_side)) continue;
            this.m_bMaxPointHalted = true;
            if (cVUnit.m_mode == 0) {
                this.m_fixX = n2;
                return;
            }
            if (cVUnit.m_mode != 1) continue;
            this.m_bBlockFiring = true;
            this.m_blockedBy = cVUnit;
            this.m_fixX = n2;
            this.m_mode = 1;
            return;
        }
    }

    public void intersectEnemyUnit(CVUnit cVUnit) {
        boolean bl;
        if (cVUnit.m_type == this.m_type) {
            if (!this.m_game.m_bSkirmishExists) {
                this.m_game.beginSkirmish(cVUnit, this);
            }
            return;
        }
        boolean bl2 = this.m_game.isInForest(this.m_fixX);
        int n = this.m_game.getOtherSide(this.m_side);
        boolean bl3 = this.m_game.hasTech(this.m_side, 5);
        if (CVUnit.unitKillsUnit(this.m_type, cVUnit.m_type, bl2, bl3, bl = this.m_game.hasTech(n, 5))) {
            this.doAttackAnim();
            cVUnit.takeHit(1, this.m_type);
            if (this.m_type == 0 && cVUnit.m_type == 2 && bl2) {
                this.addFloater(0);
            }
            this.m_bLastAttackAgainstUnit = true;
        }
        if (CVUnit.unitKillsUnit(cVUnit.m_type, this.m_type, bl2, bl, bl3)) {
            cVUnit.doAttackAnim();
            this.takeHit(1, cVUnit.m_type);
            if (this.m_type == 2 && cVUnit.m_type == 0 && bl2) {
                this.addFloater(0);
            }
            cVUnit.m_bLastAttackAgainstUnit = true;
        }
        if (cVUnit.isFortOrWall()) {
            this.m_fixX = cVUnit.m_fixX;
            this.m_mode = 1;
        }
    }

    public static int getFixRawRange(int n) {
        CVEngine cVEngine = (CVEngine)FGEngine.getEngine();
        CVGameMode cVGameMode = cVEngine.m_gameMode;
        int n2 = cVEngine.m_rangedRange;
        n2 = cVGameMode.percentifyTech(n2, n, 2);
        return FGFixed.toFixed(n2);
    }

    public int getFixRange() {
        if (this.m_bBlockFiring) {
            return FGFixed.toFixed(this.m_game.m_map.getWidth());
        }
        return CVUnit.getFixRawRange(this.m_side);
    }

    public int getX() {
        return FGFixed.toInt(this.m_fixX);
    }

    public boolean mechanicallyExists() {
        switch (this.m_mode) {
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    public void pause() {
        this.m_deathTimer.pause();
        this.m_attackAnim.pause();
        CVEngine cVEngine = (CVEngine)FGEngine.getEngine();
        if (cVEngine.isLarge()) {
            this.m_sparkleAnim.pause();
        }
    }

    public void resume() {
        this.m_deathTimer.resume();
        this.m_attackAnim.resume();
        CVEngine cVEngine = (CVEngine)FGEngine.getEngine();
        if (cVEngine.isLarge()) {
            this.m_sparkleAnim.resume();
        }
    }

    public void drawSelf(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.isFortOrWall() && this.m_mode == 2 && (n5 = this.m_deathTimer.elapsedTime() / 200) % 2 == 0) {
            return;
        }
        FGImage fGImage = null;
        boolean bl = false;
        if (this.m_mode == 2 && !this.isFortOrWall()) {
            fGImage = this.m_game.m_skullImg;
        } else if (this.m_animState == 1) {
            fGImage = this.m_attackAnim.getCurrentFrame();
            if (this.m_type == 1 && this.m_attackAnim.getFrame(n4 = this.m_attackAnim.m_numFrames - 1) == fGImage) {
                bl = true;
            }
        } else {
            fGImage = this.m_mode == 1 || this.m_bMaxPointHalted ? this.m_army.m_unitWalkGFX[this.m_type].getFrame(0) : (this.m_bBlockFiring && this.m_blockedBy != null && this.m_blockedBy.m_bMaxPointHalted ? this.m_army.m_unitWalkGFX[this.m_type].getFrame(0) : this.m_army.m_unitWalkGFX[this.m_type].getCurrentFrame());
        }
        n4 = this.getX();
        int n6 = this.m_side == 0 ? n4 - fGImage.getWidth() : n4;
        int n7 = n6 + fGImage.getWidth() / 2;
        int n8 = this.m_game.getTerrainY(n7);
        int n9 = n8 - fGImage.getHeight();
        n6 -= this.m_game.m_scroll;
        int n10 = this.m_game.m_engine.getScreenHeight() - this.m_game.m_map.getHeight();
        n9 += n10;
        n9 += this.m_army.m_unitOffsetY;
        if (this.m_side == 0) {
            fGImage.drawSelf(fGGraphics, n6, n9);
            if (bl) {
                n3 = n6 + this.m_army.m_projectileOffsetX;
                n2 = n9 + this.m_army.m_projectileOffsetY;
                this.m_army.m_projectile.drawSelf(fGGraphics, n3, n2);
            }
        } else {
            fGImage.drawSelfFlippedH(fGGraphics, n6, n9);
            if (bl) {
                n3 = n6 + fGImage.getWidth() - this.m_army.m_projectileOffsetX - this.m_army.m_projectile.getWidth();
                n2 = n9 + this.m_army.m_projectileOffsetY;
                this.m_army.m_projectile.drawSelfFlippedH(fGGraphics, n3, n2);
            }
        }
        if (this.isFortOrWall() && this.m_game.hasTech(this.m_side, 28)) {
            FGImage fGImage2 = this.m_game.m_strongWall;
            n2 = n6 + (fGImage.getWidth() - fGImage2.getWidth()) / 2;
            n = n9 + (fGImage.getHeight() - fGImage2.getHeight()) / 2;
            if (this.m_type == 4) {
                fGImage2 = this.m_game.m_strongFort;
                n2 = n6 + (fGImage.getWidth() - fGImage2.getWidth()) / 2;
                n = n9 + fGImage.getHeight() - fGImage2.getHeight();
            }
            fGImage2.drawSelf(fGGraphics, n2, n);
        }
        if (this.isSatelliteTechApply()) {
            FGImage fGImage3 = this.m_game.m_armies[this.m_side].m_satelliteAnim.getCurrentFrame();
            n2 = n6 + (fGImage.getWidth() - fGImage3.getWidth()) / 2;
            n = n9 - fGImage3.getHeight() * 2;
            fGImage3.drawSelf(fGGraphics, n2, n);
        }
        CVGameMode cVGameMode = this.m_game;
        if (cVGameMode.m_engine.isLarge() && this.m_sparkleAnim.m_bPlayingOnce && !this.m_sparkleAnim.finishedPlaying()) {
            FGImage fGImage4 = this.m_sparkleAnim.getCurrentFrame();
            n2 = this.getVisualCenter();
            n = n2 - fGImage4.getWidth() / 2;
            int n11 = n8 - fGImage4.getHeight();
            n11 += n10;
            fGImage4.drawSelf(fGGraphics, n -= this.m_game.m_scroll, n11 += this.m_army.m_unitOffsetY);
        }
    }

    public int getVisualWidth() {
        return this.m_army.m_unitWalkGFX[this.m_type].getFrame(0).getWidth();
    }

    public int getVisualCenter() {
        if (this.m_side == 0) {
            return this.getX() - this.getVisualWidth() / 2;
        }
        return this.getX() + this.getVisualWidth() / 2;
    }

    public void clearArt() {
        this.m_attackAnim.clearArt();
    }

    public void addFloater(int n) {
        this.m_game.addTechFloater(this.getVisualCenter(), n);
    }
}

