/*
 * Decompiled with CFR 0.152.
 */
class FGContentDownloader {
    public static final int DOWNLOADER_STATE_IDLE = -1;
    public static final int DOWNLOADER_STATE_DOWNLOADING = 0;
    public static final int DOWNLOADER_STATE_EXTRACTING = 1;
    public static final int DOWNLOADER_STATE_DONE = 2;
    public static final int DOWNLOADER_STATE_ERROR = 3;
    public static final int DOWNLOADER_STATE_ABORTED = 4;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NETWORK = 1;
    public static final int ERROR_BAD_DATA = 2;
    public static final int ERROR_WRITE_FAILED = 3;
    FGWeb m_web;
    boolean m_bOwnWeb;
    int m_state = -1;
    FGData m_data;
    FGString m_url = new FGString();
    FGPakReader m_pakReader;
    int m_fileNum;
    boolean m_bDisableFat = true;
    int m_errorType = 0;

    public void setFATDisable(boolean bl) {
        this.m_bDisableFat = bl;
    }

    public void init(FGWeb fGWeb) {
        if (fGWeb == null) {
            this.m_web = new FGWeb();
            this.m_web.init();
            this.m_bOwnWeb = true;
        } else {
            this.m_web = fGWeb;
            this.m_bOwnWeb = false;
        }
    }

    public void beginDownload(String string, FGData fGData) {
        if (this.m_state == 0 || this.m_state == 1) {
            FGEngine.fatal("attempt to begin a download when a download is already in progress");
            return;
        }
        this.m_url.set(string);
        this.m_web.getPage(string, fGData);
        this.m_data = fGData;
        this.m_state = 0;
        this.m_errorType = 0;
    }

    public int getState() {
        return this.m_state;
    }

    public int getError() {
        return this.m_errorType;
    }

    public int getProgress() {
        if (this.m_state == 0) {
            int n = this.m_web.getBytesRead();
            int n2 = this.m_web.getBytesToRead();
            if (n2 == 0) {
                return 0;
            }
            int n3 = n * 100 / n2;
            return n3;
        }
        if (this.m_state == 1) {
            if (this.m_pakReader.getNumFiles() == 0) {
                return 0;
            }
            int n = this.m_fileNum * 100 / this.m_pakReader.getNumFiles();
            return n;
        }
        return 0;
    }

    public void cancel() {
        if (this.m_web != null) {
            this.m_web.cancel();
            this.manageFATStatus();
            this.m_state = 4;
        }
    }

    public void releaseBuffer() {
        if (this.m_web != null) {
            this.m_web.releaseBuffer();
            this.m_data = null;
            this.m_pakReader = null;
        }
    }

    public void tick() {
        if (this.m_state == -1 || this.m_state == 3 || this.m_state == 4) {
            return;
        }
        if (this.m_web.getStatus() == 5) {
            this.manageFATStatus();
            this.m_state = 3;
            this.m_errorType = 1;
        }
        if (this.m_web.getStatus() == 7) {
            this.manageFATStatus();
            this.m_state = 4;
            this.m_errorType = 1;
        }
        if (this.m_state == 0) {
            if (this.m_web.getStatus() == 6) {
                this.m_pakReader = new FGPakReader();
                boolean bl = this.m_pakReader.init(this.m_data);
                if (!bl) {
                    System.out.println("failed to init pak reader");
                    this.m_state = 3;
                    this.m_errorType = 2;
                    return;
                }
                this.m_fileNum = 0;
                this.m_state = 1;
                if (this.m_bDisableFat) {
                    FGEngine.getEngine().getFileSystem().disableFATOutput();
                }
            }
        } else if (this.m_state == 1) {
            if (this.m_fileNum >= this.m_pakReader.getNumFiles()) {
                this.manageFATStatus();
                this.m_state = 2;
                return;
            }
            String string = this.m_pakReader.getFileName(this.m_fileNum).getNativeString();
            int n = this.m_pakReader.getFileStart(string);
            int n2 = this.m_pakReader.getFileLength(string);
            boolean bl = FGEngine.getEngine().getFileSystem().putFile(string, this.m_data, n, n2);
            if (!bl) {
                this.manageFATStatus();
                this.m_state = 3;
                this.m_errorType = 3;
            }
            ++this.m_fileNum;
        }
    }

    public void manageFATStatus() {
        if (this.m_state != 1) {
            return;
        }
        if (this.m_bDisableFat) {
            FGEngine.getEngine().getFileSystem().enableFATOutput();
        }
    }
}

