/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class FGEngine {
    public static final boolean OVERRIDE_SCREEN_SIZE = false;
    public static final int OVERRIDE_SCREEN_X = 176;
    public static final int OVERRIDE_SCREEN_Y = 220;
    public static final int NUM_KEYCODES = 23;
    public static final int AVK_1 = 49;
    public static final int AVK_2 = 50;
    public static final int AVK_3 = 51;
    public static final int AVK_4 = 52;
    public static final int AVK_5 = 53;
    public static final int AVK_6 = 54;
    public static final int AVK_7 = 55;
    public static final int AVK_8 = 56;
    public static final int AVK_9 = 57;
    public static final int AVK_0 = 48;
    public static final int AVK_STAR = 42;
    public static final int AVK_POUND = 35;
    public static final int AVK_LEFT = 2;
    public static final int AVK_RIGHT = 5;
    public static final int AVK_UP = 1;
    public static final int AVK_DOWN = 6;
    public int AVK_LEFT_SOFT;
    public int AVK_RIGHT_SOFT;
    public int AVK_FIRE;
    public int AVK_SEND;
    public int AVK_END;
    public int AVK_CLR;
    public int AVK_VOLUME_UP;
    public int AVK_VOLUME_DOWN;
    public int AVK_BACKSPACE;
    public int AVK_SONYQUIT;
    protected static final Object EXECUTION_MUTEX = new Object();
    public static String g_log = "";
    private static FGEngine g_engine;
    protected boolean[] m_bKeyStates = new boolean[23];
    protected boolean[] m_bKeysWereDown = new boolean[23];
    protected int[] m_keyIDs = new int[23];
    protected boolean m_bFailed = false;
    protected String m_failStr;
    public MidletScreen m_midletScreen;
    public boolean m_bDoRepaint = false;
    private int m_screenWidth = -1;
    private int m_screenHeight = -1;
    private int m_nextRandNum;
    long m_lastTickTime;
    long m_lastTickDuration;
    private FGFileSystem m_fileSystem = new FGFileSystem();
    private FGSoundManager m_soundManager = new FGSoundManager();
    private FGGraphics m_graphics = new FGGraphics();
    public boolean m_bExit;
    public FGString m_skuName = new FGString();
    boolean m_bOffscreen = false;
    Image m_offscreenImg = null;
    Graphics m_offscreenG = null;
    boolean m_bPaused = false;
    private FGPointerList m_timerRegistry = new FGPointerList();
    private boolean m_bWasPaused = false;
    private long m_pauseTime = 0L;

    public void init() {
    }

    public void onKeyPressed(int n) {
    }

    public void onKeyReleased(int n) {
    }

    public void onDrawSelf(FGGraphics fGGraphics) {
    }

    public void onTick() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onExitApp() {
    }

    public boolean isFullScreenApp() {
        return true;
    }

    public static FGEngine getEngine() {
        return g_engine;
    }

    public boolean isKeyDown(int n) {
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            return this.m_bKeyStates[i];
        }
        return false;
    }

    public boolean wasKeyDownSinceTick(int n) {
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            return this.m_bKeysWereDown[i];
        }
        return false;
    }

    public static void fatal(String string) {
        FGEngine fGEngine = FGEngine.getEngine();
        if (fGEngine.m_bFailed) {
            return;
        }
        fGEngine.m_failStr = string == null ? "Unspecified Fatal Error." : string;
        if (g_log.length() > 0) {
            fGEngine.m_failStr = fGEngine.m_failStr + ":";
            fGEngine.m_failStr = fGEngine.m_failStr + g_log;
        }
        fGEngine.m_bFailed = true;
        try {
            throw new RuntimeException("Fatal called: " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean hasFailed() {
        return this.m_bFailed;
    }

    public int getScreenWidth() {
        return this.m_screenWidth;
    }

    public int getScreenHeight() {
        return this.m_screenHeight;
    }

    public FGString getSku() {
        return this.m_skuName;
    }

    public void exitApp() {
        try {
            FGApp.g_app.destroyApp(true);
            FGApp.g_app.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    public int getTickTime() {
        return (int)this.m_lastTickDuration;
    }

    public void resetTickTimer() {
        this.m_lastTickTime = System.currentTimeMillis();
    }

    public int rand() {
        this.m_nextRandNum = this.m_nextRandNum * 1103515245 + 12345;
        int n = this.m_nextRandNum / 65536 % 32768;
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public void srand(int n) {
        this.m_nextRandNum = n;
    }

    public void srand() {
        this.srand((int)System.currentTimeMillis());
    }

    public FGFileSystem getFileSystem() {
        return this.m_fileSystem;
    }

    public FGSoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public FGPointerList getTimerRegistry() {
        if (this.m_timerRegistry == null) {
            this.m_timerRegistry = new FGPointerList();
        }
        return this.m_timerRegistry;
    }

    public FGEngine() {
        this.srand();
    }

    public void keyStateChange(int n, boolean bl) {
        if (!bl) {
            this.clearKeyStates();
            return;
        }
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            this.m_bKeyStates[i] = bl;
            if (!bl) continue;
            this.m_bKeysWereDown[i] = true;
        }
    }

    public void clearKeyStates() {
        for (int i = 0; i < 23; ++i) {
            this.m_bKeyStates[i] = false;
        }
    }

    public void clearKeyWasStates() {
        for (int i = 0; i < 23; ++i) {
            this.m_bKeysWereDown[i] = false;
        }
    }

    public void entInit() {
        g_engine = this;
        this.m_midletScreen = new MidletScreen();
        FGApp.g_app.m_display.setCurrent((Displayable)this.m_midletScreen);
        this.m_lastTickTime = System.currentTimeMillis();
        this.setUpForSku();
        this.m_keyIDs[0] = 49;
        this.m_keyIDs[1] = 50;
        this.m_keyIDs[2] = 51;
        this.m_keyIDs[3] = 52;
        this.m_keyIDs[4] = 53;
        this.m_keyIDs[5] = 54;
        this.m_keyIDs[6] = 55;
        this.m_keyIDs[7] = 56;
        this.m_keyIDs[8] = 57;
        this.m_keyIDs[9] = 48;
        this.m_keyIDs[10] = 42;
        this.m_keyIDs[11] = 35;
        this.m_keyIDs[12] = 2;
        this.m_keyIDs[13] = 5;
        this.m_keyIDs[14] = 1;
        this.m_keyIDs[15] = 6;
        this.m_keyIDs[16] = this.AVK_LEFT_SOFT;
        this.m_keyIDs[17] = this.AVK_RIGHT_SOFT;
        this.m_keyIDs[18] = this.AVK_FIRE;
        this.m_keyIDs[19] = this.AVK_VOLUME_UP;
        this.m_keyIDs[20] = this.AVK_VOLUME_DOWN;
        this.m_keyIDs[21] = this.AVK_BACKSPACE;
        this.m_keyIDs[22] = this.AVK_SONYQUIT;
        this.clearKeyStates();
        this.clearKeyWasStates();
        this.m_fileSystem.init();
        this.m_soundManager.init();
        this.init();
    }

    public String getProperty(String string) {
        String string2 = FGApp.g_app.getAppProperty(string);
        return string2;
    }

    private void setUpForSku() {
        this.AVK_LEFT_SOFT = -6;
        this.AVK_RIGHT_SOFT = -7;
        this.AVK_FIRE = -5;
        this.AVK_CLR = -8;
        this.AVK_VOLUME_UP = -36;
        this.AVK_VOLUME_DOWN = -37;
        this.AVK_BACKSPACE = -8;
        this.AVK_SONYQUIT = -11;
        this.AVK_SEND = -10;
        this.AVK_END = -11;
        this.m_bOffscreen = false;
        String string = FGApp.g_app.getAppProperty("FGFW_SKU");
        String string2 = FGApp.g_app.getAppProperty("FGFW_LSK");
        String string3 = FGApp.g_app.getAppProperty("FGFW_RSK");
        String string4 = FGApp.g_app.getAppProperty("FGFW_FIRE");
        String string5 = FGApp.g_app.getAppProperty("FGFW_CLR");
        String string6 = FGApp.g_app.getAppProperty("FGFW_SEND");
        String string7 = FGApp.g_app.getAppProperty("FGFW_END");
        String string8 = FGApp.g_app.getAppProperty("FGFW_WIDTH");
        String string9 = FGApp.g_app.getAppProperty("FGFW_HEIGHT");
        String string10 = FGApp.g_app.getAppProperty("FGFW_FULLSCREEN");
        String string11 = FGApp.g_app.getAppProperty("FGFW_OFFSCREEN");
        if (string != null) {
            this.m_skuName.set(string);
        }
        if (string2 != null) {
            this.AVK_LEFT_SOFT = Integer.parseInt(string2);
        }
        if (string3 != null) {
            this.AVK_RIGHT_SOFT = Integer.parseInt(string3);
        }
        if (string4 != null) {
            this.AVK_FIRE = Integer.parseInt(string4);
        }
        if (string5 != null) {
            this.AVK_CLR = Integer.parseInt(string5);
        }
        if (string6 != null) {
            this.AVK_SEND = Integer.parseInt(string6);
        }
        if (string7 != null) {
            this.AVK_END = Integer.parseInt(string7);
        }
        if (string8 != null) {
            this.m_screenWidth = Integer.parseInt(string8);
        }
        if (string9 != null) {
            this.m_screenHeight = Integer.parseInt(string9);
        }
        if (string10 != null && string10.equals("false")) {
            this.m_midletScreen.setFullScreenMode(false);
        }
        if (string11 != null && string11.equals("true")) {
            this.m_bOffscreen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entPaint(Graphics graphics) {
        if (this.m_bPaused) {
            return;
        }
        if (this.m_bWasPaused) {
            return;
        }
        if (!this.m_bDoRepaint) {
            return;
        }
        if (this.hasFailed()) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getScreenWidth(), this.m_screenHeight);
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            Graphics graphics2 = graphics;
            if (this.m_bOffscreen) {
                if (this.m_offscreenG == null || this.m_offscreenImg == null) {
                    this.m_offscreenImg = Image.createImage((int)this.m_screenWidth, (int)this.m_screenHeight);
                    this.m_offscreenG = this.m_offscreenImg.getGraphics();
                }
                graphics2 = this.m_offscreenG;
            }
            graphics2.setClip(0, 0, this.m_screenWidth, this.m_screenHeight);
            this.m_graphics.setGraphics(graphics2);
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glDrawSelf(this.m_graphics);
            } else {
                this.onDrawSelf(this.m_graphics);
            }
            if (this.m_bOffscreen) {
                graphics.drawImage(this.m_offscreenImg, 0, 0, 20);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entKeyPressed(int n) {
        if (this.m_bPaused) {
            return;
        }
        if (n == this.AVK_SEND || n == this.AVK_END) {
            return;
        }
        if (n == 0) {
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            if (this.hasFailed()) {
                this.exitApp();
                return;
            }
            this.keyStateChange(n, true);
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glKeyPressed(n);
            } else {
                this.onKeyPressed(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entKeyReleased(int n) {
        if (this.m_bPaused) {
            return;
        }
        if (n == this.AVK_SEND || n == this.AVK_END) {
            return;
        }
        if (n == 0) {
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            this.keyStateChange(n, false);
            this.onKeyReleased(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entTick() {
        if (this.m_bPaused) {
            return;
        }
        if (this.m_bWasPaused) {
            this.clearKeyStates();
            this.clearKeyWasStates();
            long l = System.currentTimeMillis();
            int n = (int)(l - this.m_pauseTime);
            for (int i = 0; i < this.m_timerRegistry.getNumPointers(); ++i) {
                FGTimer fGTimer = (FGTimer)this.m_timerRegistry.getPointer(i);
                if (fGTimer.isPaused()) continue;
                fGTimer.advance(-n);
            }
            this.m_bWasPaused = false;
            this.onResume();
        }
        if (this.hasFailed()) {
            this.showFatalAlert();
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            this.m_lastTickDuration = System.currentTimeMillis() - this.m_lastTickTime;
            if (this.m_lastTickDuration <= 0L) {
                return;
            }
            this.resetTickTimer();
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glTick();
            } else {
                this.onTick();
            }
            this.clearKeyWasStates();
        }
    }

    public void entPause() {
        if (this.m_bPaused) {
            return;
        }
        this.m_bPaused = true;
        this.m_bWasPaused = true;
        this.m_pauseTime = System.currentTimeMillis();
        this.onPause();
    }

    public void entResume() {
        if (!this.m_bPaused) {
            return;
        }
        this.m_bPaused = false;
        this.resetTickTimer();
    }

    public void entExitApp() {
        this.m_bExit = true;
        this.onExitApp();
        this.m_soundManager.shutDown();
    }

    public void entExitAppQuiet() {
        this.m_bExit = true;
        this.m_soundManager.shutDown();
        this.m_soundManager = null;
    }

    public void showFatalAlert() {
        Alert alert = new Alert("Fatal");
        alert.setString(this.m_failStr);
        alert.setTimeout(-2);
        FGApp.g_app.m_display.setCurrent((Displayable)alert);
        boolean bl = true;
        while (bl) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void setAlternateHeapSize(int n) {
    }

    public boolean isUsingAlternateHeap() {
        return false;
    }

    public void useAlternateHeap(boolean bl) {
    }

    class MidletScreen
    extends Canvas {
        public MidletScreen() {
            if (FGEngine.this.isFullScreenApp()) {
                this.setFullScreenMode(true);
            }
            if (FGEngine.this.m_screenWidth == -1) {
                FGEngine.this.m_screenWidth = this.getWidth();
                FGEngine.this.m_screenHeight = this.getHeight();
            }
        }

        protected void sizeChanged(int n, int n2) {
            FGEngine.this.m_screenWidth = n;
            FGEngine.this.m_screenHeight = n2;
        }

        public void paint(Graphics graphics) {
            try {
                FGEngine.this.entPaint(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        protected void keyPressed(int n) {
            int n2 = 0;
            try {
                n2 = this.getGameAction(n);
            }
            catch (Exception exception) {
                return;
            }
            try {
                FGEngine.this.entKeyPressed(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        protected void keyReleased(int n) {
            int n2 = 0;
            try {
                n2 = this.getGameAction(n);
            }
            catch (Exception exception) {
                return;
            }
            try {
                FGEngine.this.entKeyReleased(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public void hideNotify() {
            try {
                if (!FGApp.g_app.isPaused()) {
                    FGApp.g_app.pauseApp();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public void showNotify() {
            try {
                if (FGApp.g_app.isPaused() && FGApp.g_app.appWasStarted()) {
                    FGApp.g_app.startApp();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public int getGameAction(int n) {
            for (int i = 0; i < 23; ++i) {
                if (FGEngine.this.m_keyIDs[i] != n) continue;
                return n;
            }
            return super.getGameAction(n);
        }
    }
}

