/*
 * Decompiled with CFR 0.152.
 */
class FGLayout {
    public static final boolean VERBOSE = true;
    public int m_numElements;
    public int m_backgroundColor;
    public int m_width;
    public int m_height;
    public int[] m_xValues;
    public int[] m_solidColorValue;
    public int[] m_yValues;
    public boolean[] m_bTileables;
    public int[] m_widths;
    public int[] m_heights;
    private int[] m_filenameIDs;
    private int[] m_IDStringIDs;
    public FGImage[] m_images;
    public FGPointerList m_strings;
    public boolean[] m_bNotes;

    public boolean init(String string) {
        int n;
        FGData fGData = FGEngine.getEngine().getFileSystem().getFile(string);
        if (fGData == null) {
            FGString fGString = new FGString();
            fGString.set("Could not load layout file: ");
            fGString.add(string);
            FGEngine.fatal(fGString.getNativeString());
            return false;
        }
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        FGData fGData2 = new FGData();
        fGData2.init(5);
        for (int i = 0; i < 5; ++i) {
            fGData2.m_data[i] = fGDataReader.readByte();
        }
        fGData2.m_dataLength = 5;
        FGString fGString = new FGString();
        fGString.set(fGData2);
        if (!fGString.equals("FGLYT")) {
            return false;
        }
        int n2 = fGDataReader.readInt();
        if (n2 != 3) {
            FGString fGString2 = new FGString();
            fGString2.set("Invalid version of layout file: ");
            fGString2.add(string);
            FGEngine.fatal(fGString2.getNativeString());
            return false;
        }
        int n3 = fGDataReader.readInt();
        int n4 = fGDataReader.readInt();
        int n5 = fGDataReader.readInt();
        int n6 = fGDataReader.readInt();
        this.m_strings = new FGPointerList(16, 8);
        for (n = 0; n < n6; ++n) {
            FGString fGString3 = fGDataReader.readUTF();
            this.noteString(fGString3.getNativeString());
        }
        n = fGDataReader.readInt();
        this.internalInit(n, n5, n3, n4);
        for (int i = 0; i < this.m_numElements; ++i) {
            int n7 = fGDataReader.readInt();
            int n8 = fGDataReader.readInt();
            int n9 = fGDataReader.readInt();
            int n10 = fGDataReader.readInt();
            boolean bl = fGDataReader.readBoolean();
            int n11 = fGDataReader.readInt();
            int n12 = fGDataReader.readInt();
            this.setImage(i, n9, n10, bl, n11, n12, n7, n8, false);
        }
        return true;
    }

    public void registerNoteName(String string) {
        int n = this.getStringTableID(string);
        if (n == -1) {
            return;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.m_IDStringIDs[i] != n) continue;
            this.m_bNotes[i] = true;
        }
    }

    public void registerNeededImages(FGResLoader fGResLoader) {
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.isNote(i) || this.m_solidColorValue[i] != 0xFF00FF) continue;
            fGResLoader.registerImage(this.getElementName(i));
        }
    }

    public void getNeededImages(FGResLoader fGResLoader) {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = this.isNote(i) || this.m_solidColorValue[i] != 0xFF00FF ? null : fGResLoader.getImage(this.getElementName(i));
        }
    }

    public void releaseImages() {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = null;
        }
    }

    public void drawImageAt(FGGraphics fGGraphics, FGImage fGImage, String string, int n, int n2) {
        int n3 = this.getFirstIdx(string);
        if (n3 == -1) {
            return;
        }
        fGImage.drawSelf(fGGraphics, this.m_xValues[n3] + n, this.m_yValues[n3] + n2);
    }

    public void drawTextIn(FGGraphics fGGraphics, FGFont fGFont, String string, String string2, int n, int n2) {
        int n3 = this.getFirstIdx(string2);
        if (n3 == -1) {
            return;
        }
        int n4 = this.m_xValues[n3] + n;
        int n5 = this.m_yValues[n3] + n2;
        int n6 = this.m_widths[n3];
        int n7 = fGFont.getDisplayHeight(string, n6);
        fGFont.drawText(fGGraphics, string, n4, n5 += (this.m_heights[n3] - n7) / 2, n6);
    }

    public void drawSelf(FGGraphics fGGraphics, int n, int n2) {
        int n3 = fGGraphics.getClipX();
        int n4 = fGGraphics.getClipY();
        int n5 = fGGraphics.getClipWidth();
        int n6 = fGGraphics.getClipHeight();
        fGGraphics.setClip(n, n2, this.m_width, this.m_height);
        if (this.m_backgroundColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_backgroundColor);
            fGGraphics.fillRect(n, n2, this.m_width, this.m_height);
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.isNote(i)) continue;
            int n7 = n + this.m_xValues[i];
            int n8 = n2 + this.m_yValues[i];
            if (this.m_solidColorValue[i] != 0xFF00FF) {
                fGGraphics.setColor(this.m_solidColorValue[i]);
                fGGraphics.fillRect(n7, n8, this.m_widths[i], this.m_heights[i]);
                continue;
            }
            if (this.m_bTileables[i]) {
                this.m_images[i].drawTiled(fGGraphics, n7, n8, this.m_widths[i], this.m_heights[i]);
                continue;
            }
            this.m_images[i].drawSelf(fGGraphics, n7, n8);
        }
        fGGraphics.setClip(n3, n4, n5, n6);
    }

    public int getFirstIdx(String string) {
        int n = this.getStringTableID(string);
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.m_IDStringIDs[i] != n) continue;
            return i;
        }
        return -1;
    }

    int getWidth() {
        return this.m_width;
    }

    int getHeight() {
        return this.m_height;
    }

    int getNumElements() {
        return this.m_numElements;
    }

    int getElementX(int n) {
        return this.m_xValues[n];
    }

    int getElementY(int n) {
        return this.m_yValues[n];
    }

    int getElementWidth(int n) {
        return this.m_widths[n];
    }

    int getElementHeight(int n) {
        return this.m_heights[n];
    }

    String getElementName(int n) {
        return this.getString(this.m_filenameIDs[n]);
    }

    String getElementIDString(int n) {
        return this.getString(this.m_IDStringIDs[n]);
    }

    public boolean isNote(int n) {
        return this.m_bNotes[n];
    }

    public void setNote(int n, boolean bl) {
        this.m_bNotes[n] = bl;
    }

    public int getElementX(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementX(n);
    }

    public int getElementY(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementY(n);
    }

    public int getElementWidth(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementWidth(n);
    }

    public int getElementHeight(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementHeight(n);
    }

    public FGImage getElementImage(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return null;
        }
        return this.m_images[n];
    }

    public boolean initManual(int n, int n2, int n3, int n4) {
        this.m_strings = new FGPointerList(16, 8);
        return this.internalInit(n, n2, n3, n4);
    }

    private boolean internalInit(int n, int n2, int n3, int n4) {
        this.m_width = n3;
        this.m_height = n4;
        this.m_backgroundColor = n2;
        this.m_numElements = n;
        this.m_xValues = new int[this.m_numElements];
        this.m_yValues = new int[this.m_numElements];
        this.m_bTileables = new boolean[this.m_numElements];
        this.m_widths = new int[this.m_numElements];
        this.m_heights = new int[this.m_numElements];
        this.m_filenameIDs = new int[this.m_numElements];
        this.m_IDStringIDs = new int[this.m_numElements];
        this.m_images = new FGImage[this.m_numElements];
        this.m_bNotes = new boolean[this.m_numElements];
        this.m_solidColorValue = new int[this.m_numElements];
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_solidColorValue[i] = 0xFF00FF;
        }
        return true;
    }

    public void setImage(int n, int n2, int n3, boolean bl, int n4, int n5, String string, String string2, boolean bl2) {
        int n6 = this.noteString(string);
        int n7 = this.noteString(string2);
        this.setImage(n, n2, n3, bl, n4, n5, n6, n7, bl2);
    }

    public void setImage(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, boolean bl2) {
        this.m_xValues[n] = n2;
        this.m_yValues[n] = n3;
        this.m_bTileables[n] = bl;
        this.m_widths[n] = n4;
        this.m_heights[n] = n5;
        this.m_filenameIDs[n] = n6;
        this.m_IDStringIDs[n] = n7;
        this.m_bNotes[n] = bl2;
        FGString fGString = new FGString(this.getElementName(n));
        if (fGString.startsWith("0x")) {
            FGString fGString2 = fGString.substring(2);
            this.m_solidColorValue[n] = fGString2.toIntFromHex();
        }
    }

    private int noteString(String string) {
        for (int i = 0; i < this.m_strings.getNumPointers(); ++i) {
            FGString fGString = (FGString)this.m_strings.getPointer(i);
            if (!fGString.equals(string)) continue;
            return i;
        }
        FGString fGString = new FGString(string);
        this.m_strings.addPointer(fGString);
        return this.m_strings.getNumPointers() - 1;
    }

    private String getString(int n) {
        FGString fGString = (FGString)this.m_strings.getPointer(n);
        return fGString.getNativeString();
    }

    private int getStringTableID(String string) {
        for (int i = 0; i < this.m_strings.getNumPointers(); ++i) {
            FGString fGString = (FGString)this.m_strings.getPointer(i);
            if (!fGString.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void clearArt() {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = null;
        }
    }
}

