/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.Resources;
import com.tqm.fantasydefense.shop.AbstractShop;
import com.tqm.fantasydefense.shop.secret.SecretCastleDefender;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class ShopCastleCatapults
extends AbstractShop {
    private Sprite catapultSprite;
    private Sprite ballistaSprite;
    private Sprite cannonSprite;
    private Sprite specialitiesSprite;
    private Sprite statisticsIconSprite;
    private Sprite statisticsLineSprite;
    private Image statisticsImage;
    private SecretCastleDefender[] catapults;
    private boolean questionMode;
    private int itemDescWidth;
    private int itemDescHeight;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;

    public ShopCastleCatapults(SecretCastleDefender[] catapults) {
        this.catapults = catapults;
        this.questionMode = false;
    }

    protected final void loadSprites() {
        this.catapultSprite = GameLogic.loadSprite(50);
        this.ballistaSprite = GameLogic.loadSprite(44);
        this.cannonSprite = GameLogic.loadSprite(37);
        this.specialitiesSprite = GameLogic.loadSprite(111);
        this.statisticsIconSprite = GameLogic.loadSprite(134);
        this.statisticsLineSprite = GameLogic.loadSprite(118);
        try {
            this.statisticsImage = Image.createImage((String)("/com/tqm/fantasydefense/" + Resources.imgNames[116] + ".png"));
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    protected final void setSpritesPositions() {
        int n = this.catapultSprite.getWidth() / 3;
        int n2 = ShopCastleCatapults.getFirstRackItemX(n, new Sprite[]{this.catapultSprite, this.ballistaSprite, this.cannonSprite});
        this.catapultSprite.setPosition(n2, ShopCastleCatapults.getRackItemY(this.catapultSprite));
        this.ballistaSprite.setPosition(ShopCastleCatapults.getRackItemX(this.catapultSprite, n), ShopCastleCatapults.getRackItemY(this.ballistaSprite));
        this.cannonSprite.setPosition(ShopCastleCatapults.getRackItemX(this.ballistaSprite, n), ShopCastleCatapults.getRackItemY(this.cannonSprite));
        n = ShopCastleCatapults.getFramedPaper().getY() + ShopCastleCatapults.getFramedPaper().getLowFrameHeight() - this.statisticsLineSprite.getHeight() * 5 / 2;
        n2 = n + this.statisticsLineSprite.getHeight() / 2 - this.statisticsIconSprite.getHeight() / 2;
        this.statisticsIconSprite.setPosition(ShopCastleCatapults.getFramedPaper().getPaperX() + ShopCastleCatapults.getFramedPaper().getHorizontalPaperMargin(), n2);
        this.statisticsLineSprite.setPosition(ShopCastleCatapults.getFramedPaper().getPaperX() + 2 * ShopCastleCatapults.getFramedPaper().getHorizontalPaperMargin() + this.statisticsIconSprite.getWidth(), n);
        n = ShopCastleCatapults.getItemDesc().getX() + ShopCastleCatapults.getItemDesc().getWidth() - (this.specialitiesSprite.getWidth() << 1);
        this.specialitiesSprite.setPosition(n, ShopCastleCatapults.getTitleStressY() - this.specialitiesSprite.getHeight() - 2);
    }

    protected final void initOthersShopData() {
        ShopCastleCatapults.setFramedPaperDefaultPosition();
        int filledPaperHeight22 = ShopCastleCatapults.getItemDesc().getY() + ShopCastleCatapults.getItemDesc().getHeight() - this.statisticsIconSprite.getY();
        this.itemDescWidth = ShopCastleCatapults.getItemDesc().getWidth();
        this.itemDescHeight = ShopCastleCatapults.getItemDesc().getHeight() - filledPaperHeight22 - ShopCastleCatapults.getFramedPaper().getVerticalPaperMargin();
        ShopCastleCatapults filledPaperHeight22 = this;
        ShopCastleCatapults.getItemDesc().setSize(filledPaperHeight22.itemDescWidth, filledPaperHeight22.itemDescHeight);
        this.setSelectionDesc();
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(50);
        MainLogic.disposeImage(44);
        MainLogic.disposeImage(37);
        MainLogic.disposeImage(39);
        MainLogic.disposeImage(82);
        MainLogic.disposeImage(134);
        MainLogic.disposeImage(118);
        MainLogic.disposeImage(116);
        this.catapultSprite = null;
        this.ballistaSprite = null;
        this.cannonSprite = null;
        this.specialitiesSprite = null;
        this.statisticsIconSprite = null;
        this.statisticsLineSprite = null;
        this.statisticsImage = null;
    }

    protected final void drawShopItems(Graphics g) {
        this.setSelectionMark(0, this.catapultSprite);
        this.catapultSprite.paint(g);
        this.setSelectionMark(1, this.ballistaSprite);
        this.ballistaSprite.paint(g);
        this.setSelectionMark(2, this.cannonSprite);
        this.cannonSprite.paint(g);
        Graphics graphics = g;
        ShopCastleCatapults shopCastleCatapults = this;
        ShopCastleCatapults.drawUnlockState(graphics, shopCastleCatapults.catapultSprite, shopCastleCatapults.catapults[0]);
        ShopCastleCatapults.drawUnlockState(graphics, shopCastleCatapults.ballistaSprite, shopCastleCatapults.catapults[1]);
        ShopCastleCatapults.drawUnlockState(graphics, shopCastleCatapults.cannonSprite, shopCastleCatapults.catapults[2]);
        graphics = g;
        shopCastleCatapults = this;
        ShopCastleCatapults.drawActiveState(graphics, shopCastleCatapults.catapultSprite, shopCastleCatapults.catapults[0]);
        ShopCastleCatapults.drawActiveState(graphics, shopCastleCatapults.ballistaSprite, shopCastleCatapults.catapults[1]);
        ShopCastleCatapults.drawActiveState(graphics, shopCastleCatapults.cannonSprite, shopCastleCatapults.catapults[2]);
    }

    protected final void drawShopItemDesc(Graphics graphics) {
        if (this.questionMode) {
            ShopCastleCatapults.drawItemDesc(graphics);
            return;
        }
        ShopCastleCatapults.drawShopItemDescWithPrice(graphics, this.catapults[this.getCurrRackItem()]);
        Graphics graphics2 = graphics;
        ShopCastleCatapults shopCastleCatapults = this;
        shopCastleCatapults.statisticsIconSprite.paint(graphics2);
        shopCastleCatapults.statisticsLineSprite.paint(graphics2);
        int n = 0;
        switch (shopCastleCatapults.getCurrRackItem()) {
            case 0: {
                n = shopCastleCatapults.catapults[shopCastleCatapults.getCurrRackItem()].getPower();
                break;
            }
            case 1: {
                n = shopCastleCatapults.catapults[shopCastleCatapults.getCurrRackItem()].getPower();
                break;
            }
            case 2: {
                n = shopCastleCatapults.catapults[shopCastleCatapults.getCurrRackItem()].getPower();
            }
        }
        graphics2.drawRegion(shopCastleCatapults.statisticsImage, 0, shopCastleCatapults.statisticsImage.getHeight() / 2, shopCastleCatapults.statisticsImage.getWidth() * n / 40, shopCastleCatapults.statisticsImage.getHeight() / 2, 0, shopCastleCatapults.statisticsLineSprite.getX() + (shopCastleCatapults.statisticsLineSprite.getWidth() - shopCastleCatapults.statisticsImage.getWidth()) / 2, shopCastleCatapults.statisticsLineSprite.getY() + (shopCastleCatapults.statisticsLineSprite.getHeight() - shopCastleCatapults.statisticsImage.getHeight() / 2) / 2, 20);
        int n2 = this.catapults[this.getCurrRackItem()].getSpecialSkill();
        if (n2 != -1) {
            this.clipX = graphics.getClipX();
            this.clipY = graphics.getClipY();
            this.clipWidth = graphics.getClipWidth();
            this.clipHeight = graphics.getClipHeight();
            if (ShopCastleCatapults.getItemDesc().getTransY() < 0) {
                graphics.setClip(this.specialitiesSprite.getX(), ShopCastleCatapults.getItemDesc().getY(), this.specialitiesSprite.getWidth(), ShopCastleCatapults.getTitleStressY() - ShopCastleCatapults.getFramedPaper().getPaperY());
            }
            this.specialitiesSprite.setPosition(this.specialitiesSprite.getX(), ShopCastleCatapults.getTitleStressY() - this.specialitiesSprite.getHeight() - 2 + ShopCastleCatapults.getItemDesc().getTransY());
            this.specialitiesSprite.setFrame(n2);
            this.specialitiesSprite.paint(graphics);
            graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
    }

    protected final void onEnterKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setSelectionDesc();
            return;
        }
        if (this.getCurrRackItem() == 0 || this.catapults[this.getCurrRackItem() - 1].isUnlocked()) {
            this.onEnterForBuyKeyPressed(this.catapults[this.getCurrRackItem()]);
            return;
        }
        this.questionMode = true;
        ShopCastleCatapults.setDescTextWithTitle(MainLogic.strings[302], MainLogic.strings[198]);
    }

    protected final void onBackKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setSelectionDesc();
            return;
        }
        this.onBackForBuyKeyPressed$255f299(243);
    }

    protected final void onOthersKeyPressed(int key) {
        if (!this.questionMode) {
            this.onLeftAndRightKeyPressed(key, 3);
        }
    }

    protected final void setSelectionDesc() {
        switch (this.getCurrRackItem()) {
            case 0: {
                ShopCastleCatapults.setDescTextWithTitle(MainLogic.strings[195], MainLogic.strings[192]);
                break;
            }
            case 1: {
                ShopCastleCatapults.setDescTextWithTitle(MainLogic.strings[196], MainLogic.strings[193]);
                break;
            }
            case 2: {
                ShopCastleCatapults.setDescTextWithTitle(MainLogic.strings[197], MainLogic.strings[194]);
            }
        }
        ShopCastleCatapults.setPriceCrystalPosition(this.catapults[this.getCurrRackItem()].getPrice());
    }
}

