/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.Resources;
import com.tqm.fantasydefense.shop.AbstractShop;
import com.tqm.fantasydefense.shop.secret.SecretDefenceUnit;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class ShopDefenceUnits
extends AbstractShop {
    private Sprite elfSprite;
    private Sprite paladinSprite;
    private Sprite warlockSprite;
    private Sprite elfSelectionSprite;
    private Sprite paladinSelectionSprite;
    private Sprite warlockSelectionSprite;
    private Sprite statisticsIconsSprite;
    private Image statisticsImage;
    private Sprite statisticsLineSprite;
    private Sprite specialitiesSprite;
    private Sprite specialityWindowSprite;
    private SecretDefenceUnit[] defenceUnits;
    private int statisticsIconsX;
    private int statisticsIconsY;
    private int statisticsLineX;
    private int statisticsLineY;

    public ShopDefenceUnits(SecretDefenceUnit[] defenceUnits) {
        this.defenceUnits = defenceUnits;
    }

    protected final void loadSprites() {
        this.elfSprite = GameLogic.loadSprite(154);
        this.paladinSprite = GameLogic.loadSprite(150);
        this.warlockSprite = GameLogic.loadSprite(148);
        this.elfSelectionSprite = GameLogic.loadSprite(46);
        this.paladinSelectionSprite = GameLogic.loadSprite(47);
        this.warlockSelectionSprite = GameLogic.loadSprite(62);
        this.statisticsIconsSprite = GameLogic.loadSprite(230);
        this.statisticsLineSprite = GameLogic.loadSprite(118);
        this.specialitiesSprite = GameLogic.loadSprite(39);
        this.specialityWindowSprite = GameLogic.loadSprite(82);
        try {
            this.statisticsImage = Image.createImage((String)("/com/tqm/fantasydefense/" + Resources.imgNames[116] + ".png"));
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    protected final void setSpritesPositions() {
        int n = ShopDefenceUnits.getFirstRackItemX(0, new Sprite[]{this.elfSprite, this.paladinSprite, this.warlockSprite});
        this.elfSprite.setPosition(n, ShopDefenceUnits.getRackItemY(this.elfSprite));
        this.paladinSprite.setFrame(1);
        this.paladinSprite.setPosition(ShopDefenceUnits.getRackItemX(this.elfSprite, 0), ShopDefenceUnits.getRackItemY(this.paladinSprite));
        this.warlockSprite.setPosition(ShopDefenceUnits.getRackItemX(this.paladinSprite, 0), ShopDefenceUnits.getRackItemY(this.warlockSprite));
        this.elfSelectionSprite.setPosition(ShopDefenceUnits.getSelectionX(this.elfSprite, this.elfSelectionSprite) - this.elfSprite.getWidth() / 60, ShopDefenceUnits.getSelectionY(this.elfSprite, this.elfSelectionSprite));
        this.paladinSelectionSprite.setPosition(ShopDefenceUnits.getSelectionX(this.paladinSprite, this.paladinSelectionSprite) + this.paladinSprite.getWidth() / 20, ShopDefenceUnits.getSelectionY(this.paladinSprite, this.paladinSelectionSprite) + this.paladinSprite.getHeight() / 36);
        this.warlockSelectionSprite.setPosition(ShopDefenceUnits.getSelectionX(this.warlockSprite, this.warlockSelectionSprite) + this.warlockSprite.getWidth() / 68, ShopDefenceUnits.getSelectionY(this.warlockSprite, this.warlockSelectionSprite) + this.warlockSprite.getHeight() / 9);
        ShopDefenceUnits.setFramedPaperDefaultPosition();
        this.statisticsIconsX = ShopDefenceUnits.getFramedPaper().getPaperX() + ShopDefenceUnits.getFramedPaper().getHorizontalPaperMargin();
        n = ShopDefenceUnits.getFramedPaper().getLowPaperHeight() - (ShopDefenceUnits.getTitleStressY() - ShopDefenceUnits.getFramedPaper().getPaperY());
        this.statisticsIconsY = ShopDefenceUnits.getTitleStressY() + (n - this.statisticsIconsSprite.getFrameSequenceLength() * this.statisticsIconsSprite.getHeight()) / 2;
        this.statisticsLineX = this.statisticsIconsX + this.statisticsIconsSprite.getWidth() + ShopDefenceUnits.getFramedPaper().getHorizontalPaperMargin();
        this.statisticsLineY = this.statisticsIconsY + (this.statisticsIconsSprite.getHeight() - this.statisticsLineSprite.getHeight()) / 2;
        n = this.statisticsLineX + this.statisticsLineSprite.getWidth() + (ShopDefenceUnits.getFramedPaper().getPaperX() + ShopDefenceUnits.getFramedPaper().getWidePaperWidth() - (this.statisticsLineX + this.statisticsLineSprite.getWidth()) - this.specialityWindowSprite.getWidth()) / 2;
        int n2 = ShopDefenceUnits.getFramedPaper().getY() + ShopDefenceUnits.getFramedPaper().getLowFrameHeight() - ShopDefenceUnits.getTitleStressY();
        int n3 = (ShopDefenceUnits.getFramedPaper().getLowFrameHeight() - ShopDefenceUnits.getFramedPaper().getLowPaperHeight()) / 2;
        n2 -= n3;
        n3 = ShopDefenceUnits.getTitleStressY() + (n2 - this.specialityWindowSprite.getHeight()) / 2;
        int n4 = ShopDefenceUnits.getTitleStressY() + n2 - ShopDefenceUnits.getPriceSprite().getY();
        if (n4 > 0) {
            n3 = ShopDefenceUnits.getTitleStressY() + (n2 - n4 - this.specialityWindowSprite.getHeight()) / 2;
        }
        this.specialityWindowSprite.setPosition(n, n3);
        n = this.specialityWindowSprite.getX() + (this.specialityWindowSprite.getWidth() - this.specialitiesSprite.getWidth()) * 10 / 16;
        n2 = this.specialityWindowSprite.getY() + (this.specialityWindowSprite.getHeight() - this.specialitiesSprite.getHeight()) * 9 / 16;
        this.specialitiesSprite.setPosition(n, n2);
    }

    private static int getSelectionX(Sprite sprite, Sprite sprite2) {
        int n = sprite2.getWidth();
        int n2 = sprite.getWidth();
        return sprite.getX() - (n - n2) / 2;
    }

    private static int getSelectionY(Sprite sprite, Sprite sprite2) {
        int n = sprite2.getHeight();
        int n2 = sprite.getHeight();
        return sprite.getY() - (n - n2) / 2;
    }

    protected final void initOthersShopData() {
        this.setSelectionDesc();
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(154);
        MainLogic.disposeImage(150);
        MainLogic.disposeImage(148);
        MainLogic.disposeImage(46);
        MainLogic.disposeImage(47);
        MainLogic.disposeImage(62);
        MainLogic.disposeImage(230);
        MainLogic.disposeImage(118);
        MainLogic.disposeImage(39);
        MainLogic.disposeImage(82);
        this.elfSprite = null;
        this.paladinSprite = null;
        this.warlockSprite = null;
        this.elfSelectionSprite = null;
        this.paladinSelectionSprite = null;
        this.warlockSelectionSprite = null;
        this.statisticsIconsSprite = null;
        this.statisticsLineSprite = null;
        this.statisticsImage = null;
        this.specialitiesSprite = null;
        this.specialityWindowSprite = null;
    }

    protected final void drawShopItems(Graphics g) {
        Graphics graphics = g;
        ShopDefenceUnits shopDefenceUnits = this;
        switch (shopDefenceUnits.getCurrRackItem()) {
            case 0: {
                shopDefenceUnits.elfSelectionSprite.paint(graphics);
                break;
            }
            case 1: {
                shopDefenceUnits.paladinSelectionSprite.paint(graphics);
                break;
            }
            case 2: {
                shopDefenceUnits.warlockSelectionSprite.paint(graphics);
            }
        }
        this.elfSprite.paint(g);
        this.paladinSprite.paint(g);
        this.warlockSprite.paint(g);
        graphics = g;
        shopDefenceUnits = this;
        ShopDefenceUnits.drawUnlockState(graphics, shopDefenceUnits.elfSprite, shopDefenceUnits.defenceUnits[0]);
        ShopDefenceUnits.drawUnlockState(graphics, shopDefenceUnits.paladinSprite, shopDefenceUnits.defenceUnits[1]);
        ShopDefenceUnits.drawUnlockState(graphics, shopDefenceUnits.warlockSprite, shopDefenceUnits.defenceUnits[2]);
        graphics = g;
        shopDefenceUnits = this;
        ShopDefenceUnits.drawActiveState(graphics, shopDefenceUnits.elfSprite, shopDefenceUnits.defenceUnits[0]);
        ShopDefenceUnits.drawActiveState(graphics, shopDefenceUnits.paladinSprite, shopDefenceUnits.defenceUnits[1]);
        ShopDefenceUnits.drawActiveState(graphics, shopDefenceUnits.warlockSprite, shopDefenceUnits.defenceUnits[2]);
    }

    protected final void drawShopItemDesc(Graphics graphics) {
        ShopDefenceUnits.drawShopItemDescWithPrice(graphics, this.defenceUnits[this.getCurrRackItem()]);
        block6: for (int i = 0; i < this.statisticsIconsSprite.getFrameSequenceLength(); ++i) {
            this.statisticsIconsSprite.setFrame(i);
            this.statisticsIconsSprite.setPosition(this.statisticsIconsX, this.statisticsIconsY + i * this.statisticsIconsSprite.getHeight());
            this.statisticsIconsSprite.paint(graphics);
            this.statisticsLineSprite.setPosition(this.statisticsLineX, this.statisticsLineY + i * this.statisticsIconsSprite.getHeight());
            this.statisticsLineSprite.paint(graphics);
            int n = i;
            Graphics graphics2 = graphics;
            ShopDefenceUnits shopDefenceUnits = this;
            switch (n) {
                case 0: {
                    shopDefenceUnits.drawStatistic(graphics2, shopDefenceUnits.defenceUnits[shopDefenceUnits.getCurrRackItem()].getGroundInjury(), 50);
                    continue block6;
                }
                case 1: {
                    shopDefenceUnits.drawStatistic(graphics2, shopDefenceUnits.defenceUnits[shopDefenceUnits.getCurrRackItem()].getAirInjury(), 50);
                    continue block6;
                }
                case 2: {
                    shopDefenceUnits.drawStatistic(graphics2, shopDefenceUnits.defenceUnits[shopDefenceUnits.getCurrRackItem()].getRange(), 84);
                    continue block6;
                }
                case 3: {
                    shopDefenceUnits.drawStatistic(graphics2, 36 - shopDefenceUnits.defenceUnits[shopDefenceUnits.getCurrRackItem()].getAttackSpeed(), 36);
                }
            }
        }
        this.specialityWindowSprite.paint(graphics);
        this.specialitiesSprite.setFrame(this.defenceUnits[this.getCurrRackItem()].getSpecialSkill());
        this.specialitiesSprite.paint(graphics);
    }

    private void drawStatistic(Graphics g, int defenceUnitStat, int defenceUnitMaxStat) {
        int yPart = this.statisticsLineSprite.getHeight() - this.statisticsImage.getHeight() / 2;
        g.drawRegion(this.statisticsImage, 0, this.statisticsImage.getHeight() / 2, this.statisticsImage.getWidth() * defenceUnitStat / defenceUnitMaxStat, this.statisticsImage.getHeight() / 2, 0, this.statisticsLineSprite.getX() + (this.statisticsLineSprite.getWidth() - this.statisticsImage.getWidth()) / 2, this.statisticsLineSprite.getY() + yPart / 2 + yPart % 2, 20);
    }

    protected final void onEnterKeyPressed() {
        this.onEnterForBuyKeyPressed(this.defenceUnits[this.getCurrRackItem()]);
    }

    protected final void onBackKeyPressed() {
        this.onBackForBuyKeyPressed$255f299(217);
    }

    protected final void onOthersKeyPressed(int key) {
        this.onLeftAndRightKeyPressed(key, 3);
    }

    protected final void setSelectionDesc() {
        switch (this.getCurrRackItem()) {
            case 0: {
                ShopDefenceUnits.setDescTextWithTitle("", MainLogic.strings[170]);
                break;
            }
            case 1: {
                ShopDefenceUnits.setDescTextWithTitle("", MainLogic.strings[169]);
                break;
            }
            case 2: {
                ShopDefenceUnits.setDescTextWithTitle("", MainLogic.strings[171]);
            }
        }
        ShopDefenceUnits.setPriceCrystalPosition(this.defenceUnits[this.getCurrRackItem()].getPrice());
    }
}

