/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.ui;

import com.tqm.agave.ui.GameImage;
import com.tqm.agave.ui.Layer;
import javax.microedition.lcdui.Graphics;

public class Sprite
extends Layer {
    GameImage sourceImage;
    int numberFrames;
    private int[] frameCoordsX;
    private int[] frameCoordsY;
    private int srcFrameWidth;
    private int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    int t_currentTransformation;

    public Sprite(GameImage gameImage) {
        super(gameImage.getWidth(), gameImage.getHeight());
        this.initializeFrames$681c42b0(gameImage, gameImage.getWidth(), gameImage.getHeight());
        this.setTransformImpl$13462e();
    }

    public Sprite(GameImage gameImage, int n, int n2) {
        super(n, n2);
        if (n <= 0 || n2 <= 0 || gameImage.getWidth() % n != 0 || gameImage.getHeight() % n2 != 0) {
            throw new IllegalArgumentException("Sprite " + gameImage.name + " (iw:" + gameImage.getWidth() + ",ih:" + gameImage.getHeight() + ", frameSize:" + n + "," + n2 + ")");
        }
        this.initializeFrames$681c42b0(gameImage, n, n2);
        this.setTransformImpl$13462e();
    }

    public final void setRefPixelPosition(int n, int n2) {
        this.x = n - this.getTransformedPtX(0, 0, 0);
        this.y = n2 - this.getTransformedPtY(0, 0, 0);
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException("setFrame frameSequence.length: " + this.frameSequence.length + ", sequenceIndex: " + sequenceIndex + ", " + this.sourceImage.name);
        }
        this.sequenceIndex = sequenceIndex;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            this.sourceImage.drawRegion$36d9c437(graphics, this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.frameCoordsY[this.frameSequence[this.sequenceIndex]], this.srcFrameWidth, this.srcFrameHeight, 0, this.x, this.y);
        }
    }

    private void initializeFrames$681c42b0(GameImage gameImage, int n, int n2) {
        int n3 = gameImage.getWidth();
        int n4 = gameImage.getHeight();
        int n5 = n3 / n;
        int n6 = n4 / n2;
        this.sourceImage = gameImage;
        this.srcFrameWidth = n;
        this.srcFrameHeight = n2;
        this.numberFrames = n5 * n6;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        this.sequenceIndex = 0;
        this.frameSequence = new int[this.numberFrames];
        int n7 = 0;
        for (n5 = 0; n5 < n4; n5 += n2) {
            for (n6 = 0; n6 < n3; n6 += n) {
                this.frameCoordsX[n7] = n6;
                this.frameCoordsY[n7] = n5;
                this.frameSequence[n7] = n7;
                ++n7;
            }
        }
    }

    private void setTransformImpl$13462e() {
        this.x = this.x + this.getTransformedPtX(0, 0, 0) - this.getTransformedPtX(0, 0, 0);
        this.y = this.y + this.getTransformedPtY(0, 0, 0) - this.getTransformedPtY(0, 0, 0);
        Sprite sprite = this;
        this.width = sprite.srcFrameWidth;
        sprite.height = sprite.srcFrameHeight;
        this.t_currentTransformation = 0;
    }

    private int getTransformedPtX(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = this.srcFrameWidth - 1;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 5: {
                n = this.srcFrameHeight - 1;
                break;
            }
            case 3: {
                n = this.srcFrameWidth - 1;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = this.srcFrameHeight - 1;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n;
    }

    private int getTransformedPtY(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 1: {
                n = this.srcFrameHeight - 1;
                break;
            }
            case 5: {
                n = 0;
                break;
            }
            case 3: {
                n = this.srcFrameHeight - 1;
                break;
            }
            case 6: {
                n = this.srcFrameWidth - 1;
                break;
            }
            case 7: {
                n = this.srcFrameWidth - 1;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n;
    }
}

