/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop.secret;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.game.Defender;
import com.tqm.fantasydefense.shop.secret.AbstractSecretItem;
import com.tqm.fantasydefense.shop.secret.SecretCampaign;
import com.tqm.fantasydefense.shop.secret.SecretCastleDefender;
import com.tqm.fantasydefense.shop.secret.SecretDefenceUnit;
import com.tqm.fantasydefense.shop.secret.SecretElixir;
import com.tqm.fantasydefense.shop.secret.SecretGems;
import com.tqm.wrapper.VirtualGood;

public final class SecretItemsManager {
    private static SecretItemsManager itemsManager;
    private static GameLogic gameLogic;
    private SecretCampaign[] campaigns;
    private SecretGems[] gems;
    private SecretDefenceUnit[] defenceUnits;
    private SecretElixir[] elixirs;
    private SecretCastleDefender[] dragons;
    private SecretCastleDefender[] catapults;
    private SecretCastleDefender[] gates;
    private AbstractSecretItem[] allSecretItems;

    public static SecretItemsManager getInstance() {
        if (itemsManager == null) {
            itemsManager = new SecretItemsManager();
        }
        return itemsManager;
    }

    private SecretItemsManager() {
        SecretItemsManager secretItemsManager = this;
        this.campaigns = new SecretCampaign[2];
        secretItemsManager.campaigns[0] = new SecretCampaign(25, 0, 24);
        secretItemsManager.campaigns[1] = new SecretCampaign(50, 1, 25);
        secretItemsManager = this;
        this.gems = new SecretGems[1];
        secretItemsManager.gems[0] = new SecretGems(0, 1);
        secretItemsManager = this;
        this.defenceUnits = new SecretDefenceUnit[3];
        Defender defender = new Defender(0, 0, 0, false);
        new Defender(0, 0, 0, false)._type = 24;
        defender._level = 1;
        defender.setUnitStats(false);
        secretItemsManager.defenceUnits[0] = new SecretDefenceUnit(0, defender._damageGround, defender._damageAir, defender._range, defender._startAttackDelay, 2, 21);
        defender._type = 23;
        defender.setUnitStats(false);
        secretItemsManager.defenceUnits[1] = new SecretDefenceUnit(1, defender._damageGround, defender._damageAir, defender._range, defender._startAttackDelay, 3, 22);
        defender._type = 25;
        defender.setUnitStats(false);
        secretItemsManager.defenceUnits[2] = new SecretDefenceUnit(2, defender._damageGround, defender._damageAir, defender._range, defender._startAttackDelay, 0, 23);
        secretItemsManager = this;
        this.elixirs = new SecretElixir[12];
        secretItemsManager.elixirs[0] = new SecretElixir(14, 0, 2, 30, 0);
        secretItemsManager.elixirs[1] = new SecretElixir(8, 1, 2, 15, 1);
        secretItemsManager.elixirs[2] = new SecretElixir(16, 2, 3, 20, 2);
        secretItemsManager.elixirs[3] = new SecretElixir(6, 3, 3, 12, 3);
        secretItemsManager.elixirs[4] = new SecretElixir(14, 4, new int[]{0, 1}, 10, 4);
        secretItemsManager.elixirs[5] = new SecretElixir(8, 5, new int[]{0, 1}, 5, 5);
        secretItemsManager.elixirs[6] = new SecretElixir(14, 6, 3, 20, 6);
        secretItemsManager.elixirs[7] = new SecretElixir(6, 7, 3, 12, 7);
        secretItemsManager.elixirs[8] = new SecretElixir(12, 8, 4, 2, 8);
        secretItemsManager.elixirs[9] = new SecretElixir(16, 9, 5, -1, 9);
        secretItemsManager.elixirs[10] = new SecretElixir(14, 10, 6, -1, 10);
        secretItemsManager.elixirs[11] = new SecretElixir(16, 11, 7, -1, 11);
        secretItemsManager.elixirs[0].setExclusiveElixir(secretItemsManager.elixirs[1]);
        secretItemsManager.elixirs[2].setExclusiveElixir(secretItemsManager.elixirs[3]);
        secretItemsManager.elixirs[4].setExclusiveElixir(secretItemsManager.elixirs[5]);
        secretItemsManager.elixirs[6].setExclusiveElixir(secretItemsManager.elixirs[7]);
        secretItemsManager.elixirs[1].setExclusiveElixir(secretItemsManager.elixirs[0]);
        secretItemsManager.elixirs[3].setExclusiveElixir(secretItemsManager.elixirs[2]);
        secretItemsManager.elixirs[5].setExclusiveElixir(secretItemsManager.elixirs[4]);
        secretItemsManager.elixirs[7].setExclusiveElixir(secretItemsManager.elixirs[6]);
        secretItemsManager = this;
        this.dragons = new SecretCastleDefender[3];
        secretItemsManager.dragons[0] = new SecretCastleDefender(40, 0, 0, 10, -1, 12);
        secretItemsManager.dragons[1] = new SecretCastleDefender(80, 0, 1, 20, 0, 13);
        secretItemsManager.dragons[2] = new SecretCastleDefender(160, 0, 2, 30, 2, 14);
        secretItemsManager.dragons[0].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.dragons[1], secretItemsManager.dragons[2]});
        secretItemsManager.dragons[1].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.dragons[0], secretItemsManager.dragons[2]});
        secretItemsManager.dragons[2].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.dragons[0], secretItemsManager.dragons[1]});
        secretItemsManager = this;
        this.catapults = new SecretCastleDefender[3];
        secretItemsManager.catapults[0] = new SecretCastleDefender(35, 2, 0, 10, -1, 18);
        secretItemsManager.catapults[1] = new SecretCastleDefender(70, 2, 1, 20, 2, 19);
        secretItemsManager.catapults[2] = new SecretCastleDefender(140, 2, 2, 30, 0, 20);
        secretItemsManager.catapults[0].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.catapults[1], secretItemsManager.catapults[2]});
        secretItemsManager.catapults[1].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.catapults[0], secretItemsManager.catapults[2]});
        secretItemsManager.catapults[2].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.catapults[0], secretItemsManager.catapults[1]});
        secretItemsManager = this;
        this.gates = new SecretCastleDefender[3];
        secretItemsManager.gates[0] = new SecretCastleDefender(20, 1, 0, 10, -1, 15);
        secretItemsManager.gates[1] = new SecretCastleDefender(40, 1, 1, 25, -1, 16);
        secretItemsManager.gates[2] = new SecretCastleDefender(80, 1, 2, 50, -1, 17);
        secretItemsManager.gates[0].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.gates[1], secretItemsManager.gates[2]});
        secretItemsManager.gates[1].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.gates[0], secretItemsManager.gates[2]});
        secretItemsManager.gates[2].setExclusiveCastleDefenders(new SecretCastleDefender[]{secretItemsManager.gates[0], secretItemsManager.gates[1]});
        this.allSecretItems = new AbstractSecretItem[]{this.gems[0], this.campaigns[0], this.campaigns[1], this.dragons[0], this.dragons[1], this.dragons[2], this.catapults[0], this.catapults[1], this.catapults[2], this.gates[0], this.gates[1], this.gates[2], this.defenceUnits[0], this.defenceUnits[1], this.defenceUnits[2], this.elixirs[0], this.elixirs[1], this.elixirs[2], this.elixirs[3], this.elixirs[4], this.elixirs[5], this.elixirs[6], this.elixirs[7], this.elixirs[8], this.elixirs[9], this.elixirs[10], this.elixirs[11]};
    }

    public final void updateGemsQuantity() {
        VirtualGood[] virtualGoodArray = gameLogic.getCurrVirtualGoods();
        this.gems = new SecretGems[virtualGoodArray.length];
        for (int i = 0; i < this.gems.length; ++i) {
            this.gems[i] = new SecretGems(SecretItemsManager.getVirtualGood(i).getQuantity(), Integer.parseInt(SecretItemsManager.getVirtualGood(i).getId()));
        }
        gameLogic.getShopManager().getShopGems().updateGems(this.gems);
    }

    private static VirtualGood getVirtualGood(int gemsType) {
        return gameLogic.getCurrVirtualGoods()[gemsType];
    }

    public final void saveDefaultToRMS() {
        for (int i = 0; i < this.allSecretItems.length; ++i) {
            this.allSecretItems[i].saveDefaultToRMS();
        }
    }

    public final void loadFromRMS() {
        for (int i = 0; i < this.allSecretItems.length; ++i) {
            this.allSecretItems[i].loadFromRMS();
        }
    }

    public final SecretCampaign[] getCampaigns() {
        return this.campaigns;
    }

    public final SecretCastleDefender[] getCatapults() {
        return this.catapults;
    }

    public final SecretDefenceUnit[] getDefenceUnits() {
        return this.defenceUnits;
    }

    public final SecretCastleDefender[] getDragons() {
        return this.dragons;
    }

    public final int getActiveDragon() {
        if (this.dragons[1].isActive()) {
            return 2;
        }
        if (this.dragons[2].isActive()) {
            return 3;
        }
        if (this.dragons[0].isActive()) {
            return 1;
        }
        return 0;
    }

    public final SecretElixir[] getElixirs() {
        return this.elixirs;
    }

    public final int[] getInactiveSmallElixirsIds() {
        int[] nArray = SecretItemsManager.createSecretElixirsIdsArray$2558076();
        int n = this.checkSmallElixirInactiveness(nArray, 1, 0);
        n = this.checkSmallElixirInactiveness(nArray, 7, n);
        n = this.checkSmallElixirInactiveness(nArray, 3, n);
        n = this.checkSmallElixirInactiveness(nArray, 5, n);
        return SecretItemsManager.createSecretElixirsIdsArrayResult(nArray, n);
    }

    private static int[] createSecretElixirsIdsArray$2558076() {
        int[] secretElixirsIds = new int[4];
        for (int i = 0; i < secretElixirsIds.length; ++i) {
            secretElixirsIds[i] = -1;
        }
        return secretElixirsIds;
    }

    private int checkSmallElixirInactiveness(int[] secretElixirsIds, int smallElixirId, int inactiveElixirsCounter) {
        if (!this.elixirs[smallElixirId].isActive() && !this.elixirs[smallElixirId].getExclusiveElixir().isActive()) {
            secretElixirsIds[inactiveElixirsCounter] = smallElixirId;
            ++inactiveElixirsCounter;
        }
        return inactiveElixirsCounter;
    }

    private static int[] createSecretElixirsIdsArrayResult(int[] secretElixirsIds, int arraySize) {
        int[] secretElixirsIdsResult = new int[arraySize];
        System.arraycopy(secretElixirsIds, 0, secretElixirsIdsResult, 0, arraySize);
        return secretElixirsIdsResult;
    }

    public final int[] getInactiveBigElixirsIds() {
        int[] nArray = SecretItemsManager.createSecretElixirsIdsArray$2558076();
        int n = this.checkBigElixirInactiveness(nArray, 0, 0);
        n = this.checkBigElixirInactiveness(nArray, 6, n);
        n = this.checkBigElixirInactiveness(nArray, 2, n);
        n = this.checkBigElixirInactiveness(nArray, 4, n);
        return SecretItemsManager.createSecretElixirsIdsArrayResult(nArray, n);
    }

    private int checkBigElixirInactiveness(int[] secretElixirsIds, int bigElixirId, int inactiveElixirsCounter) {
        if (!this.elixirs[bigElixirId].isActive()) {
            secretElixirsIds[inactiveElixirsCounter] = bigElixirId;
            ++inactiveElixirsCounter;
        }
        return inactiveElixirsCounter;
    }

    public final void resetElixirs() {
        for (int i = 0; i < this.elixirs.length; ++i) {
            this.elixirs[i].saveDefaultToRMS();
        }
        SecretItemsManager secretItemsManager = this;
        for (int i = 0; i < secretItemsManager.elixirs.length; ++i) {
            secretItemsManager.elixirs[i].loadFromRMS();
        }
        this.updateElixirPrices();
    }

    public final void updateElixirPrices() {
        if (this.elixirs[1].isActive()) {
            this.elixirs[0].setPrice(6);
        } else {
            this.elixirs[0].setPrice(14);
        }
        if (this.elixirs[7].isActive()) {
            this.elixirs[6].setPrice(8);
        } else {
            this.elixirs[6].setPrice(14);
        }
        if (this.elixirs[3].isActive()) {
            this.elixirs[2].setPrice(10);
        } else {
            this.elixirs[2].setPrice(16);
        }
        if (this.elixirs[5].isActive()) {
            this.elixirs[4].setPrice(6);
            return;
        }
        this.elixirs[4].setPrice(14);
    }

    public final SecretCastleDefender[] getGates() {
        return this.gates;
    }

    public final SecretCastleDefender getActiveGate() {
        if (this.gates[0].isActive()) {
            return this.gates[0];
        }
        if (this.gates[1].isActive()) {
            return this.gates[1];
        }
        if (this.gates[2].isActive()) {
            return this.gates[2];
        }
        return null;
    }

    public final SecretGems[] getGems() {
        return this.gems;
    }

    public final void resetSecretItemsParams() {
        int i;
        for (i = 0; i < this.dragons.length; ++i) {
            this.dragons[i].uninstallItem();
            this.catapults[i].uninstallItem();
            this.gates[i].uninstallItem();
        }
        for (i = 0; i < this.elixirs.length; ++i) {
            this.elixirs[i].setUnlocked(false);
            this.elixirs[i].setActive(false);
            this.elixirs[i].saveDefaultToRMS();
        }
        this.updateElixirPrices();
    }

    public final boolean isAllElixirsBought() {
        return this.elixirs[0].isActive() && this.elixirs[6].isActive() && this.elixirs[2].isActive() && this.elixirs[4].isActive() && this.elixirs[9].isActive() && this.elixirs[8].isActive() && this.elixirs[10].isActive() && this.elixirs[11].isActive();
    }

    public final boolean isAllCastleUpgradesBought() {
        return SecretItemsManager.isAllSecretItemsBought(this.dragons) && SecretItemsManager.isAllSecretItemsBought(this.gates) && SecretItemsManager.isAllSecretItemsBought(this.catapults);
    }

    public final boolean isAllDefenceUnitsBought() {
        return SecretItemsManager.isAllSecretItemsBought(this.defenceUnits);
    }

    private static boolean isAllSecretItemsBought(AbstractSecretItem[] items) {
        boolean result = true;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].isUnlocked()) continue;
            result = false;
            break;
        }
        return result;
    }

    public static void setGameLogic(GameLogic gameLogic) {
        SecretItemsManager.gameLogic = gameLogic;
    }
}

