/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.epicheroes.views;

import com.am.activity.components.NewButton;
import com.am.activity.interfaces.ActivityInterface;
import com.am.activity.main.Activity;
import com.amediax.epicheroes.content.Res;
import com.amediax.epicheroes.engine.Engine;
import com.amediax.epicheroes.game.Arrow;
import com.amediax.epicheroes.game.Enemy;
import com.amediax.epicheroes.game.Player;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class GameView
extends Activity
implements ActivityInterface {
    private NewButton btnBack;
    private Vector arrows;
    private Vector enemies;
    private EnemyThread enemyThread;
    private Player player;
    private int startx;
    private int starty;
    private int endx;
    private int endy;
    private int counterMovingEnemy;
    private int lifeCounter;
    public static int scoreCounter;
    private final int halfDisplay = Engine.displayWidth / 2;
    private static Random rand;
    private int maxSleepTime;
    private int speedEnemy;

    public GameView(int width, int height) {
        super(width, height);
    }

    public void startNewGame() {
        this.startx = 20;
        this.starty = 170;
        this.endx = 20;
        this.endy = 170;
        if (!this.arrows.isEmpty()) {
            for (int i = 0; i < this.arrows.size(); ++i) {
                this.remove((Layer)((Arrow)((Object)this.arrows.elementAt(i))));
            }
        }
        this.arrows.removeAllElements();
        this.enemies.removeAllElements();
        this.enemyThread.requestStart();
        this.counterMovingEnemy = 0;
        this.lifeCounter = 100;
        scoreCounter = 0;
        this.maxSleepTime = 7000;
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        g.drawImage(Res.IMG_BOX, 60, 200, 20);
        if (this.endx != 20 && this.endy != 170) {
            double a = this.starty - this.endy;
            double b = this.endx - this.startx;
            double val = 5.0;
            a /= val;
            b /= val;
            g.setColor(0xFF0000);
            for (double i = 0.0; i < 10.0; i += 1.0) {
                int posx = 20 + (int)(a * i);
                int posy = 170 - (int)(b * i - 10.0 * i * i / 2.0);
                g.fillRoundRect(posx, posy, 5, 5, 5, 5);
            }
        }
        for (int i = 0; i < this.enemies.size(); ++i) {
            ((Enemy)this.enemies.elementAt(i)).paint(g);
        }
        g.setFont(Res.BIG_BOLD_FONT);
        g.setColor(0xFF0000);
        g.drawString("" + this.lifeCounter, 5, 45, 20);
        g.setColor(65280);
        g.drawString("" + scoreCounter, this.halfDisplay, 45, 17);
        this.update();
    }

    public boolean pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.startx = x;
        this.starty = y;
        this.player.positionToShoot();
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.endx = x;
        this.endy = y;
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.endx != 20 && this.endy != 170) {
            double a = this.starty - this.endy;
            double b = this.endx - this.startx;
            if (this.arrows.size() < 6) {
                Arrow ar = new Arrow(a, b);
                ar.setPosition(20, 170);
                this.insert((Layer)ar, 0);
                this.arrows.addElement(ar);
            }
        }
        this.endx = 20;
        this.endy = 170;
        this.player.positionStay();
        return false;
    }

    private void update() {
        int i;
        if (this.counterMovingEnemy > this.speedEnemy) {
            this.counterMovingEnemy = 0;
            if (!this.enemies.isEmpty()) {
                for (i = 0; i < this.enemies.size(); ++i) {
                    Enemy enemy = (Enemy)this.enemies.elementAt(i);
                    if (enemy.isDead()) {
                        this.enemies.removeElementAt(i);
                        this.enemies.trimToSize();
                    }
                    enemy.move();
                    if (!enemy.isDeadLine()) continue;
                    this.lifeCounter = enemy.isBoss() ? (this.lifeCounter -= 2) : --this.lifeCounter;
                    if (this.lifeCounter > 0) continue;
                    Engine.getInstance().handleEvent(107);
                }
            }
        } else {
            ++this.counterMovingEnemy;
        }
        if (!this.arrows.isEmpty()) {
            Arrow ar;
            for (i = 0; i < this.arrows.size(); ++i) {
                ar = (Arrow)((Object)this.arrows.elementAt(i));
                if (!ar.isEndMoving()) continue;
                this.arrows.removeElementAt(i);
                this.arrows.trimToSize();
                this.remove((Layer)ar);
            }
            for (i = 0; i < this.arrows.size(); ++i) {
                ar = (Arrow)((Object)this.arrows.elementAt(i));
                ar.move();
                if (!this.checkTargetHit(ar)) continue;
                this.arrows.removeElementAt(i);
                this.arrows.trimToSize();
                this.remove((Layer)ar);
                return;
            }
        }
    }

    private boolean checkTargetHit(Arrow ar) {
        for (int j = 0; j < this.enemies.size(); ++j) {
            Enemy enemy = (Enemy)this.enemies.elementAt(j);
            if (!ar.collidesWith(enemy.getSpr_enemy(), true)) continue;
            enemy.hit();
            if (enemy.isDead()) {
                scoreCounter = enemy.isBoss() ? (scoreCounter += 50) : (scoreCounter += 10);
                if (scoreCounter > 500) {
                    this.maxSleepTime = 6000;
                }
                if (scoreCounter > 700) {
                    this.maxSleepTime = 5000;
                }
            }
            return true;
        }
        return false;
    }

    private void createEnemy() {
        if (this.enemies.size() < 7) {
            Enemy enemy = rand.nextInt(100) < 80 ? new Enemy(Enemy.SOLDIER) : new Enemy(Enemy.BOSS);
            enemy.setPosition(this.activityWidth, 160);
            this.enemies.addElement(enemy);
        }
    }

    public void buttonIsPressed(int i) {
    }

    public void buttonIsReleased(int i) {
        if (this.btnBack.getID() == i) {
            this.enemyThread.requestPause();
            Engine.getInstance().handleEvent(104);
        }
    }

    public void returnState(int i, int i1) {
    }

    public void initResources() {
        this.speedEnemy = 10;
        if (Engine.displayWidth == 400) {
            this.speedEnemy = 7;
        }
        this.btnBack = NewButton.createButtonWithImage(this, Res.IMG_BTN_EXIT);
        this.btnBack.setPosition(this.activityWidth - this.btnBack.getWidth(), 0);
        this.arrows = new Vector();
        this.enemies = new Vector();
        this.enemyThread = new EnemyThread();
        this.player = new Player();
        this.insert((Layer)this.player, 0);
        this.append((Layer)Res.sprBackground);
    }

    public void refreshResources() {
        this.enemyThread.requestStart();
    }

    public void buttonIsDragged(int i, int i1, int i2) {
    }

    private long getRandSleepTime() {
        int val = rand.nextInt(this.maxSleepTime);
        if (val < 3500) {
            return this.getRandSleepTime();
        }
        return val;
    }

    static {
        rand = new Random();
    }

    class EnemyThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                EnemyThread enemyThread = this;
                synchronized (enemyThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("Run start");
            while (!this.stop) {
                try {
                    if (this.pause) {
                        EnemyThread enemyThread = this;
                        synchronized (enemyThread) {
                            this.wait();
                            continue;
                        }
                    }
                    GameView.this.createEnemy();
                    Thread.sleep(GameView.this.getRandSleepTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

