/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.utils;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MultiLineText {
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 0;
    private final int SCROLL_STEP;
    private final int scrollbarWidth;
    private int scrollbarHeight = 0;
    private boolean scrollbarVisible = true;
    private int scrollbarTop = 0;
    private int scrollbarColor = 0;
    private int borderWidth = 1;
    private Font textFont = Font.getDefaultFont();
    private int textColor = 0;
    private final int padding;
    private final int interline;
    private int width = 0;
    private int height = 0;
    private int innerWidth = 0;
    private int innerHeight = 0;
    private int currentY = 0;
    private int textHeight = 0;
    private int pressedPointY;
    private String[] textRows = null;
    private final int posX;
    private final int posY;
    private boolean scrollable = true;
    private boolean visible = true;

    public MultiLineText(String text, int width, int height) {
        this.SCROLL_STEP = 4;
        this.scrollbarWidth = 4;
        this.padding = 10;
        this.interline = 2;
        this.scrollableTextFieldExt(width, height);
        this.setText(text);
        this.posX = 0;
        this.posY = 0;
        this.pressedPointY = 0;
    }

    public MultiLineText(String text, int width, int height, int posX, int posY) {
        this.SCROLL_STEP = 4;
        this.scrollbarWidth = 4;
        this.padding = 10;
        this.interline = 2;
        this.posX = posX;
        this.posY = posY;
        this.pressedPointY = posY;
        this.scrollableTextFieldExt(width, height);
        this.setText(text);
    }

    private void scrollableTextFieldExt(int width, int height) {
        this.width = width;
        this.height = height;
        this.innerWidth = width - 2 * this.getBorderWidth() - 20 - 4;
        this.innerHeight = height - 2 * this.getBorderWidth() - 20;
    }

    public final void setText(String text) {
        this.textRows = this.getTextRows(text, this.getTextFont(), this.innerWidth - this.posX);
        this.textHeight = this.textRows.length * (2 + this.getTextFont().getHeight());
        System.out.println("innerHeight=" + this.innerHeight);
        System.out.println("textHeight=" + this.textHeight);
        this.scrollbarHeight = Math.min(this.innerHeight, this.innerHeight * this.innerHeight / this.textHeight);
        System.out.println("scrollbarHeight=" + this.scrollbarHeight);
        this.scrollbarTop = this.posY;
        this.currentY = this.posY;
        if (this.textRows.length * (this.getTextFont().getHeight() + 2) < this.innerHeight) {
            this.scrollbarVisible = false;
            this.setScrollable(false);
        }
    }

    private String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        String[] rowsArray = new String[rowsVector.size()];
        for (int i = 0; i < rowsArray.length; ++i) {
            rowsArray[i] = (String)rowsVector.elementAt(i);
        }
        return rowsArray;
    }

    private void scroll(int delta) {
        if (this.scrollable) {
            this.currentY = delta > 0 ? (this.currentY -= 4) : (this.currentY += 4);
            if (this.currentY > this.posY) {
                this.currentY = this.posY;
            } else if (-this.currentY > this.textHeight - this.innerHeight) {
                this.currentY += 4;
            }
            this.scrollbarTop = this.posY + -(this.innerHeight * ((this.currentY - this.posY) * 100 / this.textHeight)) / 100;
        }
    }

    public void paint(Graphics g) {
        if (this.visible) {
            g.setColor(this.getTextColor());
            g.setFont(this.getTextFont());
            g.setClip(this.posX, this.posY, this.innerWidth, this.innerHeight);
            if (this.textRows != null) {
                for (int i = 0; i < this.textRows.length; ++i) {
                    g.drawString(this.textRows[i], this.posX, i * (this.getTextFont().getHeight() + 2) + this.currentY, 20);
                }
            }
            g.setClip(0, 0, 500, 500);
            if (this.scrollbarVisible) {
                g.setColor(this.getScrollbarColor());
                g.fillRect(this.innerWidth, this.scrollbarTop, 4, this.scrollbarHeight);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.visible && x > this.posX && x < this.posX + this.width && y > this.posY && y < this.posY + this.height && this.scrollable) {
            this.pressedPointY = y;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.visible && this.scrollable) {
            this.scroll(this.pressedPointY - y);
        }
    }

    public int getScrollbarColor() {
        return this.scrollbarColor;
    }

    public void setScrollbarColor(int scrollbarColor) {
        this.scrollbarColor = scrollbarColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setScrollbarVisible(boolean scrollbarVisible) {
        this.scrollbarVisible = scrollbarVisible;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

