/*
 * Decompiled with CFR 0.152.
 */
package com.am.ashamidlet;

import com.am.asha_inapp.Payment;
import com.am.asha_inapp.PaymentStat;
import com.am.ashamidlet.EmptyPaymentManager;
import com.am.ashamidlet.Settings;
import com.am.ashamidlet.Stat;
import com.am.blockapplib.main.BlockerView;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

public abstract class AshaMidlet
extends MIDlet {
    private static final String SEPARATOR = "|";
    private static final String IN_APP_PRODUCT_IDS = "/productIDs.txt";
    private static boolean productIdsInit = false;
    private static Hashtable productIds = new Hashtable();
    private static AshaMidlet self;
    public BlockerView blocker;
    Payment paymentManager;
    public PaymentStat stat;
    private boolean isInit = false;

    public static AshaMidlet getInstance() {
        return self;
    }

    protected final void destroyApp(boolean unconditional) {
        this.onDestroy();
    }

    public final void destroyApp() {
        this.destroyApp(true);
    }

    protected final void pauseApp() {
        this.onPause();
    }

    protected final void startApp() {
        self = this;
        if (!this.isInit) {
            this.stat = new Stat();
            try {
                this.readFileProductIDs(IN_APP_PRODUCT_IDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String className = Settings.getInAppClass();
            try {
                Class<?> clazz = Class.forName(className);
                this.paymentManager = (Payment)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException();
            }
            catch (InstantiationException ie) {
                throw new IllegalStateException();
            }
            catch (IllegalAccessException ise) {
                throw new IllegalStateException();
            }
            Enumeration enumeration = productIds.keys();
            while (enumeration.hasMoreElements()) {
                String key = new String((String)enumeration.nextElement());
                this.getPayManager().setNewProduct(key, (String)productIds.get(key));
            }
            this.blocker = new BlockerView(this, this.getPayManager());
            this.onCreate();
            this.getPayManager().initInApp(this, this.stat);
            this.blocker.init();
            this.isInit = true;
        }
        this.onResume();
    }

    public Payment getPayManager() {
        if (this.paymentManager != null) {
            return this.paymentManager;
        }
        System.err.println("**********************************************************************");
        System.err.println("ERROR!!! inApp not initialized on Aplication Descriptor - User Defined");
        System.err.println("**********************************************************************");
        return new EmptyPaymentManager();
    }

    private boolean readFileProductIDs(String filename) throws UnsupportedEncodingException, IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (is != null && !productIdsInit) {
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            String line = null;
            try {
                while ((line = this.readLine(reader)) != null) {
                    String[] result = this.split(line, SEPARATOR);
                    productIds.put(result[0], result[1]);
                }
                productIdsInit = true;
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        return productIdsInit;
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    public abstract void onPause();

    public abstract void onCreate();

    public abstract void onResume();

    public abstract void onDestroy();
}

