/*
 * Decompiled with CFR 0.152.
 */
public class Projectiles
implements GameConstants,
Constants {
    static int MAX_NUM_PROJECTILES = 140;
    static int PROJECTILE_TYPE = 0;
    static int PROJECTILE_ROW = PROJECTILE_TYPE + 1;
    static int PROJECTILE_FP_X = PROJECTILE_ROW + 1;
    static int PROJECTILE_FP_Y = PROJECTILE_FP_X + 1;
    static int PROJECTILE_FP_VX = PROJECTILE_FP_Y + 1;
    static int PROJECTILE_FP_VY = PROJECTILE_FP_VX + 1;
    static int PROJECTILE_MOTION_TYPE = PROJECTILE_FP_VY + 1;
    static int PROJECTILE_FLAGS = PROJECTILE_MOTION_TYPE + 1;
    static int PROJECTILE_DMG_RANGE_FLAGS = PROJECTILE_FLAGS + 1;
    static int PROJECTILE_TORCHED_PLANT_INDEX = PROJECTILE_DMG_RANGE_FLAGS + 1;
    static int PROJECTILE_MAX_VALS = PROJECTILE_TORCHED_PLANT_INDEX + 1;
    static int[] PROJECTILES = new int[MAX_NUM_PROJECTILES * PROJECTILE_MAX_VALS];
    static int m_nProjectiles;
    static int PROJECTILE_OFFSET_X;
    static int PROJECTILE_OFFSET_Y;
    static int PROJECTILE_OFFSET_SHADOW_X;
    static int PROJECTILE_OFFSET_SHADOW_Y;
    static int PROJECTILE_OFFSET_MAX_VALS;
    static int[] PROJECTILE_OFFSETS;
    static int FP1;
    static int PROJECTILE_LOB_SPEED;
    static int PROJECTILE_LOB_SPEED_OFFSET_Y;
    static int PROJECTILE_LOB_GRAVITY;
    static int[] PROJECTILE_RECT;
    static int PROJECTILE_RECT_X;
    static int PROJECTILE_RECT_Y;
    static int PROJECTILE_RECT_W;
    static int PROJECTILE_RECT_H;

    static void init() {
        PROJECTILE_LOB_SPEED = FP.fpMul(573440, GModel.FP_SPEED_SCALER_WIDTH);
        PROJECTILE_LOB_SPEED_OFFSET_Y = -28672;
        PROJECTILE_LOB_GRAVITY = FP.fpDiv("\u0000\u0000\u0000\u012c\u012c\u012c\u012c\u0d02\u012c\uffff\uffff\uffff".charAt(3) * 4096, 4096000);
    }

    static void resetVarsNewLevel() {
        Util.resetArray(PROJECTILES, -1);
        m_nProjectiles = 0;
    }

    static int addProjectile(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n >= 0) {
            int n8 = 0;
            for (int i = 0; i < MAX_NUM_PROJECTILES; ++i) {
                n8 = PROJECTILE_MAX_VALS * i;
                if (PROJECTILES[n8 + PROJECTILE_TYPE] != -1) continue;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_TYPE] = n;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_ROW] = n4;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_X] = n2 * FP1;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_Y] = n3 * FP1;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_MOTION_TYPE] = Math.max(n6, 0);
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_VX] = Projectiles.getSpeedFP(n, "\u0d02\u0d02\u0d02\uffff\uffff\uffff\uffff\u0d02\uffff\u0d02\u0d02\u0d02");
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FLAGS] = 0;
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_TORCHED_PLANT_INDEX] = -1;
                if (n6 == 1) {
                    Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_VY] = Projectiles.getSpeedFP(n, "\u0d02\uffff\uffff\uffff\uffff\uffff#\uffff\uffff\uffff\uffff\uffff");
                    if (n4 < Plants.getRow(n5)) {
                        Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_VY] = -PROJECTILES[n8 + PROJECTILE_FP_VY];
                    }
                } else {
                    Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_FP_VY] = Projectiles.getSpeedFP(n, "\u0000\u0000\u0000\u012c\u012c\u012c\u012c\u0d02\u012c\uffff\uffff\uffff");
                }
                if (n6 == 2) {
                    Projectiles.setFlag(2, i);
                }
                Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_DMG_RANGE_FLAGS] = Plants.getDamageRangeFlags(n5, n7);
                ++m_nProjectiles;
                return i;
            }
        }
        return -1;
    }

    static boolean isProjectileAtIndex(int n) {
        return PROJECTILES[PROJECTILE_MAX_VALS * n + PROJECTILE_TYPE] != -1;
    }

    static void getProjectileOffsets(int n) {
        char c = "\u0000\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n".charAt(n);
        if (c == '\uffffffff') {
            Util.resetArray(PROJECTILE_OFFSETS, 0);
            return;
        }
        Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_X] = (short)"\u001f\f\u0000\u0000\ufffe\u0000\u0000\u000f\u001e\u0012\u0012".charAt(c);
        Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_Y] = (short)"\u0007\u0005\ufff9\ufffc\ufff6\ufff6\u0000\ufffa\n\u0016\u0018".charAt(c);
        Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_SHADOW_X] = (short)"\u0000\r\u0002\u0000\u0006\u0004\u0000\u0000\u0000\u0000\u0000".charAt(c);
        Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_SHADOW_Y] = (short)"\u0015\u0015!!!!\u0015!!\t\t".charAt(c);
    }

    static int getSpeedFP(int n, String string) {
        int n2 = (short)string.charAt(n) * FP1;
        if (n2 == 0) {
            return 0;
        }
        n2 = FP.fpMul(n2, GModel.FP_SPEED_SCALER_WIDTH);
        n2 = FP.fpMul(n2, GModel.FP_FPS_SCALER);
        n2 = FP.fpDiv(n2, FP1 * 1000);
        return n2;
    }

    static void update() {
        int n = 0;
        int n2 = m_nProjectiles;
        for (int i = 0; i < MAX_NUM_PROJECTILES && n < n2; ++i) {
            if (!Projectiles.isProjectileAtIndex(i)) continue;
            int n3 = PROJECTILE_MAX_VALS * i;
            int n4 = PROJECTILES[n3 + PROJECTILE_TYPE];
            int n5 = PROJECTILES[n3 + PROJECTILE_MOTION_TYPE];
            boolean bl = false;
            if (n5 == 0) {
                Projectiles.updateMotionStraight(i);
            } else if (n5 == 2) {
                bl = Projectiles.updateMotionLobbed(i);
            } else if (n5 == 1) {
                Projectiles.updateMotionThreepeater(i);
            }
            if (n5 != 2 && CollisionHandler.checkProjectileOffScreen(i)) {
                Projectiles.killProjectile(i);
            } else if (n4 == 8) {
                Projectiles.updateBasketBallCollisions(i, bl);
            } else {
                Projectiles.updatePlantProjectileCollisions(i, bl);
            }
            ++n;
        }
    }

    static void killProjectile(int n) {
        if (PROJECTILES[n * PROJECTILE_MAX_VALS + PROJECTILE_TYPE] != -1) {
            Projectiles.PROJECTILES[n * Projectiles.PROJECTILE_MAX_VALS + Projectiles.PROJECTILE_TYPE] = -1;
            --m_nProjectiles;
        }
    }

    static void updateMotionStraight(int n) {
        int n2 = PROJECTILE_MAX_VALS * n;
        int n3 = n2 + PROJECTILE_FP_X;
        PROJECTILES[n3] = PROJECTILES[n3] + PROJECTILES[n2 + PROJECTILE_FP_VX];
        int n4 = n2 + PROJECTILE_FP_Y;
        PROJECTILES[n4] = PROJECTILES[n4] + PROJECTILES[n2 + PROJECTILE_FP_VY];
    }

    static void updateMotionThreepeater(int n) {
        int n2 = PROJECTILE_MAX_VALS * n;
        int n3 = n2 + PROJECTILE_FP_X;
        PROJECTILES[n3] = PROJECTILES[n3] + PROJECTILES[n2 + PROJECTILE_FP_VX];
        int n4 = FP.fpMul(PROJECTILES[n2 + PROJECTILE_FP_VY], GModel.FP_95_PERCENT);
        Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_FP_VY] = n4;
        int n5 = n4;
        int n6 = PROJECTILES[n2 + PROJECTILE_ROW];
        Cursor.getGridPosRect(n6 * 9, 0);
        Plants.getPlantOffsets(10);
        Projectiles.getProjectileOffsets(0);
        int n7 = (Cursor.GRID_POS[Cursor.GRID_POS_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_Y] + PROJECTILE_OFFSETS[PROJECTILE_OFFSET_Y]) * FP1;
        Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_FP_Y] = n5 > 0 ? Math.min(PROJECTILES[n2 + PROJECTILE_FP_Y] + n5, n7) : Math.max(PROJECTILES[n2 + PROJECTILE_FP_Y] + n5, n7);
        if (PROJECTILES[n2 + PROJECTILE_FP_Y] == n7) {
            Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_MOTION_TYPE] = 0;
            Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_FP_VY] = 0;
        }
    }

    static boolean updateMotionLobbed(int n) {
        int n2 = PROJECTILE_MAX_VALS * n;
        int n3 = n2 + PROJECTILE_FP_X;
        PROJECTILES[n3] = PROJECTILES[n3] + PROJECTILES[n2 + PROJECTILE_FP_VX];
        int n4 = n2 + PROJECTILE_FP_Y;
        PROJECTILES[n4] = PROJECTILES[n4] + PROJECTILES[n2 + PROJECTILE_FP_VY];
        int n5 = n2 + PROJECTILE_FP_VY;
        PROJECTILES[n5] = PROJECTILES[n5] + PROJECTILE_LOB_GRAVITY;
        if (PROJECTILES[n2 + PROJECTILE_FP_VY] > 0) {
            Cursor.getGridRowPos(PROJECTILES[n2 + PROJECTILE_ROW], 0);
            int n6 = GFCanvas.getImageHeight("C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(PROJECTILES[n2 + PROJECTILE_TYPE]));
            int n7 = (Cursor.GRID_POS[Cursor.GRID_POS_Y] + Cursor.GRID_POS[Cursor.GRID_POS_H] - n6) * 4096;
            if (PROJECTILES[n2 + PROJECTILE_FP_Y] >= n7) {
                return true;
            }
        }
        return false;
    }

    static void getRect(int n, boolean bl) {
        int n2 = n * PROJECTILE_MAX_VALS;
        int n3 = PROJECTILES[n2 + PROJECTILE_TYPE];
        char c = "C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(n3);
        Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_W] = GFCanvas.getImageWidth(c);
        Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_H] = GFCanvas.getImageHeight(c);
        Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_X] = FP.toInt(PROJECTILES[n2 + PROJECTILE_FP_X]);
        Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_Y] = FP.toInt(PROJECTILES[n2 + PROJECTILE_FP_Y]);
        if (bl && (n3 == 0 || n3 == 1 || n3 == 9 || n3 == 10)) {
            int n4 = PROJECTILE_RECT_X;
            PROJECTILE_RECT[n4] = PROJECTILE_RECT[n4] - PROJECTILE_RECT[PROJECTILE_RECT_W];
            int n5 = PROJECTILE_RECT_W;
            PROJECTILE_RECT[n5] = PROJECTILE_RECT[n5] * 2;
        }
    }

    static void convertToFireball(int n) {
        int n2 = n * PROJECTILE_MAX_VALS;
        int n3 = PROJECTILES[n2 + PROJECTILE_TYPE];
        int n4 = 0;
        int n5 = 0;
        if (n3 == 0) {
            Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_TYPE] = 2;
            Projectiles.getProjectileOffsets(0);
            n4 = PROJECTILE_OFFSETS[PROJECTILE_OFFSET_X];
            n5 = PROJECTILE_OFFSETS[PROJECTILE_OFFSET_Y];
            Projectiles.setFlag(1, n);
        } else if (n3 == 1) {
            Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_TYPE] = 0;
            Projectiles.getProjectileOffsets(1);
            n4 = PROJECTILE_OFFSETS[PROJECTILE_OFFSET_X];
            n5 = PROJECTILE_OFFSETS[PROJECTILE_OFFSET_Y];
        }
        Projectiles.getProjectileOffsets(PROJECTILES[n2 + PROJECTILE_TYPE]);
        int n6 = n2 + PROJECTILE_FP_X;
        PROJECTILES[n6] = PROJECTILES[n6] + (PROJECTILE_OFFSETS[PROJECTILE_OFFSET_X] - n4) * FP1;
        int n7 = n2 + PROJECTILE_FP_Y;
        PROJECTILES[n7] = PROJECTILES[n7] + (PROJECTILE_OFFSETS[PROJECTILE_OFFSET_Y] - n5) * FP1;
    }

    public static boolean isFlagSet(int n, int n2) {
        return (PROJECTILES[n2 * PROJECTILE_MAX_VALS + PROJECTILE_FLAGS] & 1 << n) != 0;
    }

    public static void setFlag(int n, int n2) {
        int n3 = n2 * PROJECTILE_MAX_VALS + PROJECTILE_FLAGS;
        PROJECTILES[n3] = PROJECTILES[n3] | 1 << n;
    }

    public static void unSetFlag(int n, int n2) {
        int n3 = n2 * PROJECTILE_MAX_VALS + PROJECTILE_FLAGS;
        PROJECTILES[n3] = PROJECTILES[n3] & ~(1 << n);
    }

    static boolean isZombieHitBySplashDamage(int n, int n2) {
        int n3 = n * PROJECTILE_MAX_VALS;
        int n4 = PROJECTILES[n3 + PROJECTILE_ROW];
        int n5 = PROJECTILES[n3 + PROJECTILE_TYPE];
        int n6 = Zombies.ZOMBIE_MAX_VALS * n2;
        int n7 = Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_ROW];
        int n8 = Math.abs(n4 - n7);
        if (n8 > 1) {
            return false;
        }
        Projectiles.getRect(n, false);
        int n9 = PROJECTILE_RECT[PROJECTILE_RECT_Y];
        char c = "\u0d02\uffff\uffff\uffff\uffff\uffff#\uffff\uffff\uffff\uffff\uffff".charAt(n5);
        int n10 = PROJECTILE_RECT[PROJECTILE_RECT_H];
        int n11 = PROJECTILE_RECT[PROJECTILE_RECT_X] + (PROJECTILE_RECT[PROJECTILE_RECT_W] - c) / 2;
        Zombies.getHitRect(n2);
        int n12 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X];
        int n13 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y];
        int n14 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W];
        int n15 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H];
        return Geometry.rectIntersect(n11, n9, c, n10, n12, n13, n14, n15);
    }

    static void updatePlantProjectileCollisions(int n, boolean bl) {
        int n2 = n * PROJECTILE_MAX_VALS;
        int n3 = PROJECTILES[n2 + PROJECTILE_TYPE];
        int n4 = CollisionHandler.checkProjectileZombieCollisions(n);
        if (n4 != -1) {
            if (n3 == 6) {
                CollisionHandler.doSplashDamage(n, n4, 0);
                GCanvasController.doProjectileSplat(n4, n);
            } else {
                Zombies.takeDamage(n4, "\u0014\u0014((\u0014(P\u0014K\u0014\u0014\u0014".charAt(n3), n3, 0, false);
                if (n3 == 0 || n3 == 1 || n3 == 3 || n3 == 2 || n3 == 9 || n3 == 10 || n3 == 7) {
                    GCanvasController.doProjectileSplat(n4, n);
                }
            }
            Projectiles.killProjectile(n);
        } else if (bl) {
            Projectiles.killProjectile(n);
        } else if (n3 == 1 || n3 == 10) {
            GCanvasController.doProjectileTrail(n);
        }
    }

    static void updateBasketBallCollisions(int n, boolean bl) {
        int n2 = n * PROJECTILE_MAX_VALS;
        int n3 = PROJECTILES[n2 + PROJECTILE_TYPE];
        int n4 = CollisionHandler.checkProjectilePlantCollisions(n);
        if (n4 != -1) {
            Plants.takeDamage(n4, "\u0014\u0014((\u0014(P\u0014K\u0014\u0014\u0014".charAt(n3), false);
            Projectiles.killProjectile(n);
        } else if (bl) {
            Projectiles.killProjectile(n);
        }
    }

    static {
        PROJECTILE_OFFSET_X = 0;
        PROJECTILE_OFFSET_Y = PROJECTILE_OFFSET_X + 1;
        PROJECTILE_OFFSET_SHADOW_X = PROJECTILE_OFFSET_Y + 1;
        PROJECTILE_OFFSET_SHADOW_Y = PROJECTILE_OFFSET_SHADOW_X + 1;
        PROJECTILE_OFFSET_MAX_VALS = PROJECTILE_OFFSET_SHADOW_Y + 1;
        PROJECTILE_OFFSETS = new int[PROJECTILE_OFFSET_MAX_VALS];
        FP1 = 4096;
        PROJECTILE_RECT = new int[4];
        PROJECTILE_RECT_X = 0;
        PROJECTILE_RECT_Y = 1;
        PROJECTILE_RECT_W = 2;
        PROJECTILE_RECT_H = 3;
    }
}

