/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DashFont {
    private Image m_img;
    private String m_format;
    private int m_charWidth;
    private int m_charHeight;
    private boolean m_isSystemFont = false;
    private Font m_systemFont = null;
    private int m_sysFontColor = 0xFFFFFF;
    public static int FORCE_CASE_NONE = 0;
    public static int FORCE_CASE_UPPER = 1;
    public static int FORCE_CASE_LOWER = 2;
    private int m_forceCase = FORCE_CASE_NONE;

    public DashFont(String fileID, String format) {
        this.init(fileID, format);
    }

    public DashFont(String fileID) {
        this.init(fileID, "");
    }

    public DashFont(Font font) {
        this.m_isSystemFont = true;
        this.m_systemFont = font;
    }

    public void forceCase(int force) {
        this.m_forceCase = force;
    }

    private void init(String fileID, String format) {
        this.m_format = format;
        if (this.m_format == null) {
            System.out.println("format string not found for DashFont " + this.m_img);
            throw new Error("null formatted font, fileid " + fileID);
        }
        Image tmp = null;
        try {
            tmp = Image.createImage((String)fileID);
        }
        catch (Throwable skeet) {
            skeet.printStackTrace();
        }
        if (tmp == null) {
            System.out.println("error allocating DashFont " + fileID);
            return;
        }
        this.m_img = tmp;
        this.m_charWidth = tmp.getWidth() / this.m_format.length();
        this.m_charHeight = tmp.getHeight();
        this.m_forceCase = FORCE_CASE_UPPER;
    }

    public void setColor(int color) {
        this.m_sysFontColor = color;
    }

    public int getIndex(char ch) {
        return this.m_format.indexOf(ch);
    }

    public boolean isValidChar(char ch) {
        return this.getIndex(ch) != -1;
    }

    public void drawString(Graphics g, String str, int x, int y, int align) {
        if (this.m_isSystemFont) {
            g.setFont(this.m_systemFont);
            int oldColor = g.getColor();
            g.setColor(this.m_sysFontColor);
            g.drawString(str, x, y, align);
            g.setColor(oldColor);
        } else {
            int clipx = g.getClipX();
            int clipy = g.getClipY();
            int clipw = g.getClipWidth();
            int cliph = g.getClipHeight();
            Image img = this.m_img;
            if (img == null) {
                System.out.println("cannot draw font " + this.m_img + ", img allocation error.  trying to draw string " + str);
                g.drawString(str, x, y, align);
                return;
            }
            if ((align & 1) != 0) {
                x -= str.length() * this.m_charWidth / 2;
            } else if ((align & 8) != 0) {
                x -= str.length() * this.m_charWidth;
            }
            if ((align & 2) != 0) {
                y -= this.m_charHeight / 2;
            } else if ((align & 0x20) != 0) {
                y -= this.m_charHeight;
            }
            if (this.m_forceCase != FORCE_CASE_NONE) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    str = str.toUpperCase();
                }
                if (this.m_forceCase == FORCE_CASE_LOWER) {
                    str = str.toLowerCase();
                }
            }
            for (int i = 0; i < str.length(); ++i) {
                int frameTmp = this.m_format.indexOf(str.charAt(i));
                if (frameTmp == -1) continue;
                g.clipRect(x + i * this.m_charWidth, y, this.m_charWidth, this.m_charHeight);
                g.drawImage(img, x + i * this.m_charWidth - frameTmp * this.m_charWidth, y, 20);
                g.setClip(clipx, clipy, clipw, cliph);
            }
        }
    }

    protected void drawString_faster(Graphics g, String str, int x, int y) {
        if (this.m_isSystemFont) {
            g.setFont(this.m_systemFont);
            int oldColor = g.getColor();
            g.setColor(this.m_sysFontColor);
            g.drawString(str, x, y, 20);
            g.setColor(oldColor);
        } else {
            Image img = this.m_img;
            for (int i = 0; i < str.length(); ++i) {
                int frameTmp = this.m_format.indexOf(str.charAt(i));
                if (frameTmp == -1) continue;
                int sx = x + i * this.m_charWidth;
                g.setClip(sx, y, this.m_charWidth, this.m_charHeight);
                g.drawImage(img, -(frameTmp * this.m_charWidth) + sx, y, 20);
            }
        }
    }

    public int stringWidth(String str) {
        if (this.m_isSystemFont) {
            return this.m_systemFont.stringWidth(str);
        }
        return str.length() * this.m_charWidth;
    }

    public int getHeight() {
        if (this.m_isSystemFont) {
            return this.m_systemFont.getHeight();
        }
        return this.m_charHeight;
    }

    public int getWidth() {
        if (this.m_isSystemFont) {
            return this.m_systemFont.charWidth('W');
        }
        return this.m_charWidth;
    }

    public String[] wrap(String text, int width) {
        String[] retval = WordWrap.WrapString(width, text, this);
        if (this.m_forceCase != FORCE_CASE_NONE) {
            for (int i = 0; i < retval.length; ++i) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    retval[i] = retval[i].toUpperCase();
                }
                if (this.m_forceCase != FORCE_CASE_LOWER) continue;
                retval[i] = retval[i].toLowerCase();
            }
        }
        return retval;
    }
}

