/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.sys.FixedPoint;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GfxUtils {
    private static int colour = -1;
    public static final int rgbToGreyR = FixedPoint.stringToFP("0.30") / 3;
    public static final int rgbToGreyG = FixedPoint.stringToFP("0.59") / 3;
    public static final int rgbToGreyB = FixedPoint.stringToFP("0.11") / 3;

    public static final void drawCircle(Graphics g, int x, int y, int r, int points) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        int x0 = 0;
        int y0 = 0;
        int fp_r = r < 0 ? -(-r << 16) : r << 16;
        int fp_i_to_angle = (int)(0x10000000000L / (long)(points < 0 ? -(-points << 16) : points << 16));
        for (int i = 0; i <= points; ++i) {
            int fp_i = i < 0 ? -(-i << 16) : i << 16;
            int x1 = FixedPoint.sinLut(((fp_i ^ fp_i_to_angle) & 0x8000000) != 0 ? -((int)((long)(-fp_i) * (long)fp_i_to_angle >> 16)) : (int)((long)fp_i * (long)fp_i_to_angle >> 16));
            int y1 = FixedPoint.sinLut((((fp_i ^ fp_i_to_angle) & 0x8000000) != 0 ? -((int)((long)(-fp_i) * (long)fp_i_to_angle >> 16)) : (int)((long)fp_i * (long)fp_i_to_angle >> 16)) + 0x400000);
            x1 = ((x1 ^ fp_r) & 0x8000000) != 0 ? -((int)((long)(-x1) * (long)fp_r >> 16)) : (int)((long)x1 * (long)fp_r >> 16);
            x1 = x + (x1 < 0 ? -(-x1 >> 16) : x1 >> 16);
            y1 = ((y1 ^ fp_r) & 0x8000000) != 0 ? -((int)((long)(-y1) * (long)fp_r >> 16)) : (int)((long)y1 * (long)fp_r >> 16);
            y1 = y + (y1 < 0 ? -(-y1 >> 16) : y1 >> 16);
            if (i > 0) {
                g.drawLine(x0, y0, x1, y1);
            }
            x0 = x1;
            y0 = y1;
        }
    }

    public static final void drawPoint(Graphics g, int x, int y) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        g.drawLine(x - 1, y, x + 1, y);
        g.drawLine(x, y - 1, x, y + 1);
    }

    public static void setColor(Graphics g, int col) {
        colour = 0xFF000000 | col;
        g.setColor(colour);
    }

    public static void drawTriangle(Graphics g, int x0, int y0, int x1, int y1, int x2, int y2) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        g.fillTriangle(x0, y0, x1, y1, x2, y2);
    }

    public static final void drawCrossHatch(Graphics g, int col, int x0, int y0, int w, int h) {
        g.setClip(x0, y0, w, h);
        ImageSequence.clipSet = true;
        g.setColor(col);
        for (int x = 0; x < w; x += 2) {
            g.drawLine(x0 + x, y0, x0 + x + w, y0 + w);
        }
        for (int y = 0; y < h; y += 2) {
            g.drawLine(x0, y0 + y, x0 + h, y0 + y + h);
        }
    }

    public static final int lerpColour(int t, int rgb0, int rgb1) {
        int red = (rgb1 >> 16 & 0xFF) - (rgb0 >> 16 & 0xFF);
        int green = (rgb1 >> 8 & 0xFF) - (rgb0 >> 8 & 0xFF);
        int blue = (rgb1 & 0xFF) - (rgb0 & 0xFF);
        red = red < 0 ? -(-red << 16) : red << 16;
        red = ((red ^ t) & 0x8000000) != 0 ? -((int)((long)(-red) * (long)t >> 16)) : (int)((long)red * (long)t >> 16);
        red = (red < 0 ? -(-red >> 16) : red >> 16) + (rgb0 >> 16 & 0xFF);
        green = green < 0 ? -(-green << 16) : green << 16;
        green = ((green ^ t) & 0x8000000) != 0 ? -((int)((long)(-green) * (long)t >> 16)) : (int)((long)green * (long)t >> 16);
        green = (green < 0 ? -(-green >> 16) : green >> 16) + (rgb0 >> 8 & 0xFF);
        blue = blue < 0 ? -(-blue << 16) : blue << 16;
        blue = ((blue ^ t) & 0x8000000) != 0 ? -((int)((long)(-blue) * (long)t >> 16)) : (int)((long)blue * (long)t >> 16);
        blue = (blue < 0 ? -(-blue >> 16) : blue >> 16) + (rgb0 & 0xFF);
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static final int[] resampleImage(Image src, int dst_width, int dst_height) {
        if (src == null) {
            return null;
        }
        int src_width = src.getWidth();
        int src_height = src.getHeight();
        try {
            int[] src_rgb = new int[src_width * src_height];
            if (src_rgb == null) {
                return null;
            }
            src.getRGB(src_rgb, 0, src_width, 0, 0, src_width, src_height);
            int[] dst_rgb = new int[dst_width * dst_height];
            int fp_scale_x = (int)(((long)(src_width < 0 ? -(-src_width << 16) : src_width << 16) << 16) / (long)(dst_width < 0 ? -(-dst_width << 16) : dst_width << 16));
            int fp_scale_y = (int)(((long)(src_height < 0 ? -(-src_height << 16) : src_height << 16) << 16) / (long)(dst_height < 0 ? -(-dst_height << 16) : dst_height << 16));
            for (int y = 0; y < dst_height; ++y) {
                for (int x = 0; x < dst_width; ++x) {
                    int count = 0;
                    long r = 0L;
                    long g = 0L;
                    long b = 0L;
                    for (int y0 = y * fp_scale_y < 0 ? -(-(y * fp_scale_y) >> 16) : y * fp_scale_y >> 16; y0 < ((y + 1) * fp_scale_y < 0 ? -(-((y + 1) * fp_scale_y) >> 16) : (y + 1) * fp_scale_y >> 16); ++y0) {
                        for (int x0 = x * fp_scale_x < 0 ? -(-(x * fp_scale_x) >> 16) : x * fp_scale_x >> 16; x0 < ((x + 1) * fp_scale_x < 0 ? -(-((x + 1) * fp_scale_x) >> 16) : (x + 1) * fp_scale_x >> 16); ++x0) {
                            int pixel = src_rgb[y0 * src_width + x0];
                            r += (long)(pixel >> 16 & 0xFF);
                            g += (long)(pixel >> 8 & 0xFF);
                            b += (long)(pixel & 0xFF);
                            ++count;
                        }
                    }
                    int ir = (int)(r / (long)count);
                    int ig = (int)(g / (long)count);
                    int ib = (int)(b / (long)count);
                    dst_rgb[y * dst_width + x] = (ir & 0xFF) << 16 | (ig & 0xFF) << 8 | ib & 0xFF;
                }
            }
            src_rgb = null;
            return dst_rgb;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void colourizePng(byte[] png_file, int colour) {
        int palOffset = 0;
        for (int i = 0; i < png_file.length - 4; ++i) {
            if (png_file[i] != 80 || png_file[i + 1] != 76 || png_file[i + 2] != 84) continue;
            palOffset = i;
            System.out.println("PALETTE offset " + palOffset);
            break;
        }
        int dataOffset = palOffset - 4;
        int numColors = ((png_file[dataOffset] & 0xFF) << 24 | (png_file[dataOffset + 1] & 0xFF) << 16 | (png_file[dataOffset + 2] & 0xFF) << 8 | png_file[dataOffset + 3] & 0xFF) & 0xFFFFFFFF;
        System.out.println("PALETTE numColors " + numColors);
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        for (int i = dataOffset += 8; i < dataOffset + numColors; i += 3) {
            int r_c = png_file[i] & 0xFF;
            int g_c = png_file[i + 1] & 0xFF;
            int b_c = png_file[i + 2] & 0xFF;
            png_file[i] = (byte)(r * r_c >> 8);
            png_file[i + 1] = (byte)(g * g_c >> 8);
            png_file[i + 2] = (byte)(b * b_c >> 8);
        }
    }

    public static final Image createDarkImage(Image image, int x0, int y0, int w, int h) {
        try {
            System.out.println("createDarkImage() - allocating screen buffer");
            int area = w * h;
            int[] rgb = new int[area];
            if (rgb == null) {
                return null;
            }
            image.getRGB(rgb, 0, image.getWidth(), x0, y0, w, h);
            image = null;
            System.out.println("createDarkImage() - processing...");
            for (int i = 0; i < area; ++i) {
                int old = rgb[i];
                int r = old >> 16 & 0xFF;
                int g = old >> 8 & 0xFF;
                int b = old & 0xFF;
                int grey = r * rgbToGreyR + g * rgbToGreyG + b * rgbToGreyB >> 16;
                grey = (grey & 0xFF) << 16 | (grey & 0xFF) << 8 | grey & 0xFF;
                old = GfxUtils.lerpColour(16384, grey, old);
                r = old >> 16 & 0xFF;
                g = old >> 8 & 0xFF;
                b = old & 0xFF;
                rgb[i] = (r - (r >> 2) & 0xFF) << 16 | (g - (g >> 2) & 0xFF) << 8 | b - (b >> 2) & 0xFF;
            }
            System.out.println("createDarkImage() - writing buffer to image");
            Image output = Image.createRGBImage((int[])rgb, (int)w, (int)h, (boolean)false);
            rgb = null;
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }
}

