/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ImageSet;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageSequence {
    public static boolean doNotClip = false;
    public static boolean forceRedraw = false;
    public static final int IS_X = 0;
    public static final int IS_Y = 1;
    public static final int IS_WIDTH = 2;
    public static final int IS_HEIGHT = 3;
    public static final int IS_OFFSETX = 4;
    public static final int IS_OFFSETY = 5;
    public static final int IS_ORIGWIDTH = 6;
    public static final int IS_ORIGHEIGHT = 7;
    public static final int IS_MAX = 8;
    public static final int IS_SHIFT = 3;
    byte flags;
    public int numFrames;
    public int currentFrame;
    public short[] clipRects;
    public byte clipRectsStride;
    public Vector vecImageFilenames = new Vector();
    public Image[] imageFrame;
    public byte[] imageIndex;
    private static int[] tempClip = new int[4];
    private static int[] clip = new int[4];
    public static boolean clipSet = false;

    public void setup(byte lFlags, int lFrames, int liTotalNumPages) {
        this.flags = lFlags;
        this.numFrames = lFrames;
        if ((this.flags & 2) != 0) {
            System.out.println("ImageSequence contains offsets");
        }
        this.clipRectsStride = (byte)((this.flags & 2) != 0 ? 8 : 4);
        this.clipRects = new short[this.numFrames * this.clipRectsStride];
        if (liTotalNumPages > 1) {
            this.imageIndex = new byte[this.numFrames];
        }
        this.imageFrame = new Image[liTotalNumPages];
    }

    public short getRectWidth(int frame) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[frame * this.clipRectsStride + 6];
        }
        return this.clipRects[frame * this.clipRectsStride + 2];
    }

    public short getRectHeight(int frame) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[frame * this.clipRectsStride + 7];
        }
        return this.clipRects[frame * this.clipRectsStride + 3];
    }

    public short getClipRectX(int frame) {
        return this.clipRects[frame * this.clipRectsStride + 0];
    }

    public short getClipRectY(int frame) {
        return this.clipRects[frame * this.clipRectsStride + 1];
    }

    public short getClipRectWidth(int frame) {
        return this.clipRects[frame * this.clipRectsStride + 2];
    }

    public short getClipRectHeight(int frame) {
        return this.clipRects[frame * this.clipRectsStride + 3];
    }

    private short getOffsetX(int frame) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[frame * this.clipRectsStride + 4];
        }
        return 0;
    }

    private short getOffsetY(int frame) {
        if ((this.flags & 2) != 0) {
            return this.clipRects[frame * this.clipRectsStride + 5];
        }
        return 0;
    }

    public void setRect(int frame, int x0, int y0, int w, int h, int offsetX, int offsetY, int originalWidth, int originalHeight) {
        if ((2 & this.flags) != 0) {
            this.clipRects[frame * this.clipRectsStride + 0] = (short)x0;
            this.clipRects[frame * this.clipRectsStride + 1] = (short)y0;
            this.clipRects[frame * this.clipRectsStride + 4] = (short)offsetX;
            this.clipRects[frame * this.clipRectsStride + 5] = (short)offsetY;
            this.clipRects[frame * this.clipRectsStride + 2] = (short)originalWidth;
            this.clipRects[frame * this.clipRectsStride + 3] = (short)originalHeight;
            this.clipRects[frame * this.clipRectsStride + 6] = (short)w;
            this.clipRects[frame * this.clipRectsStride + 7] = (short)h;
            System.out.println("SET RECT : cropWidth : " + w + " : cropHeight : " + h + " : origWidth : " + originalWidth + " : origHeight : " + originalHeight);
        } else {
            this.clipRects[frame * this.clipRectsStride + 0] = (short)x0;
            this.clipRects[frame * this.clipRectsStride + 1] = (short)y0;
            this.clipRects[frame * this.clipRectsStride + 2] = (short)w;
            this.clipRects[frame * this.clipRectsStride + 3] = (short)h;
        }
    }

    public void copyRect(int dst_frame, ImageSequence other, int src_frame) {
        this.clipRects[dst_frame * this.clipRectsStride + 0] = other.clipRects[src_frame * this.clipRectsStride + 0];
        this.clipRects[dst_frame * this.clipRectsStride + 1] = other.clipRects[src_frame * this.clipRectsStride + 1];
        this.clipRects[dst_frame * this.clipRectsStride + 2] = other.clipRects[src_frame * this.clipRectsStride + 2];
        this.clipRects[dst_frame * this.clipRectsStride + 3] = other.clipRects[src_frame * this.clipRectsStride + 3];
        if ((2 & this.flags) != 0 && (2 & other.flags) != 0) {
            this.clipRects[dst_frame * this.clipRectsStride + 4] = other.clipRects[src_frame * this.clipRectsStride + 4];
            this.clipRects[dst_frame * this.clipRectsStride + 5] = other.clipRects[src_frame * this.clipRectsStride + 5];
            this.clipRects[dst_frame * this.clipRectsStride + 6] = other.clipRects[src_frame * this.clipRectsStride + 6];
            this.clipRects[dst_frame * this.clipRectsStride + 7] = other.clipRects[src_frame * this.clipRectsStride + 7];
        }
    }

    public int addImageIfNew(String filename) {
        int i = this.getImageIndex(filename);
        if (i == -1) {
            i = this.vecImageFilenames.size();
            this.vecImageFilenames.addElement(filename);
        }
        return i;
    }

    public int getImageIndex(String filename) {
        for (int i = 0; i < this.vecImageFilenames.size(); ++i) {
            String str = (String)this.vecImageFilenames.elementAt(i);
            if (!str.equals(filename)) continue;
            return i;
        }
        return -1;
    }

    public Image getImage(int frame) {
        if (this.imageIndex == null) {
            return this.imageFrame[0];
        }
        return this.imageFrame[this.imageIndex[frame]];
    }

    public static ImageSequence createFromImage(String filename) {
        ImageSequence seq = new ImageSequence();
        if (filename.startsWith("/")) {
            filename = filename.substring(1, filename.length());
        }
        seq.vecImageFilenames = new Vector();
        seq.addImageIfNew(filename);
        seq.setup((byte)0, 1, 1);
        seq.imageFrame[0] = ImageSet.loadImage("/" + filename);
        if (seq.imageFrame[0] != null) {
            seq.setRect(0, 0, 0, seq.imageFrame[0].getWidth(), seq.imageFrame[0].getHeight(), 0, 0, 0, 0);
        } else {
            seq.setRect(0, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        return seq;
    }

    public static ImageSequence createFromImage(Image image) {
        ImageSequence seq = new ImageSequence();
        seq.setup((byte)0, 1, 1);
        seq.imageFrame[0] = image;
        if (seq.imageFrame[0] == null) {
            seq.setRect(0, 0, 0, 0, 0, 0, 0, 0, 0);
            return null;
        }
        seq.setRect(0, 0, 0, image.getWidth(), image.getHeight(), 0, 0, 0, 0);
        seq.numFrames = 1;
        return seq;
    }

    public static ImageSequence createBlank(int width, int height, int frames, byte flags) {
        try {
            ImageSequence seq = new ImageSequence();
            seq.setup(flags, frames, 1);
            for (int i = 0; i < frames; ++i) {
                seq.clipRects[i * seq.clipRectsStride + 0] = (short)(i * width / frames);
                seq.clipRects[i * seq.clipRectsStride + 1] = 0;
                seq.clipRects[i * seq.clipRectsStride + 2] = (short)(width / frames);
                seq.clipRects[i * seq.clipRectsStride + 3] = (short)height;
                System.out.println("createBlank[" + i + "] x0=" + seq.clipRects[i * seq.clipRectsStride + 0] + "y0=" + seq.clipRects[i * seq.clipRectsStride + 1] + "w=" + seq.clipRects[i * seq.clipRectsStride + 2] + "h=" + seq.clipRects[i * seq.clipRectsStride + 3]);
            }
            seq.imageFrame[0] = Image.createImage((int)width, (int)height);
            return seq;
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nImageSequence.createBlank() - Exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
            return null;
        }
    }

    public void copyFrame(ImageSequence seq, int src_frame, int dst_frame) {
        try {
            this.setRect(dst_frame, dst_frame * seq.getClipRectWidth(src_frame), 0, seq.getClipRectWidth(src_frame), seq.getClipRectHeight(src_frame), seq.getOffsetX(src_frame), seq.getOffsetY(src_frame), seq.getRectWidth(src_frame), seq.getRectHeight(src_frame));
            if (seq.getImage(src_frame) != null) {
                Graphics g = this.getImage(dst_frame).getGraphics();
                seq.drawImage(g, src_frame, this.getClipRectX(dst_frame), this.getClipRectY(dst_frame));
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nImageSequence.copyFrame() - Exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public void copyFrame(Image imgSrc, int dst_frame) {
        try {
            Graphics g = this.getImage(dst_frame).getGraphics();
            g.drawImage(imgSrc, (int)this.getClipRectX(dst_frame), 0, 20);
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nImageSequence.copyFrame() - Exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public void drawIntoFrame(Image src_img, int dst_frame) {
        try {
            this.setRect(dst_frame, dst_frame * src_img.getWidth(), 0, src_img.getWidth(), src_img.getHeight(), 0, 0, 0, 0);
            Graphics g = this.getImage(dst_frame).getGraphics();
            g.drawImage(src_img, dst_frame * src_img.getWidth(), 0, 20);
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nImageSequence.copyFrame() - Exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public void unload() {
        if (this.imageFrame == null) {
            System.out.println("Assertion Failure: imageFrame != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSequence.java[384]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.imageFrame.length; ++i) {
            this.imageFrame[i] = null;
        }
    }

    public void reload() {
        if (this.imageFrame == null) {
            System.out.println("Assertion Failure: imageFrame != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSequence.java[403]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.vecImageFilenames.size(); ++i) {
            String filename = (String)this.vecImageFilenames.elementAt(i);
            if (this.imageFrame[i] != null) continue;
            this.imageFrame[i] = ImageSet.loadImage("/" + filename);
        }
    }

    public void setLoaded(int start, int len) {
        int i;
        System.out.println("setLoaded(" + start + "," + len + ")");
        int loadedMask = 0;
        for (i = 0; i < this.numFrames; ++i) {
            if (i < start || i - start >= len) continue;
            loadedMask |= 1 << this.imageIndex[i];
        }
        for (i = 0; i < this.imageFrame.length; ++i) {
            if ((loadedMask & 1 << i) != 0) continue;
            this.imageFrame[i] = null;
        }
        for (i = 0; i < this.imageFrame.length; ++i) {
            if ((loadedMask & 1 << i) == 0) continue;
            String filename = (String)this.vecImageFilenames.elementAt(i);
            if (this.imageFrame[i] == null) {
                this.imageFrame[i] = ImageSet.loadImage("/" + filename);
                continue;
            }
            System.out.println("already cached: " + filename);
        }
    }

    public void drawImage(Graphics g, int frame, int x, int y) {
        if ((2 & this.flags) != 0) {
            x += this.getOffsetX(frame);
            y += this.getOffsetY(frame);
        }
        ImageSequence.tempClip[0] = BaseScreen.visibleRect.x0;
        ImageSequence.tempClip[1] = BaseScreen.visibleRect.y0;
        ImageSequence.tempClip[2] = BaseScreen.visibleRect.w;
        ImageSequence.tempClip[3] = BaseScreen.visibleRect.h;
        this.drawImageClipped(g, frame, x, y, tempClip);
    }

    public void drawImageTrans(Graphics g, int frame, int x, int y, int trans) {
        try {
            if (this.getImage(frame) == null) {
                return;
            }
            if (doNotClip || x + this.getClipRectWidth(frame) > BaseScreen.visibleRect.x0 && x - BaseScreen.visibleRect.x0 < BaseScreen.displayWidth && y + this.getClipRectHeight(frame) > BaseScreen.visibleRect.y0 && y - BaseScreen.visibleRect.y0 < BaseScreen.displayHeight) {
                if (clipSet) {
                    g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                    clipSet = false;
                }
                int w = (this.getClipRectX(frame) + this.getClipRectWidth(frame) < this.getImage(frame).getWidth() ? this.getClipRectX(frame) + this.getClipRectWidth(frame) : this.getImage(frame).getWidth()) - this.getClipRectX(frame);
                int h = (this.getClipRectY(frame) + this.getClipRectHeight(frame) < this.getImage(frame).getHeight() ? this.getClipRectY(frame) + this.getClipRectHeight(frame) : this.getImage(frame).getHeight()) - this.getClipRectY(frame);
                g.drawRegion(this.getImage(frame), (int)this.getClipRectX(frame), (int)this.getClipRectY(frame), w, h, trans, x, y, 20);
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\ndrawImageTrans " + e + "\n*******************************************************\n\n");
        }
    }

    public void drawImageClipped(Graphics g, int frame, int x, int y, int[] rect) {
        try {
            if (this.getImage(frame) == null) {
                return;
            }
            ImageSequence.clip[0] = x > rect[0] ? x : rect[0];
            ImageSequence.clip[1] = y > rect[1] ? y : rect[1];
            int w = (this.getClipRectX(frame) + this.getClipRectWidth(frame) < this.getImage(frame).getWidth() ? this.getClipRectX(frame) + this.getClipRectWidth(frame) : this.getImage(frame).getWidth()) - this.getClipRectX(frame);
            int h = (this.getClipRectY(frame) + this.getClipRectHeight(frame) < this.getImage(frame).getHeight() ? this.getClipRectY(frame) + this.getClipRectHeight(frame) : this.getImage(frame).getHeight()) - this.getClipRectY(frame);
            ImageSequence.clip[2] = (x + w < rect[0] + rect[2] ? x + w : rect[0] + rect[2]) - clip[0];
            ImageSequence.clip[3] = (y + h < rect[1] + rect[3] ? y + h : rect[1] + rect[3]) - clip[1];
            if (clip[2] > 0 && clip[3] > 0) {
                if (clipSet) {
                    g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                    clipSet = false;
                }
                g.drawRegion(this.getImage(frame), this.getClipRectX(frame) + (clip[0] - x), this.getClipRectY(frame) + (clip[1] - y), clip[2], clip[3], 0, clip[0], clip[1], 20);
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\ndrawImageClipped " + e + " on frame: " + frame + " max: " + this.numFrames + " name: " + (String)this.vecImageFilenames.elementAt(0) + "\n*******************************************************\n\n");
        }
    }

    public void drawImageDirty(Graphics g, int frame, int x, int y, int[] dirty, int[] rect) {
        try {
            if (this.getImage(frame) == null) {
                return;
            }
            if (frame >= this.numFrames) {
                System.out.println("Assertion Failure: frame < numFrames\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/ImageSequence.java[550]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ImageSequence.clip[0] = x > BaseScreen.visibleRect.x0 ? x : (int)BaseScreen.visibleRect.x0;
            ImageSequence.clip[1] = y > BaseScreen.visibleRect.y0 ? y : (int)BaseScreen.visibleRect.y0;
            ImageSequence.clip[2] = x + this.getRectWidth(frame) < BaseScreen.visibleRect.x0 + BaseScreen.visibleRect.w ? x + this.getRectWidth(frame) : BaseScreen.visibleRect.x0 + BaseScreen.visibleRect.w;
            int n = ImageSequence.clip[3] = y + this.getRectHeight(frame) < BaseScreen.visibleRect.y0 + BaseScreen.visibleRect.h ? y + this.getRectHeight(frame) : BaseScreen.visibleRect.y0 + BaseScreen.visibleRect.h;
            if (rect != null) {
                ImageSequence.clip[0] = clip[0] > rect[0] ? clip[0] : rect[0];
                ImageSequence.clip[1] = clip[1] > rect[1] ? clip[1] : rect[1];
                ImageSequence.clip[2] = (clip[2] < rect[0] + rect[2] ? clip[2] : rect[0] + rect[2]) - clip[0];
                ImageSequence.clip[3] = (clip[3] < rect[1] + rect[3] ? clip[3] : rect[1] + rect[3]) - clip[1];
            }
            clip[2] = clip[2] - clip[0];
            clip[3] = clip[3] - clip[1];
            if (forceRedraw || clip[0] != dirty[0] || clip[1] != dirty[1] || clip[2] != dirty[2] || clip[3] != dirty[3] || frame != dirty[4]) {
                if (clip[2] > 0 && clip[3] > 0) {
                    if (clipSet) {
                        g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                        clipSet = false;
                    }
                    g.drawRegion(this.getImage(frame), this.getClipRectX(frame) + (clip[0] - x), this.getClipRectY(frame) + (clip[1] - y), clip[2], clip[3], 0, clip[0], clip[1], 20);
                }
                dirty[0] = clip[0];
                dirty[1] = clip[1];
                dirty[2] = clip[2];
                dirty[3] = clip[3];
                dirty[4] = frame;
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\ndrawImageDirty " + e + "\n*******************************************************\n\n");
        }
    }

    public void undrawImageDirty(Graphics g, Image imgBG, int x, int y, int[] dirty) {
        try {
            if (imgBG == null) {
                return;
            }
            ImageSequence.clip[0] = dirty[0] > BaseScreen.visibleRect.x0 ? dirty[0] : BaseScreen.visibleRect.x0;
            ImageSequence.clip[1] = dirty[1] > BaseScreen.visibleRect.y0 ? dirty[1] : BaseScreen.visibleRect.y0;
            ImageSequence.clip[2] = (dirty[2] + dirty[0] < BaseScreen.visibleRect.x0 + BaseScreen.visibleRect.w ? dirty[2] + dirty[0] : BaseScreen.visibleRect.x0 + BaseScreen.visibleRect.w) - clip[0];
            ImageSequence.clip[3] = (dirty[3] + dirty[1] < BaseScreen.visibleRect.y0 + BaseScreen.visibleRect.h ? dirty[3] + dirty[1] : BaseScreen.visibleRect.y0 + BaseScreen.visibleRect.h) - clip[1];
            if (clip[2] > 0 && clip[3] > 0 && dirty[4] != -1) {
                if (clipSet) {
                    g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                    clipSet = false;
                }
                g.drawRegion(imgBG, clip[0], clip[1], clip[2], clip[3], 0, clip[0], clip[1], 20);
                dirty[4] = -1;
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nundrawImageDirty " + e + " " + clip[0] + "," + clip[1] + "," + clip[2] + "," + clip[3] + "\n*******************************************************\n\n");
        }
    }
}

