/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameEffects;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameSequence;
import com.slg.j2me.game.HiscoreTable;
import com.slg.j2me.game.MapScreen;
import com.slg.j2me.game.ShopScreen;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gfx.Software3D;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.control.ControlHandler;
import com.slg.j2me.lib.gui.control.GuiControl;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.MenuLayout;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.gui.layout.TextLayout;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.sys.VecMath;
import com.slg.j2me.lib.util.CSVLoader;
import com.slg.j2me.lib.util.MultiLingual;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends ScreenLayout
implements ControlHandler {
    public static final boolean cacheImagesSysmem = true;
    public static final boolean cameraTopDownOnly = false;
    public static final boolean veryLazyPrediction = false;
    private boolean editNearClipPlane = false;
    public static GameLogic game;
    public static boolean loaded;
    public static ImageSet isGame;
    public static ImageSet isFish;
    public static BitmapFont fontGame;
    public static BitmapFont speechFont;
    public static ImageSequence gfxGameMenu;
    public static ImageSequence gfxPauseMenu;
    public static ImageSequence gfxGaugeEnergy;
    public static ImageSequence gfxGaugeTension;
    public static ImageSequence gfxGaugeIcons;
    public static ImageSequence gfxLeftArrow;
    public static ImageSequence gfxRightArrow;
    public static ImageSequence gfxDownArrow;
    public static ImageSequence gfxReel;
    public static ImageSequence gfxLureIcons;
    public static TextLayout textGameInfo;
    public static TextLayout[] textHiScoreColumns;
    public static TextLayout textFishCaught;
    public static TextLayout textLureDesc;
    int currentFishFrame = 0;
    public static MenuLayout currentMenu;
    public static MenuLayout menuPause;
    public static GuiControl controlPauseTitle;
    public static GuiControl controlOptions;
    public static GuiControl controlMainMenu;
    public static GuiControl controlResume;
    public static GuiControl controlForceWin;
    public static final int arcShift = 0;
    public static MenuLayout menuOptions;
    public static GuiControl controlOptionsTitle;
    public static GuiControl controlOptionsResume;
    public static GuiControl controlSound;
    public static GuiControl controlVibrate;
    private static final int cPauseOff = 0;
    private static final int cPauseMenu = 1;
    private static final int cPauseGame = 2;
    private static final int cPauseSelectLure = 3;
    private static final int cPauseShowFish = 4;
    private static int pauseState;
    private static final int cfpPauseMenuTime = 16384;
    private static int fpPauseTimer;
    private boolean quitConfirm;
    private static final int cGameMenuMain = 0;
    private static final int cGameMenuBoat = 1;
    private static final int cGameMenuFish = 2;
    private static final int cGameMenuTackle = 3;
    private static int gameIconSel;
    private static int gameLureIconSel;
    private static int[] gameLureList;
    private static int gameLureCount;
    public static TextLayout textPauseInfo;
    public static TextLayout textQuitConfirm;
    public static final int cItemRod = 0;
    public static final int cItemReel = 1;
    public static final int cItemLine = 2;
    public static final int cItemLure = 3;
    public static final int cItemSpecial = 4;
    public static final int cNumTypes = 5;
    public static final int cArcadeMaxLevels = 5;
    public static short[] cArcadeLocations;
    public static short[][] cArcadeEquipment;
    public static short[] cArcadeTimePerPound;
    public static short[] cArcadePointsPerPound;
    public static short[] cArcadeTimeLimit;
    public static short[] cArcadeTargetPounds;
    public static short[][] cArcadeFishPopulation;
    public static final int cfpRodMaxSpeed;
    public static final int cfpRodMaxSpeedFight;
    public static final int cfpRodMaxSpeedFishing;
    public static final int cfpRodAcc;
    public static final int cfpRodAccFight;
    public static final int cfpRodAccFishing;
    public static final int cfpRodMaxPos;
    public static final int cfpRodMaxPosSlowDownMargin;
    public static final int cfpRodMaxPosOffsetFight;
    public static final int cfpRodMaxPosOffsetFishing;
    public static final int cfpRodTipSpeed;
    public static final int cfpRodTipMaxPos;
    public static final int cfpBoatAnimSpeed;
    public static final int cfpRodSegLenMin;
    public static final int cfpRodSegLenMax;
    public static final int cfpRodAngleMin;
    public static final int cfpRodAngleMax;
    public static final int cfpRodAngleMaxCasting;
    public static final int cfpRodAngleHooked;
    public static final int cfpRodAngleSpeedBend;
    public static final int cfpRodAngleSpeedIdle;
    public static final int cfpRodAngleSpeedLureDrop;
    public static final int cfpRodAngleSpeedCasting;
    public static final int cfpRodPullSmallMin = 262144;
    public static final int cfpRodPullSmallMax = 327680;
    public static final int cfpRodPullMidMin = 458752;
    public static final int cfpRodPullMidMax = 655360;
    public static final int cfpRodPullLargeMin = 655360;
    public static final int cfpRodPullLargeMax = 983040;
    public static final int cfpCastingPowerAcc = 65536;
    public static final int cfpCastingPowerVelocityMax = 65536;
    private static int fpScrollX;
    private static int fpWantedScrollX;
    private int flashTime = 0;
    private int flashDuration = 500;
    private static boolean flashOn;
    private int fastFlashTime = 0;
    private int fastFlashDuration = 150;
    private static boolean fastFlashOn;
    public static int displayWidth;
    public static int displayHeight;
    public static ClipRect visibleRect;
    public static GameEffects gameEffects;
    public int currentBackgroundIndex = -1;
    public static int gameTime;
    public static int savedTime;
    public static final int warnLowTime = 30000;
    private boolean forcedWin = false;
    public int biggestFishWeight = 0;
    public static int arcadeLevel;
    public static int arcadeScore;
    public static int arcadeCatch;
    public static int arcadeFishCaught;
    private boolean shownArcadeCompleteScreen1;
    public static boolean showingArcadeHiScoreTable;
    private int fpMoneyShotWantedRodAngle;
    private int fpMoneyShotWantedAnglePull;
    private int fpMoneyShotWantedRodX;
    private int fpMoneyShotWantedFloatOffsetX;
    private int fpMoneyShotWantedFloatY;
    private int fpMoneyShotWantedFloatZ;
    private int moneyShotTransitionPhase;
    private boolean bFirstTime = true;
    public static int[] selectedItems;
    private static int[][] matView;
    private static int[][] matProj;
    public static final int near;
    public static final int far;
    public static final int aspect;
    public static final int cViewportWidth;
    public static final int cViewCanvasWidth;
    private static int currentCamera;
    private static int[] vecForward;
    private static int[] vecRight;
    static int[] screenPos;
    private static final int cBGSky1 = 0;
    private static final int cBGSky2 = 1;
    private static final int cBGScenery = 2;
    private static final int cBGWater = 3;
    private static final int cBGBoat = 4;
    private static final int cNumBGLayers = 5;
    private Image[] bgLayers = new Image[5];
    private static final int[] bgWaterYpos;
    private final int[] facadeOffsets = new int[]{-91, -98, -100, -89, -80, -80};
    private static boolean bDrawOptionsBack;
    public int[] gameScreenTunes = new int[]{6, 6, 6, 6, 6, 6, 3, 3, 4, 6, 6, 6, 6, 6};
    private static final int cfpRodTipPullBackY;
    private static final int cfpRodTipDefaultY;
    private static final int cfpRodTipDefaultZ;
    private static final int cfpPullbackY = 0x140000;
    private static final int cfpPullbackZ = 0x140000;
    private static final int cfpFloatVelY = 327680;
    private static final int cfpFloatVelZ = 131072;
    private static final int cfpFloatDrop = 655360;
    private boolean bLineStressed = false;
    private boolean bLineBeingReeled = false;
    private boolean bStartedCastingPowerBar = false;
    private int fCastingPowerVelocity = 0;
    private static final int constfpMinCastingRange;
    private static final int constfpMaxCastingRangeCrapRod;
    private static final int constfpMaxCastingRangeAceRod;
    private static final int cfpDroppingRodDampingRange;
    private static final long cMinTimeBetweenDragRipples = 350L;
    private long lastTimeDragged = 0L;
    private static boolean bShowWeighInScreen;
    private static int[] dbgPos;
    private int fire_y0;
    private static String strScrollingMsg;
    public static int scrollMsgWidth;
    public static int scrollMessageXpos;
    private static String weightStr;
    private static String strWeight;
    private static String strCutoff;
    static final int cNumRodJoints = 5;
    static int fpRodAngle;
    static int fpRodLineTension;
    int fpAnglePull = 0;
    int rodTipScrX;
    int rodTipScrY;
    static final int[] rodStartPos;
    public static int[] rodPos;
    static int rodXVel;
    public int bigBoatYwave = 0;
    static int[] floatPos;
    static int[] floatVel;
    static int[] rodTip;
    boolean initLine = true;
    static int cNumLineElements;
    static int cfpMaxLineSegmentLen;
    static int[] fpLineSegmentX;
    static int[] fpLineSegmentY;
    static int[] fpLineSegmentYVel;
    static int lineDrawXoffset;
    static int lineDrawYoffset;
    static int reelFrame;
    static final int cReelSpeed = 30;
    static int reelTimer;
    static final int[] cRodColours;
    private static short[] cRodTensionBonus;
    private static short[] cLineWeightLimit;
    private static short[] cRodMaxPull;
    int[] floatScreenPos = new int[4];
    static final int cRodColDark = 7020043;
    static final int cRodColLight = 0x774E44;
    private int postPauseDelay = 0;
    public static final int cFishColourNear = 1911088;
    public static final int cFishColourFar = 2965835;
    public static final int cWaterColourNear = 2372412;
    public static final int cWaterColourFar = 4482163;
    private int[] fishInWaterScreenPos = new int[4];
    private int[] fishVertPos = new int[3];
    private int[][] fv = new int[4][2];
    private int[] fishTempPos = new int[3];
    static int fp_waterAngle;
    static int fp_boatAngle;
    static int[] fpRodPos;
    private int fpSkyScrollingOffset = 0;
    private static final int cGaugeTop = 0;
    private static final int cGaugeBottom = 1;
    private final int cPowerBarHeight = GameScreen.getScaledY(4) > 2 ? GameScreen.getScaledY(4) : 2;
    private final int cPowerLevels;
    private final ClipRect powerClipRect = new ClipRect(0, GameScreen.getScaledY(140), 0, this.cPowerBarHeight * 10 + 1);
    static final int cBorderX;
    static final int cBorderY;

    private static boolean isPaused() {
        return pauseState != 0;
    }

    public static int getScaledX(int x) {
        return BaseScreen.getScaledX(x);
    }

    public static int getScaledY(int y) {
        return BaseScreen.getScaledY(y);
    }

    public void layout() {
    }

    public void open() {
        this.reload();
        if (pauseState == 1) {
            menuPause.down();
            menuPause.layout();
        }
    }

    public void close() {
        this.unload();
    }

    public GameScreen() {
        this.cPowerLevels = 10;
        displayWidth = BaseScreen.displayWidth;
        displayHeight = BaseScreen.displayHeight;
        visibleRect = BaseScreen.visibleRect;
        System.out.println("Creating GameLogic");
        Application.printMemoryStatus();
        game = new GameLogic();
        Application.printMemoryStatus();
        System.out.println("Created GameLogic");
        isGame = new ImageSet("/game.is", false);
        ImageSet imagesetLarge = new ImageSet("/gamefont.is", true);
        fontGame = new BitmapFont(imagesetLarge, "gamefont");
        if (imagesetLarge.getImageSequence("gamefont") == null) {
            fontGame = ScreenStack.font;
        }
        speechFont = ScreenStack.fontSmall;
        gfxLeftArrow = isGame.getImageSequence("left-arrow");
        gfxRightArrow = isGame.getImageSequence("right-arrow");
        gfxDownArrow = isGame.getImageSequence("down-arrow");
        gfxReel = isGame.getImageSequence("reel");
        gfxPauseMenu = isGame.getImageSequence("pausemenu");
        gfxGaugeEnergy = isGame.getImageSequence("gauge-energy");
        gfxGaugeTension = isGame.getImageSequence("gauge-tension");
        gfxGaugeIcons = isGame.getImageSequence("gauge-icon");
        gfxGameMenu = isGame.getImageSequence("gameicon");
        gfxLureIcons = isGame.getImageSequence("lure-icon");
        if (gfxGameMenu == null) {
            System.out.println("Assertion Failure: gfxGameMenu != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[376]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxLureIcons == null) {
            System.out.println("Assertion Failure: gfxLureIcons != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[377]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxLeftArrow == null) {
            System.out.println("Assertion Failure: gfxLeftArrow != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[380]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxRightArrow == null) {
            System.out.println("Assertion Failure: gfxRightArrow != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[381]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxDownArrow == null) {
            System.out.println("Assertion Failure: gfxDownArrow != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[382]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxReel == null) {
            System.out.println("Assertion Failure: gfxReel != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[383]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxPauseMenu == null) {
            System.out.println("Assertion Failure: gfxPauseMenu != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[384]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxGaugeEnergy == null) {
            System.out.println("Assertion Failure: gfxGaugeEnergy != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[385]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxGaugeTension == null) {
            System.out.println("Assertion Failure: gfxGaugeTension != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[386]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (gfxGaugeIcons == null) {
            System.out.println("Assertion Failure: gfxGaugeIcons != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[387]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        short menuOffset = gfxGameMenu.getRectHeight(0);
        this.fire_y0 = displayHeight - menuOffset - speechFont.getFontHeight();
        GameScreen.textGameInfo.iLayoutFlags = 3;
        GameScreen.textGameInfo.clipRect.y0 = (short)(speechFont.getFontHeight() * 2);
        GameScreen.textGameInfo.clipRect.h = (short)(this.fire_y0 - GameScreen.textGameInfo.clipRect.y0);
        GameScreen.textGameInfo.clipRect.x0 = (short)(displayWidth / 16);
        GameScreen.textGameInfo.clipRect.w = (short)(displayWidth * 7 / 8);
        GameScreen.textFishCaught.iLayoutFlags = GameScreen.textGameInfo.iLayoutFlags;
        GameScreen.textFishCaught.clipRect.x0 = (short)(GameScreen.textGameInfo.clipRect.x0 + 8);
        GameScreen.textFishCaught.clipRect.y0 = (short)(GameScreen.textGameInfo.clipRect.y0 + 8);
        GameScreen.textFishCaught.clipRect.w = (short)(GameScreen.textGameInfo.clipRect.w - 16);
        GameScreen.textFishCaught.clipRect.h = (short)(GameScreen.textGameInfo.clipRect.h - 16);
        GameScreen.textLureDesc.iLayoutFlags = 1;
        short textLureBorderX = (short)(gfxLureIcons.getRectWidth(0) + cBorderX * 2);
        GameScreen.textLureDesc.clipRect.x0 = (short)(textLureBorderX + 8);
        GameScreen.textLureDesc.clipRect.y0 = (short)(speechFont.getFontHeight() * 2 + 8);
        GameScreen.textLureDesc.clipRect.w = (short)(GameScreen.textGameInfo.clipRect.w - textLureBorderX - 16);
        GameScreen.textLureDesc.clipRect.h = (short)(this.fire_y0 - GameScreen.textLureDesc.clipRect.y0 - 16);
        for (int i = 0; i < 2; ++i) {
            GameScreen.textHiScoreColumns[i] = new TextLayout();
            GameScreen.textHiScoreColumns[i].clipRect.w = (short)GameScreen.getScaledX(100);
            GameScreen.textHiScoreColumns[i].clipRect.h = (short)GameScreen.getScaledY(120);
            if (i == 0) {
                GameScreen.textHiScoreColumns[i].iLayoutFlags = 0;
                GameScreen.textHiScoreColumns[i].clipRect.x0 = (short)((displayWidth >> 1) - GameScreen.textHiScoreColumns[i].clipRect.w);
                GameScreen.textHiScoreColumns[i].clipRect.w = (short)displayWidth;
            } else {
                GameScreen.textHiScoreColumns[i].iLayoutFlags = 512;
                GameScreen.textHiScoreColumns[i].clipRect.x0 = (short)(displayWidth >> 1);
            }
            GameScreen.textHiScoreColumns[i].clipRect.y0 = (short)(BaseScreen.displayHeight >> 1);
        }
        GameScreen.textPauseInfo.iLayoutFlags = 3;
        GameScreen.textPauseInfo.clipRect.y0 = (short)(speechFont.getFontHeight() * 2);
        GameScreen.textPauseInfo.clipRect.h = (short)(this.fire_y0 - GameScreen.textPauseInfo.clipRect.y0);
        GameScreen.textGameInfo.clipRect.x0 = (short)(displayWidth / 16);
        GameScreen.textGameInfo.clipRect.w = (short)(displayWidth * 7 / 8);
        GameScreen.textQuitConfirm.iLayoutFlags = 3;
        GameScreen.textQuitConfirm.clipRect.y0 = (short)(speechFont.getFontHeight() * 2);
        GameScreen.textQuitConfirm.clipRect.h = (short)(this.fire_y0 - GameScreen.textPauseInfo.clipRect.y0);
        GameScreen.textQuitConfirm.clipRect.x0 = (short)(displayWidth / 16);
        GameScreen.textQuitConfirm.clipRect.w = (short)(displayWidth * 7 / 8);
        this.initFixedCameras();
        this.setupFixedCamera(0);
        this.createPauseMenu();
        gameEffects = new GameEffects();
        this.initGameData();
        loaded = true;
        this.bFirstTime = true;
    }

    private void initGameData() {
        int i;
        Vector _lStatData = new Vector();
        String[] _headings = CSVLoader.loadCSV("/itemeffects.bin", _lStatData);
        for (i = 0; i < _headings.length; ++i) {
            if (_headings[i].compareTo("RodTensionBonusPercent") == 0) {
                cRodTensionBonus = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cRodTensionBonus != null) continue;
                System.out.println("Assertion Failure: cRodTensionBonus != null with msg: Error loading RodTensionBonusPercent into cRodTensionBonus\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[495]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("LineWeightLbs") == 0) {
                cLineWeightLimit = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cLineWeightLimit != null) continue;
                System.out.println("Assertion Failure: cLineWeightLimit != null with msg: Error loading LineWeightLbs into cLineWeightLimit\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[496]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("ReelSpeed") != 0 || (cRodMaxPull = CSVLoader.getCSVShortArray(_lStatData, i)) != null) continue;
            System.out.println("Assertion Failure: cRodMaxPull != null with msg: Error loading ReelSpeed into cRodMaxPull\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[497]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData.removeAllElements();
        _lStatData = new Vector();
        _headings = CSVLoader.loadCSV("/arcademode.bin", _lStatData);
        for (i = 0; i < _headings.length; ++i) {
            if (_headings[i].compareTo("Location") == 0) {
                cArcadeLocations = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeLocations != null) continue;
                System.out.println("Assertion Failure: cArcadeLocations != null with msg: Error loading Location into cArcadeLocations\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[502]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("TimeSecs") == 0) {
                cArcadeTimeLimit = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeTimeLimit != null) continue;
                System.out.println("Assertion Failure: cArcadeTimeLimit != null with msg: Error loading TimeSecs into cArcadeTimeLimit\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[503]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("BonusPerPound") == 0) {
                cArcadeTimePerPound = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeTimePerPound != null) continue;
                System.out.println("Assertion Failure: cArcadeTimePerPound != null with msg: Error loading BonusPerPound into cArcadeTimePerPound\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[504]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("PointsPerPound") == 0) {
                cArcadePointsPerPound = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadePointsPerPound != null) continue;
                System.out.println("Assertion Failure: cArcadePointsPerPound != null with msg: Error loading PointsPerPound into cArcadePointsPerPound\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[505]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("TargetPounds") == 0) {
                cArcadeTargetPounds = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeTargetPounds != null) continue;
                System.out.println("Assertion Failure: cArcadeTargetPounds != null with msg: Error loading TargetPounds into cArcadeTargetPounds\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[506]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("ReelEquiped") == 0) {
                GameScreen.cArcadeEquipment[1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeEquipment[1] != null) continue;
                System.out.println("Assertion Failure: cArcadeEquipment[cItemReel] != null with msg: Error loading ReelEquiped into cArcadeEquipment[cItemReel]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[507]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("RodEquiped") == 0) {
                GameScreen.cArcadeEquipment[0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeEquipment[0] != null) continue;
                System.out.println("Assertion Failure: cArcadeEquipment[cItemRod] != null with msg: Error loading RodEquiped into cArcadeEquipment[cItemRod]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[508]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("LureEquiped") == 0) {
                GameScreen.cArcadeEquipment[3] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeEquipment[3] != null) continue;
                System.out.println("Assertion Failure: cArcadeEquipment[cItemLure] != null with msg: Error loading LureEquiped into cArcadeEquipment[cItemLure]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[509]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("LineEquiped") == 0) {
                GameScreen.cArcadeEquipment[2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeEquipment[2] != null) continue;
                System.out.println("Assertion Failure: cArcadeEquipment[cItemLine] != null with msg: Error loading LineEquiped into cArcadeEquipment[cItemLine]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[510]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("TinyFish") == 0) {
                GameScreen.cArcadeFishPopulation[0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeFishPopulation[0] != null) continue;
                System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishTiny] != null with msg: Error loading TinyFish into cArcadeFishPopulation[GameLogic.cFishTiny]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[511]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("SmallFish") == 0) {
                GameScreen.cArcadeFishPopulation[1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeFishPopulation[1] != null) continue;
                System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishSmall] != null with msg: Error loading SmallFish into cArcadeFishPopulation[GameLogic.cFishSmall]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[512]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("MediumFish") == 0) {
                GameScreen.cArcadeFishPopulation[2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeFishPopulation[2] != null) continue;
                System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishMedium] != null with msg: Error loading MediumFish into cArcadeFishPopulation[GameLogic.cFishMedium]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[513]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("LargeFish") == 0) {
                GameScreen.cArcadeFishPopulation[3] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeFishPopulation[3] != null) continue;
                System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishLarge] != null with msg: Error loading LargeFish into cArcadeFishPopulation[GameLogic.cFishLarge]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[514]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("HugeFish") == 0) {
                GameScreen.cArcadeFishPopulation[4] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cArcadeFishPopulation[4] != null) continue;
                System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishHuge] != null with msg: Error loading HugeFish into cArcadeFishPopulation[GameLogic.cFishHuge]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[515]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("KempyFish") != 0) continue;
            GameScreen.cArcadeFishPopulation[5] = CSVLoader.getCSVShortArray(_lStatData, i);
            if (cArcadeFishPopulation[5] != null) continue;
            System.out.println("Assertion Failure: cArcadeFishPopulation[GameLogic.cFishKempy] != null with msg: Error loading KempyFish into cArcadeFishPopulation[GameLogic.cFishKempy]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[516]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData.removeAllElements();
        if (cArcadeLocations.length != 5) {
            System.out.println("Assertion Failure: cArcadeLocations.length == cArcadeMaxLevels\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[519]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void newGame() {
        game.newGame();
    }

    public void initArcadeLevel() {
        System.out.println("INIT ARCADE LEVEL");
        this.initGame(cArcadeLocations[arcadeLevel]);
        arcadeCatch = 0;
        arcadeFishCaught = 0;
        this.biggestFishWeight = 0;
        for (int i = 0; i < cArcadeEquipment.length; ++i) {
            GameScreen.selectedItems[i] = cArcadeEquipment[i][arcadeLevel];
        }
        GameScreen.setTickerMessage("");
        game.nextState(0);
    }

    public void initArcadeGame(int level) {
        System.out.println("INIT ARCADE GAME");
        arcadeLevel = level;
        arcadeScore = 0;
        this.biggestFishWeight = 0;
        GameLogic.competitorFish = new int[1][50];
        this.initArcadeLevel();
        this.bFirstTime = false;
    }

    public void continueArcadeGame(int level) {
        System.out.println("CONTINUE ARCADE GAME");
        this.biggestFishWeight = 0;
        arcadeLevel = level;
        this.initGame(cArcadeLocations[arcadeLevel]);
        for (int i = 0; i < cArcadeEquipment.length; ++i) {
            GameScreen.selectedItems[i] = cArcadeEquipment[i][arcadeLevel];
        }
        GameScreen.setTickerMessage("");
        if (this.bFirstTime) {
            System.out.println("FIRST TIME");
            this.bFirstTime = false;
            game.nextState(0);
        } else {
            System.out.println("NOT FIRST TIME");
            game.nextState(1);
        }
    }

    public void updateFishCaughtText() {
        int weight;
        textFishCaught.clearText();
        textFishCaught.formatText(fontGame, "" + MultiLingual.get(124) + ":\n");
        int numFish = 0;
        for (int i = 0; i < GameLogic.competitorFish[0].length && (weight = GameLogic.competitorFish[0][i]) != 0; ++i) {
            ++numFish;
            int lbs = weight >> 4;
            int oz = weight & 0xF;
            int type = GameLogic.getFishTypeFromWeight(weight);
            textFishCaught.formatText(speechFont, "" + GameLogic.cFishSizeNames(type) + ", " + lbs + " " + MultiLingual.get(194) + " " + oz + " " + MultiLingual.get(195) + "\n");
        }
        if (numFish == 0) {
            textFishCaught.formatText(speechFont, "" + MultiLingual.get(125) + "");
        }
        textFishCaught.layout();
    }

    public void updateLureText() {
        textLureDesc.clearText();
        textLureDesc.formatText(fontGame, "" + MultiLingual.get(126) + "\n\n");
        int i = gameLureList[gameLureIconSel];
        textLureDesc.formatText(speechFont, ShopScreen.strItemName(3, i) + "\n\n");
        textLureDesc.formatText(speechFont, ShopScreen.strItemDescription(3, i) + "\n\n");
        if (GameScreen.getCurrent(3) == i) {
            textLureDesc.formatText(speechFont, "" + MultiLingual.get(129) + "");
        } else if (GameScreen.game.currentState == 1) {
            textLureDesc.formatText(speechFont, "" + MultiLingual.get(127) + "");
        } else {
            textLureDesc.formatText(speechFont, "" + MultiLingual.get(130) + "");
        }
        textLureDesc.layout();
    }

    public void setGameOver() {
        GameScreen.game.currentState = 10;
    }

    public boolean isGameOver() {
        return GameScreen.game.currentState == 10;
    }

    public boolean hasCompletedArcadeLevel() {
        return gameTime == 0;
    }

    public void initGame(int background) {
        fpScrollX = 32768;
        this.quitConfirm = false;
        fpWantedScrollX = fpScrollX;
        this.forcedWin = false;
        this.resetRod();
        this.bLineStressed = false;
        this.bLineBeingReeled = false;
        this.bStartedCastingPowerBar = false;
        this.setBackground(background);
        game.initGame();
        if (FrontEnd.gameType == 1) {
            GameApp.frontEnd.gameSequence.initFishInCurrentLocation();
        } else {
            game.addRandomFish(cArcadeFishPopulation.length);
            GameLogic.competitorFish = new int[1][50];
        }
        game.nextState(1);
    }

    public void updateSelectedItems() {
        for (int i = 0; i < selectedItems.length; ++i) {
            GameScreen.selectedItems[i] = GameApp.frontEnd.shopScreen.getBestItemOfType(i);
        }
    }

    public void initFixedCameras() {
        int num_cams = Software3D.loadCameras("/cameras.bin", 0, 6553);
        int fov_scale = FixedPoint.stringToFP("1.32");
        for (int i = 0; i < num_cams; ++i) {
            Software3D.loadedCameraFOV[i] = ((Software3D.loadedCameraFOV[i] ^ fov_scale) & 0x8000000) != 0 ? -((int)((long)(-Software3D.loadedCameraFOV[i]) * (long)fov_scale >> 16)) : (int)((long)Software3D.loadedCameraFOV[i] * (long)fov_scale >> 16);
        }
    }

    public void setupFixedCamera(int camera) {
        if (currentCamera != camera) {
            currentCamera = camera;
            Software3D.makeView(matView, Software3D.loadedCameraMatrix[camera][3], Software3D.loadedCameraMatrix[camera][0], Software3D.loadedCameraMatrix[camera][1], Software3D.loadedCameraMatrix[camera][2]);
            Software3D.makeProjection(matProj, near, far, Software3D.loadedCameraFOV[camera], aspect);
            Software3D.setCamera(matView, matProj, Software3D.loadedCameraMatrix[camera][3]);
            VecMath.norm2d(vecForward, Software3D.loadedCameraMatrix[camera][2]);
            Software3D.setViewport(0, 0, cViewportWidth, displayHeight);
            VecMath.norm2d(vecRight, Software3D.loadedCameraMatrix[camera][0]);
        }
    }

    public static void worldToScreenPos(int[] outScreenPos, int[] worldPos) {
        Software3D.project(screenPos, worldPos);
        int margin = cViewCanvasWidth - BaseScreen.displayWidth;
        outScreenPos[0] = (screenPos[0] - (((fpScrollX ^ (margin < 0 ? -(-margin << 16) : margin << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16)) : (int)((long)fpScrollX * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16)) < 0 ? -(-(screenPos[0] - (((fpScrollX ^ (margin < 0 ? -(-margin << 16) : margin << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16)) : (int)((long)fpScrollX * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16))) >> 16) : screenPos[0] - (((fpScrollX ^ (margin < 0 ? -(-margin << 16) : margin << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16)) : (int)((long)fpScrollX * (long)(margin < 0 ? -(-margin << 16) : margin << 16) >> 16)) >> 16) + (margin >> 1);
        outScreenPos[1] = screenPos[1] < 0 ? -(-screenPos[1] >> 16) : screenPos[1] >> 16;
        outScreenPos[2] = screenPos[2] < 0 ? -(-screenPos[2] >> 16) : screenPos[2] >> 16;
    }

    public void setBackground(int backgroundIndex) {
        if (this.bgLayers[0] == null) {
            this.bgLayers[0] = ImageSet.loadImage("/bg-scrolling-sky.png");
        }
        if (this.bgLayers[1] == null) {
            this.bgLayers[1] = ImageSet.loadImage("/bg-scrolling-sky2.png");
        }
        if (this.bgLayers[3] == null) {
            this.bgLayers[3] = ImageSet.loadImage("/bg-generic-water.png");
        }
        if (this.bgLayers[4] == null) {
            this.bgLayers[4] = ImageSet.loadImage("/boat_front.png");
        }
        if (this.bgLayers[2] == null || this.currentBackgroundIndex != backgroundIndex) {
            this.bgLayers[2] = null;
            this.bgLayers[2] = ImageSet.loadImage("/bg_" + backgroundIndex + ".png");
            this.currentBackgroundIndex = backgroundIndex;
        }
    }

    public void setupPauseMenuText() {
        BitmapFont pmFont = ScreenStack.fontSmall;
        GameScreen.controlPauseTitle.controlImage = new TextImage(ScreenStack.font, "" + MultiLingual.get(119) + "");
        GameScreen.controlOptions.controlImage = new TextImage(pmFont, "" + MultiLingual.get(16) + "");
        GameScreen.controlMainMenu.controlImage = new TextImage(pmFont, "" + MultiLingual.get(122) + "");
        GameScreen.controlResume.controlImage = new TextImage(pmFont, "" + MultiLingual.get(123) + "");
        menuPause.layout();
        GameScreen.controlOptionsTitle.controlImage = new TextImage(ScreenStack.font, "" + MultiLingual.get(16) + "");
        GameScreen.controlSound.controlImage = FrontEnd.controlOptionsSound.controlImage;
        GameScreen.controlVibrate.controlImage = FrontEnd.controlOptionsVibrate.controlImage;
        menuOptions.layout();
        textQuitConfirm.clearText();
        textQuitConfirm.formatText(pmFont, "" + MultiLingual.get(80) + "");
        textQuitConfirm.layout();
        this.resetGameText();
    }

    private void createPauseMenu() {
        this.setupPauseMenuText();
        GameScreen.controlForceWin.controlImage = new TextImage(ScreenStack.fontSmall, "CHEAT: FORCE WIN");
        menuPause.addControl(controlPauseTitle);
        menuPause.addControl(controlResume);
        menuPause.addControl(controlForceWin);
        menuPause.addControl(controlOptions);
        menuPause.addControl(controlMainMenu);
        GameScreen.menuPause.clipRect.w = (short)displayWidth;
        GameScreen.menuPause.clipRect.x0 = 0;
        GameScreen.menuPause.clipRect.y0 = (short)((displayHeight - GameScreen.menuPause.clipRect.h) / 2);
        GameScreen.menuPause.controlHandler = this;
        GameScreen.updateMenuHeight(menuPause);
        menuPause.open();
        menuOptions.addControl(controlOptionsTitle);
        menuOptions.addControl(controlSound);
        menuOptions.addControl(controlVibrate);
        GameScreen.menuOptions.controlHandler = this;
        GameScreen.updateMenuHeight(menuOptions);
        menuOptions.open();
    }

    boolean areSoftkeysActive() {
        switch (GameScreen.game.currentState) {
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    public static void updateMenuHeight(MenuLayout menu) {
        menu.clipRect.h = 0;
        for (int i = 0; i < menu.controlList.size(); ++i) {
            GuiControl control = (GuiControl)menu.controlList.elementAt(i);
            if (control.hidden) continue;
            menu.clipRect.h = FrontEnd.gfxBar != null ? (short)(menu.clipRect.h + (FrontEnd.gfxBar.getRectHeight(0) + 2)) : (short)(menu.clipRect.h + (control.clipRect.h + 5));
        }
        menu.clipRect.y0 = (short)((displayHeight - menu.clipRect.h) / 2);
    }

    public void pushScreen(ScreenLayout container, boolean transition) {
        currentMenu = (MenuLayout)container;
        GameScreen.updateMenuHeight(currentMenu);
        GameScreen.currentMenu.iSelected = 0;
        currentMenu.open();
    }

    public void openMenu() {
        SoundBank.stop(1);
        GameScreen.controlForceWin.hidden = !BaseScreen.cheatsEnabled;
        GameScreen.updateMenuHeight(menuPause);
        this.pushScreen(menuPause, true);
        this.quitConfirm = false;
        pauseState = 1;
    }

    public void controlExecuted(ScreenLayout container, GuiControl control) {
        if (container == menuPause) {
            if (control == controlMainMenu) {
                this.quitConfirm = true;
            }
            if (control == controlResume) {
                pauseState = 0;
            }
            if (control == controlOptions) {
                bDrawOptionsBack = true;
                this.pushScreen(menuOptions, false);
            }
            if (control == controlForceWin) {
                if (FrontEnd.gameType == 1) {
                    GameLogic.competitorFish[0][0] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][1] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][2] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[1][0] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[1][1] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[1][2] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[2][0] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[2][1] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[2][2] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[3][0] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[3][1] = GameLogic.randRange(16, 48);
                    GameLogic.competitorFish[3][2] = GameLogic.randRange(16, 48);
                    gameTime = 0;
                    pauseState = 0;
                    this.forcedWin = true;
                } else if (FrontEnd.gameType == 0) {
                    gameTime = 0;
                    GameLogic.competitorFish[0][0] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][1] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][2] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][3] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][4] = GameLogic.randRange(16, 160);
                    GameLogic.competitorFish[0][5] = GameLogic.randRange(16, 160);
                    arcadeFishCaught = 6;
                    arcadeCatch = GameLogic.competitorFish[0][0] + GameLogic.competitorFish[0][1] + GameLogic.competitorFish[0][2] + GameLogic.competitorFish[0][3] + GameLogic.competitorFish[0][4] + GameLogic.competitorFish[0][5];
                    arcadeScore = arcadeCatch * 10;
                    pauseState = 0;
                    this.forcedWin = true;
                }
            }
        }
        if (container == menuOptions) {
            if (control == controlSound) {
                FrontEnd.instance.controlExecuted(FrontEnd.menuOptions, FrontEnd.controlOptionsSound);
            }
            if (control == controlVibrate) {
                FrontEnd.instance.controlExecuted(FrontEnd.menuOptions, FrontEnd.controlOptionsVibrate);
            }
        }
    }

    public static void exitGame() {
    }

    public void reload() {
        this.setBackground(this.currentBackgroundIndex);
        isGame.reloadImages();
        gameEffects.reload();
    }

    public void unload() {
        try {
            isGame.unloadImages();
            gameEffects.unload();
            for (int i = 0; i < 5; ++i) {
                this.bgLayers[i] = null;
            }
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nGameScreen.load() - exception: " + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public void setupSound() {
        SoundBank.stop(0);
    }

    public void updateSound() {
        int tune = this.gameScreenTunes[GameScreen.game.currentState];
        boolean bLoop = GameApp.tuneLoop[tune];
        if (pauseState != 0) {
            if (SoundBank.currentSound != -1) {
                SoundBank.stop(0);
            }
        } else if (FrontEnd.sound && !BaseScreen.pauseDialogShown && SoundBank.currentSound != tune && tune != 1) {
            if (tune == 4) {
                if (GameApp.playCaught) {
                    SoundBank.play(0, tune, bLoop, 0);
                    GameApp.playCaught = false;
                }
            } else {
                GameApp.playCaught = true;
                SoundBank.play(0, tune, bLoop, 0);
            }
        }
    }

    public static boolean isGameInProgress() {
        return GameScreen.game.currentState != 10;
    }

    public void nextState(int state) {
        if (ScreenStack.currentContainer == this) {
            BaseScreen.resetKeys();
        }
        switch (state) {
            case 0: {
                if (FrontEnd.gameType != 0) break;
                textGameInfo.clearText();
                textGameInfo.formatText(fontGame, "" + MultiLingual.get(322) + "\n");
                textGameInfo.formatText(speechFont, "" + MultiLingual.get(379) + " " + GameApp.scoreArcadeAllTimeBest + "\n");
                textGameInfo.formatText(speechFont, "" + MultiLingual.get(380) + " " + GameApp.scoreArcadePersonalBest + "\n");
                textGameInfo.layout();
                break;
            }
            case 11: {
                if (FrontEnd.gameType != 0) {
                    System.out.println("Assertion Failure: FrontEnd.gameType == FrontEnd.eQuickMatch\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[1224]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                textGameInfo.clearText();
                textGameInfo.formatText(speechFont, "" + MultiLingual.get(303) + "" + "\n\n");
                textGameInfo.formatText(speechFont, "" + MultiLingual.get(305) + "" + "\n\n");
                textGameInfo.formatText(speechFont, "" + MultiLingual.get(308) + " " + this.getGameTime() + "\n");
                textGameInfo.layout();
                break;
            }
            case 1: {
                BaseScreen.resetKeys();
                this.resetRod();
                textGameInfo.clearText();
                GameScreen.textGameInfo.iLayoutFlags = 1;
                textGameInfo.formatText(speechFont, "\n\n" + MultiLingual.get(160) + "");
                textGameInfo.layout();
                GameScreen.textGameInfo.iLayoutFlags = 3;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                fpRodAngle = cfpRodAngleHooked;
                if (FrontEnd.vibration) {
                    Application.display.vibrate(500);
                }
                this.bLineStressed = true;
                game.scareFishAwayFromPoint(floatPos, 0, true);
                fpWantedScrollX = 32768;
                break;
            }
            case 7: {
                GameScreen.worldToScreenPos(this.fishInWaterScreenPos, floatPos);
                int sx = this.fishInWaterScreenPos[0];
                int sy = this.fishInWaterScreenPos[1];
                int fishType = GameScreen.game.fishType[GameScreen.game.currentFish];
                gameEffects.hideFightingFishHead();
                gameEffects.addEffect(2, sx, sy);
                gameEffects.addEffect(3, sx, sy);
                gameEffects.addEffect(4, sx, sy);
                gameEffects.addMoneyShot(fishType, sx, sy);
                switch (fishType) {
                    case 0: 
                    case 1: {
                        this.fpMoneyShotWantedRodAngle = cfpRodAngleMin;
                        this.fpMoneyShotWantedAnglePull = 327680;
                        this.fpMoneyShotWantedRodX = -196608;
                        this.fpMoneyShotWantedFloatOffsetX = 131072;
                        this.fpMoneyShotWantedFloatY = rodPos[1];
                        this.fpMoneyShotWantedFloatZ = 0x120000;
                        break;
                    }
                    case 2: {
                        this.fpMoneyShotWantedRodAngle = cfpRodAngleMin;
                        this.fpMoneyShotWantedAnglePull = 458752;
                        this.fpMoneyShotWantedRodX = -196608;
                        this.fpMoneyShotWantedFloatOffsetX = FixedPoint.stringToFP("2.3");
                        this.fpMoneyShotWantedFloatY = rodPos[1];
                        this.fpMoneyShotWantedFloatZ = 0x130000;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.fpMoneyShotWantedRodAngle = cfpRodAngleMin;
                        this.fpMoneyShotWantedAnglePull = 655360;
                        this.fpMoneyShotWantedRodX = -196608;
                        this.fpMoneyShotWantedFloatOffsetX = 163840;
                        this.fpMoneyShotWantedFloatY = rodPos[1];
                        this.fpMoneyShotWantedFloatZ = 0x130000;
                        break;
                    }
                    case 5: {
                        this.fpMoneyShotWantedRodAngle = cfpRodAngleMin;
                        this.fpMoneyShotWantedAnglePull = 786432;
                        this.fpMoneyShotWantedRodX = -196608;
                        this.fpMoneyShotWantedFloatOffsetX = FixedPoint.stringToFP("2.5");
                        this.fpMoneyShotWantedFloatY = rodPos[1];
                        this.fpMoneyShotWantedFloatZ = 0x130000;
                    }
                }
                this.moneyShotTransitionPhase = 0;
                if (rodPos[0] > 0) {
                    this.fpMoneyShotWantedRodX = -this.fpMoneyShotWantedRodX;
                    this.fpMoneyShotWantedFloatOffsetX = -this.fpMoneyShotWantedFloatOffsetX;
                }
                GameScreen.floatVel[0] = 0;
                GameScreen.floatVel[1] = 0;
                GameScreen.floatVel[2] = 0;
                break;
            }
            case 8: {
                gameEffects.setMoneyShotLayer(1);
                textGameInfo.clearText();
                int weight = game.getCurrentFishWeight();
                int lbs = weight / 16;
                int oz = weight % 16;
                int fishType = GameScreen.game.fishType[GameScreen.game.currentFish];
                if (weight > this.biggestFishWeight) {
                    this.biggestFishWeight = weight;
                }
                String weightString = "" + lbs + " " + MultiLingual.get(194) + " " + oz + " " + MultiLingual.get(195) + "\n";
                if (FrontEnd.gameType == 0) {
                    textGameInfo.formatText(speechFont, "\n\n");
                }
                textGameInfo.formatText(speechFont, GameLogic.cFishSizeNames(fishType) + "\n");
                textGameInfo.formatText(fontGame, weightString + "\n");
                boolean gameInfoAtTop = false;
                if (gameInfoAtTop) {
                    GameScreen.textGameInfo.iLayoutFlags = 1;
                }
                textGameInfo.layout();
                GameScreen.textGameInfo.iLayoutFlags = 3;
                break;
            }
            case 10: {
                gameEffects.killAllEffects();
                textGameInfo.clearText();
                showingArcadeHiScoreTable = false;
                if (FrontEnd.gameType == 0) {
                    if (this.hasCompletedArcadeLevel()) {
                        if (arcadeScore > GameApp.scoreArcadePersonalBest) {
                            GameApp.scoreArcadePersonalBest = arcadeScore;
                        }
                        if (GameApp.scoreArcadePersonalBest > GameApp.scoreArcadeAllTimeBest) {
                            GameApp.scoreArcadeAllTimeBest = GameApp.scoreArcadePersonalBest;
                        }
                        if (bShowWeighInScreen) {
                            textGameInfo.formatText(fontGame, "" + MultiLingual.get(358) + "\n" + GameScreen.getWeightString(arcadeCatch));
                        } else {
                            textGameInfo.formatText(fontGame, "" + MultiLingual.get(177) + "\n\n");
                        }
                        this.shownArcadeCompleteScreen1 = false;
                    } else {
                        textGameInfo.formatText(fontGame, "" + MultiLingual.get(317) + "\n");
                        textGameInfo.formatText(speechFont, "" + MultiLingual.get(318) + " " + cArcadeTargetPounds[arcadeLevel] + " " + MultiLingual.get(319) + "\n");
                    }
                } else if (FrontEnd.gameType == 1) {
                    if (this.forcedWin) {
                        textGameInfo.formatText(speechFont, "Forced win");
                    } else {
                        textGameInfo.formatText(fontGame, "" + MultiLingual.get(177) + "");
                    }
                } else {
                    textGameInfo.formatText(fontGame, "" + MultiLingual.get(177) + "");
                }
                textGameInfo.layout();
                break;
            }
            case 12: {
                GameScreen.floatVel[2] = 0;
                GameScreen.floatVel[1] = 0;
                GameScreen.floatVel[0] = 0;
                this.resetRod();
                textGameInfo.clearText();
                textGameInfo.formatText(fontGame, "" + MultiLingual.get(148) + "\n");
                if (game.getFishFightNormalizedTension() >= 65536) {
                    textGameInfo.formatText(speechFont, "" + MultiLingual.get(163) + "");
                } else {
                    textGameInfo.formatText(speechFont, "" + MultiLingual.get(164) + "");
                }
                textGameInfo.layout();
                game.releaseFish(GameScreen.game.currentFish);
            }
        }
    }

    public void resetGameText() {
        switch (GameScreen.game.currentState) {
            case 0: 
            case 11: {
                break;
            }
            case 1: {
                textGameInfo.clearText();
                GameScreen.textGameInfo.iLayoutFlags = 1;
                textGameInfo.formatText(speechFont, "\n\n" + MultiLingual.get(160) + "");
                textGameInfo.layout();
                GameScreen.textGameInfo.iLayoutFlags = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 12: {
                textGameInfo.clearText();
                textGameInfo.formatText(fontGame, "" + MultiLingual.get(148) + "\n");
                if (game.getFishFightNormalizedTension() >= 65536) {
                    textGameInfo.formatText(speechFont, "" + MultiLingual.get(163) + "");
                } else {
                    textGameInfo.formatText(speechFont, "" + MultiLingual.get(164) + "");
                }
                textGameInfo.layout();
            }
        }
    }

    void limitFloat() {
        if (floatPos[0] < GameLogic.cfpFishMinX) {
            GameScreen.floatPos[0] = GameLogic.cfpFishMinX;
        }
        if (floatPos[0] > GameLogic.cfpFishMaxX) {
            GameScreen.floatPos[0] = GameLogic.cfpFishMaxX;
        }
    }

    public void process() {
        if (Application.isLoading) {
            return;
        }
        this.updateSound();
        this.processKeyPressed();
        this.processKeyReleased();
        game.processTransition();
        if (GameScreen.isPaused()) {
            fpPauseTimer = fpPauseTimer + Application.fp_deltatime < 16384 ? fpPauseTimer + Application.fp_deltatime : 16384;
            return;
        }
        this.flashTime += Application.lastFrameTime;
        if (this.flashTime > this.flashDuration) {
            flashOn = !flashOn;
            this.flashTime -= this.flashDuration;
        }
        this.fastFlashTime += Application.lastFrameTime;
        if (this.fastFlashTime > this.fastFlashDuration) {
            fastFlashOn = !fastFlashOn;
            this.fastFlashTime -= this.fastFlashDuration;
        }
        if (gameTime > 0) {
            if (!this.isGameOver() && GameScreen.game.currentState != -1 && GameScreen.game.currentState != 0 && GameScreen.game.currentState != 11 && GameScreen.game.currentState != 7 && GameScreen.game.currentState != 8) {
                gameTime = 0 > gameTime - Application.lastFrameTime ? 0 : gameTime - Application.lastFrameTime;
            }
        } else if (GameScreen.game.currentState != 10) {
            game.transitionToNextState(10);
        }
        int t = Application.fp_deltatime;
        if (GameLogic.transitionState == 0) {
            switch (GameScreen.game.currentState) {
                case 0: {
                    if (!ScreenLayout.keysDown(16)) break;
                    if (FrontEnd.gameType == 0) {
                        game.nextState(11);
                        break;
                    }
                    game.nextState(1);
                    break;
                }
                case 11: {
                    if (!ScreenLayout.keysDown(16)) break;
                    game.transitionToNextState(1);
                    break;
                }
                case 1: {
                    this.moveRodOnXAxis();
                    GameScreen.rodTip[0] = rodPos[0];
                    if (ScreenLayout.keysDown(8)) {
                        if (!this.bStartedCastingPowerBar) {
                            this.fCastingPowerVelocity = 0;
                            this.RodResetAngleToDown();
                        }
                        this.bStartedCastingPowerBar = true;
                        this.fCastingPowerVelocity += ((0x10000 ^ t) & 0x8000000) != 0 ? -((int)(-65536L * (long)t >> 16)) : (int)(65536L * (long)t >> 16);
                        if (this.fCastingPowerVelocity > 65536) {
                            this.fCastingPowerVelocity = 65536;
                        }
                        this.moveRodUp(((cfpRodAngleSpeedIdle ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpRodAngleSpeedIdle) * (long)t >> 16)) : (int)((long)cfpRodAngleSpeedIdle * (long)t >> 16));
                        break;
                    }
                    if (!ScreenLayout.keysReleased(8) || !this.bStartedCastingPowerBar) break;
                    game.nextState(2);
                    break;
                }
                case 2: {
                    rodTip[1] = rodTip[1] - (((0x140000 ^ t) & 0x8000000) != 0 ? -((int)(-1310720L * (long)t >> 16)) : (int)(0x140000L * (long)t >> 16));
                    rodTip[2] = rodTip[2] + (((0x140000 ^ t) & 0x8000000) != 0 ? -((int)(-1310720L * (long)t >> 16)) : (int)(0x140000L * (long)t >> 16));
                    GameScreen.floatPos[0] = rodPos[0];
                    GameScreen.floatPos[1] = rodTip[1];
                    GameScreen.floatPos[2] = rodTip[2];
                    game.nextState(3);
                    break;
                }
                case 3: {
                    int fDiffy = cfpRodTipDefaultY - rodTip[1];
                    int fDiffz = cfpRodTipDefaultZ - rodTip[2];
                    rodTip[1] = rodTip[1] + (fDiffy >> 1);
                    rodTip[2] = rodTip[2] + (fDiffz >> 1);
                    GameScreen.floatPos[0] = rodTip[0];
                    GameScreen.floatPos[1] = rodTip[1];
                    GameScreen.floatPos[2] = rodTip[2];
                    fpRodAngle = (fpRodAngle += ((cfpRodAngleSpeedCasting ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpRodAngleSpeedCasting) * (long)t >> 16)) : (int)((long)cfpRodAngleSpeedCasting * (long)t >> 16)) < cfpRodAngleMaxCasting ? fpRodAngle : cfpRodAngleMaxCasting;
                    if (Math.abs(fDiffy < 0 ? -(-fDiffy >> 16) : fDiffy >> 16) > 1 && Math.abs(fDiffz < 0 ? -(-fDiffz >> 16) : fDiffz >> 16) > 1) break;
                    boolean rodOffset = false;
                    game.nextState(4);
                    GameScreen.floatPos[0] = rodTip[0];
                    GameScreen.floatPos[1] = rodTip[1];
                    GameScreen.floatPos[2] = rodTip[2];
                    GameScreen.floatVel[0] = 0;
                    int fpRodValue = (int)(((long)(GameScreen.getCurrentRod() < 0 ? -(-GameScreen.getCurrentRod() << 16) : GameScreen.getCurrentRod() << 16) << 16) / 262144L);
                    int fpMaxRange = FixedPoint.linearInterpolate(fpRodValue, constfpMaxCastingRangeCrapRod, constfpMaxCastingRangeAceRod);
                    GameScreen.floatVel[1] = FixedPoint.linearInterpolate(this.fCastingPowerVelocity, constfpMinCastingRange, fpMaxRange);
                    GameScreen.floatVel[2] = 131072;
                    break;
                }
                case 4: {
                    int fpDropSpeed = cfpRodAngleSpeedLureDrop;
                    if (cfpRodAngleMax - fpRodAngle < cfpDroppingRodDampingRange) {
                        int slowdown = (int)(((long)(cfpRodAngleMax - fpRodAngle) << 16) / (long)cfpDroppingRodDampingRange);
                        slowdown = slowdown < 8192 ? 8192 : (slowdown > 65536 ? 65536 : slowdown);
                        fpDropSpeed = ((fpDropSpeed ^ slowdown) & 0x8000000) != 0 ? -((int)((long)(-fpDropSpeed) * (long)slowdown >> 16)) : (int)((long)fpDropSpeed * (long)slowdown >> 16);
                    }
                    this.moveRodDown(((fpDropSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpDropSpeed) * (long)t >> 16)) : (int)((long)fpDropSpeed * (long)t >> 16));
                    GameScreen.floatPos[0] = floatPos[0] + (((floatVel[0] ^ t) & 0x8000000) != 0 ? -((int)((long)(-floatVel[0]) * (long)t >> 16)) : (int)((long)floatVel[0] * (long)t >> 16));
                    GameScreen.floatPos[1] = floatPos[1] + (((floatVel[1] ^ t) & 0x8000000) != 0 ? -((int)((long)(-floatVel[1]) * (long)t >> 16)) : (int)((long)floatVel[1] * (long)t >> 16));
                    GameScreen.floatPos[2] = floatPos[2] + (((floatVel[2] ^ t) & 0x8000000) != 0 ? -((int)((long)(-floatVel[2]) * (long)t >> 16)) : (int)((long)floatVel[2] * (long)t >> 16));
                    floatVel[2] = floatVel[2] - (((0xA0000 ^ t) & 0x8000000) != 0 ? -((int)(-655360L * (long)t >> 16)) : (int)(655360L * (long)t >> 16));
                    if (floatPos[2] > 0) break;
                    GameScreen.worldToScreenPos(this.fishInWaterScreenPos, floatPos);
                    int sx = this.fishInWaterScreenPos[0];
                    int sy = this.fishInWaterScreenPos[1];
                    gameEffects.addEffect(0, sx, sy);
                    GameScreen.floatPos[2] = 0;
                    GameScreen.floatVel[0] = 0;
                    GameScreen.floatVel[1] = 0;
                    GameScreen.floatVel[2] = 0;
                    this.bStartedCastingPowerBar = false;
                    game.nextState(5);
                    break;
                }
                case 5: {
                    int scaledRodPull;
                    this.moveRodOnXAxis();
                    int n = scaledRodPull = ((GameScreen.getRodPull() ^ t) & 0x8000000) != 0 ? -((int)((long)(-GameScreen.getRodPull()) * (long)t >> 16)) : (int)((long)GameScreen.getRodPull() * (long)t >> 16);
                    if (GameScreen.game.currentFish == -1) {
                        if (ScreenLayout.keysReleased(16) && this.postPauseDelay > 0) {
                            BaseScreen.resetKeys();
                            this.postPauseDelay = 0;
                        }
                        if (ScreenLayout.keysDown(16) && this.postPauseDelay == 0) {
                            GameScreen.floatVel[1] = -scaledRodPull;
                        }
                        boolean dragged = false;
                        if (ScreenLayout.keysPressed(2)) {
                            GameScreen.floatVel[0] = -scaledRodPull;
                            dragged = true;
                        } else if (ScreenLayout.keysPressed(4)) {
                            GameScreen.floatVel[0] = scaledRodPull;
                            dragged = true;
                        }
                        if (dragged) {
                            long currentTime = System.currentTimeMillis();
                            if (this.lastTimeDragged == 0L || this.lastTimeDragged > currentTime || currentTime - this.lastTimeDragged > 350L) {
                                this.lastTimeDragged = currentTime;
                                GameScreen.worldToScreenPos(this.floatScreenPos, floatPos);
                                int sx = this.floatScreenPos[0];
                                int sy = this.floatScreenPos[1];
                                gameEffects.addEffect(1, sx, sy);
                            }
                        }
                    } else if (ScreenLayout.keysPressed(8)) {
                        GameScreen.worldToScreenPos(this.floatScreenPos, floatPos);
                        int sx = this.floatScreenPos[0];
                        int sy = this.floatScreenPos[1];
                        gameEffects.addEffect(2, sx, sy);
                        if (game.isPossibleToStrike()) {
                            game.scareFishAwayFromPoint(floatPos, 0, true);
                            game.nextState(6);
                        } else {
                            if (GameScreen.game.currentFish == -1) {
                                System.out.println("Assertion Failure: game.currentFish != -1\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[1891]");
                                try {
                                    throw new Exception();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            game.releaseFish(GameScreen.game.currentFish);
                            game.scareFishAwayFromPoint(floatPos, 0, true);
                            game.nextState(13);
                            textGameInfo.clearText();
                            textGameInfo.formatText(fontGame, "" + MultiLingual.get(156) + "\n");
                            textGameInfo.formatText(speechFont, "" + MultiLingual.get(168) + "");
                            textGameInfo.layout();
                        }
                    }
                    GameScreen.floatPos[0] = floatPos[0] + floatVel[0];
                    GameScreen.floatPos[1] = floatPos[1] + floatVel[1];
                    GameScreen.floatPos[2] = floatPos[2] + floatVel[2];
                    this.limitFloat();
                    int fWaterFriction = FixedPoint.stringToFP("0.95");
                    GameScreen.floatVel[0] = ((floatVel[0] ^ fWaterFriction) & 0x8000000) != 0 ? -((int)((long)(-floatVel[0]) * (long)fWaterFriction >> 16)) : (int)((long)floatVel[0] * (long)fWaterFriction >> 16);
                    GameScreen.floatVel[1] = ((floatVel[1] ^ fWaterFriction) & 0x8000000) != 0 ? -((int)((long)(-floatVel[1]) * (long)fWaterFriction >> 16)) : (int)((long)floatVel[1] * (long)fWaterFriction >> 16);
                    int n2 = GameScreen.floatVel[2] = ((floatVel[2] ^ fWaterFriction) & 0x8000000) != 0 ? -((int)((long)(-floatVel[2]) * (long)fWaterFriction >> 16)) : (int)((long)floatVel[2] * (long)fWaterFriction >> 16);
                    if (floatPos[1] >= rodPos[1]) break;
                    if (GameScreen.game.currentFish != -1) {
                        game.releaseFish(GameScreen.game.currentFish);
                    }
                    game.nextState(9);
                    textGameInfo.clearText();
                    textGameInfo.layout();
                    break;
                }
                case 6: {
                    if (!game.hasFishOn()) {
                        System.out.println("Assertion Failure: game.hasFishOn()\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[1927]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    GameScreen.floatPos[0] = GameLogic.fishMouthPos[GameScreen.game.currentFish][0];
                    GameScreen.floatPos[1] = GameLogic.fishMouthPos[GameScreen.game.currentFish][1];
                    if (ScreenLayout.keysDown(16)) {
                        int fpCurrRodPull = ((GameScreen.getRodPull() ^ t) & 0x8000000) != 0 ? -((int)((long)(-GameScreen.getRodPull()) * (long)t >> 16)) : (int)((long)GameScreen.getRodPull() * (long)t >> 16);
                        fpCurrRodPull = ((fpCurrRodPull ^ 65536 - game.getFishFightTension()) & 0x8000000) != 0 ? -((int)((long)(-fpCurrRodPull) * (long)(65536 - game.getFishFightTension()) >> 16)) : (int)((long)fpCurrRodPull * (long)(65536 - game.getFishFightTension()) >> 16);
                        game.reelInFish(fpCurrRodPull);
                        if (game.isFishReeledIn()) {
                            game.transitionToNextState(7);
                            return;
                        }
                        this.bLineStressed = true;
                    }
                    if (ScreenLayout.keysDown(8)) {
                        this.bLineStressed = false;
                    }
                    if (ScreenLayout.keysDown(2)) {
                        GameScreen.floatVel[0] = ((-GameScreen.getRodPull() ^ t) & 0x8000000) != 0 ? -((int)((long)(-(-GameScreen.getRodPull())) * (long)t >> 16)) : (int)((long)(-GameScreen.getRodPull()) * (long)t >> 16);
                        rodTip[0] = rodTip[0] - (((cfpRodTipSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpRodTipSpeed) * (long)t >> 16)) : (int)((long)cfpRodTipSpeed * (long)t >> 16));
                        if (rodTip[0] < -cfpRodTipMaxPos) {
                            GameScreen.rodTip[0] = -cfpRodTipMaxPos;
                        }
                        this.bLineStressed = true;
                    } else if (ScreenLayout.keysDown(4)) {
                        GameScreen.floatVel[0] = ((GameScreen.getRodPull() ^ t) & 0x8000000) != 0 ? -((int)((long)(-GameScreen.getRodPull()) * (long)t >> 16)) : (int)((long)GameScreen.getRodPull() * (long)t >> 16);
                        rodTip[0] = rodTip[0] + (((cfpRodTipSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpRodTipSpeed) * (long)t >> 16)) : (int)((long)cfpRodTipSpeed * (long)t >> 16));
                        if (rodTip[0] > cfpRodTipMaxPos) {
                            GameScreen.rodTip[0] = cfpRodTipMaxPos;
                        }
                        this.bLineStressed = true;
                    }
                    GameScreen.floatPos[0] = floatPos[0] + floatVel[0];
                    GameScreen.floatPos[1] = floatPos[1] + floatVel[1];
                    GameScreen.floatPos[2] = floatPos[2] + floatVel[2];
                    GameScreen.worldToScreenPos(this.fishInWaterScreenPos, floatPos);
                    this.moveRodBend();
                    this.moveRodOnXAxis();
                    break;
                }
                case 7: {
                    int fpRodAngleBlendSpeed = FixedPoint.stringToFP("30");
                    int fpAnglePullBlendSpeed = FixedPoint.stringToFP("30");
                    int fpRodXBlendSpeed = FixedPoint.stringToFP("50");
                    int fpFloatOffsetXBlendSpeed = FixedPoint.stringToFP("50");
                    int fpFloatYBlendSpeed = FixedPoint.stringToFP("50");
                    int fpFloatZBlendSpeed = FixedPoint.stringToFP("40");
                    int floatOffset = floatPos[0] - rodPos[0];
                    if (this.moneyShotTransitionPhase == 0) {
                        fpRodAngle = GameScreen.moveValue(fpRodAngle, this.fpMoneyShotWantedRodAngle, ((fpRodAngleBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpRodAngleBlendSpeed) * (long)t >> 16)) : (int)((long)fpRodAngleBlendSpeed * (long)t >> 16));
                        GameScreen.rodPos[0] = GameScreen.moveValueWithDamping(rodPos[0], this.fpMoneyShotWantedRodX, ((fpRodXBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpRodXBlendSpeed) * (long)t >> 16)) : (int)((long)fpRodXBlendSpeed * (long)t >> 16), 327680, 8192);
                        GameScreen.floatPos[1] = GameScreen.moveValue(floatPos[1], this.fpMoneyShotWantedFloatY, ((fpFloatYBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpFloatYBlendSpeed) * (long)t >> 16)) : (int)((long)fpFloatYBlendSpeed * (long)t >> 16));
                        floatOffset = GameScreen.moveValue(floatOffset, this.fpMoneyShotWantedFloatOffsetX, ((fpFloatOffsetXBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpFloatOffsetXBlendSpeed) * (long)t >> 16)) : (int)((long)fpFloatOffsetXBlendSpeed * (long)t >> 16));
                        GameScreen.floatPos[0] = rodPos[0] + floatOffset;
                        if (fpRodAngle != this.fpMoneyShotWantedRodAngle || rodPos[0] != this.fpMoneyShotWantedRodX || floatOffset != this.fpMoneyShotWantedFloatOffsetX || floatPos[1] != this.fpMoneyShotWantedFloatY) break;
                        this.moneyShotTransitionPhase = 1;
                        break;
                    }
                    if (this.moneyShotTransitionPhase != 1) break;
                    this.fpAnglePull = GameScreen.moveValueWithDamping(this.fpAnglePull, this.fpMoneyShotWantedAnglePull, ((fpAnglePullBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpAnglePullBlendSpeed) * (long)t >> 16)) : (int)((long)fpAnglePullBlendSpeed * (long)t >> 16), 0x100000, 8192);
                    GameScreen.floatPos[2] = GameScreen.moveValueWithDamping(floatPos[2], this.fpMoneyShotWantedFloatZ, ((fpFloatZBlendSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpFloatZBlendSpeed) * (long)t >> 16)) : (int)((long)fpFloatZBlendSpeed * (long)t >> 16), 327680, 8192);
                    if (this.fpAnglePull != this.fpMoneyShotWantedAnglePull || floatPos[2] != this.fpMoneyShotWantedFloatZ) break;
                    game.nextState(8);
                    break;
                }
                case 8: {
                    GameScreen.game.fishPos[GameScreen.game.currentFish][0] = floatPos[0];
                    GameScreen.game.fishPos[GameScreen.game.currentFish][1] = floatPos[1];
                    GameScreen.game.fishPos[GameScreen.game.currentFish][2] = floatPos[2];
                    if (!ScreenLayout.keysDown(16)) break;
                    if (FrontEnd.gameType == 0 && this.hasCompletedArcadeLevel()) {
                        game.transitionToNextState(10);
                        break;
                    }
                    game.nextState(1);
                    break;
                }
                case 9: {
                    if (!ScreenLayout.keysDown(16)) break;
                    game.nextState(1);
                    break;
                }
                case 13: {
                    if (!ScreenLayout.keysPressed(16)) break;
                    game.nextState(5);
                    break;
                }
                case 10: {
                    if (!ScreenLayout.keysPressed(16)) break;
                    if (FrontEnd.gameType == 1) {
                        GameSequence cfr_ignored_0 = FrontEnd.instance.gameSequence;
                        GameSequence.gameOver(!this.forcedWin);
                        this.forcedWin = false;
                        FrontEnd.instance.popScreenUntil(FrontEnd.instance.gameSequence, null);
                        break;
                    }
                    if (this.hasCompletedArcadeLevel()) {
                        if (!bShowWeighInScreen && arcadeCatch > 0) {
                            FrontEnd.instance.startWeighIn();
                            bShowWeighInScreen = true;
                            break;
                        }
                        if (showingArcadeHiScoreTable) {
                            bShowWeighInScreen = false;
                            GameScreen.backToMainMenu();
                            break;
                        }
                        GameScreen.setupArcadeHiScoreTable();
                        break;
                    }
                    System.out.println("You failed the arcade mode");
                    if (showingArcadeHiScoreTable) {
                        FrontEnd.instance.popScreen(true);
                        break;
                    }
                    GameScreen.setupArcadeHiScoreTable();
                    break;
                }
                case 12: {
                    if (!ScreenLayout.keysDown(16)) break;
                    game.nextState(1);
                }
            }
        }
        game.process();
        boolean bl = this.bLineBeingReeled = ScreenLayout.keysDown(16) && (GameScreen.game.currentState == 5 || GameScreen.game.currentState == 6) || game.isReelingIn() && GameScreen.game.fp_state_time < 65536;
        if (this.bLineBeingReeled && (reelTimer -= Application.lastFrameTime) < 0) {
            reelTimer = 30;
            if (++reelFrame >= GameScreen.gfxReel.numFrames) {
                reelFrame = 0;
            }
        }
        if (this.bLineBeingReeled && GameScreen.game.currentState == 5) {
            long currentTime = System.currentTimeMillis();
            if (this.lastTimeDragged == 0L || this.lastTimeDragged > currentTime || currentTime - this.lastTimeDragged > 350L) {
                this.lastTimeDragged = currentTime;
                GameScreen.worldToScreenPos(this.floatScreenPos, floatPos);
                int sx = this.floatScreenPos[0];
                int sy = this.floatScreenPos[1];
                gameEffects.addEffect(1, sx, sy);
            }
        }
        if (GameScreen.game.currentState != 6) {
            fpWantedScrollX = (int)(((long)(rodPos[0] + cfpRodMaxPos) << 16) / (long)(cfpRodMaxPos << 1));
            fpScrollX = fpWantedScrollX = fpWantedScrollX < 0 ? 0 : (fpWantedScrollX > 65536 ? 65536 : fpWantedScrollX);
        } else if (fpScrollX < fpWantedScrollX) {
            fpScrollX = (fpScrollX += ((cfpBoatAnimSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpBoatAnimSpeed) * (long)t >> 16)) : (int)((long)cfpBoatAnimSpeed * (long)t >> 16)) < fpWantedScrollX ? fpScrollX : fpWantedScrollX;
        } else if (fpScrollX > fpWantedScrollX) {
            fpScrollX = (fpScrollX -= ((cfpBoatAnimSpeed ^ t) & 0x8000000) != 0 ? -((int)((long)(-cfpBoatAnimSpeed) * (long)t >> 16)) : (int)((long)cfpBoatAnimSpeed * (long)t >> 16)) > fpWantedScrollX ? fpScrollX : fpWantedScrollX;
        }
        this.animateBoat();
        gameEffects.moveEffects();
    }

    public static void setupArcadeHiScoreTable() {
        textGameInfo.clearText();
        textHiScoreColumns[0].clearText();
        textHiScoreColumns[1].clearText();
        HiscoreTable table = GameApp.hiscoreTable;
        if (table != null) {
            int i;
            int tableIndex = 2;
            int theScore = arcadeScore + arcadeLevel + 1;
            int hiscorePlace = table.getHiscorePlace(tableIndex, theScore);
            int numScores = table.getNumScores(tableIndex);
            if (hiscorePlace != -1) {
                table.addHiscore(tableIndex, theScore, "" + MultiLingual.get(321) + "");
                hiscorePlace = -1;
                for (i = 0; i < numScores; ++i) {
                    if (theScore != table.getScore(tableIndex, i) || table.getName(tableIndex, i).compareTo("" + MultiLingual.get(321) + "") != 0) continue;
                    hiscorePlace = i;
                    break;
                }
                GameApp.autoSave();
            }
            textGameInfo.formatText(speechFont, " " + MultiLingual.get(322) + "\n\n");
            for (i = 0; i < numScores; ++i) {
                if (i == hiscorePlace) {
                    textHiScoreColumns[0].formatText(speechFont, "> ");
                }
                textHiScoreColumns[0].formatText(speechFont, table.getName(tableIndex, i));
                int fixedScore = table.getScore(tableIndex, i);
                fixedScore -= fixedScore % 10;
                textHiScoreColumns[1].formatText(speechFont, "" + fixedScore + "\n");
                if (i == hiscorePlace) {
                    textHiScoreColumns[0].formatText(speechFont, " < - " + MultiLingual.get(323) + "\n");
                    continue;
                }
                textHiScoreColumns[0].formatText(speechFont, "\n");
            }
        }
        textGameInfo.layout();
        textHiScoreColumns[0].layout();
        textHiScoreColumns[1].layout();
        showingArcadeHiScoreTable = true;
    }

    public void checkUpdateBiggestFishRecord(int ounces) {
        this.biggestFishWeight = ounces;
        System.out.println("*************************************");
        System.out.println("*************************************");
        System.out.println("CHECKING WEIGHT:" + this.biggestFishWeight);
        System.out.println("*************************************");
        System.out.println("*************************************");
        if (this.biggestFishWeight <= 0) {
            return;
        }
        HiscoreTable table = GameApp.hiscoreTable;
        if (table == null) {
            return;
        }
        int tableIndex = 1;
        int hiscorePlace = table.getHiscorePlace(tableIndex, this.biggestFishWeight);
        if (hiscorePlace != -1) {
            table.addHiscore(tableIndex, this.biggestFishWeight, "" + MultiLingual.get(321) + "");
            GameApp.autoSave();
        }
    }

    public static int moveValue(int from, int to, int speed) {
        if (from < to) {
            from = (from += speed) < to ? from : to;
        } else if (from > to) {
            from = (from -= speed) > to ? from : to;
        }
        return from;
    }

    public static int moveValueWithDamping(int from, int to, int speed, int dampingRange, int fpMaxDampingScale) {
        if (from < to) {
            if (to - from < dampingRange) {
                int slowdown = (int)(((long)(to - from) << 16) / (long)dampingRange);
                slowdown = slowdown < fpMaxDampingScale ? fpMaxDampingScale : (slowdown > 65536 ? 65536 : slowdown);
                speed = ((speed ^ slowdown) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)slowdown >> 16)) : (int)((long)speed * (long)slowdown >> 16);
            }
            from = (from += speed) < to ? from : to;
        } else if (from > to) {
            if (from - to < dampingRange) {
                int slowdown = (int)(((long)(from - to) << 16) / (long)dampingRange);
                slowdown = slowdown < fpMaxDampingScale ? fpMaxDampingScale : (slowdown > 65536 ? 65536 : slowdown);
                speed = ((speed ^ slowdown) & 0x8000000) != 0 ? -((int)((long)(-speed) * (long)slowdown >> 16)) : (int)((long)speed * (long)slowdown >> 16);
            }
            from = (from -= speed) > to ? from : to;
        }
        return from;
    }

    public void updateFlashing() {
        this.flashTime += Application.lastFrameTime;
        if (this.flashTime > this.flashDuration) {
            flashOn = !flashOn;
            this.flashTime -= this.flashDuration;
        }
        this.fastFlashTime += Application.lastFrameTime;
        if (this.fastFlashTime > this.fastFlashDuration) {
            fastFlashOn = !fastFlashOn;
            this.fastFlashTime -= this.fastFlashDuration;
        }
    }

    public void moveRodOnXAxis() {
        int maxSpeed = cfpRodMaxSpeed;
        int maxAcc = cfpRodAcc;
        int minPos = -cfpRodMaxPos;
        int maxPos = cfpRodMaxPos;
        if (GameScreen.game.currentState == 6) {
            maxSpeed = cfpRodMaxSpeedFight;
            maxAcc = cfpRodAccFight;
            minPos = GameScreen.game.fpFishFightStartPosX - cfpRodMaxPosOffsetFight;
            maxPos = GameScreen.game.fpFishFightStartPosX + cfpRodMaxPosOffsetFight;
        } else if (GameScreen.game.currentState == 5) {
            maxSpeed = cfpRodMaxSpeedFishing;
            maxAcc = cfpRodAccFishing;
            minPos = minPos > floatPos[0] - cfpRodMaxPosOffsetFishing ? minPos : floatPos[0] - cfpRodMaxPosOffsetFishing;
            maxPos = maxPos < floatPos[0] + cfpRodMaxPosOffsetFishing ? maxPos : floatPos[0] + cfpRodMaxPosOffsetFishing;
        }
        int dt = Application.fp_deltatime;
        boolean moved = false;
        if (GameScreen.game.currentState != 4) {
            if (ScreenLayout.keysDown(2)) {
                if ((rodXVel -= ((maxAcc ^ dt) & 0x8000000) != 0 ? -((int)((long)(-maxAcc) * (long)dt >> 16)) : (int)((long)maxAcc * (long)dt >> 16)) < -maxSpeed) {
                    rodXVel = -maxSpeed;
                }
                moved = true;
            }
            if (ScreenLayout.keysDown(4)) {
                if ((rodXVel += ((maxAcc ^ dt) & 0x8000000) != 0 ? -((int)((long)(-maxAcc) * (long)dt >> 16)) : (int)((long)maxAcc * (long)dt >> 16)) > maxSpeed) {
                    rodXVel = maxSpeed;
                }
                moved = true;
            }
        }
        int xvel = rodXVel;
        int marginPos = cfpRodMaxPos - cfpRodMaxPosSlowDownMargin;
        if (rodPos[0] > marginPos && rodXVel > 0) {
            int slowdown = 65536 - (int)(((long)(rodPos[0] - marginPos) << 16) / (long)cfpRodMaxPosSlowDownMargin);
            slowdown = slowdown < 8192 ? 8192 : (slowdown > 65536 ? 65536 : slowdown);
            xvel = ((xvel ^ slowdown) & 0x8000000) != 0 ? -((int)((long)(-xvel) * (long)slowdown >> 16)) : (int)((long)xvel * (long)slowdown >> 16);
        } else if (rodPos[0] < -marginPos && rodXVel < 0) {
            int slowdown = 65536 - (int)(((long)(-rodPos[0] - marginPos) << 16) / (long)cfpRodMaxPosSlowDownMargin);
            slowdown = slowdown < 8192 ? 8192 : (slowdown > 65536 ? 65536 : slowdown);
            xvel = ((xvel ^ slowdown) & 0x8000000) != 0 ? -((int)((long)(-xvel) * (long)slowdown >> 16)) : (int)((long)xvel * (long)slowdown >> 16);
        }
        rodPos[0] = rodPos[0] + (((xvel ^ dt) & 0x8000000) != 0 ? -((int)((long)(-xvel) * (long)dt >> 16)) : (int)((long)xvel * (long)dt >> 16));
        if (!moved) {
            if (rodXVel > 0) {
                if ((rodXVel -= ((maxAcc ^ dt) & 0x8000000) != 0 ? -((int)((long)(-maxAcc) * (long)dt >> 16)) : (int)((long)maxAcc * (long)dt >> 16)) < 0) {
                    rodXVel = 0;
                }
            } else if (rodXVel < 0 && (rodXVel += ((maxAcc ^ dt) & 0x8000000) != 0 ? -((int)((long)(-maxAcc) * (long)dt >> 16)) : (int)((long)maxAcc * (long)dt >> 16)) > 0) {
                rodXVel = 0;
            }
        }
        if (rodPos[0] < minPos) {
            GameScreen.rodPos[0] = minPos;
            rodXVel = 0;
        } else if (rodPos[0] > maxPos) {
            GameScreen.rodPos[0] = maxPos;
            rodXVel = 0;
        }
    }

    public void moveRodBend() {
        if (!game.hasFishOn()) {
            if (ScreenLayout.keysDown(8)) {
                this.moveRodUp(((cfpRodAngleSpeedBend ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-cfpRodAngleSpeedBend) * (long)Application.fp_deltatime >> 16)) : (int)((long)cfpRodAngleSpeedBend * (long)Application.fp_deltatime >> 16));
            } else if (ScreenLayout.keysDown(1)) {
                this.moveRodDown(((cfpRodAngleSpeedBend ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-cfpRodAngleSpeedBend) * (long)Application.fp_deltatime >> 16)) : (int)((long)cfpRodAngleSpeedBend * (long)Application.fp_deltatime >> 16));
            }
        } else {
            fpRodAngle = FixedPoint.linearInterpolate(game.getFishFightTension(), cfpRodAngleMax, cfpRodAngleMin);
            int yDist = floatPos[1] - rodPos[1];
            int fpPullUpDist = 0x120000;
            if (yDist < fpPullUpDist) {
                if (yDist < 0) {
                    yDist = 0;
                }
                int l = (int)(((long)(fpPullUpDist - yDist) << 16) / (long)fpPullUpDist);
                fpRodAngle = FixedPoint.linearInterpolate(l, fpRodAngle, cfpRodAngleMin);
            }
        }
        if (game.hasFishOn()) {
            switch (GameScreen.game.fishType[GameScreen.game.currentFish]) {
                case 0: 
                case 1: {
                    this.fpAnglePull = GameLogic.randRange(262144, 327680);
                    break;
                }
                case 2: 
                case 3: {
                    this.fpAnglePull = GameLogic.randRange(458752, 655360);
                    break;
                }
                case 4: 
                case 5: {
                    this.fpAnglePull = GameLogic.randRange(655360, 983040);
                }
            }
            int fpMaxPull = 655360;
            int fpLowerBendPointFar = 655360;
            int fpLowerBendPointNear = -196608;
            if (this.fpAnglePull > fpMaxPull) {
                int yPos = floatPos[1];
                if (yPos > fpLowerBendPointFar) {
                    this.fpAnglePull = fpMaxPull;
                } else if (yPos > fpLowerBendPointNear) {
                    int l = (int)(((long)(yPos - fpLowerBendPointNear) << 16) / (long)(fpLowerBendPointFar - fpLowerBendPointNear));
                    this.fpAnglePull = FixedPoint.linearInterpolate(l, this.fpAnglePull, fpMaxPull);
                }
            }
        } else {
            this.fpAnglePull = 0;
        }
    }

    public void RodResetAngleToDown() {
        fpRodAngle = cfpRodAngleMax;
    }

    public void RodResetAngleToUp() {
        fpRodAngle = cfpRodAngleMin;
    }

    public void moveRodUp(int fpAmount) {
        fpRodAngle = fpRodAngle - fpAmount > cfpRodAngleMin ? fpRodAngle - fpAmount : cfpRodAngleMin;
    }

    public void moveRodDown(int fpAmount) {
        fpRodAngle = fpRodAngle + fpAmount < cfpRodAngleMax ? fpRodAngle + fpAmount : cfpRodAngleMax;
    }

    public static void drawTriangle(Graphics g, int x0, int y0, int x1, int y1, int x2, int y2, int col) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        GfxUtils.setColor(g, col);
        GfxUtils.drawTriangle(g, x0, y0, x1, y1, x2, y2);
        GfxUtils.setColor(g, 0);
        g.drawLine(x0, y0, x1, y1);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x0, y0);
    }

    public void debugDrawText3D(Graphics g, String txt, int[] pos) {
        GameScreen.worldToScreenPos(dbgPos, pos);
        int x = dbgPos[0] < 0 ? -(-dbgPos[0] >> 16) : dbgPos[0] >> 16;
        int y = dbgPos[1] < 0 ? -(-dbgPos[1] >> 16) : dbgPos[1] >> 16;
        ScreenStack.fontSmall.drawText(g, txt, x, y, visibleRect);
    }

    private void drawTitle(Graphics g, String strTitleText, int titlePos) {
        if (strTitleText != null) {
            short fh = ScreenStack.font.getFontHeight();
            int pos = GameLogic.transitionAmount;
            int n = pos = GameScreen.game.fp_state_time > 196608 ? 65536 - (GameScreen.game.fp_state_time - 196608) : 65536;
            pos = pos < 0 ? 0 : (pos > 65536 ? 65536 : pos);
            pos = pos < GameLogic.transitionAmount ? pos : GameLogic.transitionAmount;
            titlePos = FixedPoint.linearInterpolate(pos, -fh, fh);
            GameScreen.drawCenteredText(g, ScreenStack.font, strTitleText, titlePos);
            if (strTitleText.indexOf("$game.title.view$") != -1) {
                short strW = ScreenStack.font.getTextWidth("$game.title.view$");
                int yp = titlePos + (ScreenStack.font.getFontHeight() >> 1) - (ScreenStack.gfxButtonIcons.getRectHeight(3) >> 1);
                ScreenStack.gfxButtonIcons.drawImage(g, 2, (BaseScreen.displayWidth >> 1) - (strW >> 1) - ScreenStack.gfxButtonIcons.getRectWidth(2) - 1, yp);
                ScreenStack.gfxButtonIcons.drawImage(g, 3, (BaseScreen.displayWidth >> 1) + (strW >> 1) + 1, yp);
            }
        }
    }

    public void drawPressFire(Graphics g, boolean on) {
        BitmapFont pmFont = ScreenStack.fontSmall;
        if (!GameScreen.isPaused() && on) {
            GameScreen.drawCenteredText(g, pmFont, "" + MultiLingual.get(137) + "", this.fire_y0);
        }
    }

    public static void setTickerMessage(String str) {
        System.out.println("SetTickerMessage: " + str);
        strScrollingMsg = str;
        scrollMsgWidth = speechFont.getTextWidth(strScrollingMsg);
        scrollMessageXpos = BaseScreen.displayWidth;
    }

    public static String getWeightString(int ounces) {
        weightStr = "" + ounces / 16 + " " + MultiLingual.get(194) + "";
        if (ounces % 16 > 0) {
            weightStr = weightStr + " " + ounces % 16 + " " + MultiLingual.get(195) + "";
        }
        return weightStr;
    }

    public static void updateTickerMsg(int weight) {
        strWeight = GameScreen.getWeightString(weight);
        strCutoff = GameScreen.getWeightString(GameLogic.cutOffCatch);
        strScrollingMsg = GameSequence.day == 2 ? FrontEnd.instance.gameSequence.getDayName() + " " + "" + MultiLingual.get(296) + "...  " + MultiLingual.get(297) + ": " + strWeight + "   " : FrontEnd.instance.gameSequence.getDayName() + " " + "" + MultiLingual.get(296) + "...  " + MultiLingual.get(298) + ": " + strWeight + "   " + MultiLingual.get(299) + ": " + strCutoff + " ";
        scrollMsgWidth = speechFont.getTextWidth(strScrollingMsg);
        if (scrollMessageXpos < 0) {
            scrollMessageXpos = BaseScreen.displayWidth;
        }
        System.out.println("updateTickerMsg: " + strScrollingMsg);
    }

    public void drawTicker(Graphics g) {
        if (!GameScreen.isPaused()) {
            --scrollMessageXpos;
        }
        speechFont.drawText(g, strScrollingMsg, scrollMessageXpos, cBorderY, visibleRect);
    }

    public void drawPlace(Graphics g) {
        block4: {
            String strPos;
            int y;
            block6: {
                block5: {
                    short fh = speechFont.getFontHeight();
                    y = fh + cBorderY;
                    if (FrontEnd.gameType == 0) {
                        return;
                    }
                    if (FrontEnd.gameType != 1) break block4;
                    if (GameLogic.competitorFish == null || GameScreen.isPaused()) break block4;
                    strPos = "" + MultiLingual.get(152) + ": " + "" + GameLogic.currentPlace + "/" + GameSequence.cPlayersInRound[GameSequence.day];
                    if (GameSequence.day != 2) break block5;
                    speechFont.drawText(g, strPos, BaseScreen.displayWidth - speechFont.getTextWidth(strPos) - cBorderX, y, visibleRect);
                    break block4;
                }
                if (flashOn) break block6;
                if (GameLogic.currentPlace > GameSequence.cPositionToAdvance[GameSequence.day]) break block4;
            }
            speechFont.drawText(g, strPos, BaseScreen.displayWidth - speechFont.getTextWidth(strPos) - cBorderX, y, visibleRect);
        }
    }

    public void drawScore(Graphics g) {
        if (FrontEnd.gameType == 0) {
            String strScore = "" + MultiLingual.get(153) + ": " + arcadeScore;
            GameScreen.drawCenteredText(g, speechFont, strScore, cBorderY);
        }
    }

    public static void drawCenteredText(Graphics g, BitmapFont font, String text, int y) {
        short w = font.getTextWidth(text);
        int x0 = displayWidth - w >> 1;
        font.drawText(g, text, x0, y, visibleRect);
    }

    public static void drawCenteredText(Graphics g, BitmapFont font, String text, int dx, int y) {
        short w = font.getTextWidth(text);
        int x0 = dx + (displayWidth - w >> 1);
        font.drawText(g, text, x0, y, visibleRect);
    }

    public static int getCurrentRod() {
        return selectedItems[0];
    }

    public static int getCurrentReel() {
        return selectedItems[1];
    }

    public static int getCurrent(int item) {
        if (item < 0 || item >= 4) {
            System.out.println("Assertion Failure: item >= cItemRod && item < cItemSpecial with msg: You can't select items of type " + item + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java" + "[" + 2927 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return selectedItems[item];
    }

    public static void setCurrentLure(int i) {
        GameScreen.selectedItems[3] = i;
    }

    public static int calculateNormalisedTension() {
        if (game.hasFishOn()) {
            int fpBonus = 65536 + (int)(((long)(cRodTensionBonus[GameScreen.getCurrentRod()] < 0 ? -(-cRodTensionBonus[GameScreen.getCurrentRod()] << 16) : cRodTensionBonus[GameScreen.getCurrentRod()] << 16) << 16) / 0x640000L);
            int fpTopWeight = ((((cLineWeightLimit[GameScreen.getCurrent(2)] < 0 ? -(-cLineWeightLimit[GameScreen.getCurrent(2)] << 16) : cLineWeightLimit[GameScreen.getCurrent(2)] << 16) ^ fpBonus) & 0x8000000) != 0 ? -((int)((long)(-(cLineWeightLimit[GameScreen.getCurrent(2)] < 0 ? -(-cLineWeightLimit[GameScreen.getCurrent(2)] << 16) : cLineWeightLimit[GameScreen.getCurrent(2)] << 16)) * (long)fpBonus >> 16)) : (int)((long)(cLineWeightLimit[GameScreen.getCurrent(2)] < 0 ? -(-cLineWeightLimit[GameScreen.getCurrent(2)] << 16) : cLineWeightLimit[GameScreen.getCurrent(2)] << 16) * (long)fpBonus >> 16)) * 16;
            int fpTension = (int)(((long)(game.getCurrentFishWeight() < 0 ? -(-game.getCurrentFishWeight() << 16) : game.getCurrentFishWeight() << 16) << 16) / (long)fpTopWeight);
            fpTension = fpTension < 0 ? 0 : (fpTension > 65536 ? 65536 : fpTension);
            return fpTension;
        }
        return 0;
    }

    public static int getRodPull() {
        return cRodMaxPull[GameScreen.getCurrentReel()] < 0 ? -(-cRodMaxPull[GameScreen.getCurrentReel()] << 16) : cRodMaxPull[GameScreen.getCurrentReel()] << 16;
    }

    public void drawRodBend(Graphics g) {
        int fpLineOffset = FixedPoint.stringToFP("0.7");
        int fpReelOffset = FixedPoint.stringToFP("1.0");
        int ringMaxSize = GameScreen.getScaledX(5);
        int x1 = BaseScreen.displayWidth >> 1;
        int y1 = BaseScreen.displayHeight >> 1;
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        int fpAngle = fpRodAngle;
        int[] fpRodPos = new int[]{rodPos[0], rodPos[1], rodPos[2]};
        GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
        x1 = this.floatScreenPos[0];
        y1 = this.floatScreenPos[1] + this.bigBoatYwave;
        fpRodPos[0] = fpRodPos[0] + fpReelOffset;
        GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
        fpRodPos[0] = fpRodPos[0] - fpReelOffset;
        int linex1 = this.floatScreenPos[0];
        int liney1 = this.floatScreenPos[1] + this.bigBoatYwave;
        fpAngle = fpRodAngle;
        int fpLevel = (int)(((long)(GameScreen.getCurrentRod() + 1 < 0 ? -(-(GameScreen.getCurrentRod() + 1) << 16) : GameScreen.getCurrentRod() + 1 << 16) << 16) / 327680L);
        int fpRodSegLen = cfpRodSegLenMin + (((cfpRodSegLenMax - cfpRodSegLenMin ^ fpLevel) & 0x8000000) != 0 ? -((int)((long)(-cfpRodSegLenMax - cfpRodSegLenMin) * (long)fpLevel >> 16)) : (int)((long)(cfpRodSegLenMax - cfpRodSegLenMin) * (long)fpLevel >> 16));
        for (int i = 0; i < 5; ++i) {
            int x2 = ((FixedPoint.sinLut(fpAngle) ^ fpRodSegLen) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fpAngle)) * (long)fpRodSegLen >> 16)) : (int)((long)FixedPoint.sinLut(fpAngle) * (long)fpRodSegLen >> 16);
            int y2 = ((FixedPoint.sinLut(fpAngle + 0x400000) ^ fpRodSegLen) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fpAngle + 0x400000)) * (long)fpRodSegLen >> 16)) : (int)((long)FixedPoint.sinLut(fpAngle + 0x400000) * (long)fpRodSegLen >> 16);
            fpRodPos[1] = fpRodPos[1] - x2;
            fpRodPos[2] = fpRodPos[2] - y2;
            GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
            g.setColor(3880972);
            int xrod = this.floatScreenPos[0];
            int yrod = this.floatScreenPos[1] + this.bigBoatYwave;
            fpRodPos[2] = fpRodPos[2] - fpLineOffset;
            GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
            fpRodPos[2] = fpRodPos[2] + fpLineOffset;
            int xline = this.floatScreenPos[0];
            int yline = this.floatScreenPos[1] + this.bigBoatYwave;
            if (i < 4) {
                int r;
                int cy;
                int cx;
                if (i == 0) {
                    g.setColor(9613474);
                    g.drawLine(linex1, liney1, xline, yline);
                    cx = xline + xrod >> 1;
                    cy = yline + yrod >> 1;
                    r = Math.abs(xline - xrod) > Math.abs(yline - yrod) ? Math.abs(xline - xrod) : Math.abs(yline - yrod);
                    r = r < ringMaxSize ? r : ringMaxSize;
                    g.drawArc(cx - (r >> 1), cy - (r >> 1) + 0, r, r, 0, 360);
                    g.setColor(cRodColours[GameScreen.getCurrentRod()]);
                    g.drawLine(x1 - 2, y1, xrod - 2, yrod);
                    g.setColor(cRodColours[GameScreen.getCurrentRod()]);
                    g.drawLine(x1 - 1, y1, xrod - 1, yrod);
                    g.setColor(0x404040);
                    g.drawLine(x1, y1, xrod, yrod);
                    g.setColor(cRodColours[GameScreen.getCurrentRod()]);
                    g.drawLine(x1 + 1, y1, xrod + 1, yrod);
                    g.setColor(cRodColours[GameScreen.getCurrentRod()]);
                    g.drawLine(x1 + 2, y1, xrod + 2, yrod);
                } else {
                    g.setColor(9613474);
                    g.drawLine(linex1, liney1, xline, yline);
                    cx = xline + xrod >> 1;
                    cy = yline + yrod >> 1;
                    r = Math.abs(xline - xrod) > Math.abs(yline - yrod) ? Math.abs(xline - xrod) : Math.abs(yline - yrod);
                    r = r < ringMaxSize ? r : ringMaxSize;
                    g.drawArc(cx - (r >> 1), cy - (r >> 1) + 0, r, r, 0, 360);
                    g.setColor(7020043);
                    g.drawLine(x1 - 1, y1, xrod - 1, yrod);
                    g.setColor(0x774E44);
                    g.drawLine(x1, y1, xrod, yrod);
                    g.setColor(7020043);
                    g.drawLine(x1 + 1, y1, xrod + 1, yrod);
                }
            } else {
                g.setColor(9613474);
                g.drawLine(linex1, liney1, xrod, yrod);
                g.setColor(7020043);
                g.drawLine(x1 - 1, y1, xrod, yrod);
                g.setColor(0x774E44);
                g.drawLine(x1, y1, xrod, yrod);
                g.setColor(7020043);
                g.drawLine(x1 + 1, y1, xrod, yrod);
            }
            x1 = xrod;
            y1 = yrod;
            linex1 = xline;
            liney1 = yline;
            fpAngle += this.fpAnglePull;
        }
        this.rodTipScrX = x1;
        this.rodTipScrY = y1;
        gfxReel.drawImage(g, reelFrame, BaseScreen.displayWidth - (gfxReel.getRectWidth(0) + cBorderX), BaseScreen.displayHeight - (gfxReel.getRectHeight(0) + gfxPauseMenu.getRectHeight(0) + cBorderY));
    }

    public String getGameTime() {
        StringBuffer str_time = new StringBuffer("");
        int time_count_down = gameTime / 1000;
        int secs = time_count_down % 60;
        int mins = time_count_down / 60;
        str_time.append(mins + ":");
        if (secs < 10) {
            str_time.append("0" + secs);
        } else {
            str_time.append(secs);
        }
        return "" + str_time;
    }

    public void drawGameTime(Graphics g) {
        if (FrontEnd.gameType == 2) {
            return;
        }
        StringBuffer str_time = new StringBuffer("");
        int time_count_down = gameTime / 1000;
        int secs = time_count_down % 60;
        int mins = time_count_down / 60;
        str_time.append(mins + ":");
        if (secs < 10) {
            str_time.append("0" + secs);
        } else {
            str_time.append(secs);
        }
        boolean draw = true;
        if (FrontEnd.gameType == 1 && gameTime < 30000 && gameTime > 0) {
            str_time.append(" - " + MultiLingual.get(159) + "");
            draw = fastFlashOn;
        }
        int x = cBorderX;
        short fh = ScreenStack.fontSmall.getFontHeight();
        int y = fh + cBorderY;
        if (draw) {
            ScreenStack.fontSmall.drawText(g, "" + str_time, x, y, visibleRect);
        }
    }

    public void drawFloatAndLine(Graphics g) {
        int i;
        int gravity;
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (GameScreen.game.currentState == 0 || GameScreen.game.currentState == 1 || GameScreen.game.currentState == 2 || GameScreen.game.currentState == 10 || GameScreen.game.currentState == 11) {
            return;
        }
        int drawx = 0;
        GameScreen.worldToScreenPos(this.floatScreenPos, floatPos);
        if (GameScreen.game.currentState == 8 || GameScreen.game.currentState == 7) {
            this.floatScreenPos[1] = this.floatScreenPos[1] + this.bigBoatYwave;
        }
        int wave_len = BaseScreen.getScaledY(2);
        int yoffset = (((FixedPoint.sinLut(fp_waterAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_waterAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_waterAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) < 0 ? -(-(((FixedPoint.sinLut(fp_waterAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_waterAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_waterAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) >> 16) : (((FixedPoint.sinLut(fp_waterAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_waterAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_waterAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) >> 16;
        int t = Application.fp_deltatime;
        int x = this.floatScreenPos[0] - drawx;
        int y = this.floatScreenPos[1];
        if (game.hasFishOn()) {
            g.setColor(9613474);
            g.drawLine(this.rodTipScrX, this.rodTipScrY, x, y);
            return;
        }
        int n = gravity = ((0xA0000 ^ t) & 0x8000000) != 0 ? -((int)(-655360L * (long)t >> 16)) : (int)(655360L * (long)t >> 16);
        if (this.initLine) {
            System.out.println("initline!");
            this.initLine = false;
            y = 50;
            int yv = -10;
            for (int i2 = 0; i2 < cNumLineElements; ++i2) {
                GameScreen.fpLineSegmentX[i2] = this.rodTipScrX < 0 ? -(-this.rodTipScrX << 16) : this.rodTipScrX << 16;
                GameScreen.fpLineSegmentY[i2] = y < 0 ? -(-y << 16) : y << 16;
                GameScreen.fpLineSegmentYVel[i2] = 0;
                y += yv;
                ++yv;
            }
        }
        GameScreen.fpLineSegmentX[0] = this.rodTipScrX < 0 ? -(-this.rodTipScrX << 16) : this.rodTipScrX << 16;
        int n2 = GameScreen.fpLineSegmentY[0] = this.rodTipScrY < 0 ? -(-this.rodTipScrY << 16) : this.rodTipScrY << 16;
        if (!GameScreen.isPaused()) {
            if (!game.isReelingIn()) {
                GameScreen.fpLineSegmentX[GameScreen.cNumLineElements - 1] = x + lineDrawXoffset < 0 ? -(-(x + lineDrawXoffset) << 16) : x + lineDrawXoffset << 16;
                int n3 = GameScreen.fpLineSegmentY[GameScreen.cNumLineElements - 1] = y + lineDrawYoffset < 0 ? -(-(y + lineDrawYoffset) << 16) : y + lineDrawYoffset << 16;
            }
            if (game.hasFishOn() && cfpMaxLineSegmentLen > 65536) {
                cfpMaxLineSegmentLen -= 65536;
            }
            for (i = 1; i < cNumLineElements; ++i) {
                int fpVel;
                int n4 = fpVel = ((fpLineSegmentYVel[i] ^ t) & 0x8000000) != 0 ? -((int)((long)(-fpLineSegmentYVel[i]) * (long)t >> 16)) : (int)((long)fpLineSegmentYVel[i] * (long)t >> 16);
                if (game.isReelingIn() || i != cNumLineElements - 1) {
                    int n5 = i;
                    fpLineSegmentY[n5] = fpLineSegmentY[n5] + fpVel;
                }
                int n6 = i;
                fpLineSegmentYVel[n6] = fpLineSegmentYVel[n6] + gravity;
                int dx = fpLineSegmentX[i] - fpLineSegmentX[i - 1];
                int dy = fpLineSegmentY[i] - fpLineSegmentY[i - 1];
                int len = (((dx ^ dx) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)dx >> 16)) : (int)((long)dx * (long)dx >> 16)) + (((dy ^ dy) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)dy >> 16)) : (int)((long)dy * (long)dy >> 16));
                if ((len = FixedPoint.sqrt_bits(len)) <= cfpMaxLineSegmentLen) continue;
                int diff = (int)(((long)(len - cfpMaxLineSegmentLen) << 16) / (long)len);
                int fpDamp = FixedPoint.stringToFP("0.6");
                if (game.hasFishOn() || this.bLineStressed) {
                    fpDamp = FixedPoint.stringToFP("0.8");
                }
                if (!game.isReelingIn()) {
                    if (i != cNumLineElements - 1) {
                        int n7 = i;
                        fpLineSegmentX[n7] = fpLineSegmentX[n7] - ((((((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) * (long)diff >> 16));
                        int n8 = i;
                        fpLineSegmentY[n8] = fpLineSegmentY[n8] - ((((((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) * (long)diff >> 16));
                    }
                    if (i <= 1) continue;
                    int n9 = i - 1;
                    fpLineSegmentX[n9] = fpLineSegmentX[n9] + ((((((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) * (long)diff >> 16));
                    int n10 = i - 1;
                    fpLineSegmentY[n10] = fpLineSegmentY[n10] + ((((((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) * (long)diff >> 16));
                    continue;
                }
                fpDamp = FixedPoint.stringToFP("0.5");
                int n11 = i;
                fpLineSegmentX[n11] = fpLineSegmentX[n11] - ((((((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dx ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dx) * (long)fpDamp >> 16)) : (int)((long)dx * (long)fpDamp >> 16)) * (long)diff >> 16));
                int n12 = i;
                fpLineSegmentY[n12] = fpLineSegmentY[n12] - ((((((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) ^ diff) & 0x8000000) != 0 ? -((int)((long)(-(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16))) * (long)diff >> 16)) : (int)((long)(((dy ^ fpDamp) & 0x8000000) != 0 ? -((int)((long)(-dy) * (long)fpDamp >> 16)) : (int)((long)dy * (long)fpDamp >> 16)) * (long)diff >> 16));
            }
        }
        if (GameScreen.game.currentState != 3) {
            for (i = 0; i < cNumLineElements - 1; ++i) {
                int col = (int)(((long)(i < 0 ? -(-i << 16) : i << 16) << 16) / (long)(cNumLineElements < 0 ? -(-cNumLineElements << 16) : cNumLineElements << 16));
                int drawColor = GfxUtils.lerpColour(col, 9613474, 3953483);
                g.setColor(drawColor);
                g.drawLine(fpLineSegmentX[i] < 0 ? -(-fpLineSegmentX[i] >> 16) : fpLineSegmentX[i] >> 16, fpLineSegmentY[i] < 0 ? -(-fpLineSegmentY[i] >> 16) : fpLineSegmentY[i] >> 16, fpLineSegmentX[i + 1] < 0 ? -(-fpLineSegmentX[i + 1] >> 16) : fpLineSegmentX[i + 1] >> 16, fpLineSegmentY[i + 1] < 0 ? -(-fpLineSegmentY[i + 1] >> 16) : fpLineSegmentY[i + 1] >> 16);
            }
        }
        g.setColor(0xFFFFFF);
        g.fillRect(fpLineSegmentX[fpLineSegmentX.length - 1] < 0 ? -(-fpLineSegmentX[fpLineSegmentX.length - 1] >> 16) : fpLineSegmentX[fpLineSegmentX.length - 1] >> 16, fpLineSegmentY[fpLineSegmentX.length - 1] < 0 ? -(-fpLineSegmentY[fpLineSegmentX.length - 1] >> 16) : fpLineSegmentY[fpLineSegmentX.length - 1] >> 16, 2, 1);
    }

    public void resetRod() {
        gameEffects.killAllEffects();
        fpRodAngle = cfpRodAngleMax;
        this.fpAnglePull = 0;
        GameScreen.floatVel[2] = 0;
        GameScreen.floatVel[1] = 0;
        GameScreen.floatVel[0] = 0;
        GameScreen.floatPos[0] = rodStartPos[0];
        GameScreen.floatPos[1] = rodStartPos[1];
        GameScreen.floatPos[2] = rodStartPos[2];
        GameScreen.rodPos[0] = rodStartPos[0];
        GameScreen.rodPos[1] = rodStartPos[1];
        GameScreen.rodPos[2] = rodStartPos[2];
        rodXVel = 0;
        cfpMaxLineSegmentLen = GameScreen.getScaledY(393216);
        fpRodLineTension = 0;
        this.initLine = true;
        this.bLineStressed = false;
        BaseScreen.resetKeys();
    }

    public void drawFishInWater(Graphics g) {
        for (int i = 0; i < GameScreen.game.numFish; ++i) {
            if (GameScreen.game.fishState[i] == 3 || GameScreen.gameEffects.fishHeadOn && GameScreen.gameEffects.fishHeadDrawn && GameScreen.game.currentFish == i) continue;
            int fishAlpha = GameScreen.game.fishAlpha[i];
            int colNear = GfxUtils.lerpColour(fishAlpha, 2372412, 1911088);
            int colFar = GfxUtils.lerpColour(fishAlpha, 4482163, 2965835);
            int distLerp = (int)(((long)(GameScreen.game.fishPos[i][1] - GameLogic.cfpFishMinY) << 16) / (long)(GameLogic.cfpFishMaxY - GameLogic.cfpFishMinY));
            distLerp = distLerp < 0 ? 0 : (distLerp > 65536 ? 65536 : distLerp);
            int col = GfxUtils.lerpColour(distLerp, colNear, colFar);
            g.setColor(col);
            int fpRot = GameScreen.game.fishRot[i];
            int fpLen = GameScreen.game.fishSize[i][1];
            int fpWid = GameScreen.game.fishSize[i][0];
            int fpRotSin = FixedPoint.sinLut(fpRot);
            int fpRotCos = FixedPoint.sinLut(fpRot + 0x400000);
            int fpTailOffset = (((fpWid ^ FixedPoint.sinLut(GameScreen.game.fishTailPhase[i])) & 0x8000000) != 0 ? -((int)((long)(-fpWid) * (long)FixedPoint.sinLut(GameScreen.game.fishTailPhase[i]) >> 16)) : (int)((long)fpWid * (long)FixedPoint.sinLut(GameScreen.game.fishTailPhase[i]) >> 16)) >> 1;
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        this.fishTempPos[0] = (((fpRotCos ^ fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)fpLen >> 16)) : (int)((long)fpRotCos * (long)fpLen >> 16)) + (((fpRotSin ^ fpWid) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)fpWid >> 16)) : (int)((long)fpRotSin * (long)fpWid >> 16));
                        this.fishTempPos[1] = (((fpRotSin ^ fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)fpLen >> 16)) : (int)((long)fpRotSin * (long)fpLen >> 16)) - (((fpRotCos ^ fpWid) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)fpWid >> 16)) : (int)((long)fpRotCos * (long)fpWid >> 16));
                        this.fishTempPos[2] = 0;
                        break;
                    }
                    case 1: {
                        this.fishTempPos[0] = (((fpRotCos ^ fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)fpLen >> 16)) : (int)((long)fpRotCos * (long)fpLen >> 16)) + (((fpRotSin ^ -fpWid) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)(-fpWid) >> 16)) : (int)((long)fpRotSin * (long)(-fpWid) >> 16));
                        this.fishTempPos[1] = (((fpRotSin ^ fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)fpLen >> 16)) : (int)((long)fpRotSin * (long)fpLen >> 16)) - (((fpRotCos ^ -fpWid) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)(-fpWid) >> 16)) : (int)((long)fpRotCos * (long)(-fpWid) >> 16));
                        break;
                    }
                    case 2: {
                        this.fishTempPos[0] = (((fpRotCos ^ -fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)(-fpLen) >> 16)) : (int)((long)fpRotCos * (long)(-fpLen) >> 16)) + (((fpRotSin ^ fpTailOffset - (fpWid >> 1)) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)(fpTailOffset - (fpWid >> 1)) >> 16)) : (int)((long)fpRotSin * (long)(fpTailOffset - (fpWid >> 1)) >> 16));
                        this.fishTempPos[1] = (((fpRotSin ^ -fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)(-fpLen) >> 16)) : (int)((long)fpRotSin * (long)(-fpLen) >> 16)) - (((fpRotCos ^ fpTailOffset - (fpWid >> 1)) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)(fpTailOffset - (fpWid >> 1)) >> 16)) : (int)((long)fpRotCos * (long)(fpTailOffset - (fpWid >> 1)) >> 16));
                        break;
                    }
                    case 3: {
                        this.fishTempPos[0] = (((fpRotCos ^ -fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)(-fpLen) >> 16)) : (int)((long)fpRotCos * (long)(-fpLen) >> 16)) + (((fpRotSin ^ (fpWid >> 1) + fpTailOffset) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)((fpWid >> 1) + fpTailOffset) >> 16)) : (int)((long)fpRotSin * (long)((fpWid >> 1) + fpTailOffset) >> 16));
                        this.fishTempPos[1] = (((fpRotSin ^ -fpLen) & 0x8000000) != 0 ? -((int)((long)(-fpRotSin) * (long)(-fpLen) >> 16)) : (int)((long)fpRotSin * (long)(-fpLen) >> 16)) - (((fpRotCos ^ (fpWid >> 1) + fpTailOffset) & 0x8000000) != 0 ? -((int)((long)(-fpRotCos) * (long)((fpWid >> 1) + fpTailOffset) >> 16)) : (int)((long)fpRotCos * (long)((fpWid >> 1) + fpTailOffset) >> 16));
                    }
                }
                this.fishVertPos[0] = this.fishTempPos[0] + GameScreen.game.fishPos[i][0];
                this.fishVertPos[1] = this.fishTempPos[1] + GameScreen.game.fishPos[i][1];
                this.fishVertPos[2] = this.fishTempPos[2] + GameScreen.game.fishPos[i][2];
                GameScreen.worldToScreenPos(this.fishInWaterScreenPos, this.fishVertPos);
                this.fv[j][0] = this.fishInWaterScreenPos[0];
                this.fv[j][1] = this.fishInWaterScreenPos[1];
            }
            g.fillTriangle(this.fv[0][0], this.fv[0][1], this.fv[1][0], this.fv[1][1], this.fv[2][0], this.fv[2][1]);
            g.fillTriangle(this.fv[0][0], this.fv[0][1], this.fv[2][0], this.fv[2][1], this.fv[3][0], this.fv[3][1]);
            int frontCircleX = this.fv[0][0] + this.fv[1][0] >> 1;
            int frontCircleY = this.fv[0][1] + this.fv[1][1] >> 1;
            int backCircleX = this.fv[2][0] + this.fv[3][0] >> 1;
            int backCircleY = this.fv[2][1] + this.fv[3][1] >> 1;
            int dx = this.fv[0][0] - this.fv[1][0];
            int dy = this.fv[0][1] - this.fv[1][1];
            int rad = FixedPoint.sqrt_bits((dx * dx < 0 ? -(-(dx * dx) << 16) : dx * dx << 16) + (dy * dy < 0 ? -(-(dy * dy) << 16) : dy * dy << 16));
            rad = rad < 0 ? -(-rad >> 16) : rad >> 16;
            g.fillArc(frontCircleX - (rad >> 1), frontCircleY - (rad >> 1), rad, rad, 0, 360);
            dx = this.fv[2][0] - this.fv[3][0];
            dy = this.fv[2][1] - this.fv[3][1];
            rad = FixedPoint.sqrt_bits((dx * dx < 0 ? -(-(dx * dx) << 16) : dx * dx << 16) + (dy * dy < 0 ? -(-(dy * dy) << 16) : dy * dy << 16));
            rad = rad < 0 ? -(-rad >> 16) : rad >> 16;
            g.fillArc(backCircleX - (rad >> 1), backCircleY - (rad >> 1), rad, rad, 0, 360);
            int tailTopX = this.fv[2][0] - this.fv[0][0];
            int tailTopY = this.fv[2][1] - this.fv[0][1];
            int tailBotX = this.fv[3][0] - this.fv[1][0];
            int tailBotY = this.fv[3][1] - this.fv[1][1];
            int tailMidX = ((tailTopX + tailBotX ^ FixedPoint.stringToFP("0.2")) & 0x8000000) != 0 ? -((int)((long)(-(tailTopX + tailBotX)) * (long)FixedPoint.stringToFP("0.2") >> 16)) : (int)((long)(tailTopX + tailBotX) * (long)FixedPoint.stringToFP("0.2") >> 16);
            int tailMidY = ((tailTopY + tailBotY ^ FixedPoint.stringToFP("0.2")) & 0x8000000) != 0 ? -((int)((long)(-(tailTopY + tailBotY)) * (long)FixedPoint.stringToFP("0.2") >> 16)) : (int)((long)(tailTopY + tailBotY) * (long)FixedPoint.stringToFP("0.2") >> 16);
            tailTopX = (tailTopX >> 1) + backCircleX;
            tailTopY = (tailTopY >> 1) + backCircleY;
            tailBotX = (tailBotX >> 1) + backCircleX;
            tailBotY = (tailBotY >> 1) + backCircleY;
            g.fillTriangle(tailTopX, tailTopY, tailMidX += backCircleX, tailMidY += backCircleY, backCircleX, backCircleY);
            g.fillTriangle(tailMidX, tailMidY, tailBotX, tailBotY, backCircleX, backCircleY);
        }
    }

    public void animateBoat() {
        fp_boatAngle += ((FixedPoint.stringToFP("50") ^ Application.fp_deltatime) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.stringToFP("50")) * (long)Application.fp_deltatime >> 16)) : (int)((long)FixedPoint.stringToFP("50") * (long)Application.fp_deltatime >> 16);
        fp_boatAngle &= 0xFFFFFF;
    }

    public void doWaterWave(Graphics g, Image img, int yStart, int yOffset, int iDistortStart, int fpAngleUpdate, int amplitute) {
        int amplitudeX = 0;
        int fp_ang = fp_waterAngle;
        int viewX = img.getWidth() - BaseScreen.displayWidth >> 1;
        g.setClip(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        g.drawImage(img, 0, yStart + yOffset, 0x10 | 4);
        for (int y = yStart; y < BaseScreen.displayHeight; ++y) {
            if (y < iDistortStart) {
                amplitudeX = 0;
            } else if (y == iDistortStart) {
                amplitudeX = 65536;
            }
            int xoffset = (((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) < 0 ? -(-(((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) >> 16) : (((FixedPoint.sinLut(fp_ang) ^ amplitudeX) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_ang)) * (long)amplitudeX >> 16)) : (int)((long)FixedPoint.sinLut(fp_ang) * (long)amplitudeX >> 16)) >> 16;
            g.setClip(0, y, BaseScreen.displayWidth, 1);
            g.drawImage(img, xoffset - viewX, yStart + yOffset, 0x10 | 4);
            amplitudeX += amplitute;
            fp_ang += fpAngleUpdate;
            fp_ang &= 0xFFFFFF;
        }
        fp_waterAngle += 65536;
        fp_waterAngle &= 0xFFFFFF;
        g.setClip(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
    }

    public void getRodTipPos() {
        int x1 = BaseScreen.displayWidth >> 1;
        int y1 = BaseScreen.displayHeight >> 1;
        int fpAngle = fpRodAngle;
        GameScreen.fpRodPos[0] = rodPos[0];
        GameScreen.fpRodPos[1] = rodPos[1];
        GameScreen.fpRodPos[2] = rodPos[2];
        GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
        x1 = this.floatScreenPos[0];
        y1 = this.floatScreenPos[1] + this.bigBoatYwave;
        fpAngle = fpRodAngle;
        int fpLevel = (int)(((long)(GameScreen.getCurrentRod() + 1 < 0 ? -(-(GameScreen.getCurrentRod() + 1) << 16) : GameScreen.getCurrentRod() + 1 << 16) << 16) / 327680L);
        int fpRodSegLen = cfpRodSegLenMin + (((cfpRodSegLenMax - cfpRodSegLenMin ^ fpLevel) & 0x8000000) != 0 ? -((int)((long)(-cfpRodSegLenMax - cfpRodSegLenMin) * (long)fpLevel >> 16)) : (int)((long)(cfpRodSegLenMax - cfpRodSegLenMin) * (long)fpLevel >> 16));
        for (int i = 0; i < 5; ++i) {
            int x2 = ((FixedPoint.sinLut(fpAngle) ^ fpRodSegLen) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fpAngle)) * (long)fpRodSegLen >> 16)) : (int)((long)FixedPoint.sinLut(fpAngle) * (long)fpRodSegLen >> 16);
            int y2 = ((FixedPoint.sinLut(fpAngle + 0x400000) ^ fpRodSegLen) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fpAngle + 0x400000)) * (long)fpRodSegLen >> 16)) : (int)((long)FixedPoint.sinLut(fpAngle + 0x400000) * (long)fpRodSegLen >> 16);
            fpRodPos[1] = fpRodPos[1] - x2;
            fpRodPos[2] = fpRodPos[2] - y2;
            GameScreen.worldToScreenPos(this.floatScreenPos, fpRodPos);
            int xrod = this.floatScreenPos[0];
            int yrod = this.floatScreenPos[1] + this.bigBoatYwave;
            x1 = xrod;
            y1 = yrod;
            fpAngle += this.fpAnglePull;
        }
        this.rodTipScrX = x1;
        this.rodTipScrY = y1;
    }

    public void drawBackground(Graphics g) {
        int iBaseCoord;
        if (!GameScreen.isPaused()) {
            this.fpSkyScrollingOffset += FixedPoint.stringToFP("0.2");
            if (this.fpSkyScrollingOffset > ((this.bgLayers[0].getWidth() << 1) - 1 < 0 ? -(-((this.bgLayers[0].getWidth() << 1) - 1) << 16) : (this.bgLayers[0].getWidth() << 1) - 1 << 16)) {
                this.fpSkyScrollingOffset = 0;
            }
        }
        boolean bUseInterpolatedSky = (iBaseCoord & 1) != 0 && this.bgLayers[1] != null;
        boolean y_offset = false;
        for (iBaseCoord = -this.fpSkyScrollingOffset < 0 ? -(-(-this.fpSkyScrollingOffset) >> 16) : -this.fpSkyScrollingOffset >> 16; iBaseCoord < BaseScreen.displayWidth << 1; iBaseCoord += (this.bgLayers[0].getWidth() << 1) - 1) {
            int yPos = -GameScreen.getScaledY(40);
            if (bUseInterpolatedSky) {
                g.drawImage(this.bgLayers[1], iBaseCoord / 2, yPos, 0x10 | 4);
                continue;
            }
            g.drawImage(this.bgLayers[0], iBaseCoord / 2, yPos, 0x10 | 4);
        }
        int iFacadeStart = 0;
        int iFacadeEnd = iFacadeStart + this.bgLayers[2].getHeight();
        int drawx = -((((fpScrollX ^ (this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) < 0 ? -(-(((fpScrollX ^ (this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16) : (((fpScrollX ^ (this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[3].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[3].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[3].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16);
        int extraHackyYOffset = GameScreen.getScaledY(10);
        gameEffects.DrawWaterWithInOutAnimation(g, this.bgLayers[3], drawx, iFacadeEnd - extraHackyYOffset, 0, 0, FixedPoint.stringToFP("1.0"), FixedPoint.stringToFP("0.02"), GameScreen.isPaused());
        drawx = -((((fpScrollX ^ (this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) < 0 ? -(-(((fpScrollX ^ (this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16) : (((fpScrollX ^ (this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[2].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[2].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[2].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16);
        g.drawImage(this.bgLayers[2], drawx, iFacadeStart, 0x10 | 4);
    }

    private void drawGauge(Graphics g, ClipRect rect, ImageSequence bars) {
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        GfxUtils.setColor(g, 0);
        g.fillRect(rect.x0 - 3, (int)rect.y0, 3, (int)rect.h);
        g.fillRect(rect.x0 + rect.w, (int)rect.y0, 3, (int)rect.h);
        GfxUtils.setColor(g, 0x838383);
        g.drawLine(rect.x0 - 2, (int)rect.y0, rect.x0 - 2, rect.y0 + rect.h);
        g.drawLine(rect.x0 + rect.w + 1, (int)rect.y0, rect.x0 + rect.w + 1, rect.y0 + rect.h);
        bars.drawImage(g, 0, rect.x0 - 3, rect.y0 - bars.getRectHeight(0));
        bars.drawImage(g, 1, rect.x0 - 3, rect.y0 + rect.h);
    }

    private void drawPowerBar(Graphics g, ImageSequence bars, int hiddenX, int destX, int fpNorm, boolean altColours) {
        this.powerClipRect.x0 = (short)FixedPoint.linearInterpolate(GameLogic.transitionAmount, hiddenX, destX);
        this.powerClipRect.w = (short)(bars.getRectWidth(0) - 6);
        this.drawGauge(g, this.powerClipRect, bars);
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        int tick = this.quantize(fpNorm, 10);
        int n = tick = (tick = tick * 10 + 64) < 0 ? -(-tick >> 16) : tick >> 16;
        tick = tick < 0 ? 0 : (tick > 10 ? 10 : tick);
        for (int i = 0; i < 10; ++i) {
            int fg_col;
            int bg_col;
            int pos = (int)(((long)(i < 0 ? -(-i << 16) : i << 16) << 16) / 589824L);
            if (i < tick) {
                bg_col = altColours ? GfxUtils.lerpColour(pos, 0x101010, 0x404040) : GfxUtils.lerpColour(pos, 707, 49980);
                fg_col = altColours ? (pos < 32768 ? GfxUtils.lerpColour(pos * 2, 0xFFFF00, 0xFF8000) : GfxUtils.lerpColour(pos * 2 - 65536, 0xFF8000, 0xFF0000)) : (pos < 32768 ? GfxUtils.lerpColour(pos * 2, 4337151, 0x2DFFFD) : GfxUtils.lerpColour(pos * 2, 3014504, 0x2DFFFD));
            } else {
                fg_col = 0x3F3F3F;
                bg_col = 0x1F1F1F;
            }
            GfxUtils.setColor(g, bg_col);
            g.drawRect((int)this.powerClipRect.x0, this.powerClipRect.y0 + (10 - i - 1) * this.cPowerBarHeight, this.powerClipRect.w - 1, this.cPowerBarHeight);
            GfxUtils.setColor(g, fg_col);
            g.fillRect(this.powerClipRect.x0 + 1, this.powerClipRect.y0 + (10 - i - 1) * this.cPowerBarHeight + 1, this.powerClipRect.w - 2, this.cPowerBarHeight - 1);
        }
    }

    public void drawCastingPowerBar(Graphics g) {
        int iconX = cBorderX;
        int iconY = this.powerClipRect.y0 - gfxGaugeIcons.getRectHeight(0) - GameScreen.getScaledY(10);
        int gaugeX = iconX + (gfxGaugeIcons.getRectWidth(0) - gfxGaugeEnergy.getRectWidth(0)) / 2;
        this.drawPowerBar(g, gfxGaugeEnergy, gaugeX + 3, gaugeX + 3, this.fCastingPowerVelocity, false);
    }

    public void drawFishFightGUI(Graphics g) {
        int iconX = cBorderX;
        int iconY = this.powerClipRect.y0 - gfxGaugeIcons.getRectHeight(0) - 6 - GameScreen.getScaledY(10);
        gfxGaugeIcons.drawImage(g, 0, iconX, iconY);
        int gaugeX = iconX + (gfxGaugeIcons.getRectWidth(0) - gfxGaugeEnergy.getRectWidth(0)) / 2;
        this.drawPowerBar(g, gfxGaugeEnergy, -GameScreen.getScaledX(20), gaugeX + 3, game.getFishFightEnergy(), false);
        iconX = displayWidth - cBorderX - gfxGaugeIcons.getRectWidth(1);
        gfxGaugeIcons.drawImage(g, 1, iconX, iconY);
        gaugeX = iconX + (gfxGaugeIcons.getRectWidth(1) - gfxGaugeTension.getRectWidth(0)) / 2;
        int fRodTensionNormalised = game.getFishFightTension();
        this.drawPowerBar(g, gfxGaugeTension, displayWidth + GameScreen.getScaledX(20), gaugeX + 3, fRodTensionNormalised, true);
        int boatHeight = 0;
        if (this.bgLayers[4] != null) {
            boatHeight = this.bgLayers[4].getHeight();
        }
        if (game.getFishFightEnergy() > 0) {
            int iCurrentFrame;
            int n = iCurrentFrame = GameScreen.game.fpFishFightArrowFrame < 0 ? -(-GameScreen.game.fpFishFightArrowFrame >> 16) : GameScreen.game.fpFishFightArrowFrame >> 16;
            int n2 = iCurrentFrame < 0 ? 0 : (iCurrentFrame = iCurrentFrame > GameScreen.gfxDownArrow.numFrames - 1 ? GameScreen.gfxDownArrow.numFrames - 1 : iCurrentFrame);
            if (GameScreen.game.fishFightDir == 0) {
                gfxDownArrow.drawImage(g, iCurrentFrame, (displayWidth >> 1) - (gfxDownArrow.getRectWidth(0) >> 1), displayHeight - (boatHeight + gfxDownArrow.getRectHeight(0)));
            } else if (GameScreen.game.fishFightDir == 1) {
                gfxRightArrow.drawImage(g, iCurrentFrame, (displayWidth >> 1) - (gfxRightArrow.getRectWidth(0) >> 1) + gfxRightArrow.getRectWidth(0), displayHeight - (boatHeight + (gfxRightArrow.getRectHeight(0) << 1)));
            } else if (GameScreen.game.fishFightDir == 2) {
                gfxLeftArrow.drawImage(g, iCurrentFrame, (displayWidth >> 1) - (gfxLeftArrow.getRectWidth(0) >> 1) - gfxLeftArrow.getRectWidth(0), displayHeight - (boatHeight + (gfxLeftArrow.getRectHeight(0) << 1)));
            }
        }
    }

    public void drawGUI(Graphics g) {
        int y;
        int x;
        if (this.bStartedCastingPowerBar) {
            this.drawCastingPowerBar(g);
        }
        boolean hideInfoText = false;
        if (pauseState == 3 || pauseState == 4) {
            hideInfoText = true;
        }
        if (GameScreen.isPaused()) {
            hideInfoText = true;
        }
        switch (GameScreen.game.currentState) {
            case 0: 
            case 9: 
            case 11: 
            case 12: {
                if (hideInfoText) break;
                textGameInfo.paint(g);
                this.drawPressFire(g, flashOn);
                break;
            }
            case 1: 
            case 2: {
                if (hideInfoText) break;
                textGameInfo.paint(g);
                break;
            }
            case 5: {
                if (!game.isPossibleToStrike() || hideInfoText) break;
                GameScreen.drawCenteredText(g, fontGame, "" + MultiLingual.get(150) + "", GameScreen.getScaledY(60));
                break;
            }
            case 6: {
                boolean showReelText;
                int fishOnY = GameScreen.getScaledY(60);
                boolean bl = showReelText = !hideInfoText;
                if (!hideInfoText) {
                    if (game.getFishFightTension() > FixedPoint.stringToFP("0.75")) {
                        GameScreen.drawCenteredText(g, fontGame, "" + MultiLingual.get(149) + "", fishOnY);
                        GameScreen.drawCenteredText(g, fontGame, "" + MultiLingual.get(149) + "", fishOnY);
                        if (flashOn) {
                            GameScreen.drawCenteredText(g, speechFont, "" + MultiLingual.get(157) + "", fishOnY + GameScreen.getScaledY(32));
                            GameScreen.drawCenteredText(g, speechFont, "" + MultiLingual.get(158) + "", fishOnY + GameScreen.getScaledY(32) + speechFont.getFontHeight());
                        }
                        showReelText = false;
                    } else if (GameScreen.game.fp_state_time < 262144 && flashOn) {
                        GameScreen.drawCenteredText(g, fontGame, "" + MultiLingual.get(200) + "", fishOnY);
                    }
                    if (showReelText) {
                        GameScreen.drawCenteredText(g, speechFont, "" + MultiLingual.get(201) + "", fishOnY + GameScreen.getScaledY(32));
                        GameScreen.drawCenteredText(g, speechFont, "" + MultiLingual.get(202) + "", fishOnY + GameScreen.getScaledY(32) + speechFont.getFontHeight());
                    }
                }
                this.drawFishFightGUI(g);
                break;
            }
            case 8: 
            case 13: {
                if (hideInfoText) break;
                textGameInfo.paint(g);
                this.drawPressFire(g, flashOn);
                break;
            }
            case 10: {
                if (hideInfoText) break;
                textGameInfo.paint(g);
                if (FrontEnd.gameType == 0 && showingArcadeHiScoreTable) {
                    textHiScoreColumns[0].paint(g);
                    textHiScoreColumns[1].paint(g);
                }
                this.drawPressFire(g, flashOn);
            }
        }
        this.drawTicker(g);
        this.drawGameTime(g);
        this.drawPlace(g);
        if (!GameScreen.isPaused()) {
            if (this.areSoftkeysActive()) {
                x = displayWidth - gfxPauseMenu.getRectWidth(0) - (cBorderX << 1);
                y = displayHeight - gfxPauseMenu.getRectHeight(0) - cBorderY;
                gfxPauseMenu.drawImage(g, 0, x, y);
                if (GameScreen.game.currentState == 1) {
                    x = cBorderX;
                    y = displayHeight - gfxGameMenu.getRectHeight(0) - cBorderY;
                    gfxGameMenu.drawImage(g, 0, x, y);
                }
            }
        } else if (pauseState == 2) {
            for (int i = GameScreen.gfxGameMenu.numFrames - 1; i >= 0; --i) {
                int x2 = cBorderX;
                int beginY = displayHeight - gfxGameMenu.getRectHeight(0) - cBorderY;
                int y2 = displayHeight - (gfxGameMenu.getRectHeight(0) + cBorderY) * (i + 1);
                int t = (int)(((long)fpPauseTimer << 16) / 16384L);
                int actualY = FixedPoint.linearInterpolate(t, beginY, y2);
                gfxGameMenu.drawImage(g, i, x2, actualY);
            }
            if (gameIconSel >= 0 && fpPauseTimer >= 16384) {
                x = cBorderX;
                y = displayHeight - (gfxGameMenu.getRectHeight(0) + cBorderY) * (gameIconSel + 1);
                GfxUtils.setColor(g, 0xFFFFFFF);
                g.drawRect(x - 1, y - 1, gfxGameMenu.getRectWidth(gameIconSel) + 2, gfxGameMenu.getRectHeight(gameIconSel) + 2);
            }
            textPauseInfo.paint(g);
        } else if (pauseState == 3) {
            this.drawTextBackgroundShadow(g, textLureDesc);
            textLureDesc.paint(g);
            int bottomBorder = GameScreen.getScaledY(12);
            short iconW = gfxLureIcons.getRectWidth(0);
            short iconH = gfxLureIcons.getRectHeight(0);
            int borderY = 2;
            int stripHeight = (iconH + borderY) * gameLureCount;
            GfxUtils.drawCrossHatch(g, 0, cBorderX, displayHeight - (stripHeight + bottomBorder), iconW, stripHeight);
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            for (int i = 0; i < gameLureCount; ++i) {
                int x3 = cBorderX;
                int beginY = displayHeight - iconH - borderY;
                int y3 = displayHeight - bottomBorder - (iconH + borderY) * (i + 1);
                if (i == gameLureIconSel) {
                    g.setColor(0);
                    g.fillRect(x3, y3, (int)iconW, (int)iconH);
                }
                gfxLureIcons.drawImage(g, gameLureList[i], x3, y3);
                if (i != gameLureIconSel) continue;
                g.setColor(0xFFFFFF);
                g.drawRect(x3 - 1, y3 - 1, iconW + 2, iconH + 1);
            }
            short bar_y0 = FrontEnd.instance.iconMenuBar.clipRect.y0;
            FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(94) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 2);
        } else if (pauseState == 4) {
            this.drawTextBackgroundShadow(g, textFishCaught);
            textFishCaught.paint(g);
            short bar_y0 = FrontEnd.instance.iconMenuBar.clipRect.y0;
            FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(94) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 2);
        }
    }

    public void drawTextBackgroundShadow(Graphics g, TextLayout text) {
        int x0 = text.rectDocument.x0 + text.clipRect.x0;
        int y0 = text.rectDocument.y0 + text.clipRect.y0;
        int w = text.rectDocument.w;
        int h = text.rectDocument.h;
        if ((x0 -= GameScreen.getScaledX(8)) < 0) {
            x0 = 0;
        }
        if ((y0 -= GameScreen.getScaledY(8)) < 0) {
            y0 = 0;
        }
        if ((w += GameScreen.getScaledY(16)) > displayWidth) {
            h = displayWidth;
        }
        if ((h += GameScreen.getScaledY(16)) > displayHeight) {
            h = displayHeight;
        }
        GfxUtils.drawCrossHatch(g, 0, x0, y0, w, h);
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        g.setColor(0xFFFFFF);
        g.drawRect(x0, y0, w, h);
    }

    public void paint(Graphics g) {
        int yoffset;
        Application.gc();
        this.drawBackground(g);
        this.drawFishInWater(g);
        int wave_len = BaseScreen.getScaledY(10);
        this.bigBoatYwave = yoffset = (((FixedPoint.sinLut(fp_boatAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_boatAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_boatAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) < 0 ? -(-(((FixedPoint.sinLut(fp_boatAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_boatAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_boatAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) >> 16) : (((FixedPoint.sinLut(fp_boatAngle) ^ (wave_len < 0 ? -(-wave_len << 16) : wave_len << 16)) & 0x8000000) != 0 ? -((int)((long)(-FixedPoint.sinLut(fp_boatAngle)) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) : (int)((long)FixedPoint.sinLut(fp_boatAngle) * (long)(wave_len < 0 ? -(-wave_len << 16) : wave_len << 16) >> 16)) >> 16;
        if (ImageSequence.clipSet) {
            g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
            ImageSequence.clipSet = false;
        }
        if (!GameScreen.isPaused()) {
            this.getRodTipPos();
            this.drawFloatAndLine(g);
        }
        gameEffects.drawEffects(g, 0);
        if (this.bgLayers[4] != null) {
            int drawx = -((((fpScrollX ^ (this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) < 0 ? -(-(((fpScrollX ^ (this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16) : (((fpScrollX ^ (this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16)) & 0x8000000) != 0 ? -((int)((long)(-fpScrollX) * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) : (int)((long)fpScrollX * (long)(this.bgLayers[4].getWidth() - BaseScreen.displayWidth < 0 ? -(-(this.bgLayers[4].getWidth() - BaseScreen.displayWidth) << 16) : this.bgLayers[4].getWidth() - BaseScreen.displayWidth << 16) >> 16)) >> 16);
            g.drawImage(this.bgLayers[4], drawx, wave_len + (BaseScreen.displayHeight - this.bgLayers[4].getHeight()) + yoffset, 0x10 | 4);
        } else {
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            g.setColor(0xB4B5B5);
            int boatHeight = BaseScreen.getScaledY(48);
            int yp = wave_len + (BaseScreen.displayHeight - boatHeight) + yoffset;
            g.fillRect(0, yp, BaseScreen.displayWidth, BaseScreen.displayHeight - yp);
            g.setColor(0xE6E7E7);
            g.fillRect(0, yp + 4, BaseScreen.displayWidth, BaseScreen.displayHeight - yp);
        }
        if (!GameScreen.isPaused()) {
            if (GameScreen.game.currentState != 0 && GameScreen.game.currentState != 11 && GameScreen.game.currentState != 10) {
                this.drawRodBend(g);
            }
            gameEffects.drawEffects(g, 1);
        }
        if (pauseState == 1) {
            if (ImageSequence.clipSet) {
                g.setClip(0, 0, BaseScreen.displayWidth * 2, BaseScreen.displayHeight * 2);
                ImageSequence.clipSet = false;
            }
            short h = FrontEnd.gfxBar.getRectHeight(0);
            int bar_y0 = displayHeight - h;
            if (this.quitConfirm) {
                this.drawTextBackgroundShadow(g, textQuitConfirm);
                textQuitConfirm.paint(g);
                FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(96) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 0);
                FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(97) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 1);
            } else {
                FrontEnd.instance.drawMenuBars(g, currentMenu);
                currentMenu.paint(g);
                FrontEnd.instance.drawButton(g, 0, "" + MultiLingual.get(95) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 0);
                if (bDrawOptionsBack) {
                    FrontEnd.instance.drawButton(g, 1, "" + MultiLingual.get(94) + "", bar_y0, ScreenStack.menuButtonHeight, 0, 1);
                }
            }
        } else {
            this.drawGUI(g);
        }
    }

    public int quantize(int fp_val, int parts) {
        int new_val = fp_val * parts;
        new_val = new_val < 32768 ? (new_val -= 32768) : (new_val += 32768);
        return (new_val < 0 ? -(-new_val & 0xFFFF0000) : new_val & 0xFFFF0000) / parts;
    }

    public void updatePauseInfoText() {
        textPauseInfo.clearText();
        textPauseInfo.formatText(speechFont, "" + MultiLingual.get(4) + ":\n");
        switch (gameIconSel) {
            case 1: {
                textPauseInfo.formatText(speechFont, "" + MultiLingual.get(7) + "");
                break;
            }
            case 2: {
                textPauseInfo.formatText(speechFont, "" + MultiLingual.get(8) + "");
                break;
            }
            case 3: {
                textPauseInfo.formatText(speechFont, "" + MultiLingual.get(9) + "");
                break;
            }
            case 0: {
                textPauseInfo.formatText(speechFont, "" + MultiLingual.get(6) + "");
            }
        }
        textPauseInfo.layout();
    }

    public void processKeyPressed() {
        if (GameScreen.game.currentState == 1 && pauseState == 0 && ScreenLayout.keysPressed(32768)) {
            if (FrontEnd.gameType == 0) {
                savedTime = gameTime;
                GameApp.frontEnd.openMapScreen(false);
                return;
            }
            pauseState = 2;
            gameIconSel = 0;
            fpPauseTimer = 0;
            this.updatePauseInfoText();
            return;
        }
        if (ScreenLayout.keysPressed(65536) && this.areSoftkeysActive()) {
            if (pauseState == 0) {
                this.openMenu();
                return;
            }
            if (pauseState == 1 && bDrawOptionsBack) {
                bDrawOptionsBack = false;
                pauseState = 0;
                this.quitConfirm = false;
                this.openMenu();
                return;
            }
        }
        if (pauseState == 1) {
            if (this.quitConfirm) {
                if (ScreenLayout.keysPressed(32768)) {
                    this.quitConfirm = false;
                    GameScreen.backToMainMenu();
                } else if (ScreenLayout.keysPressed(65536)) {
                    pauseState = 0;
                    this.quitConfirm = false;
                }
            } else {
                currentMenu.process();
                BaseScreen.resetKeys();
            }
            return;
        }
        if (pauseState == 2) {
            if (fpPauseTimer >= 16384) {
                if (ScreenLayout.keysPressed(1)) {
                    gameIconSel = GameScreen.gfxGameMenu.numFrames - 1 < gameIconSel + 1 ? GameScreen.gfxGameMenu.numFrames - 1 : gameIconSel + 1;
                    this.updatePauseInfoText();
                } else if (ScreenLayout.keysPressed(8)) {
                    gameIconSel = 0 > gameIconSel - 1 ? 0 : gameIconSel - 1;
                    this.updatePauseInfoText();
                } else if (ScreenLayout.keysPressed(16) || ScreenLayout.keysPressed(32768)) {
                    BaseScreen.resetKeys();
                    switch (gameIconSel) {
                        case 1: {
                            GameSequence.saveFishPopulation(MapScreen.currentFishingSpot);
                            GameApp.frontEnd.openMapScreen(false);
                            pauseState = 0;
                            break;
                        }
                        case 2: {
                            pauseState = 4;
                            this.updateFishCaughtText();
                            break;
                        }
                        case 3: {
                            pauseState = 3;
                            gameLureCount = 0;
                            gameLureIconSel = 0;
                            for (int i = 0; i < 5; ++i) {
                                if (!ShopScreen.playerHasLure(i)) continue;
                                if (GameScreen.getCurrent(3) == i) {
                                    gameLureIconSel = gameLureCount;
                                }
                                GameScreen.gameLureList[GameScreen.gameLureCount++] = i;
                            }
                            if (gameLureCount < 1) {
                                System.out.println("Assertion Failure: gameLureCount >= 1\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[4631]");
                                try {
                                    throw new Exception();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            this.updateLureText();
                            break;
                        }
                        case 0: {
                            pauseState = 0;
                        }
                    }
                }
            }
            return;
        }
        if (pauseState == 4) {
            if (ScreenLayout.keysPressed(65536)) {
                pauseState = 2;
            }
            return;
        }
        if (pauseState == 3) {
            if (ScreenLayout.keysPressed(65536)) {
                pauseState = 2;
            } else if (ScreenLayout.keysPressed(1)) {
                gameLureIconSel = gameLureCount - 1 < gameLureIconSel + 1 ? gameLureCount - 1 : gameLureIconSel + 1;
                this.updateLureText();
            } else if (ScreenLayout.keysPressed(8)) {
                gameLureIconSel = 0 > gameLureIconSel - 1 ? 0 : gameLureIconSel - 1;
                this.updateLureText();
            } else if (ScreenLayout.keysPressed(16)) {
                if (GameScreen.getCurrent(3) == gameLureList[gameLureIconSel]) {
                    return;
                }
                if (GameScreen.game.currentState != 1) {
                    return;
                }
                pauseState = 0;
                GameScreen.setCurrentLure(gameLureList[gameLureIconSel]);
                BaseScreen.resetKeys();
            }
            return;
        }
        switch (GameScreen.game.currentState) {
            default: 
        }
    }

    public static void backToMainMenu() {
        if (FrontEnd.menuType == -1) {
            System.out.println("Assertion Failure: FrontEnd.menuType != FrontEnd.eMenuMain\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameScreen.java[4710]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (FrontEnd.menuType != -1) {
            GameApp.autoSave();
        }
        pauseState = 0;
        GameApp.frontEnd.pushScreen(FrontEnd.menuMain, true);
    }

    public void processKeyReleased() {
        if (GameLogic.transitionState == 0) {
            // empty if block
        }
    }

    protected void saveGame(DataOutputStream dataStream) {
        System.out.println("GameScreen.saveGame()");
        try {
            if (GameScreen.isGameInProgress()) {
                System.out.println("GameScreen.ActuallySavingGame");
                dataStream.writeBoolean(true);
                System.out.println("Saved ok");
            } else {
                System.out.println("Nothing to Save, game not in play");
                dataStream.writeBoolean(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadGame(DataInputStream inputStream) throws IOException {
        System.out.println("GameScreen.loadGame()");
        try {
            boolean savedGame = inputStream.readBoolean();
            if (savedGame) {
                System.out.println("Loaded ok");
            } else {
                System.out.println("No game to load");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        loaded = false;
        speechFont = null;
        textGameInfo = new TextLayout();
        textHiScoreColumns = new TextLayout[2];
        textFishCaught = new TextLayout();
        textLureDesc = new TextLayout();
        currentMenu = null;
        menuPause = new MenuLayout();
        controlPauseTitle = new GuiControl(false);
        controlOptions = new GuiControl(true);
        controlMainMenu = new GuiControl(true);
        controlResume = new GuiControl(true);
        controlForceWin = new GuiControl(true);
        menuOptions = new MenuLayout();
        controlOptionsTitle = new GuiControl(false);
        controlOptionsResume = new GuiControl(true);
        controlSound = new GuiControl(true);
        controlVibrate = new GuiControl(true);
        pauseState = 0;
        fpPauseTimer = 0;
        gameIconSel = 0;
        gameLureIconSel = 0;
        gameLureList = new int[5];
        gameLureCount = 0;
        textPauseInfo = new TextLayout();
        textQuitConfirm = new TextLayout();
        cArcadeLocations = null;
        cArcadeEquipment = new short[4][];
        cArcadeTimePerPound = null;
        cArcadePointsPerPound = null;
        cArcadeTimeLimit = null;
        cArcadeTargetPounds = null;
        cArcadeFishPopulation = new short[6][];
        cfpRodMaxSpeed = FixedPoint.stringToFP("30");
        cfpRodMaxSpeedFight = FixedPoint.stringToFP("60");
        cfpRodMaxSpeedFishing = FixedPoint.stringToFP("5");
        cfpRodAcc = FixedPoint.stringToFP("60");
        cfpRodAccFight = FixedPoint.stringToFP("400");
        cfpRodAccFishing = FixedPoint.stringToFP("30");
        cfpRodMaxPos = FixedPoint.stringToFP("16.0");
        cfpRodMaxPosSlowDownMargin = FixedPoint.stringToFP("1.5");
        cfpRodMaxPosOffsetFight = FixedPoint.stringToFP("7.0");
        cfpRodMaxPosOffsetFishing = FixedPoint.stringToFP("20.0");
        cfpRodTipSpeed = FixedPoint.stringToFP("25");
        cfpRodTipMaxPos = FixedPoint.stringToFP("7.0");
        cfpBoatAnimSpeed = FixedPoint.stringToFP("0.5");
        cfpRodSegLenMin = FixedPoint.stringToFP("4.0");
        cfpRodSegLenMax = FixedPoint.stringToFP("5.0");
        cfpRodAngleMin = FixedPoint.stringToFP("140");
        cfpRodAngleMax = FixedPoint.stringToFP("185");
        cfpRodAngleMaxCasting = FixedPoint.stringToFP("160");
        cfpRodAngleHooked = cfpRodAngleMin;
        cfpRodAngleSpeedBend = FixedPoint.stringToFP("200");
        cfpRodAngleSpeedIdle = FixedPoint.stringToFP("100");
        cfpRodAngleSpeedLureDrop = FixedPoint.stringToFP("80");
        cfpRodAngleSpeedCasting = FixedPoint.stringToFP("80");
        fpWantedScrollX = fpScrollX = 32768;
        flashOn = false;
        fastFlashOn = false;
        arcadeLevel = 0;
        arcadeScore = 0;
        arcadeCatch = 0;
        arcadeFishCaught = 0;
        selectedItems = new int[5];
        matView = new int[4][4];
        matProj = new int[4][4];
        near = FixedPoint.stringToFP("8.5");
        far = FixedPoint.stringToFP("400.0");
        aspect = FixedPoint.stringToFP("0.75");
        cViewportWidth = BaseScreen.displayWidth;
        cViewCanvasWidth = BaseScreen.getScaledX(360);
        currentCamera = -1;
        vecForward = new int[3];
        vecRight = new int[3];
        screenPos = new int[4];
        bgWaterYpos = new int[]{200, 200, 200, 200, 200};
        bDrawOptionsBack = false;
        cfpRodTipPullBackY = FixedPoint.stringToFP("-20.0");
        cfpRodTipDefaultY = FixedPoint.stringToFP("0.0");
        cfpRodTipDefaultZ = FixedPoint.stringToFP("15.0");
        constfpMinCastingRange = FixedPoint.stringToFP("0.0");
        constfpMaxCastingRangeCrapRod = FixedPoint.stringToFP("5.5");
        constfpMaxCastingRangeAceRod = FixedPoint.stringToFP("8.0");
        cfpDroppingRodDampingRange = FixedPoint.stringToFP("16");
        bShowWeighInScreen = false;
        dbgPos = new int[4];
        strScrollingMsg = "";
        scrollMsgWidth = 0;
        scrollMessageXpos = 0;
        weightStr = "";
        strWeight = "";
        strCutoff = "";
        fpRodAngle = cfpRodAngleMin;
        fpRodLineTension = 0;
        rodStartPos = new int[]{FixedPoint.stringToFP("0.0"), FixedPoint.stringToFP("-24.0"), FixedPoint.stringToFP("0.0")};
        rodPos = new int[3];
        rodXVel = 0;
        floatPos = new int[3];
        floatVel = new int[3];
        rodTip = new int[]{0, cfpRodTipDefaultY, cfpRodTipDefaultZ};
        cNumLineElements = 10;
        cfpMaxLineSegmentLen = GameScreen.getScaledY(393216);
        fpLineSegmentX = new int[cNumLineElements];
        fpLineSegmentY = new int[cNumLineElements];
        fpLineSegmentYVel = new int[cNumLineElements];
        lineDrawXoffset = 0;
        lineDrawYoffset = 0;
        reelFrame = 0;
        reelTimer = 30;
        cRodColours = new int[]{3098, 2115693, 3758651, 11442530, 13193738};
        cRodTensionBonus = null;
        cLineWeightLimit = null;
        cRodMaxPull = null;
        fp_waterAngle = FixedPoint.stringToFP("0.71");
        fp_boatAngle = FixedPoint.stringToFP("0.71");
        fpRodPos = new int[3];
        cBorderX = GameScreen.getScaledX(3);
        cBorderY = GameScreen.getScaledX(3);
    }
}

