/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gfx;

import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;
import com.slg.j2me.lib.sys.VecMath;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Software3D {
    public static boolean drawNormals = false;
    public static int clipMinZ = 65536;
    public static int[][] matrixCamera = new int[4][4];
    public static int[][] matrixComposite = new int[4][4];
    public static int[] matrixCompositeFast = new int[16];
    public static int[][] matrixInvWorldTrans = new int[4][4];
    public static int[][][] loadedCameraMatrix;
    public static int[] loadedCameraFOV;
    public static int[] loadedCameraNearClip;
    public static int[] loadedCameraFarClip;
    public static int fp_viewport_x0;
    public static int fp_viewport_y0;
    public static int renderWidth;
    public static int renderHeight;
    public static int halfWidth;
    public static int halfHeight;
    private static int[] vAB;
    private static int[] vAC;
    private static int[] vNorm;
    private static int[] vR;
    public static Plane nearPlane;
    public static Plane nearPlaneWS;
    private static int[] nearFrom;
    private static int[] nearNormal;
    private static int[][] mat33;
    private static int[] temp3;
    private static int[] dst;
    private static int[] tmp;
    private static int[] src;
    private static int[] localFrom;
    private static int[] localNormal;
    private static int[][] worldTrans;
    private static int[][] temp_matView;
    private static int[][] temp_matProj;
    private static int[] newup;
    private static int[] right;
    private static int[] view;
    private static int[] vdist;
    private static int[][] vert;
    private static int[][] p;
    private static int[] near_dist;

    public static int getClipPlaneDist(int[] pt) {
        return nearPlaneWS.getDistFromPlane(pt);
    }

    public static final void setIdentity(int[][] mat) {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                mat[j][i] = j == i ? 65536 : 0;
            }
        }
    }

    public static final void setTranslate(int[][] matrixWorldTrans, int[] pos) {
        Software3D.setIdentity(matrixWorldTrans);
        matrixWorldTrans[3][0] = pos[0];
        matrixWorldTrans[3][1] = pos[1];
        matrixWorldTrans[3][2] = pos[2];
    }

    public static final void preRotateY(int[][] matrixWorldTrans, int angle) {
        while (angle < 0) {
            angle += 0x1000000;
        }
        matrixWorldTrans[0][0] = FixedPoint.sinLut(angle + 0x400000);
        matrixWorldTrans[0][2] = -FixedPoint.sinLut(angle);
        matrixWorldTrans[2][0] = -matrixWorldTrans[0][2];
        matrixWorldTrans[2][2] = matrixWorldTrans[0][0];
    }

    public static final void setRotateZVec3(int[] vec, int angle) {
        Software3D.makeRotateZ33(mat33, angle);
        Software3D.temp3[0] = vec[0];
        Software3D.temp3[1] = vec[1];
        Software3D.temp3[2] = vec[2];
        Software3D.setMulVec3(vec, temp3, mat33);
        VecMath.norm3d(vec, vec);
    }

    public static final void setRotateAxisVec3(int[] vec, int[] axis, int angle) {
        Software3D.makeRotateAxis33(mat33, axis, angle);
        Software3D.temp3[0] = vec[0];
        Software3D.temp3[1] = vec[1];
        Software3D.temp3[2] = vec[2];
        Software3D.setMulVec3(vec, temp3, mat33);
        VecMath.norm3d(vec, vec);
    }

    public static final void makeRotateZ33(int[][] mat, int theta) {
        int costheta;
        while (theta < 0) {
            theta += 0x1000000;
        }
        int sintheta = FixedPoint.sinLut(theta);
        mat[0][0] = costheta = FixedPoint.sinLut(theta + 0x400000);
        mat[0][1] = sintheta;
        mat[0][2] = 0;
        mat[1][0] = -sintheta;
        mat[1][1] = costheta;
        mat[1][2] = 0;
        mat[2][0] = 0;
        mat[2][1] = 0;
        mat[2][2] = 65536;
    }

    public static final void makeRotateAxis33(int[][] mat, int[] d, int theta) {
        while (theta < 0) {
            theta += 0x1000000;
        }
        int s = FixedPoint.sinLut(theta);
        int c = FixedPoint.sinLut(theta + 0x400000);
        int t = 65536 - c;
        mat[0][0] = ((d[0] ^ d[0]) & 0x8000000) != 0 ? -((int)((long)(-d[0]) * (long)d[0] >> 16)) : (int)((long)d[0] * (long)d[0] >> 16);
        mat[0][0] = ((mat[0][0] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[0][0]) * (long)t >> 16)) : (int)((long)mat[0][0] * (long)t >> 16);
        mat[0][1] = ((d[0] ^ d[1]) & 0x8000000) != 0 ? -((int)((long)(-d[0]) * (long)d[1] >> 16)) : (int)((long)d[0] * (long)d[1] >> 16);
        mat[0][1] = ((mat[0][1] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[0][1]) * (long)t >> 16)) : (int)((long)mat[0][1] * (long)t >> 16);
        mat[0][2] = ((d[0] ^ d[2]) & 0x8000000) != 0 ? -((int)((long)(-d[0]) * (long)d[2] >> 16)) : (int)((long)d[0] * (long)d[2] >> 16);
        mat[0][2] = ((mat[0][2] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[0][2]) * (long)t >> 16)) : (int)((long)mat[0][2] * (long)t >> 16);
        mat[1][1] = ((d[1] ^ d[1]) & 0x8000000) != 0 ? -((int)((long)(-d[1]) * (long)d[1] >> 16)) : (int)((long)d[1] * (long)d[1] >> 16);
        mat[1][1] = ((mat[1][1] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[1][1]) * (long)t >> 16)) : (int)((long)mat[1][1] * (long)t >> 16);
        mat[1][2] = ((d[1] ^ d[2]) & 0x8000000) != 0 ? -((int)((long)(-d[1]) * (long)d[2] >> 16)) : (int)((long)d[1] * (long)d[2] >> 16);
        mat[1][2] = ((mat[1][2] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[1][2]) * (long)t >> 16)) : (int)((long)mat[1][2] * (long)t >> 16);
        mat[2][2] = ((d[2] ^ d[2]) & 0x8000000) != 0 ? -((int)((long)(-d[2]) * (long)d[2] >> 16)) : (int)((long)d[2] * (long)d[2] >> 16);
        mat[2][2] = ((mat[2][2] ^ t) & 0x8000000) != 0 ? -((int)((long)(-mat[2][2]) * (long)t >> 16)) : (int)((long)mat[2][2] * (long)t >> 16);
        mat[1][0] = mat[0][1];
        mat[2][0] = mat[0][2];
        mat[2][1] = mat[1][2];
        int[] nArray = mat[0];
        nArray[0] = nArray[0] + c;
        int[] nArray2 = mat[0];
        nArray2[1] = nArray2[1] + (((s ^ d[2]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[2] >> 16)) : (int)((long)s * (long)d[2] >> 16));
        int[] nArray3 = mat[0];
        nArray3[2] = nArray3[2] - (((s ^ d[1]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[1] >> 16)) : (int)((long)s * (long)d[1] >> 16));
        int[] nArray4 = mat[1];
        nArray4[0] = nArray4[0] - (((s ^ d[2]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[2] >> 16)) : (int)((long)s * (long)d[2] >> 16));
        int[] nArray5 = mat[1];
        nArray5[1] = nArray5[1] + c;
        int[] nArray6 = mat[1];
        nArray6[2] = nArray6[2] + (((s ^ d[0]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[0] >> 16)) : (int)((long)s * (long)d[0] >> 16));
        int[] nArray7 = mat[2];
        nArray7[0] = nArray7[0] + (((s ^ d[1]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[1] >> 16)) : (int)((long)s * (long)d[1] >> 16));
        int[] nArray8 = mat[2];
        nArray8[1] = nArray8[1] - (((s ^ d[0]) & 0x8000000) != 0 ? -((int)((long)(-s) * (long)d[0] >> 16)) : (int)((long)s * (long)d[0] >> 16));
        int[] nArray9 = mat[2];
        nArray9[2] = nArray9[2] + c;
    }

    public static void copyMatrix(int[][] out, int[][] in) {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                out[j][i] = in[j][i];
            }
        }
    }

    public static void copyMatrix43(int[][] out, int[][] in) {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                out[j][i] = in[j][i];
            }
        }
    }

    public static void convertMatrix44(int[] out, int[][] in) {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                out[j * 4 + i] = in[j][i];
            }
        }
    }

    public static void setMulVec3(int[] out_vec3, int[] in_vec3, int[][] in_matrix) {
        out_vec3[0] = (((in_vec3[0] ^ in_matrix[0][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][0] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][0] >> 16)) + (((in_vec3[1] ^ in_matrix[1][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][0] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][0] >> 16)) + (((in_vec3[2] ^ in_matrix[2][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][0] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][0] >> 16));
        out_vec3[1] = (((in_vec3[0] ^ in_matrix[0][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][1] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][1] >> 16)) + (((in_vec3[1] ^ in_matrix[1][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][1] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][1] >> 16)) + (((in_vec3[2] ^ in_matrix[2][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][1] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][1] >> 16));
        out_vec3[2] = (((in_vec3[0] ^ in_matrix[0][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][2] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][2] >> 16)) + (((in_vec3[1] ^ in_matrix[1][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][2] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][2] >> 16)) + (((in_vec3[2] ^ in_matrix[2][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][2] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][2] >> 16));
    }

    public static void setMulVec4(int[] out_vec4, int[] in_vec3, int[][] in_matrix) {
        out_vec4[0] = (((in_vec3[0] ^ in_matrix[0][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][0] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][0] >> 16)) + (((in_vec3[1] ^ in_matrix[1][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][0] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][0] >> 16)) + (((in_vec3[2] ^ in_matrix[2][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][0] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][0] >> 16)) + in_matrix[3][0];
        out_vec4[1] = (((in_vec3[0] ^ in_matrix[0][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][1] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][1] >> 16)) + (((in_vec3[1] ^ in_matrix[1][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][1] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][1] >> 16)) + (((in_vec3[2] ^ in_matrix[2][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][1] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][1] >> 16)) + in_matrix[3][1];
        out_vec4[2] = (((in_vec3[0] ^ in_matrix[0][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][2] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][2] >> 16)) + (((in_vec3[1] ^ in_matrix[1][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][2] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][2] >> 16)) + (((in_vec3[2] ^ in_matrix[2][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][2] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][2] >> 16)) + in_matrix[3][2];
        out_vec4[3] = (((in_vec3[0] ^ in_matrix[0][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][3] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][3] >> 16)) + (((in_vec3[1] ^ in_matrix[1][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][3] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][3] >> 16)) + (((in_vec3[2] ^ in_matrix[2][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][3] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][3] >> 16)) + in_matrix[3][3];
    }

    public static void setMulVec4Fast(int[] out_vec4, int[] in_vec3, int[] in_matrix) {
        out_vec4[0] = (((in_vec3[0] ^ in_matrix[0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0] >> 16)) + (((in_vec3[1] ^ in_matrix[4]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[4] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[4] >> 16)) + (((in_vec3[2] ^ in_matrix[8]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[8] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[8] >> 16)) + in_matrix[12];
        out_vec4[1] = (((in_vec3[0] ^ in_matrix[1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[1] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[1] >> 16)) + (((in_vec3[1] ^ in_matrix[5]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[5] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[5] >> 16)) + (((in_vec3[2] ^ in_matrix[9]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[9] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[9] >> 16)) + in_matrix[13];
        out_vec4[2] = (((in_vec3[0] ^ in_matrix[2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[2] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[2] >> 16)) + (((in_vec3[1] ^ in_matrix[6]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[6] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[6] >> 16)) + (((in_vec3[2] ^ in_matrix[10]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[10] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[10] >> 16)) + in_matrix[14];
        out_vec4[3] = (((in_vec3[0] ^ in_matrix[3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[3] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[3] >> 16)) + (((in_vec3[1] ^ in_matrix[7]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[7] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[7] >> 16)) + (((in_vec3[2] ^ in_matrix[11]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[11] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[11] >> 16)) + in_matrix[15];
    }

    public static void setMulRotVec4(int[] out_vec4, int[] in_vec3, int[][] in_matrix) {
        out_vec4[0] = (((in_vec3[0] ^ in_matrix[0][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][0] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][0] >> 16)) + (((in_vec3[1] ^ in_matrix[1][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][0] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][0] >> 16)) + (((in_vec3[2] ^ in_matrix[2][0]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][0] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][0] >> 16));
        out_vec4[1] = (((in_vec3[0] ^ in_matrix[0][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][1] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][1] >> 16)) + (((in_vec3[1] ^ in_matrix[1][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][1] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][1] >> 16)) + (((in_vec3[2] ^ in_matrix[2][1]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][1] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][1] >> 16));
        out_vec4[2] = (((in_vec3[0] ^ in_matrix[0][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][2] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][2] >> 16)) + (((in_vec3[1] ^ in_matrix[1][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][2] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][2] >> 16)) + (((in_vec3[2] ^ in_matrix[2][2]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][2] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][2] >> 16));
        out_vec4[3] = (((in_vec3[0] ^ in_matrix[0][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[0]) * (long)in_matrix[0][3] >> 16)) : (int)((long)in_vec3[0] * (long)in_matrix[0][3] >> 16)) + (((in_vec3[1] ^ in_matrix[1][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[1]) * (long)in_matrix[1][3] >> 16)) : (int)((long)in_vec3[1] * (long)in_matrix[1][3] >> 16)) + (((in_vec3[2] ^ in_matrix[2][3]) & 0x8000000) != 0 ? -((int)((long)(-in_vec3[2]) * (long)in_matrix[2][3] >> 16)) : (int)((long)in_vec3[2] * (long)in_matrix[2][3] >> 16));
    }

    public static void setMulMat4(int[][] out, int[][] arg1, int[][] arg2) {
        for (int j = 0; j < 4; ++j) {
            out[j][0] = (((arg1[j][0] ^ arg2[0][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][0] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][0] >> 16)) + (((arg1[j][1] ^ arg2[1][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][0] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][0] >> 16)) + (((arg1[j][2] ^ arg2[2][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][0] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][0] >> 16)) + (((arg1[j][3] ^ arg2[3][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][0] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][0] >> 16));
            out[j][1] = (((arg1[j][0] ^ arg2[0][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][1] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][1] >> 16)) + (((arg1[j][1] ^ arg2[1][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][1] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][1] >> 16)) + (((arg1[j][2] ^ arg2[2][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][1] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][1] >> 16)) + (((arg1[j][3] ^ arg2[3][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][1] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][1] >> 16));
            out[j][2] = (((arg1[j][0] ^ arg2[0][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][2] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][2] >> 16)) + (((arg1[j][1] ^ arg2[1][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][2] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][2] >> 16)) + (((arg1[j][2] ^ arg2[2][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][2] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][2] >> 16)) + (((arg1[j][3] ^ arg2[3][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][2] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][2] >> 16));
            out[j][3] = (((arg1[j][0] ^ arg2[0][3]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][3] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][3] >> 16)) + (((arg1[j][1] ^ arg2[1][3]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][3] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][3] >> 16)) + (((arg1[j][2] ^ arg2[2][3]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][3] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][3] >> 16)) + (((arg1[j][3] ^ arg2[3][3]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][3] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][3] >> 16));
        }
    }

    public static void setMulMat43(int[][] out, int[][] arg1, int[][] arg2) {
        for (int j = 0; j < 4; ++j) {
            out[j][0] = (((arg1[j][0] ^ arg2[0][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][0] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][0] >> 16)) + (((arg1[j][1] ^ arg2[1][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][0] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][0] >> 16)) + (((arg1[j][2] ^ arg2[2][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][0] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][0] >> 16)) + (((arg1[j][3] ^ arg2[3][0]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][0] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][0] >> 16));
            out[j][1] = (((arg1[j][0] ^ arg2[0][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][1] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][1] >> 16)) + (((arg1[j][1] ^ arg2[1][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][1] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][1] >> 16)) + (((arg1[j][2] ^ arg2[2][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][1] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][1] >> 16)) + (((arg1[j][3] ^ arg2[3][1]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][1] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][1] >> 16));
            out[j][2] = (((arg1[j][0] ^ arg2[0][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][0]) * (long)arg2[0][2] >> 16)) : (int)((long)arg1[j][0] * (long)arg2[0][2] >> 16)) + (((arg1[j][1] ^ arg2[1][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][1]) * (long)arg2[1][2] >> 16)) : (int)((long)arg1[j][1] * (long)arg2[1][2] >> 16)) + (((arg1[j][2] ^ arg2[2][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][2]) * (long)arg2[2][2] >> 16)) : (int)((long)arg1[j][2] * (long)arg2[2][2] >> 16)) + (((arg1[j][3] ^ arg2[3][2]) & 0x8000000) != 0 ? -((int)((long)(-arg1[j][3]) * (long)arg2[3][2] >> 16)) : (int)((long)arg1[j][3] * (long)arg2[3][2] >> 16));
        }
    }

    public static void setMatInv(int[][] out, int[][] in) {
        int i;
        for (i = 0; i < 4; ++i) {
            Software3D.src[i] = in[i][0];
            Software3D.src[i + 4] = in[i][1];
            Software3D.src[i + 8] = in[i][2];
            Software3D.src[i + 12] = in[i][3];
        }
        Software3D.tmp[0] = ((src[10] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-src[10]) * (long)src[15] >> 16)) : (int)((long)src[10] * (long)src[15] >> 16);
        Software3D.tmp[1] = ((src[11] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-src[11]) * (long)src[14] >> 16)) : (int)((long)src[11] * (long)src[14] >> 16);
        Software3D.tmp[2] = ((src[9] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-src[9]) * (long)src[15] >> 16)) : (int)((long)src[9] * (long)src[15] >> 16);
        Software3D.tmp[3] = ((src[11] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-src[11]) * (long)src[13] >> 16)) : (int)((long)src[11] * (long)src[13] >> 16);
        Software3D.tmp[4] = ((src[9] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-src[9]) * (long)src[14] >> 16)) : (int)((long)src[9] * (long)src[14] >> 16);
        Software3D.tmp[5] = ((src[10] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-src[10]) * (long)src[13] >> 16)) : (int)((long)src[10] * (long)src[13] >> 16);
        Software3D.tmp[6] = ((src[8] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-src[8]) * (long)src[15] >> 16)) : (int)((long)src[8] * (long)src[15] >> 16);
        Software3D.tmp[7] = ((src[11] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-src[11]) * (long)src[12] >> 16)) : (int)((long)src[11] * (long)src[12] >> 16);
        Software3D.tmp[8] = ((src[8] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-src[8]) * (long)src[14] >> 16)) : (int)((long)src[8] * (long)src[14] >> 16);
        Software3D.tmp[9] = ((src[10] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-src[10]) * (long)src[12] >> 16)) : (int)((long)src[10] * (long)src[12] >> 16);
        Software3D.tmp[10] = ((src[8] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-src[8]) * (long)src[13] >> 16)) : (int)((long)src[8] * (long)src[13] >> 16);
        Software3D.tmp[11] = ((src[9] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-src[9]) * (long)src[12] >> 16)) : (int)((long)src[9] * (long)src[12] >> 16);
        Software3D.dst[0] = (((tmp[0] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[5] >> 16)) : (int)((long)tmp[0] * (long)src[5] >> 16)) + (((tmp[3] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[6] >> 16)) : (int)((long)tmp[3] * (long)src[6] >> 16)) + (((tmp[4] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[7] >> 16)) : (int)((long)tmp[4] * (long)src[7] >> 16));
        dst[0] = dst[0] - ((((tmp[1] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[5] >> 16)) : (int)((long)tmp[1] * (long)src[5] >> 16)) + (((tmp[2] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[6] >> 16)) : (int)((long)tmp[2] * (long)src[6] >> 16)) + (((tmp[5] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[7] >> 16)) : (int)((long)tmp[5] * (long)src[7] >> 16)));
        Software3D.dst[1] = (((tmp[1] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[4] >> 16)) : (int)((long)tmp[1] * (long)src[4] >> 16)) + (((tmp[6] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[6] >> 16)) : (int)((long)tmp[6] * (long)src[6] >> 16)) + (((tmp[9] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[7] >> 16)) : (int)((long)tmp[9] * (long)src[7] >> 16));
        dst[1] = dst[1] - ((((tmp[0] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[4] >> 16)) : (int)((long)tmp[0] * (long)src[4] >> 16)) + (((tmp[7] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[6] >> 16)) : (int)((long)tmp[7] * (long)src[6] >> 16)) + (((tmp[8] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[7] >> 16)) : (int)((long)tmp[8] * (long)src[7] >> 16)));
        Software3D.dst[2] = (((tmp[2] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[4] >> 16)) : (int)((long)tmp[2] * (long)src[4] >> 16)) + (((tmp[7] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[5] >> 16)) : (int)((long)tmp[7] * (long)src[5] >> 16)) + (((tmp[10] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[7] >> 16)) : (int)((long)tmp[10] * (long)src[7] >> 16));
        dst[2] = dst[2] - ((((tmp[3] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[4] >> 16)) : (int)((long)tmp[3] * (long)src[4] >> 16)) + (((tmp[6] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[5] >> 16)) : (int)((long)tmp[6] * (long)src[5] >> 16)) + (((tmp[11] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[7] >> 16)) : (int)((long)tmp[11] * (long)src[7] >> 16)));
        Software3D.dst[3] = (((tmp[5] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[4] >> 16)) : (int)((long)tmp[5] * (long)src[4] >> 16)) + (((tmp[8] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[5] >> 16)) : (int)((long)tmp[8] * (long)src[5] >> 16)) + (((tmp[11] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[6] >> 16)) : (int)((long)tmp[11] * (long)src[6] >> 16));
        dst[3] = dst[3] - ((((tmp[4] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[4] >> 16)) : (int)((long)tmp[4] * (long)src[4] >> 16)) + (((tmp[9] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[5] >> 16)) : (int)((long)tmp[9] * (long)src[5] >> 16)) + (((tmp[10] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[6] >> 16)) : (int)((long)tmp[10] * (long)src[6] >> 16)));
        Software3D.dst[4] = (((tmp[1] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[1] >> 16)) : (int)((long)tmp[1] * (long)src[1] >> 16)) + (((tmp[2] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[2] >> 16)) : (int)((long)tmp[2] * (long)src[2] >> 16)) + (((tmp[5] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[3] >> 16)) : (int)((long)tmp[5] * (long)src[3] >> 16));
        dst[4] = dst[4] - ((((tmp[0] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[1] >> 16)) : (int)((long)tmp[0] * (long)src[1] >> 16)) + (((tmp[3] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[2] >> 16)) : (int)((long)tmp[3] * (long)src[2] >> 16)) + (((tmp[4] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[3] >> 16)) : (int)((long)tmp[4] * (long)src[3] >> 16)));
        Software3D.dst[5] = (((tmp[0] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[0] >> 16)) : (int)((long)tmp[0] * (long)src[0] >> 16)) + (((tmp[7] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[2] >> 16)) : (int)((long)tmp[7] * (long)src[2] >> 16)) + (((tmp[8] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[3] >> 16)) : (int)((long)tmp[8] * (long)src[3] >> 16));
        dst[5] = dst[5] - ((((tmp[1] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[0] >> 16)) : (int)((long)tmp[1] * (long)src[0] >> 16)) + (((tmp[6] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[2] >> 16)) : (int)((long)tmp[6] * (long)src[2] >> 16)) + (((tmp[9] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[3] >> 16)) : (int)((long)tmp[9] * (long)src[3] >> 16)));
        Software3D.dst[6] = (((tmp[3] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[0] >> 16)) : (int)((long)tmp[3] * (long)src[0] >> 16)) + (((tmp[6] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[1] >> 16)) : (int)((long)tmp[6] * (long)src[1] >> 16)) + (((tmp[11] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[3] >> 16)) : (int)((long)tmp[11] * (long)src[3] >> 16));
        dst[6] = dst[6] - ((((tmp[2] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[0] >> 16)) : (int)((long)tmp[2] * (long)src[0] >> 16)) + (((tmp[7] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[1] >> 16)) : (int)((long)tmp[7] * (long)src[1] >> 16)) + (((tmp[10] ^ src[3]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[3] >> 16)) : (int)((long)tmp[10] * (long)src[3] >> 16)));
        Software3D.dst[7] = (((tmp[4] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[0] >> 16)) : (int)((long)tmp[4] * (long)src[0] >> 16)) + (((tmp[9] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[1] >> 16)) : (int)((long)tmp[9] * (long)src[1] >> 16)) + (((tmp[10] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[2] >> 16)) : (int)((long)tmp[10] * (long)src[2] >> 16));
        dst[7] = dst[7] - ((((tmp[5] ^ src[0]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[0] >> 16)) : (int)((long)tmp[5] * (long)src[0] >> 16)) + (((tmp[8] ^ src[1]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[1] >> 16)) : (int)((long)tmp[8] * (long)src[1] >> 16)) + (((tmp[11] ^ src[2]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[2] >> 16)) : (int)((long)tmp[11] * (long)src[2] >> 16)));
        Software3D.tmp[0] = ((src[2] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-src[2]) * (long)src[7] >> 16)) : (int)((long)src[2] * (long)src[7] >> 16);
        Software3D.tmp[1] = ((src[3] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-src[3]) * (long)src[6] >> 16)) : (int)((long)src[3] * (long)src[6] >> 16);
        Software3D.tmp[2] = ((src[1] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-src[1]) * (long)src[7] >> 16)) : (int)((long)src[1] * (long)src[7] >> 16);
        Software3D.tmp[3] = ((src[3] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-src[3]) * (long)src[5] >> 16)) : (int)((long)src[3] * (long)src[5] >> 16);
        Software3D.tmp[4] = ((src[1] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-src[1]) * (long)src[6] >> 16)) : (int)((long)src[1] * (long)src[6] >> 16);
        Software3D.tmp[5] = ((src[2] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-src[2]) * (long)src[5] >> 16)) : (int)((long)src[2] * (long)src[5] >> 16);
        Software3D.tmp[6] = ((src[0] ^ src[7]) & 0x8000000) != 0 ? -((int)((long)(-src[0]) * (long)src[7] >> 16)) : (int)((long)src[0] * (long)src[7] >> 16);
        Software3D.tmp[7] = ((src[3] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-src[3]) * (long)src[4] >> 16)) : (int)((long)src[3] * (long)src[4] >> 16);
        Software3D.tmp[8] = ((src[0] ^ src[6]) & 0x8000000) != 0 ? -((int)((long)(-src[0]) * (long)src[6] >> 16)) : (int)((long)src[0] * (long)src[6] >> 16);
        Software3D.tmp[9] = ((src[2] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-src[2]) * (long)src[4] >> 16)) : (int)((long)src[2] * (long)src[4] >> 16);
        Software3D.tmp[10] = ((src[0] ^ src[5]) & 0x8000000) != 0 ? -((int)((long)(-src[0]) * (long)src[5] >> 16)) : (int)((long)src[0] * (long)src[5] >> 16);
        Software3D.tmp[11] = ((src[1] ^ src[4]) & 0x8000000) != 0 ? -((int)((long)(-src[1]) * (long)src[4] >> 16)) : (int)((long)src[1] * (long)src[4] >> 16);
        Software3D.dst[8] = (((tmp[0] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[13] >> 16)) : (int)((long)tmp[0] * (long)src[13] >> 16)) + (((tmp[3] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[14] >> 16)) : (int)((long)tmp[3] * (long)src[14] >> 16)) + (((tmp[4] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[15] >> 16)) : (int)((long)tmp[4] * (long)src[15] >> 16));
        dst[8] = dst[8] - ((((tmp[1] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[13] >> 16)) : (int)((long)tmp[1] * (long)src[13] >> 16)) + (((tmp[2] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[14] >> 16)) : (int)((long)tmp[2] * (long)src[14] >> 16)) + (((tmp[5] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[15] >> 16)) : (int)((long)tmp[5] * (long)src[15] >> 16)));
        Software3D.dst[9] = (((tmp[1] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[12] >> 16)) : (int)((long)tmp[1] * (long)src[12] >> 16)) + (((tmp[6] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[14] >> 16)) : (int)((long)tmp[6] * (long)src[14] >> 16)) + (((tmp[9] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[15] >> 16)) : (int)((long)tmp[9] * (long)src[15] >> 16));
        dst[9] = dst[9] - ((((tmp[0] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[12] >> 16)) : (int)((long)tmp[0] * (long)src[12] >> 16)) + (((tmp[7] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[14] >> 16)) : (int)((long)tmp[7] * (long)src[14] >> 16)) + (((tmp[8] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[15] >> 16)) : (int)((long)tmp[8] * (long)src[15] >> 16)));
        Software3D.dst[10] = (((tmp[2] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[12] >> 16)) : (int)((long)tmp[2] * (long)src[12] >> 16)) + (((tmp[7] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[13] >> 16)) : (int)((long)tmp[7] * (long)src[13] >> 16)) + (((tmp[10] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[15] >> 16)) : (int)((long)tmp[10] * (long)src[15] >> 16));
        dst[10] = dst[10] - ((((tmp[3] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[12] >> 16)) : (int)((long)tmp[3] * (long)src[12] >> 16)) + (((tmp[6] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[13] >> 16)) : (int)((long)tmp[6] * (long)src[13] >> 16)) + (((tmp[11] ^ src[15]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[15] >> 16)) : (int)((long)tmp[11] * (long)src[15] >> 16)));
        Software3D.dst[11] = (((tmp[5] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[12] >> 16)) : (int)((long)tmp[5] * (long)src[12] >> 16)) + (((tmp[8] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[13] >> 16)) : (int)((long)tmp[8] * (long)src[13] >> 16)) + (((tmp[11] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[14] >> 16)) : (int)((long)tmp[11] * (long)src[14] >> 16));
        dst[11] = dst[11] - ((((tmp[4] ^ src[12]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[12] >> 16)) : (int)((long)tmp[4] * (long)src[12] >> 16)) + (((tmp[9] ^ src[13]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[13] >> 16)) : (int)((long)tmp[9] * (long)src[13] >> 16)) + (((tmp[10] ^ src[14]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[14] >> 16)) : (int)((long)tmp[10] * (long)src[14] >> 16)));
        Software3D.dst[12] = (((tmp[2] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[10] >> 16)) : (int)((long)tmp[2] * (long)src[10] >> 16)) + (((tmp[5] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[11] >> 16)) : (int)((long)tmp[5] * (long)src[11] >> 16)) + (((tmp[1] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[9] >> 16)) : (int)((long)tmp[1] * (long)src[9] >> 16));
        dst[12] = dst[12] - ((((tmp[4] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[11] >> 16)) : (int)((long)tmp[4] * (long)src[11] >> 16)) + (((tmp[0] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[9] >> 16)) : (int)((long)tmp[0] * (long)src[9] >> 16)) + (((tmp[3] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[10] >> 16)) : (int)((long)tmp[3] * (long)src[10] >> 16)));
        Software3D.dst[13] = (((tmp[8] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[11] >> 16)) : (int)((long)tmp[8] * (long)src[11] >> 16)) + (((tmp[0] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[0]) * (long)src[8] >> 16)) : (int)((long)tmp[0] * (long)src[8] >> 16)) + (((tmp[7] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[10] >> 16)) : (int)((long)tmp[7] * (long)src[10] >> 16));
        dst[13] = dst[13] - ((((tmp[6] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[10] >> 16)) : (int)((long)tmp[6] * (long)src[10] >> 16)) + (((tmp[9] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[11] >> 16)) : (int)((long)tmp[9] * (long)src[11] >> 16)) + (((tmp[1] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[1]) * (long)src[8] >> 16)) : (int)((long)tmp[1] * (long)src[8] >> 16)));
        Software3D.dst[14] = (((tmp[6] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[6]) * (long)src[9] >> 16)) : (int)((long)tmp[6] * (long)src[9] >> 16)) + (((tmp[11] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[11] >> 16)) : (int)((long)tmp[11] * (long)src[11] >> 16)) + (((tmp[3] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[3]) * (long)src[8] >> 16)) : (int)((long)tmp[3] * (long)src[8] >> 16));
        dst[14] = dst[14] - ((((tmp[10] ^ src[11]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[11] >> 16)) : (int)((long)tmp[10] * (long)src[11] >> 16)) + (((tmp[2] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[2]) * (long)src[8] >> 16)) : (int)((long)tmp[2] * (long)src[8] >> 16)) + (((tmp[7] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[7]) * (long)src[9] >> 16)) : (int)((long)tmp[7] * (long)src[9] >> 16)));
        Software3D.dst[15] = (((tmp[10] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[10]) * (long)src[10] >> 16)) : (int)((long)tmp[10] * (long)src[10] >> 16)) + (((tmp[4] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[4]) * (long)src[8] >> 16)) : (int)((long)tmp[4] * (long)src[8] >> 16)) + (((tmp[9] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[9]) * (long)src[9] >> 16)) : (int)((long)tmp[9] * (long)src[9] >> 16));
        dst[15] = dst[15] - ((((tmp[8] ^ src[9]) & 0x8000000) != 0 ? -((int)((long)(-tmp[8]) * (long)src[9] >> 16)) : (int)((long)tmp[8] * (long)src[9] >> 16)) + (((tmp[11] ^ src[10]) & 0x8000000) != 0 ? -((int)((long)(-tmp[11]) * (long)src[10] >> 16)) : (int)((long)tmp[11] * (long)src[10] >> 16)) + (((tmp[5] ^ src[8]) & 0x8000000) != 0 ? -((int)((long)(-tmp[5]) * (long)src[8] >> 16)) : (int)((long)tmp[5] * (long)src[8] >> 16)));
        int det = (((src[0] ^ dst[0]) & 0x8000000) != 0 ? -((int)((long)(-src[0]) * (long)dst[0] >> 16)) : (int)((long)src[0] * (long)dst[0] >> 16)) + (((src[1] ^ dst[1]) & 0x8000000) != 0 ? -((int)((long)(-src[1]) * (long)dst[1] >> 16)) : (int)((long)src[1] * (long)dst[1] >> 16)) + (((src[2] ^ dst[2]) & 0x8000000) != 0 ? -((int)((long)(-src[2]) * (long)dst[2] >> 16)) : (int)((long)src[2] * (long)dst[2] >> 16)) + (((src[3] ^ dst[3]) & 0x8000000) != 0 ? -((int)((long)(-src[3]) * (long)dst[3] >> 16)) : (int)((long)src[3] * (long)dst[3] >> 16));
        det = (int)(0x100000000L / (long)det);
        for (int j = 0; j < 16; ++j) {
            Software3D.dst[j] = ((dst[j] ^ det) & 0x8000000) != 0 ? -((int)((long)(-dst[j]) * (long)det >> 16)) : (int)((long)dst[j] * (long)det >> 16);
        }
        for (i = 0; i < 4; ++i) {
            out[i][0] = dst[(i << 2) + 0];
            out[i][1] = dst[(i << 2) + 1];
            out[i][2] = dst[(i << 2) + 2];
            out[i][3] = dst[(i << 2) + 3];
        }
    }

    public static void setWorldTrans(int[][] worldtrans) {
        if (worldtrans == null) {
            Software3D.copyMatrix(matrixComposite, matrixCamera);
            Software3D.nearPlane.normal = Software3D.nearPlaneWS.normal;
            Software3D.nearPlane.offset = Software3D.nearPlaneWS.offset;
        } else {
            Software3D.setMulMat4(matrixComposite, worldtrans, matrixCamera);
        }
        Software3D.convertMatrix44(matrixCompositeFast, matrixComposite);
        worldTrans = worldtrans;
    }

    public static void setCamera(int[] from, int[] to, int[] up, int near, int far, int fov, int aspect) {
        Software3D.makeView(temp_matView, from, to, up);
        Software3D.makeProjection(temp_matProj, near, far, fov, aspect);
        Software3D.setCamera(temp_matView, temp_matProj, from);
    }

    public static void setCamera(int[][] matView, int[][] matProj, int[] from) {
        Software3D.setMulMat4(matrixCamera, matView, matProj);
        Software3D.nearNormal[0] = matView[0][2];
        Software3D.nearNormal[1] = matView[1][2];
        Software3D.nearNormal[2] = matView[2][2];
        Software3D.nearFrom[0] = from[0];
        Software3D.nearFrom[1] = from[1];
        Software3D.nearFrom[2] = from[2];
        nearPlaneWS.makePlane(nearFrom, nearNormal);
        Software3D.setWorldTrans(null);
    }

    public static int loadCameras(String filename, int z_offset, int unit_scale) {
        DataInputStream datain;
        InputStream inputstream = Application.instance.getClass().getResourceAsStream(filename);
        if (inputstream == null) {
            System.out.println("Assertion Failure: inputstream != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/Software3D.java[404]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((datain = new DataInputStream(inputstream)) == null) {
            System.out.println("Assertion Failure: datain != null\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/Software3D.java[408]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int num_cams = 0;
        try {
            num_cams = datain.readInt();
            loadedCameraMatrix = new int[num_cams][4][3];
            loadedCameraFOV = new int[num_cams];
            loadedCameraNearClip = new int[num_cams];
            loadedCameraFarClip = new int[num_cams];
            for (int c = 0; c < num_cams; ++c) {
                for (int j = 0; j < 4; ++j) {
                    for (int i = 0; i < 3; ++i) {
                        Software3D.loadedCameraMatrix[c][j][i] = datain.readInt();
                        if (j == 3) {
                            int n = Software3D.loadedCameraMatrix[c][j][i] = ((loadedCameraMatrix[c][j][i] ^ unit_scale) & 0x8000000) != 0 ? -((int)((long)(-loadedCameraMatrix[c][j][i]) * (long)unit_scale >> 16)) : (int)((long)loadedCameraMatrix[c][j][i] * (long)unit_scale >> 16);
                        }
                        if (j != 3 || i != 2) continue;
                        int[] nArray = loadedCameraMatrix[c][j];
                        int n = i;
                        nArray[n] = nArray[n] + z_offset;
                    }
                }
                Software3D.loadedCameraFOV[c] = datain.readInt();
            }
        }
        catch (Exception err) {
            System.out.println("\n\n*******************************************************\nError reading camera data: " + filename + " e:" + err + "\n*******************************************************\n\n");
        }
        return num_cams;
    }

    public static void releaseCameras() {
        loadedCameraMatrix = null;
        loadedCameraFOV = null;
        loadedCameraNearClip = null;
        loadedCameraFarClip = null;
    }

    public static void setViewport(int x0, int y0, int w, int h) {
        renderWidth = w;
        renderHeight = h;
        halfWidth = renderWidth >> 1;
        halfHeight = renderHeight >> 1;
        fp_viewport_x0 = x0 < 0 ? -(-x0 << 16) : x0 << 16;
        fp_viewport_y0 = y0 < 0 ? -(-y0 << 16) : y0 << 16;
    }

    public static void translate(int dx, int dy) {
        fp_viewport_x0 += dx < 0 ? -(-dx << 16) : dx << 16;
        fp_viewport_y0 += dy < 0 ? -(-dy << 16) : dy << 16;
    }

    public static void makeView(int[][] data, int[] from, int[] to, int[] up) {
        Software3D.view[0] = to[0] - from[0];
        Software3D.view[1] = to[1] - from[1];
        Software3D.view[2] = to[2] - from[2];
        VecMath.norm3d(view, view);
        Software3D.right[0] = (((up[1] ^ view[2]) & 0x8000000) != 0 ? -((int)((long)(-up[1]) * (long)view[2] >> 16)) : (int)((long)up[1] * (long)view[2] >> 16)) - (((up[2] ^ view[1]) & 0x8000000) != 0 ? -((int)((long)(-up[2]) * (long)view[1] >> 16)) : (int)((long)up[2] * (long)view[1] >> 16));
        Software3D.right[1] = (((up[2] ^ view[0]) & 0x8000000) != 0 ? -((int)((long)(-up[2]) * (long)view[0] >> 16)) : (int)((long)up[2] * (long)view[0] >> 16)) - (((up[0] ^ view[2]) & 0x8000000) != 0 ? -((int)((long)(-up[0]) * (long)view[2] >> 16)) : (int)((long)up[0] * (long)view[2] >> 16));
        Software3D.right[2] = (((up[0] ^ view[1]) & 0x8000000) != 0 ? -((int)((long)(-up[0]) * (long)view[1] >> 16)) : (int)((long)up[0] * (long)view[1] >> 16)) - (((up[1] ^ view[0]) & 0x8000000) != 0 ? -((int)((long)(-up[1]) * (long)view[0] >> 16)) : (int)((long)up[1] * (long)view[0] >> 16));
        Software3D.newup[0] = (((view[1] ^ right[2]) & 0x8000000) != 0 ? -((int)((long)(-view[1]) * (long)right[2] >> 16)) : (int)((long)view[1] * (long)right[2] >> 16)) - (((view[2] ^ right[1]) & 0x8000000) != 0 ? -((int)((long)(-view[2]) * (long)right[1] >> 16)) : (int)((long)view[2] * (long)right[1] >> 16));
        Software3D.newup[1] = (((view[2] ^ right[0]) & 0x8000000) != 0 ? -((int)((long)(-view[2]) * (long)right[0] >> 16)) : (int)((long)view[2] * (long)right[0] >> 16)) - (((view[0] ^ right[2]) & 0x8000000) != 0 ? -((int)((long)(-view[0]) * (long)right[2] >> 16)) : (int)((long)view[0] * (long)right[2] >> 16));
        Software3D.newup[2] = (((view[0] ^ right[1]) & 0x8000000) != 0 ? -((int)((long)(-view[0]) * (long)right[1] >> 16)) : (int)((long)view[0] * (long)right[1] >> 16)) - (((view[1] ^ right[0]) & 0x8000000) != 0 ? -((int)((long)(-view[1]) * (long)right[0] >> 16)) : (int)((long)view[1] * (long)right[0] >> 16));
        VecMath.norm3d(right, right);
        VecMath.norm3d(newup, newup);
        Software3D.makeView(data, from, right, newup, view);
    }

    public static void makeView(int[][] out_view, int[] from, int[] right, int[] up, int[] view) {
        out_view[0][0] = right[0];
        out_view[1][0] = right[1];
        out_view[2][0] = right[2];
        out_view[0][1] = up[0];
        out_view[1][1] = up[1];
        out_view[2][1] = up[2];
        out_view[0][2] = view[0];
        out_view[1][2] = view[1];
        out_view[2][2] = view[2];
        out_view[3][0] = -((((right[0] ^ from[0]) & 0x8000000) != 0 ? -((int)((long)(-right[0]) * (long)from[0] >> 16)) : (int)((long)right[0] * (long)from[0] >> 16)) + (((right[1] ^ from[1]) & 0x8000000) != 0 ? -((int)((long)(-right[1]) * (long)from[1] >> 16)) : (int)((long)right[1] * (long)from[1] >> 16)) + (((right[2] ^ from[2]) & 0x8000000) != 0 ? -((int)((long)(-right[2]) * (long)from[2] >> 16)) : (int)((long)right[2] * (long)from[2] >> 16)));
        out_view[3][1] = -((((up[0] ^ from[0]) & 0x8000000) != 0 ? -((int)((long)(-up[0]) * (long)from[0] >> 16)) : (int)((long)up[0] * (long)from[0] >> 16)) + (((up[1] ^ from[1]) & 0x8000000) != 0 ? -((int)((long)(-up[1]) * (long)from[1] >> 16)) : (int)((long)up[1] * (long)from[1] >> 16)) + (((up[2] ^ from[2]) & 0x8000000) != 0 ? -((int)((long)(-up[2]) * (long)from[2] >> 16)) : (int)((long)up[2] * (long)from[2] >> 16)));
        out_view[3][2] = -((((view[0] ^ from[0]) & 0x8000000) != 0 ? -((int)((long)(-view[0]) * (long)from[0] >> 16)) : (int)((long)view[0] * (long)from[0] >> 16)) + (((view[1] ^ from[1]) & 0x8000000) != 0 ? -((int)((long)(-view[1]) * (long)from[1] >> 16)) : (int)((long)view[1] * (long)from[1] >> 16)) + (((view[2] ^ from[2]) & 0x8000000) != 0 ? -((int)((long)(-view[2]) * (long)from[2] >> 16)) : (int)((long)view[2] * (long)from[2] >> 16)));
        out_view[0][3] = 0;
        out_view[1][3] = 0;
        out_view[2][3] = 0;
        out_view[3][3] = 65536;
    }

    public static void makeProjection(int[][] data, int near_plane, int far_plane, int fov, int aspect) {
        int fov_horiz = fov;
        int w = (int)(0x100000000L / (long)((int)(((long)FixedPoint.sinLut(((fov_horiz ^ 0x8000) & 0x8000000) != 0 ? -((int)((long)(-fov_horiz) * 32768L >> 16)) : (int)((long)fov_horiz * 32768L >> 16)) << 16) / (long)FixedPoint.sinLut((((fov_horiz ^ 0x8000) & 0x8000000) != 0 ? -((int)((long)(-fov_horiz) * 32768L >> 16)) : (int)((long)fov_horiz * 32768L >> 16)) + 0x400000))));
        int h = ((aspect ^ w) & 0x8000000) != 0 ? -((int)((long)(-aspect) * (long)w >> 16)) : (int)((long)aspect * (long)w >> 16);
        int Q = (int)(((long)far_plane << 16) / (long)(near_plane - far_plane));
        data[0][0] = w;
        data[0][1] = 0;
        data[0][2] = 0;
        data[0][3] = 0;
        data[1][0] = 0;
        data[1][1] = h;
        data[1][2] = 0;
        data[1][3] = 0;
        data[2][0] = 0;
        data[2][1] = 0;
        data[2][2] = Q;
        data[2][3] = 65536;
        data[3][0] = 0;
        data[3][1] = 0;
        data[3][2] = -(((Q ^ near_plane) & 0x8000000) != 0 ? -((int)((long)(-Q) * (long)near_plane >> 16)) : (int)((long)Q * (long)near_plane >> 16));
        data[3][3] = 0;
    }

    public static boolean project(int[] outpos, int[] pos) {
        Software3D.setMulVec4Fast(outpos, pos, matrixCompositeFast);
        int fRHW = (int)(0x100000000L / (long)outpos[3]);
        outpos[0] = (((outpos[0] ^ -fRHW) & 0x8000000) != 0 ? -((int)((long)(-outpos[0]) * (long)(-fRHW) >> 16)) : (int)((long)outpos[0] * (long)(-fRHW) >> 16)) + 65536;
        outpos[0] = outpos[0] * halfWidth + fp_viewport_x0;
        outpos[1] = (((outpos[1] ^ -fRHW) & 0x8000000) != 0 ? -((int)((long)(-outpos[1]) * (long)(-fRHW) >> 16)) : (int)((long)outpos[1] * (long)(-fRHW) >> 16)) + 65536;
        outpos[1] = outpos[1] * halfHeight + fp_viewport_y0;
        outpos[2] = ((outpos[2] ^ fRHW) & 0x8000000) != 0 ? -((int)((long)(-outpos[2]) * (long)fRHW >> 16)) : (int)((long)outpos[2] * (long)fRHW >> 16);
        outpos[3] = fRHW;
        return outpos[2] >= 0;
    }

    public static int clipProjectLine(int[][] p, int[] v0, int[] v1) {
        int i;
        Software3D.vdist[0] = nearPlane.getDistFromPlane(v0);
        Software3D.vdist[1] = nearPlane.getDistFromPlane(v1);
        int count = 0;
        for (i = 0; i < 2; ++i) {
            if (vdist[i] >= clipMinZ) continue;
            ++count;
        }
        switch (count) {
            case 0: {
                Software3D.project(p[0], v0);
                Software3D.project(p[1], v1);
                return 2;
            }
            case 1: {
                for (i = 0; i < 3; ++i) {
                    Software3D.vert[0][i] = v0[i];
                    Software3D.vert[1][i] = v1[i];
                }
                for (i = 0; i < 2; ++i) {
                    if (vdist[i] < clipMinZ) continue;
                    int a = i;
                    int b = 1 - a;
                    Software3D.vAB[0] = vert[b][0] - vert[a][0];
                    Software3D.vAB[1] = vert[b][1] - vert[a][1];
                    Software3D.vAB[2] = vert[b][2] - vert[a][2];
                    VecMath.norm3d(vAB, vAB);
                    int d_b = nearPlane.intersection(vert[a], vAB) - 65536;
                    Software3D.vert[b][0] = vert[a][0] + (((vAB[0] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[0]) * (long)d_b >> 16)) : (int)((long)vAB[0] * (long)d_b >> 16));
                    Software3D.vert[b][1] = vert[a][1] + (((vAB[1] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[1]) * (long)d_b >> 16)) : (int)((long)vAB[1] * (long)d_b >> 16));
                    Software3D.vert[b][2] = vert[a][2] + (((vAB[2] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[2]) * (long)d_b >> 16)) : (int)((long)vAB[2] * (long)d_b >> 16));
                    Software3D.project(p[0], vert[a]);
                    Software3D.project(p[1], vert[b]);
                }
                return 2;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public static int clipProjectTriangle(int[] v0, int[] v1, int[] v2) {
        int i;
        Software3D.vdist[0] = nearPlane.getDistFromPlane(v0);
        Software3D.vdist[1] = nearPlane.getDistFromPlane(v1);
        Software3D.vdist[2] = nearPlane.getDistFromPlane(v2);
        int count = 0;
        for (i = 0; i < 3; ++i) {
            if (vdist[i] >= clipMinZ) continue;
            ++count;
        }
        switch (count) {
            case 0: {
                Software3D.project(p[0], v0);
                Software3D.project(p[1], v1);
                Software3D.project(p[2], v2);
                return 3;
            }
            case 1: {
                for (i = 0; i < 3; ++i) {
                    Software3D.vert[0][i] = v0[i];
                    Software3D.vert[1][i] = v1[i];
                    Software3D.vert[2][i] = v2[i];
                }
                for (i = 0; i < 3; ++i) {
                    if (vdist[i] >= clipMinZ) continue;
                    int a = i;
                    int b = (a + 1) % 3;
                    int c = (a + 2) % 3;
                    Software3D.vAB[0] = vert[b][0] - vert[a][0];
                    Software3D.vAB[1] = vert[b][1] - vert[a][1];
                    Software3D.vAB[2] = vert[b][2] - vert[a][2];
                    Software3D.vAC[0] = vert[c][0] - vert[a][0];
                    Software3D.vAC[1] = vert[c][1] - vert[a][1];
                    Software3D.vAC[2] = vert[c][2] - vert[a][2];
                    VecMath.norm3d(vAB, vAB);
                    VecMath.norm3d(vAC, vAC);
                    int d_b = nearPlane.intersection(vert[a], vAB) + 65536;
                    int d_c = nearPlane.intersection(vert[a], vAC) + 65536;
                    Software3D.vAB[0] = vert[a][0] + (((vAB[0] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[0]) * (long)d_b >> 16)) : (int)((long)vAB[0] * (long)d_b >> 16));
                    Software3D.vAB[1] = vert[a][1] + (((vAB[1] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[1]) * (long)d_b >> 16)) : (int)((long)vAB[1] * (long)d_b >> 16));
                    Software3D.vAB[2] = vert[a][2] + (((vAB[2] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[2]) * (long)d_b >> 16)) : (int)((long)vAB[2] * (long)d_b >> 16));
                    Software3D.vAC[0] = vert[a][0] + (((vAC[0] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[0]) * (long)d_c >> 16)) : (int)((long)vAC[0] * (long)d_c >> 16));
                    Software3D.vAC[1] = vert[a][1] + (((vAC[1] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[1]) * (long)d_c >> 16)) : (int)((long)vAC[1] * (long)d_c >> 16));
                    Software3D.vAC[2] = vert[a][2] + (((vAC[2] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[2]) * (long)d_c >> 16)) : (int)((long)vAC[2] * (long)d_c >> 16));
                    Software3D.project(p[0], vAB);
                    Software3D.project(p[1], vert[b]);
                    Software3D.project(p[2], vert[c]);
                    Software3D.project(p[3], vAC);
                    return 4;
                }
            }
            case 2: {
                for (i = 0; i < 3; ++i) {
                    Software3D.vert[0][i] = v0[i];
                    Software3D.vert[1][i] = v1[i];
                    Software3D.vert[2][i] = v2[i];
                }
                for (i = 0; i < 3; ++i) {
                    if (vdist[i] < clipMinZ) continue;
                    int a = i;
                    int b = (a + 1) % 3;
                    int c = (a + 2) % 3;
                    Software3D.vAB[0] = vert[b][0] - vert[a][0];
                    Software3D.vAB[1] = vert[b][1] - vert[a][1];
                    Software3D.vAB[2] = vert[b][2] - vert[a][2];
                    Software3D.vAC[0] = vert[c][0] - vert[a][0];
                    Software3D.vAC[1] = vert[c][1] - vert[a][1];
                    Software3D.vAC[2] = vert[c][2] - vert[a][2];
                    VecMath.norm3d(vAB, vAB);
                    VecMath.norm3d(vAC, vAC);
                    int d_b = nearPlane.intersection(vert[a], vAB) - 65536;
                    int d_c = nearPlane.intersection(vert[a], vAC) - 65536;
                    Software3D.vert[b][0] = vert[a][0] + (((vAB[0] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[0]) * (long)d_b >> 16)) : (int)((long)vAB[0] * (long)d_b >> 16));
                    Software3D.vert[b][1] = vert[a][1] + (((vAB[1] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[1]) * (long)d_b >> 16)) : (int)((long)vAB[1] * (long)d_b >> 16));
                    Software3D.vert[b][2] = vert[a][2] + (((vAB[2] ^ d_b) & 0x8000000) != 0 ? -((int)((long)(-vAB[2]) * (long)d_b >> 16)) : (int)((long)vAB[2] * (long)d_b >> 16));
                    Software3D.vert[c][0] = vert[a][0] + (((vAC[0] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[0]) * (long)d_c >> 16)) : (int)((long)vAC[0] * (long)d_c >> 16));
                    Software3D.vert[c][1] = vert[a][1] + (((vAC[1] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[1]) * (long)d_c >> 16)) : (int)((long)vAC[1] * (long)d_c >> 16));
                    Software3D.vert[c][2] = vert[a][2] + (((vAC[2] ^ d_c) & 0x8000000) != 0 ? -((int)((long)(-vAC[2]) * (long)d_c >> 16)) : (int)((long)vAC[2] * (long)d_c >> 16));
                    Software3D.project(p[0], vert[a]);
                    Software3D.project(p[1], vert[b]);
                    Software3D.project(p[2], vert[c]);
                    return 3;
                }
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public static void drawScreenClippedLine(Graphics g, int x0, int y0, int x1, int y1) {
        if (x0 >= 0 && x0 < renderWidth && y0 >= 0 && y0 < renderHeight || x1 >= 0 && x1 < renderWidth && y1 >= 0 && y1 < renderHeight) {
            g.drawLine(x0, y0, x1, y1);
        }
    }

    public static void drawScreenClippedTri(Graphics g, int x0, int y0, int x1, int y1, int x2, int y2) {
        if (x0 >= 0 && x0 < renderWidth && y0 >= 0 && y0 < renderHeight || x1 >= 0 && x1 < renderWidth && y1 >= 0 && y1 < renderHeight || x2 >= 0 && x2 < renderWidth && y2 >= 0 && y2 < renderHeight) {
            GfxUtils.drawTriangle(g, x0, y0, x1, y1, x2, y2);
        }
    }

    public static void drawPoint3D(Graphics g, int[] pt, int fp_size) {
        int r;
        Software3D.project(p[0], pt);
        GfxUtils.drawPoint(g, p[0][0] < 0 ? -(-p[0][0] >> 16) : p[0][0] >> 16, p[0][1] < 0 ? -(-p[0][1] >> 16) : p[0][1] >> 16);
        int n = r = ((fp_size ^ 65536 - p[0][2]) & 0x8000000) != 0 ? -((int)((long)(-fp_size) * (long)(65536 - p[0][2]) >> 16)) : (int)((long)fp_size * (long)(65536 - p[0][2]) >> 16);
        r = r < 131072 ? 131072 : (r > 0x100000 ? 0x100000 : r);
        GfxUtils.drawCircle(g, p[0][0] < 0 ? -(-p[0][0] >> 16) : p[0][0] >> 16, p[0][1] < 0 ? -(-p[0][1] >> 16) : p[0][1] >> 16, r < 0 ? -(-r >> 16) : r >> 16, 12);
    }

    public static void drawLine3D(Graphics g, int[][] line_pts, int start, int end) {
        int db = 0;
        int n = end < start ? start : (end = end > line_pts.length ? line_pts.length : end);
        for (int i = start = start < 0 ? 0 : (start > end - 1 ? end - 1 : start); i < end; ++i) {
            Software3D.project(p[db], line_pts[i]);
            Software3D.near_dist[db] = nearPlane.getDistFromPlane(line_pts[i]);
            if (i > start && near_dist[db] > clipMinZ && near_dist[1 - db] > clipMinZ) {
                g.drawLine(p[db][0] < 0 ? -(-p[db][0] >> 16) : p[db][0] >> 16, p[db][1] < 0 ? -(-p[db][1] >> 16) : p[db][1] >> 16, p[1 - db][0] < 0 ? -(-p[1 - db][0] >> 16) : p[1 - db][0] >> 16, p[1 - db][1] < 0 ? -(-p[1 - db][1] >> 16) : p[1 - db][1] >> 16);
                g.drawLine((p[db][0] < 0 ? -(-p[db][0] >> 16) : p[db][0] >> 16) + 1, p[db][1] < 0 ? -(-p[db][1] >> 16) : p[db][1] >> 16, (p[1 - db][0] < 0 ? -(-p[1 - db][0] >> 16) : p[1 - db][0] >> 16) + 1, p[1 - db][1] < 0 ? -(-p[1 - db][1] >> 16) : p[1 - db][1] >> 16);
            }
            Software3D.p[1 - db][0] = p[db][0];
            Software3D.p[1 - db][1] = p[db][1];
            Software3D.near_dist[1 - db] = near_dist[db];
            db = 1 - db;
        }
    }

    public static void drawIndexedLine3D(Graphics g, int[][] line_pts, short[] line_idx) {
        for (int i = 1; i < line_idx.length; ++i) {
            if (Software3D.clipProjectLine(p, line_pts[line_idx[i - 1]], line_pts[line_idx[i]]) != 2) continue;
            Software3D.drawScreenClippedLine(g, p[0][0] < 0 ? -(-p[0][0] >> 16) : p[0][0] >> 16, p[0][1] < 0 ? -(-p[0][1] >> 16) : p[0][1] >> 16, p[1][0] < 0 ? -(-p[1][0] >> 16) : p[1][0] >> 16, p[1][1] < 0 ? -(-p[1][1] >> 16) : p[1][1] >> 16);
            Software3D.drawScreenClippedLine(g, (p[0][0] < 0 ? -(-p[0][0] >> 16) : p[0][0] >> 16) - 1, p[0][1] < 0 ? -(-p[0][1] >> 16) : p[0][1] >> 16, (p[1][0] < 0 ? -(-p[1][0] >> 16) : p[1][0] >> 16) - 1, p[1][1] < 0 ? -(-p[1][1] >> 16) : p[1][1] >> 16);
        }
    }

    public static void drawIndexedTri3D(Graphics g, int[][] line_pts, short[] line_idx) {
        for (int i = 0; i < line_idx.length; i += 3) {
            int b;
            int a;
            if (line_idx[i + 0] >= line_pts.length) {
                System.out.println("Assertion Failure: line_idx[i+0]<line_pts.length\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/Software3D.java[805]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (line_idx[i + 1] >= line_pts.length) {
                System.out.println("Assertion Failure: line_idx[i+1]<line_pts.length\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/Software3D.java[806]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (line_idx[i + 2] >= line_pts.length) {
                System.out.println("Assertion Failure: line_idx[i+2]<line_pts.length\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/lib\\gfx/Software3D.java[807]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int n = line_idx[i + 0] < 0 ? 0 : (a = line_idx[i + 0] > line_pts.length - 1 ? line_pts.length - 1 : line_idx[i + 0]);
            int n2 = line_idx[i + 1] < 0 ? 0 : (b = line_idx[i + 1] > line_pts.length - 1 ? line_pts.length - 1 : line_idx[i + 1]);
            int c = line_idx[i + 2] < 0 ? 0 : (line_idx[i + 2] > line_pts.length - 1 ? line_pts.length - 1 : line_idx[i + 2]);
            int verts = Software3D.clipProjectTriangle(line_pts[a], line_pts[b], line_pts[c]);
            if (verts < 3) continue;
            Software3D.drawScreenClippedTri(g, p[0][0] < 0 ? -(-p[0][0] >> 16) : p[0][0] >> 16, p[0][1] < 0 ? -(-p[0][1] >> 16) : p[0][1] >> 16, p[1][0] < 0 ? -(-p[1][0] >> 16) : p[1][0] >> 16, p[1][1] < 0 ? -(-p[1][1] >> 16) : p[1][1] >> 16, p[2][0] < 0 ? -(-p[2][0] >> 16) : p[2][0] >> 16, p[2][1] < 0 ? -(-p[2][1] >> 16) : p[2][1] >> 16);
            if (verts != 4) continue;
            Software3D.drawScreenClippedTri(g, p[3][0] < 0 ? -(-p[3][0] >> 16) : p[3][0] >> 16, p[3][1] < 0 ? -(-p[3][1] >> 16) : p[3][1] >> 16, p[1][0] < 0 ? -(-p[1][0] >> 16) : p[1][0] >> 16, p[1][1] < 0 ? -(-p[1][1] >> 16) : p[1][1] >> 16, p[2][0] < 0 ? -(-p[2][0] >> 16) : p[2][0] >> 16, p[2][1] < 0 ? -(-p[2][1] >> 16) : p[2][1] >> 16);
        }
    }

    static {
        fp_viewport_x0 = 0;
        fp_viewport_y0 = 0;
        renderWidth = 240;
        renderHeight = 320;
        halfWidth = 120;
        halfHeight = 160;
        vAB = new int[3];
        vAC = new int[3];
        vNorm = new int[3];
        vR = new int[3];
        nearPlane = new Plane();
        nearPlaneWS = new Plane();
        nearFrom = new int[3];
        nearNormal = new int[3];
        mat33 = new int[3][3];
        temp3 = new int[3];
        dst = new int[16];
        tmp = new int[12];
        src = new int[16];
        localFrom = new int[4];
        localNormal = new int[4];
        temp_matView = new int[4][4];
        temp_matProj = new int[4][4];
        newup = new int[3];
        right = new int[3];
        view = new int[3];
        vdist = new int[3];
        vert = new int[3][3];
        p = new int[4][4];
        near_dist = new int[2];
    }

    public static class Plane {
        public int[] normal;
        public int offset;

        public void makePlane(int[] pt, int[] norm) {
            this.normal = norm;
            this.offset = (((pt[0] ^ norm[0]) & 0x8000000) != 0 ? -((int)((long)(-pt[0]) * (long)norm[0] >> 16)) : (int)((long)pt[0] * (long)norm[0] >> 16)) + (((pt[1] ^ norm[1]) & 0x8000000) != 0 ? -((int)((long)(-pt[1]) * (long)norm[1] >> 16)) : (int)((long)pt[1] * (long)norm[1] >> 16)) + (((pt[2] ^ norm[2]) & 0x8000000) != 0 ? -((int)((long)(-pt[2]) * (long)norm[2] >> 16)) : (int)((long)pt[2] * (long)norm[2] >> 16));
        }

        public int getDistFromPlane(int[] pt) {
            return (((this.normal[0] ^ pt[0]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[0]) * (long)pt[0] >> 16)) : (int)((long)this.normal[0] * (long)pt[0] >> 16)) + (((this.normal[1] ^ pt[1]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[1]) * (long)pt[1] >> 16)) : (int)((long)this.normal[1] * (long)pt[1] >> 16)) + (((this.normal[2] ^ pt[2]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[2]) * (long)pt[2] >> 16)) : (int)((long)this.normal[2] * (long)pt[2] >> 16)) - this.offset;
        }

        public int intersection(int[] pt, int[] dir) {
            int vd = (((this.normal[0] ^ dir[0]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[0]) * (long)dir[0] >> 16)) : (int)((long)this.normal[0] * (long)dir[0] >> 16)) + (((this.normal[1] ^ dir[1]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[1]) * (long)dir[1] >> 16)) : (int)((long)this.normal[1] * (long)dir[1] >> 16)) + (((this.normal[2] ^ dir[2]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[2]) * (long)dir[2] >> 16)) : (int)((long)this.normal[2] * (long)dir[2] >> 16));
            if ((vd < 0 ? -vd : vd) < 66) {
                return 0;
            }
            int v0 = -((((this.normal[0] ^ pt[0]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[0]) * (long)pt[0] >> 16)) : (int)((long)this.normal[0] * (long)pt[0] >> 16)) + (((this.normal[1] ^ pt[1]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[1]) * (long)pt[1] >> 16)) : (int)((long)this.normal[1] * (long)pt[1] >> 16)) + (((this.normal[2] ^ pt[2]) & 0x8000000) != 0 ? -((int)((long)(-this.normal[2]) * (long)pt[2] >> 16)) : (int)((long)this.normal[2] * (long)pt[2] >> 16)) - this.offset);
            return (int)(((long)v0 << 16) / (long)vd);
        }
    }
}

