/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.pizza.main;

import com.rocktasticgames.pizza.animated.AnimatedOrder;
import com.rocktasticgames.pizza.animated.CookItem;
import com.rocktasticgames.pizza.c2m.C2MValues;
import com.rocktasticgames.pizza.main.MainCanvas;
import com.rocktasticgames.pizza.sounds.MenuMusic;
import com.rocktasticgames.pizza.utils.BMPFont;
import com.rocktasticgames.pizza.utils.List;
import com.rocktasticgames.pizza.utils.Path;
import com.rocktasticgames.pizza.utils.SharedPreferences;
import com.rocktasticgames.pizza.views.KitchenView;
import com.rocktasticgames.pizza.views.LanguageView;
import com.rocktasticgames.pizza.views.MapView;
import com.rocktasticgames.pizza.views.MenuView;
import com.rocktasticgames.pizza.views.SoundView;
import com.rocktasticgames.pizza.views.SplashC2MView;
import com.rocktasticgames.pizza.views.SplashRocktasticView;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MainActivity
extends MIDlet
implements Runnable {
    public static final float DOOR_OFFSET = 0.3f;
    public static final int PIZZERIA_ROW = 4;
    public static final int PIZZERIA_COL = 2;
    public static final int PATH_SCALE = 25;
    public static final int MAX_LEVEL = 45;
    public static String[][] appitems;
    public static String[][] cookitems;
    public static String[][] cooknames;
    public static int[][] cookprices;
    public String[] apptitles;
    public static final String[] appcanv;
    public static final String[][] appimgs;
    public static final String[][] appups;
    public static final String[] delivery_pics;
    public static final String[] delivery_icons;
    public static final String[] deliveryups;
    private MenuView menu;
    private KitchenView kitchen;
    private MapView map;
    private SplashC2MView splashone;
    private SplashRocktasticView splashtwo;
    private SoundView soundview;
    private MenuMusic music;
    private int state;
    private List orders;
    private float[] delivery_x;
    private float[] delivery_y;
    private int[] delivery_state;
    private AnimatedOrder[][] delivery_items;
    private int delivery_upgrade;
    private long start_time;
    private long pause_time;
    private SharedPreferences shared_pref;
    private SharedPreferences.Editor pref_editor;
    private boolean paused = false;
    private int[] appslots;
    private int[] appupgrades;
    private CookItem[][] cooklist;
    private BMPFont brady;
    private BMPFont cartoon;
    private long refresh_time;
    private Path[] deliver_paths;
    private int level;
    private int money;
    private int points;
    private Image emptyorderbmp;
    private Image fullorderbmp;
    private float width;
    private float height;
    private float[] delivery_hspeed;
    private float[] delivery_vspeed;
    private long last_time = 0L;
    private MainCanvas canvas;
    private Thread thread;
    private long invalidate_time;
    private boolean started = false;
    private boolean isminimized = false;
    private LanguageView languageview;
    private int language = 0;
    public Image topbar;
    public Image pausebutton;
    public Image wood;
    public Image mapbutton;
    public Image kitchenbutton;
    public Image appboard;
    public Image appnext;
    public Image appprev;
    public Image appok;
    public Image apptrash;
    public Image appempty;
    public Image appready;

    protected void startApp() throws MIDletStateChangeException {
        if (!this.started) {
            this.started = true;
            this.init();
        } else if (this.isminimized) {
            this.isminimized = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void init() {
        this.invalidate_time = System.currentTimeMillis();
        this.thread = new Thread(this);
        Display display = Display.getDisplay((MIDlet)this);
        this.canvas = new MainCanvas(this);
        display.setCurrent((Displayable)this.canvas);
        this.canvas.setFullScreenMode(true);
        this.shared_pref = new SharedPreferences();
        this.pref_editor = this.shared_pref.edit();
        this.splashone = new SplashC2MView(this);
        this.state = 6;
        this.thread.start();
    }

    public void splashTaskOne() {
        this.brady = new BMPFont("brady", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ:/+-x$'!.?()c@,\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00a1\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00dc");
        try {
            this.emptyorderbmp = Image.createImage((String)"/portrait_pizzaslot_empty.png");
            this.fullorderbmp = Image.createImage((String)"/portrait_pizzaslot_full.png");
            this.appempty = Image.createImage((String)("/" + this.getLanguageCode() + "empty.png"));
            this.appready = Image.createImage((String)("/" + this.getLanguageCode() + "ready.png"));
            this.appboard = Image.createImage((String)("/" + appcanv[3] + ".png"));
            this.appnext = Image.createImage((String)"/rightarrow.png");
            this.appprev = Image.createImage((String)"/leftarrow.png");
            this.appok = Image.createImage((String)"/button_ok.png");
            this.apptrash = Image.createImage((String)"/button_trash.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void splashTaskTwo() {
        this.cartoon = new BMPFont("cartoon", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ,$\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00dc");
        this.start_time = System.currentTimeMillis();
    }

    public void onSplashOneComplete() {
        this.splashone.destroy();
        this.splashtwo = new SplashRocktasticView(this);
        this.state = 7;
    }

    public void onSplashTwoComplete() {
        this.splashtwo.destroy();
        this.state = 9;
        this.languageview = new LanguageView(this);
    }

    public void onLanguageComplete() {
        this.languageview.destroy();
        this.soundview = new SoundView(this);
        this.state = 8;
        this.language = this.getSharedPref().getInt("language", 0);
        this.loadAll();
    }

    public void onSoundComplete() {
        this.soundview.destroy();
        this.state = 1;
        this.music = new MenuMusic(this, 50, 50);
        this.music.startMusic();
        this.openMainMenu();
    }

    public SplashC2MView getSplashOne() {
        return this.splashone;
    }

    public SplashRocktasticView getSplashTwo() {
        return this.splashtwo;
    }

    public SoundView getSoundView() {
        return this.soundview;
    }

    public LanguageView getLanguageView() {
        return this.languageview;
    }

    public void resetAll() {
        int n;
        for (n = 0; n < 5; ++n) {
            this.getPrefEditor().putInt("app_page" + n, 0);
        }
        for (n = 1; n < 5; ++n) {
            this.getPrefEditor().putBoolean("upgrade_shown_A" + n + "_U1", false);
            this.getPrefEditor().putBoolean("upgrade_shown_A" + n + "_U2", false);
            this.getPrefEditor().putBoolean("upgrade_shown_A" + n + "_S2", false);
            this.getPrefEditor().putBoolean("upgrade_shown_A" + n + "_S3", false);
            this.getPrefEditor().putBoolean("upgrade_shown_D_U" + n, false);
            this.getPrefEditor().putInt("index_shown_A" + n, 4);
        }
        for (n = 1; n <= 20; ++n) {
            this.getPrefEditor().putBoolean("msg_" + n, false);
        }
        this.getPrefEditor().putBoolean("upgrade_shown_A1_S4", false);
        this.getPrefEditor().putBoolean("upgrade_shown_A1_S5", false);
        this.getPrefEditor().putBoolean("upgrade_shown_A1_S6", false);
        this.getPrefEditor().putBoolean("salad_shown", false);
        this.getPrefEditor().putBoolean("dessert_shown", false);
        this.getPrefEditor().putLong("elapsed", 0L);
        this.getPrefEditor().putInt("orders", 0);
        this.getPrefEditor().putLong("order_time", 0L);
        this.getPrefEditor().putInt("level", 1);
        this.getPrefEditor().putInt("money", 0);
        this.getPrefEditor().putInt("points", 0);
        this.getPrefEditor().putInt("upgrade_oven", 0);
        this.getPrefEditor().putInt("upgrade_dessert", 0);
        this.getPrefEditor().putInt("upgrade_drink", 0);
        this.getPrefEditor().putInt("upgrade_salad", 0);
        this.getPrefEditor().putInt("slots_oven", 1);
        this.getPrefEditor().putInt("slots_dessert", 0);
        this.getPrefEditor().putInt("slots_drink", 1);
        this.getPrefEditor().putInt("slots_salad", 0);
        this.getPrefEditor().putInt("delivery_upgrade", 0);
        this.getPrefEditor().putInt("delivery_shown", 1);
        this.getPrefEditor().putBoolean("victory_shown", false);
        this.getPrefEditor().commit();
        this.loadAll();
    }

    public void loadAll() {
        int n;
        this.level = this.shared_pref.getInt("level", 1);
        this.money = this.shared_pref.getInt("money", 0);
        this.points = this.shared_pref.getInt("points", 0);
        this.orders = new List();
        this.delivery_hspeed = new float[5];
        this.delivery_vspeed = new float[5];
        appitems = new String[5][];
        cookitems = new String[5][];
        cooknames = new String[5][];
        cookprices = new int[5][];
        this.pref_editor.putLong("order_time", this.getTime() + 3000L);
        this.pause();
        this.appupgrades = new int[]{this.shared_pref.getInt("upgrade_oven", 0), this.shared_pref.getInt("upgrade_oven", 0), this.shared_pref.getInt("upgrade_drink", 0), this.shared_pref.getInt("upgrade_salad", 0), this.shared_pref.getInt("upgrade_dessert", 0)};
        this.cooklist = new CookItem[5][];
        for (n = 0; n < this.cooklist.length; ++n) {
            this.cooklist[n] = new CookItem[3];
        }
        this.delivery_state = new int[]{0, -1, -1, -1, -1};
        this.setAvailableSlots();
        this.delivery_upgrade = this.shared_pref.getInt("delivery_upgrade", 0);
        this.delivery_x = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 2.0f};
        this.delivery_y = new float[]{3.7f, 3.7f, 3.7f, 3.7f, 3.7f};
        this.delivery_items = new AnimatedOrder[5][2];
        this.deliver_paths = new Path[5];
        for (n = 0; n < this.deliver_paths.length; ++n) {
            this.deliver_paths[n] = new Path();
        }
        this.apptitles = new String[]{this.getLanguageCode() + "menutitle_pizzaoven", this.getLanguageCode() + "menutitle_pizzaoven", this.getLanguageCode() + "menutitle_beveragestation", this.getLanguageCode() + "menutitle_saladbar", this.getLanguageCode() + "menutitle_desserttable"};
        this.refresh_time = this.getTime();
    }

    public void run() {
        while (this.state != 5) {
            try {
                while (true) {
                    if (this.isminimized) {
                        return;
                    }
                    long l = this.invalidate_time - System.currentTimeMillis();
                    if (l > 30L) {
                        Thread.sleep(Math.min(50L, l));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.invalidate_time = System.currentTimeMillis() + 100L;
            if (this.state == 5) break;
            this.canvas.repaint();
            if (!this.canvas.isShown()) {
                this.pause();
                if (this.music == null) continue;
                this.music.stopMusic();
                continue;
            }
            if (this.music == null) continue;
            this.music.startMusic();
        }
        this.notifyDestroyed();
    }

    public void invalidate() {
        this.invalidate_time = System.currentTimeMillis();
    }

    public void postInvalidateDelayed(long l) {
        this.invalidate_time = System.currentTimeMillis() + l;
    }

    public MainCanvas getCanvas() {
        return this.canvas;
    }

    public int getState() {
        return this.state;
    }

    public int getLanguage() {
        return this.language;
    }

    public String getBMGLang() {
        switch (this.getLanguage()) {
            default: {
                return "en-GB";
            }
            case 1: {
                return "fr-FR";
            }
            case 2: {
                return "de-DE";
            }
            case 3: {
                return "pt-PT";
            }
            case 4: 
        }
        return "es-ES";
    }

    public String getLanguageCode() {
        switch (this.getLanguage()) {
            default: {
                return "";
            }
            case 1: {
                return "fr/";
            }
            case 2: {
                return "de/";
            }
            case 3: {
                return "pt/";
            }
            case 4: 
        }
        return "es/";
    }

    private void setAvailableSlots() {
        int n;
        for (n = 0; n < 5; ++n) {
            MainActivity.appitems[n] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][Math.max(0, n - 1)]];
            MainActivity.cookitems[n] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][Math.max(0, n - 1)]];
            MainActivity.cooknames[n] = new String[C2MValues.ITEMS_PER_LEVEL[this.level][Math.max(0, n - 1)]];
            MainActivity.cookprices[n] = new int[C2MValues.ITEMS_PER_LEVEL[this.level][Math.max(0, n - 1)]];
            for (int i = 0; i < C2MValues.ITEMS_PER_LEVEL[this.level][Math.max(0, n - 1)]; ++i) {
                MainActivity.appitems[n][i] = C2MValues.ITEM_NAMES[0][Math.max(0, n - 1)][i].replace('/', ' ') + "_slice";
                MainActivity.cookitems[n][i] = C2MValues.ITEM_NAMES[0][Math.max(0, n - 1)][i].replace('/', ' ');
                for (int j = 0; j < cookitems[n][i].length(); ++j) {
                    if (cookitems[n][i].charAt(j) != ' ') continue;
                    MainActivity.cookitems[n][i] = cookitems[n][i].substring(0, j) + cookitems[n][i].substring(j + 1);
                    MainActivity.appitems[n][i] = appitems[n][i].substring(0, j) + appitems[n][i].substring(j + 1);
                    --j;
                }
                MainActivity.cooknames[n][i] = C2MValues.ITEM_NAMES[this.getLanguage()][Math.max(0, n - 1)][i];
                MainActivity.cookprices[n][i] = (int)((float)C2MValues.ITEM_PRICES[Math.max(0, n - 1) * 2] * (float)(25 - i) / 25.0f + (float)C2MValues.ITEM_PRICES[Math.max(0, n - 1) * 2 + 1] * (float)i / 25.0f + 0.9f);
            }
        }
        for (n = 1; n < this.delivery_state.length; ++n) {
            if (this.delivery_state[n] != -1 || this.level < C2MValues.DELIVERY_SLOTS[n - 1]) continue;
            this.delivery_state[n] = 0;
        }
        this.appslots = new int[]{Math.min(3, this.shared_pref.getInt("slots_oven", 1)), Math.max(0, this.shared_pref.getInt("slots_oven", 1) - 3), this.shared_pref.getInt("slots_drink", 1), Math.max(Math.min(1, C2MValues.ITEMS_PER_ORDER_BY_LEVEL[this.level][5]), this.shared_pref.getInt("slots_salad", 0)), Math.max(Math.min(1, C2MValues.ITEMS_PER_ORDER_BY_LEVEL[this.level][7]), this.shared_pref.getInt("slots_dessert", 0))};
        for (n = 0; n < 5; ++n) {
            this.delivery_hspeed[n] = 9.737f * (float)C2MValues.DELIVERY_SPEED_PERCENT_BY_LEVEL[this.level] / (float)(C2MValues.AVERAGE_DELIVERY_TIME_BY_UPGRADE[n] * 100000);
            this.delivery_vspeed[n] = this.delivery_hspeed[n] * 0.7f;
        }
    }

    public void addApplianceSlot(int n) {
        int n2;
        n = Math.max(0, n - 1);
        int n3 = this.appslots[n + 1];
        if (n == 0) {
            n3 += this.appslots[0];
        }
        boolean bl = false;
        switch (n) {
            default: {
                n2 = C2MValues.PIZZA_SLOTS[n3 * 2 - 1];
                if (this.money <= n2) break;
                this.pref_editor.putInt("slots_oven", n3 + 1);
                bl = true;
                break;
            }
            case 1: {
                n2 = C2MValues.BEVERAGE_SLOTS[n3 * 2 - 1];
                if (this.money <= n2) break;
                this.pref_editor.putInt("slots_drink", n3 + 1);
                bl = true;
                break;
            }
            case 2: {
                n2 = C2MValues.SALAD_SLOTS[n3 * 2 - 1];
                if (this.money <= n2) break;
                this.pref_editor.putInt("slots_salad", n3 + 1);
                bl = true;
                break;
            }
            case 3: {
                n2 = C2MValues.DESSERT_SLOTS[n3 * 2 - 1];
                if (this.money <= n2) break;
                this.pref_editor.putInt("slots_dessert", n3 + 1);
                bl = true;
            }
        }
        if (bl) {
            this.chargeMoney(n2);
            this.pref_editor.commit();
            for (int i = 0; i < n3 % 3; ++i) {
                if (this.cooklist[0][i] == null) continue;
                if (n == 0 && n3 < 3) {
                    this.cooklist[0][i].setX((768.0f + 258.0f * (float)i - (float)n3 * 129.0f) / 1536.0f);
                    continue;
                }
                this.cooklist[n + 1][i].setX((768.0f + 258.0f * (float)i - (float)(n3 % 3) * 129.0f) / 1536.0f);
            }
            this.setAvailableSlots();
        }
    }

    public void upgradeAppliance(int n) {
        int n2 = C2MValues.APPLIANCE_UPGRADES[(n = Math.max(0, n - 1)) * 4 + this.appupgrades[n + 1] * 2 + 1];
        if (this.money > n2) {
            this.chargeMoney(n2);
            switch (n) {
                default: {
                    this.appupgrades[0] = this.appupgrades[0] + 1;
                    int n3 = n + 1;
                    this.appupgrades[n3] = this.appupgrades[n3] + 1;
                    this.pref_editor.putInt("upgrade_oven", this.appupgrades[n + 1]);
                    this.kitchen.updateAppImage(0);
                    if (this.appslots[1] <= 0) break;
                    this.kitchen.updateAppImage(1);
                    break;
                }
                case 1: {
                    int n4 = n + 1;
                    this.appupgrades[n4] = this.appupgrades[n4] + 1;
                    this.pref_editor.putInt("upgrade_drink", this.appupgrades[n + 1]);
                    this.kitchen.updateAppImage(2);
                    break;
                }
                case 2: {
                    int n5 = n + 1;
                    this.appupgrades[n5] = this.appupgrades[n5] + 1;
                    this.pref_editor.putInt("upgrade_salad", this.appupgrades[n + 1]);
                    this.kitchen.updateAppImage(3);
                    break;
                }
                case 3: {
                    int n6 = n + 1;
                    this.appupgrades[n6] = this.appupgrades[n6] + 1;
                    this.pref_editor.putInt("upgrade_dessert", this.appupgrades[n + 1]);
                    this.kitchen.updateAppImage(4);
                }
            }
            this.pref_editor.commit();
        }
    }

    public void upgradeDelivery() {
        int n = C2MValues.DELIVERY_UPGRADES[this.delivery_upgrade * 2 + 1];
        if (this.money > n) {
            this.chargeMoney(n);
            ++this.delivery_upgrade;
            this.pref_editor.putInt("delivery_upgrade", this.delivery_upgrade);
            this.pref_editor.commit();
        }
    }

    public int getDeliveryUpgrade() {
        return this.delivery_upgrade;
    }

    public int getApplianceUpgrade(int n) {
        return this.appupgrades[n];
    }

    public void registerDimensions(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public Image getEmptyOrder() {
        return this.emptyorderbmp;
    }

    public Image getFullOrder() {
        return this.fullorderbmp;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMoney() {
        return this.money;
    }

    public int getPoints() {
        return this.points;
    }

    public void addMoney(int n) {
        this.money += n;
        this.pref_editor.putInt("money", this.money);
        this.pref_editor.commit();
    }

    public void chargeMoney(int n) {
        this.money -= n;
        this.pref_editor.putInt("money", this.money);
        this.pref_editor.commit();
    }

    public void addPoints(int n) {
        this.points += n;
        if (this.level < 45) {
            if (this.points >= C2MValues.REPUTATION_TO_REACH_LEVEL[this.level + 1]) {
                ++this.level;
                this.pref_editor.putInt("level", this.level);
                this.setAvailableSlots();
                if (this.state == 3) {
                    this.kitchen.onLevelUp();
                } else if (this.state == 4) {
                    this.map.onLevelUp();
                }
                this.playSound("level_up");
            } else {
                this.playSound("delivered_order");
            }
        } else if (this.points >= 1250 && !this.shared_pref.getBoolean("victory_shown", false)) {
            this.pref_editor.putBoolean("victory_shown", true);
            this.pref_editor.commit();
            if (this.state == 3) {
                this.kitchen.onVictory();
            } else if (this.state == 4) {
                this.map.onVictory();
            }
            this.music.playVictory();
        } else {
            this.playSound("delivered_order");
        }
        this.pref_editor.putInt("points", this.points);
        this.pref_editor.commit();
    }

    public void subtractPoints(int n) {
        this.points = Math.max(this.points - n, C2MValues.REPUTATION_TO_REACH_LEVEL[this.level]);
        this.pref_editor.putInt("points", this.points);
        this.pref_editor.commit();
    }

    public void swapDeliveryOrder(int n) {
        AnimatedOrder animatedOrder = this.delivery_items[n][0];
        this.delivery_items[n][0] = this.delivery_items[n][1];
        this.delivery_items[n][1] = animatedOrder;
    }

    public int getDeliveryState(int n) {
        return this.delivery_state[n];
    }

    public AnimatedOrder getDeliveryItem(int n, int n2) {
        return this.delivery_items[n][n2];
    }

    public void addToDelivery(int n, AnimatedOrder animatedOrder, long l) {
        if (this.orders.size() == C2MValues.MAX_ORDERS_BY_LEVEL[this.level]) {
            this.pref_editor.putLong("order_time", l + (long)(C2MValues.TIME_BETWEEN_ORDERS[this.level] * 1000));
            this.pref_editor.commit();
        }
        if (this.delivery_items[n][0] == null && this.delivery_state[n] != -1) {
            AnimatedOrder animatedOrder2 = animatedOrder;
            this.delivery_items[n][1] = animatedOrder2;
            this.delivery_items[n][0] = animatedOrder2;
            if (this.delivery_upgrade >= 1) {
                this.delivery_state[n] = 1;
                return;
            }
        } else if (this.delivery_items[n][1] == this.delivery_items[n][0] && this.delivery_upgrade >= 1) {
            this.delivery_items[n][1] = animatedOrder;
        }
        this.delivery_state[n] = 2;
    }

    public int getDeliverers() {
        int n = 0;
        for (int i = 0; i < this.delivery_state.length; ++i) {
            if (this.delivery_state[i] == -1) continue;
            ++n;
        }
        return n;
    }

    public void addOrder(long l) {
        float f = 0.9238281f * (1.0f - (this.height / this.width - 1.3333334f) * 9.0f / 4.0f) + 0.91175395f * (this.height / this.width - 1.3333334f) * 9.0f / 4.0f;
        AnimatedOrder animatedOrder = new AnimatedOrder(this, null, null, (float)this.getOrders().size() * 0.2f + 0.1f, f - 0.2233073f * this.width / this.height, this.width, this.height, l, C2MValues.TIME_FOR_ORDER[this.level] * 1000, this.level);
        this.getOrders().add(animatedOrder);
        this.playSound("order_coming_in");
        this.pref_editor.putInt("orders", this.getSharedPref().getInt("orders", 0) + 1);
        this.pref_editor.putLong("order_time", l + (long)(C2MValues.TIME_BETWEEN_ORDERS[this.level] * 1000));
        this.pref_editor.commit();
        if (this.state == 3) {
            this.kitchen.registerOrder(animatedOrder);
        }
        this.checkMessage(1);
    }

    public void sendOut(int n) {
        if (this.delivery_state[n] == 0) {
            return;
        }
        this.delivery_state[n] = 3;
        if (n == 1) {
            this.playSound("delivery_confirmation_female");
        } else {
            this.playSound("delivery_confirmation_male");
        }
        this.checkMessage(13);
    }

    public float getDeliveryX(int n) {
        return this.delivery_x[n];
    }

    public float getDeliveryY(int n) {
        return this.delivery_y[n];
    }

    public int getDeliverySlots() {
        if (this.delivery_upgrade >= 1) {
            return 2;
        }
        return 1;
    }

    public Path getPath(int n) {
        return this.deliver_paths[n];
    }

    private void setPath(int n, int n2) {
        if (this.state != 4) {
            return;
        }
        this.deliver_paths[n].reset();
        if (n2 == 15) {
            return;
        }
        this.deliver_paths[n].moveTo(25.0f * this.delivery_x[n], 25.0f * this.delivery_y[n]);
        if (n2 < 1) {
            this.deliver_paths[n].lineTo(25.0f * this.delivery_x[n], 100.0f);
        }
        if (this.delivery_x[n] + 0.49999f > (float)this.delivery_items[n][0].getColumn()) {
            if (n2 < 2) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() + 0.5f), 100.0f);
            }
            if (n2 < 3) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() + 0.5f), 25 * this.delivery_items[n][0].getRow());
            }
        } else {
            if (n2 < 2) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() - 0.5f), 100.0f);
            }
            if (n2 < 3) {
                this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][0].getColumn() - 0.5f), 25 * this.delivery_items[n][0].getRow());
            }
        }
        if (n2 < 4) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25 * this.delivery_items[n][0].getRow());
        }
        if (n2 < 5) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25.0f * ((float)this.delivery_items[n][0].getRow() - 0.3f));
        }
        if (this.delivery_items[n][1] != this.delivery_items[n][0]) {
            if (n2 < 6) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][0].getColumn(), 25 * this.delivery_items[n][0].getRow());
            }
            if ((float)this.delivery_items[n][0].getColumn() + 0.49999f > (float)this.delivery_items[n][1].getColumn()) {
                if (n2 < 7) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() + 0.5f), 25 * this.delivery_items[n][0].getRow());
                }
                if (n2 < 8) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() + 0.5f), 25 * this.delivery_items[n][1].getRow());
                }
            } else {
                if (n2 < 7) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() - 0.5f), 25 * this.delivery_items[n][0].getRow());
                }
                if (n2 < 8) {
                    this.deliver_paths[n].lineTo(25.0f * ((float)this.delivery_items[n][1].getColumn() - 0.5f), 25 * this.delivery_items[n][1].getRow());
                }
            }
            if (n2 < 9) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 10) {
                this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25.0f * ((float)this.delivery_items[n][1].getRow() - 0.3f));
            }
        }
        if (n2 < 11) {
            this.deliver_paths[n].lineTo(25 * this.delivery_items[n][1].getColumn(), 25 * this.delivery_items[n][1].getRow());
        }
        if ((float)this.delivery_items[n][1].getColumn() + 0.49999f > 2.0f) {
            if (n2 < 12) {
                this.deliver_paths[n].lineTo(62.5f, 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 13) {
                this.deliver_paths[n].lineTo(62.5f, 100.0f);
            }
        } else {
            if (n2 < 12) {
                this.deliver_paths[n].lineTo(37.5f, 25 * this.delivery_items[n][1].getRow());
            }
            if (n2 < 13) {
                this.deliver_paths[n].lineTo(37.5f, 100.0f);
            }
        }
        if (n2 < 14) {
            this.deliver_paths[n].lineTo(50.0f, 100.0f);
        }
        if (n2 < 15) {
            this.deliver_paths[n].lineTo(50.0f, 92.5f);
        }
    }

    public boolean checkMessage(int n) {
        if (this.state == 3) {
            return this.kitchen.checkMessage(n);
        }
        if (this.state == 4) {
            return this.map.checkMessage(n);
        }
        return false;
    }

    public void refresh(long l) {
        int n;
        int n2;
        if (l > this.shared_pref.getLong("order_time", 0L) && this.orders.size() < C2MValues.MAX_ORDERS_BY_LEVEL[this.level]) {
            this.addOrder(l);
        }
        for (n2 = 0; n2 < this.cooklist.length; ++n2) {
            for (n = 0; n < this.appslots[n2]; ++n) {
                if (this.cooklist[n2][n] == null) continue;
                if (this.cooklist[n2][n].fetchReadySignal(l)) {
                    this.playSound("food_ready");
                    if (this.state == 3 && this.kitchen.getAppliance(n2) != this.kitchen.getSelectedAppliance()) {
                        this.kitchen.getAppliance(n2).signalDone(l);
                        this.invalidate();
                    }
                    if (n2 == 0) {
                        this.checkMessage(5);
                        continue;
                    }
                    if (n2 != 2) continue;
                    this.checkMessage(8);
                    continue;
                }
                if (!this.cooklist[n2][n].fetchWarnSignal(l)) continue;
                this.playSound("food_spoil_warning");
                if (this.state == 3 && this.kitchen.getAppliance(n2) != this.kitchen.getSelectedAppliance()) {
                    this.kitchen.getAppliance(n2).signalWarn(l);
                    this.invalidate();
                }
                if (n2 == 0) {
                    this.checkMessage(16);
                    continue;
                }
                if (n2 != 2) continue;
                this.checkMessage(17);
            }
        }
        for (n2 = 0; n2 < this.delivery_state.length; ++n2) {
            if (this.delivery_items[n2][1] == null && this.delivery_items[n2][0] != null) {
                this.delivery_items[n2][1] = this.delivery_items[n2][0];
            }
            block9: for (n = 0; n < 2; ++n) {
                if (this.delivery_items[n2][n] == null || !this.delivery_items[n2][n].checkFailed(l)) continue;
                switch (this.delivery_state[n2]) {
                    case 1: {
                        this.delivery_items[n2][n] = null;
                        this.delivery_state[n2] = 0;
                        continue block9;
                    }
                    case 2: {
                        if (this.delivery_items[n2][0] == this.delivery_items[n2][1]) {
                            this.delivery_items[n2][1] = null;
                            this.delivery_items[n2][0] = null;
                            this.delivery_state[n2] = 0;
                            continue block9;
                        }
                        if (n == 0) {
                            this.delivery_items[n2][0] = this.delivery_items[n2][1];
                        }
                        this.delivery_items[n2][1] = this.delivery_items[n2][0];
                        this.delivery_state[n2] = 1;
                        continue block9;
                    }
                    case 3: {
                        if (this.delivery_items[n2][0] == this.delivery_items[n2][1]) {
                            this.delivery_state[n2] = 5;
                            continue block9;
                        }
                        this.delivery_items[n2][n] = this.delivery_items[n2][1 - n];
                        continue block9;
                    }
                    case 4: {
                        this.delivery_items[n2][1] = this.delivery_items[n2][0];
                        this.delivery_state[n2] = 5;
                    }
                }
            }
            if (this.delivery_state[n2] == 3) {
                if (this.delivery_x[n2] == 2.0f && this.delivery_y[n2] < 4.0f && this.delivery_y[n2] > 3.0f) {
                    this.delivery_y[n2] = this.min(4.0f, this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 0);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][0].getRow() && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn() + 0.5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn() - 0.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > (float)this.delivery_items[n2][0].getColumn() ? (this.delivery_x[n2] - 0.5f < (float)this.delivery_items[n2][0].getColumn() ? this.min((float)this.delivery_items[n2][0].getColumn() + 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max((float)this.delivery_items[n2][0].getColumn() + 0.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min((float)this.delivery_items[n2][0].getColumn() - 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 1);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][0].getRow() && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < (float)this.delivery_items[n2][0].getRow() ? this.min(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 2);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][0].getColumn()) {
                    this.delivery_x[n2] = this.delivery_x[n2] < (float)this.delivery_items[n2][0].getColumn() ? this.min(this.delivery_items[n2][0].getColumn(), this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][0].getColumn(), this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 3);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.3f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max((float)this.delivery_items[n2][0].getRow() - 0.3f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 4);
                    continue;
                }
                if (this.delivery_items[n2][1] != this.delivery_items[n2][0]) {
                    this.delivery_items[n2][0].deliver();
                    this.delivery_state[n2] = 4;
                    this.setPath(n2, 5);
                    continue;
                }
                this.delivery_items[n2][0].deliver();
                this.delivery_state[n2] = 5;
                this.setPath(n2, 10);
                continue;
            }
            if (this.delivery_state[n2] == 4) {
                if (this.delivery_x[n2] == (float)this.delivery_items[n2][0].getColumn() && this.delivery_y[n2] < (float)this.delivery_items[n2][0].getRow() && this.delivery_y[n2] > (float)(this.delivery_items[n2][0].getRow() - 1)) {
                    this.delivery_y[n2] = this.min(this.delivery_items[n2][0].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 5);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][1].getRow() && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn() + 0.5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn() - 0.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > (float)this.delivery_items[n2][1].getColumn() ? (this.delivery_x[n2] - 0.5f < (float)this.delivery_items[n2][1].getColumn() ? this.min((float)this.delivery_items[n2][1].getColumn() + 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max((float)this.delivery_items[n2][1].getColumn() + 0.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min((float)this.delivery_items[n2][1].getColumn() - 0.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 6);
                    continue;
                }
                if (this.delivery_y[n2] != (float)this.delivery_items[n2][1].getRow() && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < (float)this.delivery_items[n2][1].getRow() ? this.min(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 7);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != (float)this.delivery_items[n2][1].getColumn()) {
                    this.delivery_x[n2] = this.delivery_x[n2] < (float)this.delivery_items[n2][1].getColumn() ? this.min(this.delivery_items[n2][1].getColumn(), this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(this.delivery_items[n2][1].getColumn(), this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 8);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.3f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max((float)this.delivery_items[n2][1].getRow() - 0.3f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 9);
                    continue;
                }
                this.delivery_items[n2][1].deliver();
                this.delivery_state[n2] = 5;
                this.setPath(n2, 10);
                continue;
            }
            if (this.delivery_state[n2] == 5) {
                if (this.delivery_x[n2] == (float)this.delivery_items[n2][1].getColumn() && this.delivery_y[n2] < (float)this.delivery_items[n2][1].getRow() && this.delivery_y[n2] > (float)(this.delivery_items[n2][1].getRow() - 1)) {
                    this.delivery_y[n2] = this.min(this.delivery_items[n2][1].getRow(), this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 10);
                    continue;
                }
                if (this.delivery_y[n2] != 4.0f && (this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != 2.5f && this.delivery_x[n2] != 1.5f) {
                    this.delivery_x[n2] = this.delivery_x[n2] + 0.49999f > 2.0f ? (this.delivery_x[n2] - 0.5f < 2.0f ? this.min(2.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(2.5f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time))) : this.min(1.5f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 11);
                    continue;
                }
                if (this.delivery_y[n2] != 4.0f && (this.delivery_x[n2] + 0.500001f) % 1.0f < 1.0E-5f) {
                    this.delivery_y[n2] = this.delivery_y[n2] < 4.0f ? this.min(4.0f, this.delivery_y[n2] + this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(4.0f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 12);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f) % 1.0f < 1.0E-5f && this.delivery_x[n2] != 2.0f) {
                    this.delivery_x[n2] = this.delivery_x[n2] < 2.0f ? this.min(2.0f, this.delivery_x[n2] + this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time)) : this.max(2.0f, this.delivery_x[n2] - this.delivery_hspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 13);
                    continue;
                }
                if ((this.delivery_y[n2] + 1.000001f + 0.3f) % 1.0f >= 1.0E-5f) {
                    this.delivery_y[n2] = this.max(3.7f, this.delivery_y[n2] - this.delivery_vspeed[this.delivery_upgrade] * (float)(l - this.refresh_time));
                    this.setPath(n2, 14);
                    continue;
                }
                this.delivery_state[n2] = 0;
                this.delivery_items[n2][0] = null;
                this.delivery_items[n2][1] = null;
                this.setPath(n2, 15);
                continue;
            }
            if (this.delivery_state[n2] == -1) continue;
            this.setPath(n2, 15);
        }
        this.refresh_time = l;
    }

    private float min(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        return f;
    }

    private float max(float f, float f2) {
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public KitchenView getKitchen() {
        return this.kitchen;
    }

    public MapView getMap() {
        return this.map;
    }

    public MenuView getMenu() {
        return this.menu;
    }

    public BMPFont getBrady() {
        return this.brady;
    }

    public BMPFont getCartoon() {
        return this.cartoon;
    }

    public BMPFont getKomika() {
        return this.brady;
    }

    public SharedPreferences.Editor getPrefEditor() {
        return this.pref_editor;
    }

    public SharedPreferences getSharedPref() {
        return this.shared_pref;
    }

    public CookItem[] getCooking(int n) {
        return this.cooklist[n];
    }

    public int getAppSlots(int n) {
        return this.appslots[n];
    }

    public int getAppUpgrade(int n) {
        return this.appupgrades[n];
    }

    public void togglePause() {
        if (this.paused) {
            this.resume();
        } else {
            this.pause();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.pause_time = System.currentTimeMillis();
        this.pref_editor.putLong("elapsed", this.pause_time - this.start_time);
        this.pref_editor.commit();
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.start_time += System.currentTimeMillis() - this.pause_time;
        this.paused = false;
    }

    public MenuMusic getMusic() {
        return this.music;
    }

    public List getOrders() {
        return this.orders;
    }

    public long getTime() {
        if (this.paused) {
            return this.pause_time - this.start_time;
        }
        long l = System.currentTimeMillis() - this.start_time;
        if (l - this.last_time > 500L) {
            this.start_time += l - this.last_time - 500L;
            this.last_time += 500L;
            return this.last_time;
        }
        this.last_time = l;
        return l;
    }

    public void onBackPressed() {
        switch (this.state) {
            case 5: {
                return;
            }
            case 2: {
                if (this.menu == null) {
                    this.music.kill();
                    System.gc();
                    this.state = 5;
                    break;
                }
                if (this.menu.onBack()) break;
                this.menu.destroy();
                this.menu = null;
                this.music.kill();
                System.gc();
                this.state = 5;
                break;
            }
            case 3: {
                if (this.kitchen.goBack()) break;
                this.openMainMenu();
                this.pause();
                break;
            }
            case 4: {
                if (this.map.goBack()) break;
                this.openMainMenu();
                this.pause();
                break;
            }
        }
    }

    public void openMap() {
        switch (this.state) {
            case 3: {
                if (this.kitchen == null) break;
                this.kitchen.destroy();
                this.kitchen = null;
            }
        }
        this.map = new MapView(this);
        this.state = 4;
    }

    public void openKitchen() {
        switch (this.state) {
            case 2: {
                if (this.menu != null) {
                    this.menu.destroy();
                    this.menu = null;
                }
                this.resume();
                this.music.playMusic("mainloop");
                try {
                    this.topbar = Image.createImage((String)"/topbar.png");
                    this.pausebutton = Image.createImage((String)"/button_pause.png");
                    this.wood = Image.createImage((String)"/bottompanel.png");
                    this.mapbutton = Image.createImage((String)"/button_mapview.png");
                    this.kitchenbutton = Image.createImage((String)"/button_restview.png");
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                if (this.map == null) break;
                this.map.destroy();
                this.map = null;
            }
        }
        this.kitchen = new KitchenView(this);
        this.state = 3;
    }

    public void openMainMenu() {
        switch (this.state) {
            case 3: {
                if (this.kitchen != null) {
                    this.kitchen.destroy();
                    this.kitchen = null;
                }
                this.pause();
                this.music.playMusic("pizza_openingscreen_music_j2me");
                break;
            }
            case 4: {
                if (this.map != null) {
                    this.map.destroy();
                    this.map = null;
                }
                this.pause();
                this.music.playMusic("pizza_openingscreen_music_j2me");
            }
        }
        if (this.state == 3 || this.state == 4) {
            this.topbar = null;
            this.pausebutton = null;
            this.wood = null;
            this.mapbutton = null;
            this.kitchenbutton = null;
            System.gc();
        }
        this.menu = new MenuView(this, this.state == 1);
        this.state = 2;
    }

    public void playSound(String string) {
        this.music.playEffect(string);
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        switch (this.state) {
            case 4: {
                this.map.destroy();
                break;
            }
            case 3: {
                this.kitchen.destroy();
                break;
            }
            case 2: {
                this.menu.destroy();
            }
        }
        if (this.music != null) {
            this.music.kill();
        }
        System.gc();
        this.state = 5;
    }

    protected void showNotify() {
        try {
            this.startApp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void hideNotify() {
        this.pauseApp();
    }

    protected void pauseApp() {
        this.pause();
        this.isminimized = true;
    }

    static {
        appcanv = new String[]{"order_build_canvas_pizza", "order_build_canvas_pizza", "order_build_canvas_beverage", "order_build_canvas_salad", "order_build_canvas_dessert"};
        appimgs = new String[][]{{"oven_lvl1", "oven_lvl2", "oven_lvl3"}, {"oven_lvl1", "oven_lvl2", "oven_lvl3"}, {"sodamachine_lvl1", "sodamachine_lvl2", "sodamachine_lvl3"}, {"saladbar_lvl1", "saladbar_lvl2", "saladbar_lvl3"}, {"dessert_lvl1", "dessert_lvl2", "dessert_lvl3"}};
        appups = new String[][]{{"upgradeview_oven_level1", "upgradeview_oven_level2", "upgradeview_oven_level3"}, {"upgradeview_oven_level1", "upgradeview_oven_level2", "upgradeview_oven_level3"}, {"upgradeview_sodamachine_level1", "upgradeview_sodamachine_level2", "upgradeview_sodamachine_level3"}, {"upgradeview_saladbar_level1", "upgradeview_saladbar_level2", "upgradeview_saladbar_level3"}, {"upgradeview_dessert_level1", "upgradeview_dessert_level2", "upgradeview_dessert_level3"}};
        delivery_pics = new String[]{"deliveryportrait1_jacob", "deliveryportrait2_emily", "deliveryportrait3_josh", "deliveryportrait4_elizabeth", "deliveryportrait5_nathan"};
        delivery_icons = new String[]{"deliveryicon1_jacob", "deliveryicon2_emily", "deliveryicon3_josh", "deliveryicon4_elizabeth", "deliveryicon5_nathan"};
        deliveryups = new String[]{"vehicle_level2", "vehicle_level3", "vehicle_level4", "vehicle_level5"};
    }

    public class State {
        public static final int OPENING = 1;
        public static final int MENU = 2;
        public static final int KITCHEN = 3;
        public static final int MAP = 4;
        public static final int EXITING = 5;
        public static final int SPLASH_1 = 6;
        public static final int SPLASH_2 = 7;
        public static final int SOUND = 8;
        public static final int LANGUAGE = 9;
    }
}

