/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.skiresort.animated;

import com.rocktasticgames.skiresort.animated.AnimatedElement;
import com.rocktasticgames.skiresort.main.MainActivity;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedOrder
extends AnimatedElement {
    public static final float SPEED = 0.002f;
    private static int last_house = 0;
    private static int[] last_item = new int[]{0, 0, 0, 0};
    private MainActivity activity;
    private long dest_time;
    private long start_time;
    private long finish_time;
    private long fail_time;
    private Image[] bmps;
    private int state;
    private int[][] items;
    private int destx;
    private int desty;
    private boolean taken = false;

    public AnimatedOrder(MainActivity mainActivity, Image image, Image[] imageArray, float f, float f2, float f3, float f4, long l, long l2, int n) {
        super(image, f, f2, f3, f4, 4, l);
        this.activity = mainActivity;
        this.dest_time = l;
        this.start_time = l;
        this.finish_time = l2;
        this.bmps = imageArray;
        this.state = 1;
        this.items = new int[][]{{1, 0, 0, 0}, {2, 0, 0, 0}, {3, 0, 0, 0}, {4, 0, 0, 0}};
        this.destx = (int)(System.currentTimeMillis() % 5L);
        this.desty = (int)(System.currentTimeMillis() % 2L);
        if (this.destx < 2) {
            ++this.desty;
            if (this.destx == 1 && this.desty == 2) {
                this.destx = 4;
            }
        }
        for (int i = 0; i < this.items.length; ++i) {
            int n2;
            if (this.items[i][2] != 0) continue;
            int[][] nArrayArray = new int[this.items.length - 1][];
            for (n2 = 0; n2 < i; ++n2) {
                nArrayArray[n2] = this.items[n2];
            }
            for (n2 = i; n2 < this.items.length - 1; ++n2) {
                nArrayArray[n2] = this.items[n2 + 1];
            }
            this.items = nArrayArray;
            --i;
        }
    }

    public boolean isTaken() {
        return this.taken;
    }

    public void take() {
        this.taken = true;
    }

    public void deliver() {
        this.state = 5;
        int n = 0;
        int n2 = 10;
        this.activity.addMoney(n);
        this.activity.addPoints(n2);
    }

    public int getColumn() {
        return this.destx;
    }

    public int getRow() {
        return this.desty;
    }

    public boolean isNew() {
        return this.state == 1;
    }

    public void addItem(int n, int n2) {
        if (!this.needsItem(n, n2)) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        boolean bl = true;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i][0] == n && this.items[i][1] == n2) {
                int[] nArray = this.items[i];
                nArray[3] = nArray[3] + 1;
            }
            if (this.items[i][2] == this.items[i][3]) continue;
            bl = false;
        }
        if (bl) {
            this.state = 3;
            this.activity.checkMessage(9);
        } else {
            this.activity.checkMessage(7);
        }
    }

    public boolean needsItem(int n, int n2) {
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i][0] != n || this.items[i][1] != n2 || this.items[i][2] <= this.items[i][3]) continue;
            return true;
        }
        return false;
    }

    public boolean checkFailed(long l) {
        if (this.state == 4) {
            return true;
        }
        if (this.state == 5) {
            return false;
        }
        if (l - this.start_time > this.finish_time) {
            this.state = 4;
            this.activity.subtractPoints(30);
            this.fail_time = l;
            this.activity.checkMessage(20);
            return true;
        }
        return false;
    }

    public boolean isFailed() {
        return this.state == 4;
    }

    public boolean isReady() {
        return this.state == 3;
    }

    public boolean isDelivered() {
        return this.state == 5;
    }

    public void setIndex(int n, long l) {
        this.dest_time = l + (long)((this.x - (float)n * 0.2f + 0.1f) / 0.002f);
        super.setX((float)n * 0.2f + 0.1f);
    }

    public void setBMPS(Image[] imageArray) {
        this.bmps = imageArray;
    }

    public void select() {
        if (this.state == 1) {
            this.state = 2;
        }
    }

    public float getRemaining(long l) {
        return (float)Math.max(0L, this.finish_time - l + this.start_time) / (float)this.finish_time;
    }

    public boolean render(Graphics graphics, long l) {
        return super.render(graphics, l) && l >= this.dest_time;
    }

    public int[][] getItems() {
        return this.items;
    }

    protected void drawTime(Graphics graphics, long l) {
        Image image;
        this.checkFailed(l);
        if (this.state == 4 && l - this.start_time > this.finish_time + 1000L && !this.isAnimatingOut()) {
            this.animate(3, l);
            this.animateOut(l);
            if (this.activity.getCanvas().getFocus() == this) {
                // empty if block
            }
        }
        switch (this.state) {
            case 1: {
                image = this.bmps[0];
                break;
            }
            case 2: {
                image = this.bmps[1];
                break;
            }
            default: {
                image = this.bmps[2];
                break;
            }
            case 4: {
                image = this.bmps[3];
            }
        }
        Image image2 = this.bmps[4 + Math.min((int)(2.5f * (float)(l - this.start_time) / (float)this.finish_time), 2)];
        Image image3 = this.bmps[7];
        if (l < this.dest_time) {
            graphics.translate((int)(this.parent_width * (float)(this.dest_time - l) * 0.002f), 0);
        }
        super.draw(graphics);
        if (this.filter == null) {
            graphics.drawImage(image, -image.getWidth() / 2, -this.bmp.getHeight() * 89 / 382, 0);
            graphics.drawImage(image2, -image2.getWidth() / 2, this.bmp.getHeight() * -7 / 382, 0);
            graphics.drawImage(image3, -image3.getWidth() / 2, this.bmp.getHeight() * 107 / 382, 0);
            graphics.setColor(61183);
            graphics.fillRect(-this.bmp.getWidth() * 121 / 308, this.bmp.getHeight() * 116 / 382, (int)((float)this.bmp.getWidth() * (242.0f * this.getRemaining(l)) / 308.0f), this.bmp.getHeight() * 40 / 382);
        } else {
            graphics.drawImage(this.filter.applyTo(image), -image.getWidth() / 2, -this.bmp.getHeight() * 89 / 382, 0);
            graphics.drawImage(this.filter.applyTo(image2), -image2.getWidth() / 2, this.bmp.getHeight() * -7 / 382, 0);
            graphics.drawImage(this.filter.applyTo(image3), -image3.getWidth() / 2, this.bmp.getHeight() * 107 / 382, 0);
            graphics.setColor(30591);
            graphics.fillRect(-this.bmp.getWidth() * 121 / 308, this.bmp.getHeight() * 116 / 382, (int)((float)this.bmp.getWidth() * (242.0f * this.getRemaining(l)) / 308.0f), this.bmp.getHeight() * 40 / 382);
        }
    }

    public static class State {
        public static final int NEW = 1;
        public static final int OPEN = 2;
        public static final int READY = 3;
        public static final int FAILED = 4;
        public static final int DELIVERED = 5;
    }
}

