/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Motor
implements Constraint {
    private Body a;
    private float b;
    private float c;
    private boolean d;
    private boolean e;
    private boolean f;
    private float g;
    private static FXVector h = new FXVector();
    private static FXVector i = new FXVector();
    private static FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private FXVector l = new FXVector();
    private FXVector m = new FXVector();
    private FXVector n = new FXVector();
    protected UserData mUserData = null;

    public Motor(Body body, float f2, float f3) {
        this.a = body;
        this.b = f2;
        this.d = true;
        this.e = false;
        this.f = false;
        this.g = f3;
    }

    public Motor(Body body, float f2, float f3, float f4) {
        this.a = body;
        this.b = f2;
        this.c = f3;
        this.d = false;
        this.e = false;
        this.f = false;
        this.g = f4;
    }

    public Motor(Motor motor, Body[] bodyArray) {
        this.a = bodyArray != null ? bodyArray[motor.a.mId] : motor.a;
        this.b = motor.b;
        this.c = motor.c;
        this.d = motor.d;
        this.e = motor.e;
        this.f = motor.f;
        this.g = motor.g;
        if (motor.mUserData != null) {
            this.mUserData = motor.mUserData.copy();
        }
    }

    public void setParameter(float f2, float f3, boolean bl, boolean bl2, boolean bl3) {
        this.b = f2;
        this.c = f3;
        this.d = bl;
        this.e = bl2;
        this.f = bl3;
        this.n.assignFX(0.0f, 0.0f);
    }

    public Constraint copy(Body[] bodyArray) {
        return new Motor(this, bodyArray);
    }

    private Motor() {
    }

    public static Motor loadMotor(PhysicsFileReader object, Vector vector, UserData userData) {
        Motor motor = new Motor();
        new Motor().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        motor.b = ((PhysicsFileReader)object).nextIntFX();
        motor.c = ((PhysicsFileReader)object).nextIntFX();
        motor.g = ((PhysicsFileReader)object).nextIntFX();
        int n = ((PhysicsFileReader)object).next();
        motor.d = (n & 1) > 0;
        motor.e = (n & 2) > 0;
        boolean bl = motor.f = (n & 4) > 0;
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                motor.mUserData = userData.createNewUserData((String)object, 4);
            }
        }
        return motor;
    }

    public void precalculate(float f2) {
        if (this.d) {
            this.a.applyTorque(this.n.xFX);
            return;
        }
        h.assignFX(this.b, this.c);
        if (this.e) {
            FXMatrix fXMatrix = new FXMatrix(this.a.getRotationMatrix());
            fXMatrix.invert();
            fXMatrix.mult(h, this.l);
        } else {
            this.l.xFX = Motor.h.xFX;
            this.l.yFX = Motor.h.yFX;
        }
        if (!this.f) {
            this.m.xFX = this.l.xFX;
            this.m.yFX = this.l.yFX;
            this.m.normalize();
        }
        this.a.applyMomentum(this.n);
    }

    public boolean applyMomentum(float f2) {
        if (this.d) {
            f2 = (this.a.mAngularVelocity2FX - this.b) * this.a.mShape.h;
            Motor.j.xFX = this.n.xFX;
            this.n.xFX = Math.max(Math.min(this.n.xFX + f2, this.g), -this.g);
            f2 = this.n.xFX - Motor.j.xFX;
            this.a.applyTorque(f2);
            return f2 < 0.00390625f;
        }
        this.k.xFX = this.l.xFX;
        this.k.yFX = this.l.yFX;
        if (this.f) {
            this.k.add(this.a.mVelocityFX, -1.0f);
        } else {
            f2 = this.m.xFX * this.a.mVelocityFX.xFX + this.m.yFX * this.a.mVelocityFX.yFX;
            this.k.add(this.m, -f2);
        }
        this.k.multFX(this.a.mShape.f);
        j.assign(this.n);
        this.n.xFX += this.k.xFX;
        this.n.yFX += this.k.yFX;
        this.n.minFX(this.g);
        this.n.maxFX(-this.g);
        i.assignDiff(this.n, j);
        this.a.applyMomentum(i);
        return i.fastLengthFX() < 0.00390625f;
    }

    public void postStep() {
    }

    public boolean concernsBody(Body body) {
        return body.equals(this.a);
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Motor && this.a.equals(((Motor)constraint).a) && this.b == ((Motor)constraint).b && this.c == ((Motor)constraint).c && this.d == ((Motor)constraint).d && this.e == ((Motor)constraint).e && this.g == ((Motor)constraint).g;
    }

    public float getImpulseFX() {
        return this.n.lengthFX();
    }

    public Body body() {
        return this.a;
    }

    public boolean isRotation() {
        return this.d;
    }

    public boolean isRelative() {
        return this.e;
    }

    public boolean isFixOrthogonal() {
        return this.f;
    }

    public float getMaxForceFX() {
        return this.g;
    }

    protected float getTargetAFX() {
        return this.b;
    }

    protected float getTargetBFX() {
        return this.c;
    }

    protected void setTargetAFX(float f2) {
        this.b = f2;
    }

    protected void setTargetBFX(float f2) {
        this.c = f2;
    }

    public void setMaxForceFX(float f2) {
        this.g = f2;
    }

    protected void setRotation(boolean bl) {
        this.d = bl;
    }

    protected void setIsRelative(boolean bl) {
        this.e = bl;
    }

    protected void setFixOrthogonal(boolean bl) {
        this.f = bl;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

