/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.admanager;

import com.emobtech.googleanalyticsme.Event;
import com.renderedideas.admanager.AdData;
import com.renderedideas.admanager.AdManager;
import com.renderedideas.gamemanager.GameView;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.yourgamename.Game;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class AdView
extends GameView {
    final int STATUS_DOWNLOADING;
    final int STATUS_SHOWING;
    final int STATUS_ERROR;
    public static final int LOCATION_START = 101;
    public static final int LOCATION_END = 102;
    int currentStatus;
    int adLocation;
    int dots = 0;
    private Command clickCommand;
    private Command skipCommand;
    private boolean isAlreadySkipped;
    private AdData adData;
    Bitmap yes;
    Bitmap no;

    public AdView(int adLocation) {
        this.STATUS_DOWNLOADING = 1;
        this.STATUS_SHOWING = 2;
        this.STATUS_ERROR = 3;
        this.adLocation = adLocation;
        this.currentStatus = 1;
        this.yes = new Bitmap("/donotdelete/yes.png");
        this.no = new Bitmap("/donotdelete/no.png");
        GameMIDlet.instance.gameCanvas.setFullScreenMode(false);
        GameMIDlet.instance.gameCanvas.removeCommand(GameMIDlet.instance.gameCanvas.backCommand);
        GameMIDlet.instance.gameCanvas.setTitle(GameMIDlet.instance.getAppProperty("MIDlet-Name"));
        this.startDownload();
    }

    public void update() {
    }

    private void analyzeData(AdData adData) {
        if (adData.type.equals("update")) {
            this.analyzeUpdate(adData);
        } else if (adData.type.equals("ad")) {
            if (adData.showFullScreen.equals("true")) {
                GameMIDlet.instance.gameCanvas.setFullScreenMode(true);
            }
            this.hitAllBeacons(adData);
            if (adData.adType.equals("banner")) {
                this.analyzeBanner(adData);
            } else if (adData.adType.equals("text")) {
                this.analyzeText(adData);
            } else if (adData.adType.equals("prompt")) {
                this.analyzePrompt(adData);
            } else if (adData.adType.equals("custom")) {
                this.analyzeCustom(adData);
            } else if (adData.adType.equals("call")) {
                this.analyzeCall(adData);
            }
        }
    }

    private void analyzeUpdate(AdData adData) {
        if (PlatformService.showYesNoDialog(adData.title, adData.text)) {
            PlatformService.openURL(adData.clickUrl);
            PlatformService.sleepThread(2000);
            GameMIDlet.instance.exit();
        } else if (adData.isMandatory.equals("true")) {
            GameMIDlet.instance.exit();
        } else {
            this.skipAd();
        }
    }

    private void analyzeBanner(final AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            this.rotateResizeAndScale(adData);
        }
        catch (Exception ex) {
            Debug.print("993ndk:" + ex);
        }
        if (adData.isFlipButtons.equals("true")) {
            this.skipCommand = new Command(adData.skipText, 2, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
        } else {
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
            this.skipCommand = new Command(adData.skipText, 3, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
        }
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    AdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void rotateResizeAndScale(AdData adData) {
        if (adData == null || adData.img == null) {
            return;
        }
        if (!adData.rotation.equals("0")) {
            if (adData.rotation.equals("90")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 90);
            } else if (adData.rotation.equals("180")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 180);
            } else if (adData.rotation.equals("270")) {
                adData.img = Bitmap.rotateBitmap(adData.img, 270);
            }
        }
        if (adData.isResize.equals("true")) {
            if (adData.isMaintainAspectRatio.equals("true")) {
                float scaleFactor;
                float f2 = scaleFactor = adData.img.getWidth() > adData.img.getHeight() ? (float)this.getWidth() / (float)adData.img.getWidth() : (float)this.getHeight() / (float)adData.img.getHeight();
                if ((float)adData.img.getWidth() * scaleFactor > (float)this.getWidth()) {
                    scaleFactor = (float)this.getWidth() / (float)adData.img.getWidth();
                }
                if ((float)adData.img.getHeight() * scaleFactor > (float)this.getHeight()) {
                    scaleFactor = (float)this.getHeight() / (float)adData.img.getHeight();
                }
                adData.img = Bitmap.scaleBitmap(adData.img, (int)((float)adData.img.getWidth() * scaleFactor), (int)((float)adData.img.getHeight() * scaleFactor));
            } else {
                adData.img = Bitmap.scaleBitmap(adData.img, this.getWidth(), this.getHeight());
            }
        }
        if (!adData.scale.equals("1")) {
            float scale = Float.parseFloat(adData.scale);
            adData.img = Bitmap.scaleBitmap(adData.img, (int)((float)adData.img.getWidth() * scale), (int)((float)adData.img.getHeight() * scale));
        }
    }

    private void analyzeText(final AdData adData) {
        if (adData.isFlipButtons.equals("true")) {
            this.skipCommand = new Command(adData.skipText, 2, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
        } else {
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
            this.skipCommand = new Command(adData.skipText, 3, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
        }
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    AdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void analyzePrompt(final AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            this.rotateResizeAndScale(adData);
        }
        catch (Exception ex) {
            Debug.print("993ndk:" + ex);
        }
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    AdView.this.clickAd();
                }
            });
            t.start();
        }
        if (adData.isFlipButtons.equals("true")) {
            int optionSelected = GameMIDlet.instance.showOptionsDialog(adData.title, adData.img, adData.text, adData.negativeText, adData.positiveText);
            if (optionSelected == 2) {
                this.clickAd();
            } else if (optionSelected == 1) {
                this.skipAd();
            }
        } else {
            int optionSelected = GameMIDlet.instance.showOptionsDialog(adData.title, adData.img, adData.text, adData.positiveText, adData.negativeText);
            if (optionSelected == 1) {
                this.clickAd();
            } else if (optionSelected == 2) {
                this.skipAd();
            }
        }
    }

    private void analyzeCustom(final AdData adData) {
        try {
            adData.img = PlatformService.getBitmapResponseFromServer(adData.imgUrl);
            this.rotateResizeAndScale(adData);
            if (!adData.positiveButtonImgUrl.equals("null") && !adData.positiveButtonImgUrl.equals("")) {
                adData.positiveButtonImg = PlatformService.getBitmapResponseFromServer(adData.positiveButtonImgUrl);
            }
            if (!adData.negativeButtonImgUrl.equals("null") && !adData.negativeButtonImgUrl.equals("")) {
                adData.negativeButtonImg = PlatformService.getBitmapResponseFromServer(adData.negativeButtonImgUrl);
            }
        }
        catch (Exception ex) {
            Debug.print("993ndk:" + ex);
        }
        if (adData.isFlipButtons.equals("true")) {
            this.skipCommand = new Command(adData.skipText, 2, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
        } else {
            this.clickCommand = new Command(adData.clickText, 4, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.clickCommand);
            this.skipCommand = new Command(adData.skipText, 3, 1);
            GameMIDlet.instance.gameCanvas.addCommand(this.skipCommand);
        }
        if (adData.action.equals("1")) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    PlatformService.sleepThread(Integer.parseInt(adData.actionT));
                    AdView.this.clickAd();
                }
            });
            t.start();
        }
    }

    private void analyzeCall(AdData adData) {
        this.analyzeBanner(adData);
    }

    public void paint(Graphics g2, float ef) {
        if (this.currentStatus == 1) {
            ++this.dots;
            if (this.dots > 3) {
                this.dots = 0;
            }
            Bitmap.fillColor(g2, 0, 0, this.getWidth(), this.getHeight(), 0, 0, 0);
            StringBuffer text = this.adLocation == 101 ? new StringBuffer("Loading") : new StringBuffer("Please wait");
            for (int i = 0; i < this.dots; ++i) {
                text.append(".");
            }
            Bitmap.drawString(g2, text.toString(), this.getWidth() / 2 - Bitmap.getStringWidth("Loading...") / 2, this.getHeight() / 2, 255, 255, 255);
        } else if (this.currentStatus == 2 && this.adData.type.equals("ad")) {
            if (this.adData.adType.equals("banner")) {
                this.paintBanner(g2, this.adData);
            } else if (this.adData.adType.equals("text")) {
                this.paintText(g2, this.adData);
            } else if (this.adData.adType.equals("custom")) {
                this.paintCustom(g2, this.adData);
            } else if (this.adData.adType.equals("call")) {
                this.paintCall(g2, this.adData);
            }
        }
    }

    private void paintBanner(Graphics g2, AdData adData) {
        Bitmap.fillColor(g2, 0, 0, this.getWidth(), this.getHeight(), 0, 0, 0);
        if (adData.img != null) {
            Bitmap.drawBitmap(g2, adData.img, this.getWidth() / 2 - adData.img.getWidth() / 2, this.getHeight() / 2 - adData.img.getHeight() / 2);
        }
        if (adData.img != null) {
            Bitmap.drawMultilineString(g2, adData.text, this.getWidth() / 10, this.getHeight() / 2 + adData.img.getHeight() / 2, this.getWidth() * 8 / 10);
        } else {
            Bitmap.drawMultilineString(g2, adData.text, this.getWidth() / 10, this.getHeight() / 2 - Bitmap.getMultilineStringHeight(adData.text, this.getWidth() * 8 / 10) / 2, this.getWidth() * 8 / 10);
        }
        if (adData.showFullScreen.equals("true")) {
            Bitmap.drawBitmap(g2, this.no, 0, this.getHeight() - this.no.getHeight());
            Bitmap.drawBitmap(g2, this.yes, this.getWidth() - this.yes.getWidth(), this.getHeight() - this.yes.getHeight());
        }
    }

    private void paintText(Graphics g2, AdData adData) {
        this.paintBanner(g2, adData);
    }

    private void paintCustom(Graphics g2, AdData adData) {
        Bitmap.fillColor(g2, 0, 0, this.getWidth(), this.getHeight(), adData.bgColor);
        if (adData.img != null) {
            Bitmap.drawBitmap(g2, adData.img, this.getWidth() / 2 - adData.img.getWidth() / 2, this.getHeight() / 2 - adData.img.getHeight() / 2);
        }
        if (adData.img != null) {
            Bitmap.drawMultilineString(g2, adData.text, this.getWidth() / 10, this.getHeight() / 2 + adData.img.getHeight() / 2, this.getWidth() * 8 / 10, adData.textColor);
        } else {
            Bitmap.drawMultilineString(g2, adData.text, this.getWidth() / 10, this.getHeight() / 2 - Bitmap.getMultilineStringHeight(adData.text, this.getWidth() * 8 / 10) / 2, this.getWidth() * 8 / 10, adData.textColor);
        }
        if (adData.positiveButtonImg != null) {
            Bitmap.drawBitmap(g2, adData.positiveButtonImg, this.getWidth() - adData.positiveButtonImg.getWidth(), this.getHeight() - adData.positiveButtonImg.getHeight());
        } else if (adData.showFullScreen.equals("true")) {
            Bitmap.drawBitmap(g2, this.yes, this.getWidth() - this.yes.getWidth(), this.getHeight() - this.yes.getHeight());
        }
        if (adData.negativeButtonImg != null) {
            Bitmap.drawBitmap(g2, adData.negativeButtonImg, 0, this.getHeight() - adData.negativeButtonImg.getHeight());
        } else if (adData.showFullScreen.equals("true")) {
            Bitmap.drawBitmap(g2, this.no, 0, this.getHeight() - this.no.getHeight());
        }
    }

    private void paintCall(Graphics g2, AdData adData) {
        this.paintBanner(g2, adData);
    }

    public void keyPressed(int keyID) {
    }

    public void keyReleased(int keyID) {
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pid, int x, int y) {
        if (this.adData == null || this.adData.adType == null) {
            return;
        }
        if (this.currentStatus == 2) {
            if (this.adData.adType.equals("custom")) {
                if (this.adData.negativeButtonImg != null && x <= this.adData.negativeButtonImg.getWidth() && y >= this.getHeight() - this.adData.negativeButtonImg.getHeight()) {
                    this.skipAd();
                } else {
                    this.clickAd();
                }
            } else if (!this.adData.adType.equals("update")) {
                if (x <= this.no.getWidth() && y >= this.getHeight() - this.no.getHeight()) {
                    this.skipAd();
                } else {
                    this.clickAd();
                }
            }
        }
    }

    public void pointerReleased(int pid, int x, int y) {
    }

    public void pointerDragged(int pid, int x, int y) {
    }

    public void onBackKey() {
        if (this.currentStatus == 2) {
            this.skipAd();
        }
    }

    public void handleSwipe(int direction) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        this.adData.img = null;
        this.adData.imgList = null;
        this.no = null;
        this.yes = null;
    }

    public void accelerometerData(double x, double y, double z, double min, double max) {
    }

    public void commandAction(Command c2) {
        if (c2 == this.clickCommand) {
            this.clickAd();
        } else if (c2 == this.skipCommand) {
            this.skipAd();
        }
    }

    void restoreCanvas() {
        GameMIDlet.instance.gameCanvas.setFullScreenMode(true);
        GameMIDlet.instance.gameCanvas.removeCommand(this.clickCommand);
        GameMIDlet.instance.gameCanvas.removeCommand(this.skipCommand);
        if (PlatformService.isTouchSupported()) {
            GameMIDlet.instance.gameCanvas.backCommand = new Command("Back", 2, 1);
            GameMIDlet.instance.gameCanvas.addCommand(GameMIDlet.instance.gameCanvas.backCommand);
        }
    }

    void clickAd() {
        PlatformService.openURL(this.adData.clickUrl);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    PlatformService.sleepThread(Integer.parseInt(((AdView)AdView.this).adData.clickWait));
                    AdView.this.skipAd();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        t.start();
    }

    private void skipAd() {
        if (this.isAlreadySkipped) {
            return;
        }
        this.isAlreadySkipped = true;
        if (this.adLocation == 101) {
            this.restoreCanvas();
            Game.startGame();
        } else if (this.adLocation == 102) {
            GameMIDlet.instance.exit();
        }
    }

    private void startDownload() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    if (AdView.this.adLocation == 101) {
                        AdView.this.adData = AdManager.downloadStartAd();
                    } else if (AdView.this.adLocation == 102) {
                        AdView.this.adData = AdManager.downloadEndAd();
                    }
                    if (AdView.this.adData == null) {
                        AdView.this.adFailedScreen();
                        return;
                    }
                    AdView.this.analyzeData(AdView.this.adData);
                    AdView.this.currentStatus = 2;
                }
                catch (Exception e2) {
                    if (AdView.this.adData != null) {
                        GameMIDlet.tracker.addToQueue(new Event("/Adview", "Exception", ((AdView)AdView.this).adData.response, null));
                    }
                    e2.printStackTrace();
                    AdView.this.skipAd();
                }
            }
        });
        t.start();
    }

    private void adFailedScreen() {
        if (this.adLocation == 102) {
            GameMIDlet.instance.exit();
        }
        if (GameMIDlet.instance.iapProvider != null) {
            int optionSelected = GameMIDlet.instance.show3OptionsDialog("Error", "Internect connection is required. Please allow access to internet or buy ad-free version. Ad-free version does not require internet connection to start.", "Retry", "Buy Ad-free", "Exit");
            if (optionSelected == 1) {
                this.startDownload();
            } else if (optionSelected == 2) {
                GameMIDlet.instance.iapProvider.buyGame();
                GameMIDlet.instance.exit();
            } else if (optionSelected == 3) {
                GameMIDlet.instance.exit();
            }
        } else {
            int optionSelected = GameMIDlet.instance.showOptionsDialog("Error", "Internect connection is required. Please allow access to internet or check your connection settings.", "Retry", "Exit");
            if (optionSelected == 1) {
                this.startDownload();
            } else if (optionSelected == 2) {
                GameMIDlet.instance.exit();
            }
        }
    }

    int getWidth() {
        return GameMIDlet.instance.gameCanvas.getWidth();
    }

    int getHeight() {
        return GameMIDlet.instance.gameCanvas.getHeight();
    }

    private void hitAllBeacons(final AdData adData) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < adData.beaconList.length; ++i) {
                    try {
                        if (adData.beaconList[i].indexOf(".jpg") != -1 || adData.beaconList[i].indexOf(".png") != -1 || adData.beaconList[i].indexOf(".gif") != -1) {
                            PlatformService.getBitmapResponseFromServer(adData.beaconList[i]);
                            continue;
                        }
                        PlatformService.getStringResponseFromServer(adData.beaconList[i], null);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        t.start();
    }
}

