/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.FontSprite;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.DictionaryKeyValue;
import com.renderedideas.platform.LoadResources;
import javax.microedition.lcdui.Graphics;

public class GameFont {
    private DictionaryKeyValue myFonts;
    private int spaceWidth;
    private int fontHeight;
    private int referenceCharOffsetY;

    public GameFont(String filePath) {
        try {
            this.myFonts = new DictionaryKeyValue();
            String xml = LoadResources.loadFileAsString(filePath + ".sprites");
            int count = 0;
            int i = 0;
            while ((i = xml.indexOf("<spr", i + 1)) != -1) {
                ++count;
            }
            Bitmap sourceBitmap = new Bitmap(filePath + ".png");
            int startIndex = 0;
            int endIndex = 0;
            for (i = 0; i < count; ++i) {
                startIndex = xml.indexOf("<spr name=\"", endIndex) + 11;
                String name = xml.substring(startIndex, endIndex = xml.lastIndexOf(34, xml.indexOf("x=", startIndex)));
                if (name.equals("")) {
                    name = "\"";
                } else if (name.equals(" ")) continue;
                startIndex = xml.indexOf("x=\"", startIndex) + 3;
                endIndex = xml.indexOf("\"", startIndex);
                int x = Integer.parseInt(xml.substring(startIndex, endIndex));
                startIndex = xml.indexOf("y=\"", startIndex) + 3;
                endIndex = xml.indexOf("\"", startIndex);
                int y = Integer.parseInt(xml.substring(startIndex, endIndex));
                startIndex = xml.indexOf("w=\"", startIndex) + 3;
                endIndex = xml.indexOf("\"", startIndex);
                int width = Integer.parseInt(xml.substring(startIndex, endIndex));
                startIndex = xml.indexOf("h=\"", startIndex) + 3;
                endIndex = xml.indexOf("\"", startIndex);
                int height = Integer.parseInt(xml.substring(startIndex, endIndex));
                startIndex = xml.indexOf("fx=\"", startIndex) + 4;
                endIndex = xml.indexOf("\"", startIndex);
                int fx = Integer.parseInt(xml.substring(startIndex, endIndex));
                startIndex = xml.indexOf("fy=\"", startIndex) + 4;
                endIndex = xml.indexOf("\"", startIndex);
                int fy = Integer.parseInt(xml.substring(startIndex, endIndex));
                if (width == 0 || height == 0) continue;
                FontSprite fontSprite = new FontSprite();
                fontSprite.bitmap = Bitmap.getImageRegion(sourceBitmap, x, y, width, height);
                fontSprite.fx = fx;
                fontSprite.fy = fy;
                this.myFonts.put(String.valueOf(name), fontSprite);
            }
        }
        catch (Exception e2) {
            Debug.print("Error In MyFont " + e2);
        }
        this.spaceWidth = ((FontSprite)this.myFonts.get((Object)"B")).bitmap.getWidth();
        this.fontHeight = ((FontSprite)this.myFonts.get((Object)"B")).bitmap.getHeight();
        this.referenceCharOffsetY = ((FontSprite)this.myFonts.get((Object)"B")).fy;
    }

    public FontSprite[] getFontString(String str) {
        FontSprite[] result = new FontSprite[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (FontSprite)this.myFonts.get(String.valueOf(str.charAt(i)));
        }
        return result;
    }

    public int stringWidth(String str) {
        int length = 0;
        for (int i = 0; i < str.length(); ++i) {
            FontSprite fontSprite = (FontSprite)this.myFonts.get(String.valueOf(str.charAt(i)));
            if (fontSprite == null) {
                length += this.spaceWidth;
                continue;
            }
            length = (int)((float)length + (float)fontSprite.fx * 0.8f);
        }
        return length;
    }

    public int stringHeight() {
        return this.fontHeight;
    }

    public void drawString(String str, Graphics target, int x, int y) {
        FontSprite[] msgFont = this.getFontString(str);
        int space = 0;
        for (int j = 0; j < msgFont.length; ++j) {
            if (msgFont[j] == null) {
                space += this.spaceWidth;
                continue;
            }
            Bitmap.drawBitmap(target, msgFont[j].bitmap, x + space, y + msgFont[j].fy - this.referenceCharOffsetY);
            space = (int)((float)space + (float)msgFont[j].fx * 0.8f);
        }
    }
}

