/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameObject;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.SpriteFrame;

public class ImageSet {
    public SpriteFrame[][] spriteFrames = new SpriteFrame[1][];
    public int[][] stateAnimationTime = new int[1][];
    public long animationFrameStartTime = PlatformService.currentTimeMillis();
    public int currentState;
    public int currentFrame;
    public int totalCyclesToComplete = -1;
    public GameObject gameObject;

    public ImageSet(GameObject gameObject) {
        this.gameObject = gameObject;
    }

    public void addState(Bitmap[] frames, int animationTime) {
        if (this.spriteFrames[this.spriteFrames.length - 1] != null) {
            this.spriteFrames = Utility.stretchArray(this.spriteFrames, 1);
            this.stateAnimationTime = Utility.stretchArray(this.stateAnimationTime, 1);
        }
        this.spriteFrames[this.spriteFrames.length - 1] = this.getSpriteFrames(frames);
        int[] frameTime = new int[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            frameTime[i] = animationTime / frames.length;
        }
        this.stateAnimationTime[this.stateAnimationTime.length - 1] = frameTime;
    }

    private SpriteFrame[] getSpriteFrames(Bitmap[] bitmapFrames) {
        SpriteFrame[] returnSpriteFrames = new SpriteFrame[bitmapFrames.length];
        for (int i = 0; i < bitmapFrames.length; ++i) {
            returnSpriteFrames[i] = new SpriteFrame();
            returnSpriteFrames[i].bitmap = bitmapFrames[i];
            returnSpriteFrames[i].fx = 0;
            returnSpriteFrames[i].fy = 0;
            returnSpriteFrames[i].width = bitmapFrames[i].getWidth();
            returnSpriteFrames[i].height = bitmapFrames[i].getHeight();
        }
        return returnSpriteFrames;
    }

    public void addState(SpriteFrame[] frames, int animationTime) {
        if (this.spriteFrames[this.spriteFrames.length - 1] != null) {
            this.spriteFrames = Utility.stretchArray(this.spriteFrames, 1);
            this.stateAnimationTime = Utility.stretchArray(this.stateAnimationTime, 1);
        }
        this.spriteFrames[this.spriteFrames.length - 1] = frames;
        int[] frameTime = new int[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            frameTime[i] = animationTime / frames.length;
        }
        this.stateAnimationTime[this.stateAnimationTime.length - 1] = frameTime;
    }

    public void setState(int stateToSet, boolean force, int cyclesToComplete) {
        if (this.currentState == stateToSet && force || this.currentState != stateToSet) {
            this.currentFrame = 0;
            this.totalCyclesToComplete = cyclesToComplete;
            this.animationFrameStartTime = PlatformService.currentTimeMillis();
        }
        this.currentState = stateToSet;
    }

    public void updateFrame() {
        long currentTime = PlatformService.currentTimeMillis();
        if (this.stateAnimationTime[this.currentState][this.currentFrame] != -1 && currentTime - this.animationFrameStartTime > (long)this.stateAnimationTime[this.currentState][this.currentFrame]) {
            ++this.currentFrame;
            this.animationFrameStartTime = currentTime;
            if (this.currentFrame >= this.spriteFrames[this.currentState].length) {
                --this.totalCyclesToComplete;
                if (this.totalCyclesToComplete == 0) {
                    this.currentFrame = this.spriteFrames[this.currentState].length - 1;
                    this.gameObject.animationStateComplete(this.currentState);
                    return;
                }
                this.currentFrame = 0;
            }
        }
    }

    public void deallocate() {
        this.spriteFrames = null;
        this.gameObject = null;
        this.stateAnimationTime = null;
    }

    public int getWidth() {
        return this.spriteFrames[this.currentState][this.currentFrame].width;
    }

    public int getHeight() {
        return this.spriteFrames[this.currentState][this.currentFrame].height;
    }

    public int getOffsetX() {
        return this.spriteFrames[this.currentState][this.currentFrame].fx;
    }

    public int getOffsetY() {
        return this.spriteFrames[this.currentState][this.currentFrame].fy;
    }
}

