/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.Box2DHelper;
import com.renderedideas.gamemanager.ColorRGBA;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.Polygon;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.gamemanager.Vector3;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.DictionaryKeyValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.m3g.Graphics3D;

public class PolygonMap {
    public DictionaryKeyValue textures = new DictionaryKeyValue();
    public ArrayList polygons = new ArrayList();
    public float startX;
    public float startY;
    public float startZ;
    public Point dimensionTopLeft;
    public Point dimensionBottomRight;
    static /* synthetic */ Class class$com$renderedideas$platform$LoadResources;

    public PolygonMap(String filePath, World box2dWorld) throws Exception {
        this.LoadMap(filePath, box2dWorld);
    }

    private void LoadMap(String filePath, World box2dWorld) throws Exception {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        Debug.print("Loading..." + filePath, (short)1);
        InputStream is = (class$com$renderedideas$platform$LoadResources == null ? (class$com$renderedideas$platform$LoadResources = PolygonMap.class$("com.renderedideas.platform.LoadResources")) : class$com$renderedideas$platform$LoadResources).getResourceAsStream(filePath);
        InputStreamReader reader = new InputStreamReader(is);
        String[] values = Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "dimension: ", "\n"), ",");
        this.dimensionTopLeft = new Point(Float.parseFloat(values[0]), Float.parseFloat(values[1]));
        this.dimensionBottomRight = new Point(Float.parseFloat(values[2]), Float.parseFloat(values[3]));
        PolygonMap.readLine(reader);
        Debug.print("Map Dimensions: dimensionTopLeft = " + this.dimensionTopLeft.toString() + ", dimensionsBottomRight = " + this.dimensionBottomRight.toString(), (short)1);
        this.loadTextures(PolygonMap.readLine(reader));
        PolygonMap.readLine(reader);
        PolygonMap.readLine(reader);
        String line = "";
        boolean isSensorLayerStart = false;
        boolean isEntitiesLayerStart = false;
        boolean isCollisionLayerStart = false;
        while ((line = PolygonMap.readLine(reader)) != null) {
            float[] position;
            if (line.trim().equals("")) continue;
            if (isSensorLayerStart) {
                String sensorName = line.trim();
                position = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "position: (", ")"));
                float radius = Float.parseFloat(this.getValueBetweenStrings(PolygonMap.readLine(reader), "radius: ", "\n"));
                DictionaryKeyValue attributes = this.getAttributes(PolygonMap.readLine(reader));
                this.createSensor(box2dWorld, sensorName, position, radius, attributes);
                continue;
            }
            if (line.trim().equals("SENSORS==>")) {
                isSensorLayerStart = true;
                continue;
            }
            if (isEntitiesLayerStart) {
                String entityName = line.trim();
                position = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "position: (", ")"));
                DictionaryKeyValue attributes = this.getAttributes(PolygonMap.readLine(reader));
                this.createEntity(box2dWorld, entityName, position, attributes, reader);
                continue;
            }
            if (line.trim().equals("ENTITIES==>")) {
                isEntitiesLayerStart = true;
                continue;
            }
            if (isCollisionLayerStart) {
                String collisionName = line.trim();
                position = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "position: (", ")"));
                float[] dimensions = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "dimension: (", ")"));
                FXVector[] vertices = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "vertices: (", ")\n"), "),("));
                FXVector[] edges = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "edges: (", ")\n"), "),("));
                DictionaryKeyValue attributes = this.getAttributes(PolygonMap.readLine(reader));
                this.createCollision(box2dWorld, collisionName, position, dimensions, vertices, edges, attributes);
                continue;
            }
            if (line.trim().equals("COLLISIONS==>")) {
                isCollisionLayerStart = true;
                continue;
            }
            float[] position2 = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "position: (", ")"));
            float[] dimensions = this.getVector(this.getValueBetweenStrings(PolygonMap.readLine(reader), "dimension: (", ")"));
            Vector3[] vertices = this.getVectors(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "vertices: (", ")\n"), "),("));
            int[] triangles = this.typeCastAsInteger(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "triangles: ", "\n"), ","));
            FXVector[] uvs = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "uvs: (", ")\n"), "),("));
            String textureName = this.getValueBetweenStrings(PolygonMap.readLine(reader), "texture: ", "\n");
            DictionaryKeyValue attributes = this.getAttributes(PolygonMap.readLine(reader));
            Polygon polygon = new Polygon(position2, dimensions, vertices, triangles, uvs, (Bitmap)this.textures.get(textureName), attributes);
            this.polygons.addElement(polygon);
        }
        reader.close();
    }

    public void MoveMap(float scrollX, float scrollY, float scrollZ) {
        this.startX += scrollX;
        this.startY += scrollY;
        this.startZ += scrollZ;
        if (this.startY < this.dimensionTopLeft.Y) {
            this.startY = this.dimensionTopLeft.Y;
        } else if (this.startY + (float)GameManager.screenHeight > this.dimensionBottomRight.Y) {
            this.startY = this.dimensionBottomRight.Y - (float)GameManager.screenHeight;
        }
    }

    public void DrawMap(Graphics3D target, int offsetX, int offsetY, int screenWidth, int screenHeight) {
        for (int i = 0; i < this.polygons.size(); ++i) {
            Polygon polygon = (Polygon)this.polygons.elementAt(i);
            if (!(polygon.position[0] + polygon.dimensions[0] / 2.0f > this.startX + (float)offsetX) || !(polygon.position[0] - polygon.dimensions[0] / 2.0f < this.startX + (float)screenWidth) || !(polygon.position[1] + polygon.dimensions[1] / 2.0f > this.startY + (float)offsetY) || !(polygon.position[1] - polygon.dimensions[1] / 2.0f < this.startY + (float)screenHeight)) continue;
            polygon.draw(target, (int)(-this.startX), (int)(-this.startY), (int)(-this.startZ));
        }
    }

    public void createCollision(World box2dWorld, String collisionName, float[] position, float[] dimensions, FXVector[] vertices, FXVector[] edges, DictionaryKeyValue attributes) {
        FXVector positionVector = new FXVector(position[0], position[1]);
        for (int i = 0; i < edges.length; ++i) {
            Body groundBody = Box2DHelper.createBody(box2dWorld, "ground_" + collisionName, false, 0.0f, 0.0f, 0.0f, false, false, false, new FXVector(0.0f, 0.0f), 0.0f, new FXVector(0.0f, 0.0f), true, true, "", null);
            Box2DHelper.createEdgeFixture(groundBody, collisionName + ">edge" + i, Utility.mul(Utility.add(positionVector, vertices[(int)edges[i].xFX]), 1.0f), Utility.mul(Utility.add(positionVector, vertices[(int)edges[i].yFX]), 1.0f), 1.0f, 1, 65535, 0, 1.0f, 0.0f, false, 0.0f, "", attributes);
        }
    }

    public void createSensor(World box2dWorld, String sensorName, float[] position, float radius, DictionaryKeyValue attributes) {
        FXVector positionVector = new FXVector(position[0], position[1]);
        Body sensorBody = Box2DHelper.createBody(box2dWorld, sensorName, false, 0.0f, 0.0f, 0.0f, false, false, false, new FXVector(0.0f, 0.0f), 0.0f, Utility.mul(positionVector, 1.0f), true, true, "sensors", attributes);
        int collisionCategories = attributes.get("filter_categoryBits") == null ? 1 : Integer.parseInt((String)attributes.get("filter_categoryBits"));
        int collidesWith = attributes.get("filter_maskBits") == null ? 65535 : Integer.parseInt((String)attributes.get("filter_maskBits"));
        int collisionGroup = attributes.get("filter_groupIndex") == null ? 0 : Integer.parseInt((String)attributes.get("filter_groupIndex"));
        Box2DHelper.createCircleFixture(sensorBody, sensorName, new FXVector(0.0f, 0.0f), radius * 1.0f, 0.0f, collisionCategories, collidesWith, collisionGroup, 0.0f, 0.0f, true, 0.0f, "sensors", attributes);
    }

    public void createEntity(World box2dWorld, String entityName, float[] position, DictionaryKeyValue attributes, InputStreamReader reader) throws Exception {
        if (((String)attributes.get("entityType")).equals("physicsBody")) {
            this.createPhysicsBody(box2dWorld, entityName, position, attributes, reader);
        } else if (((String)attributes.get("entityType")).equals("physicsJoint")) {
            this.createPhysicsJoint(box2dWorld, entityName, position, attributes, reader);
        } else if (((String)attributes.get("entityType")).equals("physicsImage")) {
            this.createPhysicsImage(box2dWorld, entityName, position, attributes, reader);
        } else if (((String)attributes.get("entityType")).equals("gameObject") && entityName.equals("bike")) {
            Box2DHelper.load(box2dWorld, "/bike_java.json", position[0], position[1], true);
        }
    }

    private void createPhysicsBody(World box2dWorld, String entityName, float[] position, DictionaryKeyValue attributes, InputStreamReader reader) throws Exception {
        float toRadians = (float)Math.PI / 180;
        String name = entityName;
        String type = (String)attributes.get("type");
        float angle = Float.parseFloat((String)attributes.get("angle")) * toRadians;
        float angularDamping = Float.parseFloat((String)attributes.get("angularDamping"));
        float angularVelocity = Float.parseFloat((String)attributes.get("angularVelocity")) * toRadians;
        boolean awake = Utility.parseBoolean((String)attributes.get("awake"));
        boolean bullet = Utility.parseBoolean((String)attributes.get("bullet"));
        boolean fixedRotation = Utility.parseBoolean((String)attributes.get("fixedRotation"));
        float x = Float.parseFloat(Utility.split((String)attributes.get("linearVelocity"), ",")[0]);
        float y = Float.parseFloat(Utility.split((String)attributes.get("linearVelocity"), ",")[1]);
        FXVector linearVelocity = new FXVector(x, y);
        float massData_mass = Float.parseFloat((String)attributes.get("massData-mass"));
        x = Float.parseFloat(Utility.split((String)attributes.get("massData-center"), ",")[0]);
        y = Float.parseFloat(Utility.split((String)attributes.get("massData-center"), ",")[1]);
        FXVector massData_center = new FXVector(x, y);
        float massData_I = Float.parseFloat((String)attributes.get("massData-I"));
        float linearDamping = Float.parseFloat((String)attributes.get("linearDamping"));
        FXVector positionVector = new FXVector(position[0], position[1]);
        positionVector = Utility.mul(positionVector, 1.0f);
        float massData = massData_mass;
        Body body = Box2DHelper.createBody(box2dWorld, name, !type.equals("static"), angle, angularDamping, angularVelocity, awake, bullet, fixedRotation, linearVelocity, linearDamping, positionVector, true, true, "", attributes);
        String fixtureName = entityName;
        float density = Float.parseFloat((String)attributes.get("density"));
        int filter_categoryBits = Integer.parseInt((String)attributes.get("filter-categoryBits"));
        int filter_maskBits = Integer.parseInt((String)attributes.get("filter-maskBits"));
        int filter_groupIndex = Integer.parseInt((String)attributes.get("filter-groupIndex"));
        float friction = Float.parseFloat((String)attributes.get("friction"));
        float restitution = Float.parseFloat((String)attributes.get("restitution"));
        boolean sensor = Utility.parseBoolean((String)attributes.get("sensor"));
        String shape = (String)attributes.get("shape");
        String nextLine = PolygonMap.readLine(reader);
        if (shape.equals("circle")) {
            float radius = Float.parseFloat(this.getValueBetweenStrings(nextLine, "radius: ", "\n"));
            FXVector center = new FXVector(0.0f, 0.0f);
            Box2DHelper.createCircleFixture(body, fixtureName, center, radius *= 1.0f, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, "", attributes);
            nextLine = PolygonMap.readLine(reader);
            if (nextLine.startsWith("texture:")) {
                int[] triangles = new int[]{0, 1, 3, 2, 0, 3};
                FXVector[] uvs = new FXVector[]{new FXVector(0.0f, 1.0f), new FXVector(1.0f, 1.0f), new FXVector(0.0f, 0.0f), new FXVector(1.0f, 0.0f)};
                String file = this.getValueBetweenStrings(nextLine, "texture: ", "\n");
                FXVector[] vertices = new FXVector[]{new FXVector(center.xFX - radius, center.yFX - radius), new FXVector(center.xFX + radius, center.yFX - radius), new FXVector(center.xFX - radius, center.yFX + radius), new FXVector(center.xFX + radius, center.yFX + radius)};
                for (int i = 0; i < vertices.length; ++i) {
                    vertices[i].yFX *= -1.0f;
                    vertices[i] = Utility.scl(vertices[i], 1.0f);
                }
                float opacity = attributes.get("opacity") == null ? 1.0f : Float.parseFloat((String)attributes.get("opacity"));
                float renderOrder = attributes.get("renderOrder") == null ? 0.0f : Float.parseFloat((String)attributes.get("renderOrder"));
                Bitmap bitmap = (Bitmap)this.textures.get(file);
                Box2DHelper.createBodyImage(box2dWorld, file, opacity, renderOrder, 1.0f, 1.0f, 0.0f, body, new FXVector(0.0f, 0.0f), null, bitmap, 0, false, ColorRGBA.White, triangles, uvs, vertices, attributes);
            }
        } else if (shape.equals("polygon")) {
            FXVector[] vertices = this.getVectors2D(Utility.split(this.getValueBetweenStrings(nextLine, "vertices: (", ")\n"), "),("));
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = Utility.mul(vertices[i], 1.0f);
            }
            Debug.print("create=" + entityName);
            FXVector[] verts = Utility.getSortedPointsClockwise(vertices);
            Box2DHelper.createPolygonFixture(body, fixtureName, verts, density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, "", attributes);
            nextLine = PolygonMap.readLine(reader);
            if (nextLine.startsWith("triangles:")) {
                int[] triangles = this.typeCastAsInteger(Utility.split(this.getValueBetweenStrings(nextLine, "triangles: ", "\n"), ","));
                FXVector[] uvs = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "uvs: (", ")\n"), "),("));
                String file = this.getValueBetweenStrings(PolygonMap.readLine(reader), "texture: ", "\n");
                for (int i = 0; i < vertices.length; ++i) {
                    vertices[i].yFX *= -1.0f;
                    vertices[i] = Utility.mul(vertices[i], 1.0f);
                }
                float opacity = attributes.get("opacity") == null ? 1.0f : Float.parseFloat((String)attributes.get("opacity"));
                float renderOrder = attributes.get("renderOrder") == null ? 0.0f : Float.parseFloat((String)attributes.get("renderOrder"));
                Bitmap bitmap = (Bitmap)this.textures.get(file);
                Box2DHelper.createBodyImage(box2dWorld, file, opacity, renderOrder, 1.0f, 1.0f, 0.0f, body, new FXVector(0.0f, 0.0f), null, bitmap, 0, false, new ColorRGBA(255, 255, 255, 255), triangles, uvs, vertices, attributes);
            }
        } else if (shape.equals("edge")) {
            FXVector[] vertices = this.getVectors2D(Utility.split(this.getValueBetweenStrings(nextLine, "vertices: (", ")\n"), "),("));
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = Utility.mul(vertices[i], 1.0f);
            }
            Box2DHelper.createEdgeFixture(body, fixtureName, vertices[0], vertices[1], density, filter_categoryBits, filter_maskBits, filter_groupIndex, friction, restitution, sensor, massData, "", attributes);
        }
    }

    private void createPhysicsJoint(World box2dWorld, String entityName, float[] position, DictionaryKeyValue attributes, InputStreamReader reader) {
        float toRadians = (float)Math.PI / 180;
        String type = (String)attributes.get("jointType");
        String jointName = entityName;
        Body bodyA = (Body)Box2DHelper.bodies.get(">" + (String)attributes.get("bodyA"));
        Body bodyB = (Body)Box2DHelper.bodies.get(">" + (String)attributes.get("bodyB"));
        float x = Float.parseFloat(Utility.split((String)attributes.get("worldAnchorA"), ",")[0]);
        float y = Float.parseFloat(Utility.split((String)attributes.get("worldAnchorA"), ",")[1]);
        FXVector anchorA = new FXVector(x, y);
        anchorA = Utility.mul(anchorA, 1.0f);
        anchorA = Utility.sub(anchorA, bodyA.positionFX());
        x = Float.parseFloat(Utility.split((String)attributes.get("worldAnchorB"), ",")[0]);
        y = Float.parseFloat(Utility.split((String)attributes.get("worldAnchorB"), ",")[1]);
        FXVector anchorB = new FXVector(x, y);
        anchorB = Utility.mul(anchorB, 1.0f);
        anchorB = Utility.sub(anchorB, bodyB.positionFX());
        boolean collideConnected = Utility.parseBoolean((String)attributes.get("collideConnected"));
        DictionaryKeyValue jointCustomProperties = attributes;
        if (type.equals("revolute")) {
            boolean enableLimit = Utility.parseBoolean((String)attributes.get("enableLimit"));
            boolean enableMotor = Utility.parseBoolean((String)attributes.get("enableMotor"));
            float jointSpeed = Float.parseFloat((String)attributes.get("jointSpeed"));
            float lowerLimit = Float.parseFloat((String)attributes.get("lowerLimit")) * toRadians;
            float maxMotorTorque = Float.parseFloat((String)attributes.get("maxMotorTorque"));
            float motorSpeed = Float.parseFloat((String)attributes.get("motorSpeed")) * toRadians;
            float refAngle = Float.parseFloat((String)attributes.get("refAngle")) * toRadians;
            float upperLimit = Float.parseFloat((String)attributes.get("upperLimit")) * toRadians;
            Box2DHelper.createRevoluteJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, collideConnected, enableLimit, enableMotor, lowerLimit, maxMotorTorque, motorSpeed, refAngle, upperLimit, "", jointCustomProperties);
        } else if (type.equals("distance")) {
            float dampingRatio = Float.parseFloat((String)attributes.get("dampingRatio"));
            float frequency = Float.parseFloat((String)attributes.get("frequency"));
            float length = Float.parseFloat((String)attributes.get("length")) * 1.0f;
            Box2DHelper.createDistanceJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, collideConnected, dampingRatio, frequency, length, "", jointCustomProperties);
        } else if (type.equals("prismatic")) {
            boolean enableLimit = Utility.parseBoolean((String)attributes.get("enableLimit"));
            boolean enableMotor = Utility.parseBoolean((String)attributes.get("enableMotor"));
            x = Float.parseFloat(Utility.split((String)attributes.get("localAxisA"), ",")[0]);
            y = Float.parseFloat(Utility.split((String)attributes.get("localAxisA"), ",")[1]);
            FXVector localAxisA = new FXVector(x, y);
            float lowerLimit = Float.parseFloat((String)attributes.get("lowerLimit"));
            float maxMotorForce = Float.parseFloat((String)attributes.get("maxMotorForce"));
            float motorSpeed = Float.parseFloat((String)attributes.get("motorSpeed"));
            float refAngle = Float.parseFloat((String)attributes.get("refAngle")) * toRadians;
            float upperLimit = Float.parseFloat((String)attributes.get("upperLimit"));
            Box2DHelper.createPrismaticJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, localAxisA, collideConnected, enableLimit, enableMotor, lowerLimit, maxMotorForce, motorSpeed, refAngle, upperLimit, "", jointCustomProperties);
        } else if (type.equals("wheel")) {
            boolean enableMotor = Utility.parseBoolean((String)attributes.get("enableMotor"));
            x = Float.parseFloat(Utility.split((String)attributes.get("localAxisA"), ",")[0]);
            y = Float.parseFloat(Utility.split((String)attributes.get("localAxisA"), ",")[1]);
            FXVector localAxisA = new FXVector(x, y);
            float maxMotorTorque = Float.parseFloat((String)attributes.get("maxMotorTorque"));
            float motorSpeed = Float.parseFloat((String)attributes.get("motorSpeed")) * toRadians;
            float springDampingRatio = Float.parseFloat((String)attributes.get("springDampingRatio"));
            float springFrequency = Float.parseFloat((String)attributes.get("springFrequency"));
            Box2DHelper.createWheelJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, localAxisA, collideConnected, enableMotor, maxMotorTorque, motorSpeed, springDampingRatio, springFrequency, "", jointCustomProperties);
        } else if (type.equals("rope")) {
            float maxlength = Float.parseFloat((String)attributes.get("maxlength"));
            Box2DHelper.createRopeJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, collideConnected, maxlength, "", jointCustomProperties);
        } else if (type.equals("motor")) {
            float maxForce = Float.parseFloat((String)attributes.get("maxForce"));
            float maxTorque = Float.parseFloat((String)attributes.get("maxTorque"));
            float correctionFactor = Float.parseFloat((String)attributes.get("correctionFactor"));
            Box2DHelper.createMotorJoint(box2dWorld, jointName, bodyA, bodyB, collideConnected, maxForce, maxTorque, "", jointCustomProperties);
        } else if (type.equals("weld")) {
            float refAngle = Float.parseFloat((String)attributes.get("refAngle")) * toRadians;
            float dampingRatio = Float.parseFloat((String)attributes.get("dampingRatio"));
            float frequency = Float.parseFloat((String)attributes.get("frequency"));
            Box2DHelper.createWeldJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, collideConnected, refAngle, dampingRatio, frequency, "", jointCustomProperties);
        } else if (type.equals("friction")) {
            float maxForce = Float.parseFloat((String)attributes.get("maxForce"));
            float maxTorque = Float.parseFloat((String)attributes.get("maxTorque"));
            Box2DHelper.createFrictionJoint(box2dWorld, jointName, bodyA, bodyB, anchorA, anchorB, collideConnected, maxForce, maxTorque, "", jointCustomProperties);
        }
    }

    private void createPhysicsImage(World box2dWorld, String entityName, float[] position, DictionaryKeyValue attributes, InputStreamReader reader) throws Exception {
        Body body = (Body)Box2DHelper.bodies.get(">" + (String)attributes.get("body"));
        FXVector[] vertices = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "vertices: (", ")\n"), "),("));
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i].xFX += -body.positionFX().xFX * 1.0f + position[0];
            vertices[i].yFX += body.positionFX().yFX * 1.0f - position[1];
            vertices[i].yFX *= -1.0f;
        }
        int[] triangles = this.typeCastAsInteger(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "triangles: ", "\n"), ","));
        FXVector[] uvs = this.getVectors2D(Utility.split(this.getValueBetweenStrings(PolygonMap.readLine(reader), "uvs: (", ")\n"), "),("));
        String file = this.getValueBetweenStrings(PolygonMap.readLine(reader), "texture: ", "\n");
        float opacity = attributes.get("opacity") == null ? 1.0f : Float.parseFloat((String)attributes.get("opacity"));
        float renderOrder = attributes.get("renderOrder") == null ? 0.0f : Float.parseFloat((String)attributes.get("renderOrder"));
        Bitmap bitmap = (Bitmap)this.textures.get(file);
        FXVector center = new FXVector(position[0], position[1]);
        center = Utility.mul(center, 1.0f);
        Box2DHelper.createBodyImage(box2dWorld, file, opacity, renderOrder, 1.0f, 1.0f, 0.0f, body, center, null, bitmap, 0, false, new ColorRGBA(255, 255, 255, 255), triangles, uvs, vertices, attributes);
    }

    public void deallocate() {
    }

    private void loadTextures(String line) {
        String[] texturesToLoad = Utility.split(this.getValueBetweenStrings(line, "textures: ", "\n"), ",");
        for (int i = 0; i < texturesToLoad.length; ++i) {
            if (texturesToLoad[i].trim().equals("")) continue;
            Debug.print("Loading Texture: " + texturesToLoad[i], (short)1);
            Bitmap texture = new Bitmap("/mapData/" + texturesToLoad[i]);
            this.textures.put(texturesToLoad[i], texture);
        }
    }

    private static String readLine(InputStreamReader reader) throws IOException {
        StringBuffer string = new StringBuffer("");
        while (true) {
            int readChar;
            if ((readChar = reader.read()) == -1) {
                return null;
            }
            if (readChar == 13) continue;
            if (readChar == 10) break;
            string.append((char)readChar);
        }
        string.append('\n');
        return string.toString();
    }

    private String getValueBetweenStrings(String from, String startTag, String endTag) {
        int startIndex = from.indexOf(startTag) + startTag.length();
        int endIndex = from.indexOf(endTag);
        if (startIndex == -1 || endIndex == -1) {
            return null;
        }
        return from.substring(startIndex, endIndex);
    }

    private float[] getVector(String line) {
        String[] cordinates = Utility.split(line, ",");
        float f1 = Float.parseFloat(cordinates[0].trim());
        float f2 = Float.parseFloat(cordinates[1].trim());
        float f3 = Float.parseFloat(cordinates[2].trim());
        return new float[]{f1, f2, f3};
    }

    private Vector3[] getVectors(String[] lines) {
        Vector3[] vectors = new Vector3[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            float[] vector = this.getVector(lines[i]);
            vectors[i] = new Vector3(vector[0], vector[1], vector[2]);
        }
        return vectors;
    }

    private float[] getVector2D(String line) {
        String[] cordinates = Utility.split(line, ",");
        float f1 = Float.parseFloat(cordinates[0].trim());
        float f2 = Float.parseFloat(cordinates[1].trim());
        return new float[]{f1, f2};
    }

    private FXVector[] getVectors2D(String[] lines) {
        FXVector[] vectors = new FXVector[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            float[] vector = this.getVector2D(lines[i]);
            vectors[i] = new FXVector(vector[0], vector[1]);
        }
        return vectors;
    }

    private int[] typeCastAsInteger(String[] strings) {
        int[] numbers = new int[strings.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = Integer.parseInt(strings[i]);
        }
        return numbers;
    }

    private DictionaryKeyValue getAttributes(String line) {
        DictionaryKeyValue attributes = new DictionaryKeyValue();
        String attributeLine = this.getValueBetweenStrings(line, "attributes: (", ")\n");
        if (attributeLine != null) {
            String[] pairs = Utility.split(attributeLine, ");(");
            for (int i = 0; i < pairs.length; ++i) {
                String[] pair = Utility.split(pairs[i], "=");
                attributes.put(pair[0], pair[1]);
            }
        }
        return attributes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

