/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.PointFloat;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.SpriteFrame;
import javax.microedition.m3g.Transform;

public class Utility3D {
    public static float[] matrix = new float[16];

    public static void copy(float[] src, float[] dest) {
        for (int i = 0; i < src.length; ++i) {
            dest[i] = src[i];
        }
    }

    public static float dotProduct(float[] v, float[] u) {
        return v[0] * u[0] + v[1] * u[1] + v[2] * u[2];
    }

    public static void transpose(float[][] matrix, float[][] result) {
        int m = matrix.length;
        int n = matrix[0].length;
        for (int c2 = 0; c2 < m; ++c2) {
            for (int d2 = 0; d2 < n; ++d2) {
                result[d2][c2] = matrix[c2][d2];
            }
        }
    }

    public static void crossProduct(float[] v, float[] u, float[] resultVector) {
        resultVector[0] = v[1] * u[2] - v[2] * u[1];
        resultVector[1] = v[2] * u[0] - v[0] * u[2];
        resultVector[2] = v[0] * u[1] - v[1] * u[0];
    }

    public static float magnitudeOfVector(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static float squaredMagnitudeOfVector(float[] v) {
        return v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
    }

    public static void subtractVectors(float[] v, float[] u, float[] resultVector) {
        resultVector[0] = v[0] - u[0];
        resultVector[1] = v[1] - u[1];
        resultVector[2] = v[2] - u[2];
    }

    public static void normalizeVector(float[] v, float[] result) {
        float len = Utility3D.magnitudeOfVector(v);
        result[0] = v[0] / len;
        result[1] = v[1] / len;
        result[2] = v[2] / len;
    }

    public static void scalarMultiplication(float scalar, float[] v) {
        v[0] = v[0] * scalar;
        v[1] = v[1] * scalar;
        v[2] = v[2] * scalar;
    }

    public static void scalarMultiplication(float scalarX, float scalarY, float scalarZ, float[] v) {
        v[0] = v[0] * scalarX;
        v[1] = v[1] * scalarY;
        v[2] = v[2] * scalarZ;
    }

    public static void printVector(float[] v) {
        Debug.print("(" + v[0] + ", " + v[1] + ", " + v[2] + ")");
    }

    public static void postRotateAboutLocalAxis(Transform t, float angleX, float angleY, float angleZ) {
        float zCordinate;
        float yCordinate;
        float xCordinate;
        if (angleX != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleX, 1.0f, 0.0f, 0.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (angleY != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleY, 0.0f, 1.0f, 0.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (angleZ != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleZ, 0.0f, 0.0f, 1.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
    }

    public static void postRotateAboutLocalAxis(Transform t, float[] rotation) {
        float zCordinate;
        float yCordinate;
        float xCordinate;
        if (rotation[0] != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(rotation[0], 1.0f, 0.0f, 0.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (rotation[1] != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(rotation[1], 0.0f, 1.0f, 0.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (rotation[2] != 0.0f) {
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            Utility3D.matrix[11] = 0.0f;
            Utility3D.matrix[7] = 0.0f;
            Utility3D.matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(rotation[2], 0.0f, 0.0f, 1.0f);
            t.get(matrix);
            Utility3D.matrix[3] = xCordinate;
            Utility3D.matrix[7] = yCordinate;
            Utility3D.matrix[11] = zCordinate;
            t.set(matrix);
        }
    }

    public static void postTranslateAboutGlobalAxis(Transform t, float x, float y, float z) {
        t.get(matrix);
        matrix[3] = matrix[3] + x;
        matrix[7] = matrix[7] + y;
        matrix[11] = matrix[11] + z;
        t.set(matrix);
    }

    public static void postRotateAboutLineParallelToXaxisInXYplane(Transform t, float yIntercept, float angle) {
        t.get(matrix);
        float xCordinate = matrix[3];
        float yCordinate = matrix[7];
        float zCordinate = matrix[11];
        Utility3D.matrix[11] = 0.0f;
        Utility3D.matrix[7] = 0.0f;
        Utility3D.matrix[3] = 0.0f;
        Utility3D.matrix[7] = yIntercept;
        t.set(matrix);
        t.postRotate(angle, 1.0f, 0.0f, 0.0f);
        t.get(matrix);
        Utility3D.matrix[3] = xCordinate;
        Utility3D.matrix[7] = yCordinate;
        Utility3D.matrix[11] = zCordinate;
        t.set(matrix);
    }

    public static void postTranslateAboutGlobalAxis(Transform t, float[] vector) {
        t.get(matrix);
        matrix[3] = matrix[3] + vector[0];
        matrix[7] = matrix[7] + vector[1];
        matrix[11] = matrix[11] + vector[2];
        t.set(matrix);
    }

    public static void setTranslate(Transform t, float x, float y, float z) {
        t.get(matrix);
        Utility3D.matrix[3] = x;
        Utility3D.matrix[7] = y;
        Utility3D.matrix[11] = z;
        t.set(matrix);
    }

    public static void setTranslate(Transform t, float[] position) {
        t.get(matrix);
        Utility3D.matrix[3] = position[0];
        Utility3D.matrix[7] = position[1];
        Utility3D.matrix[11] = position[2];
        t.set(matrix);
    }

    public static void setTranslateY(Transform t, float y) {
        t.get(matrix);
        Utility3D.matrix[7] = y;
        t.set(matrix);
    }

    public static void setTranslateZ(Transform t, float z) {
        t.get(matrix);
        Utility3D.matrix[11] = z;
        t.set(matrix);
    }

    public static void setScale(Transform t, float[] scale) {
        t.get(matrix);
        Utility3D.matrix[0] = scale[0];
        Utility3D.matrix[5] = scale[1];
        Utility3D.matrix[10] = scale[2];
        t.set(matrix);
    }

    public static void printPosition(Transform t) {
        float[] position = new float[3];
        Utility3D.getPosition(t, position);
        Debug.print("(" + position[0] + "," + position[1] + "," + position[2] + ")");
    }

    public static void getPosition(Transform t, float[] position) {
        t.get(matrix);
        position[0] = matrix[3];
        position[1] = matrix[7];
        position[2] = matrix[11];
    }

    public static float[] getNewVector(float x, float y, float z) {
        float[] vector = new float[]{x, y, z};
        return vector;
    }

    public static short[] scaleArrayElements(short[] array, float scaleFactor) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)((float)array[i] * scaleFactor);
        }
        return newArray;
    }

    public static short[] scaleArrayElements(short[] array, float[] scaleFactor) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; i += 3) {
            newArray[i] = (short)((float)array[i] * scaleFactor[0]);
            newArray[i + 1] = (short)((float)array[i + 1] * scaleFactor[1]);
            newArray[i + 2] = (short)((float)array[i + 2] * scaleFactor[2]);
        }
        return newArray;
    }

    public static short[] translateArrayElements(short[] array, float x, float y, float z) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; i += 3) {
            newArray[i] = (short)((float)array[i] + x * 255.0f);
            newArray[i + 1] = (short)((float)array[i + 1] + y * 255.0f);
            newArray[i + 2] = (short)((float)array[i + 2] + z * 255.0f);
        }
        return newArray;
    }

    public static short[] translateArrayElements(short[] array, float[] translation) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; i += 3) {
            newArray[i] = (short)((float)array[i] + translation[0] * 255.0f);
            newArray[i + 1] = (short)((float)array[i + 1] + translation[1] * 255.0f);
            newArray[i + 2] = (short)((float)array[i + 2] + translation[2] * 255.0f);
        }
        return newArray;
    }

    public static short maxX(short[] array) {
        short maxValue = array[0];
        for (int i = 3; i < array.length; i += 3) {
            if (array[i] <= maxValue) continue;
            maxValue = array[i];
        }
        return maxValue;
    }

    public static short maxY(short[] array) {
        short maxValue = array[1];
        for (int i = 4; i < array.length; i += 3) {
            if (array[i] <= maxValue) continue;
            maxValue = array[i];
        }
        return maxValue;
    }

    public static short maxZ(short[] array) {
        short maxValue = array[2];
        for (int i = 5; i < array.length; i += 3) {
            if (array[i] <= maxValue) continue;
            maxValue = array[i];
        }
        return maxValue;
    }

    public static float[] getDimensions(short[] array) {
        float[] dimensions = new float[]{(float)(Utility3D.maxX(array) - Utility3D.minX(array)) / 128.0f, (float)(Utility3D.maxY(array) - Utility3D.minY(array)) / 128.0f, (float)(Utility3D.maxZ(array) - Utility3D.minZ(array)) / 128.0f};
        return dimensions;
    }

    public static short minX(short[] array) {
        short minValue = array[0];
        for (int i = 3; i < array.length; i += 3) {
            if (array[i] >= minValue) continue;
            minValue = array[i];
        }
        return minValue;
    }

    public static short minY(short[] array) {
        short minValue = array[1];
        for (int i = 4; i < array.length; i += 3) {
            if (array[i] >= minValue) continue;
            minValue = array[i];
        }
        return minValue;
    }

    public static short minZ(short[] array) {
        short minValue = array[2];
        for (int i = 5; i < array.length; i += 3) {
            if (array[i] >= minValue) continue;
            minValue = array[i];
        }
        return minValue;
    }

    public static SpriteFrame[][] stretchArray(SpriteFrame[][] src, int expandby) {
        SpriteFrame[][] dest = new SpriteFrame[src.length + expandby][];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static void setLookAt(Transform cameraTransform, float[] position, float[] look) throws NullPointerException, IllegalArgumentException {
        int i;
        Utility3D.setTranslateZ(cameraTransform, 0.0f);
        float[] up = new float[]{0.0f, 1.0f, 0.0f};
        float[] lookOrient = new float[3];
        float[] normLook = new float[3];
        float[] normUp = new float[3];
        float[] tempS = new float[3];
        float[] tempU = new float[3];
        float tempValue = 0.0f;
        if (position == null || look == null || up == null) {
            throw new NullPointerException();
        }
        if (position.length != 3 || look.length != 3 || up.length != 3) {
            throw new IllegalArgumentException();
        }
        if (up[0] == 0.0f && up[1] == 0.0f && up[2] == 0.0f) {
            throw new IllegalArgumentException();
        }
        if (position[0] == look[0] && position[1] == look[1] && position[2] == look[2]) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < position.length; ++i) {
            lookOrient[i] = look[i] - position[i];
        }
        tempValue = (float)Math.sqrt(lookOrient[0] * lookOrient[0] + lookOrient[1] * lookOrient[1] + lookOrient[2] * lookOrient[2]);
        for (i = 0; i < lookOrient.length; ++i) {
            normLook[i] = lookOrient[i] / tempValue;
        }
        tempValue = (float)Math.sqrt(up[0] * up[0] + up[1] * up[1] + up[2] * up[2]);
        for (i = 0; i < up.length; ++i) {
            normUp[i] = up[i] / tempValue;
        }
        tempS[0] = normLook[1] * normUp[2] - normLook[2] * normUp[1];
        tempS[1] = normLook[2] * normUp[0] - normLook[0] * normUp[2];
        tempS[2] = normLook[0] * normUp[1] - normLook[1] * normUp[0];
        tempU[0] = tempS[1] * normLook[2] - tempS[2] * normLook[1];
        tempU[1] = tempS[2] * normLook[0] - tempS[0] * normLook[2];
        tempU[2] = tempS[0] * normLook[1] - tempS[1] * normLook[0];
        float[] temp = new float[]{tempS[0], tempU[0], -1.0f * normLook[0], position[0], tempS[1], tempU[1], -1.0f * normLook[1], position[1], tempS[2], tempU[2], -1.0f * normLook[2], position[2], 0.0f, 0.0f, 0.0f, 1.0f};
        cameraTransform.set(temp);
    }

    public static boolean isVectorsEqual(float[] vector1, float[] vector2) {
        return vector1[0] == vector2[0] && vector1[1] == vector2[1] && vector1[2] == vector2[2];
    }

    public static void getRotatedPoints(PointFloat[] points, float anchorX, float anchorY, float angle, PointFloat[] result) {
        for (int i = 0; i < points.length; ++i) {
            if (result[i] == null) {
                result[i] = new PointFloat();
            }
            result[i].x = Utility.getRotatedPointX(anchorX, anchorY, points[i].x, points[i].y, angle);
            result[i].y = Utility.getRotatedPointY(anchorX, anchorY, points[i].x, points[i].y, angle);
        }
    }

    public static float[] getVector(float x, float y, float z) {
        float[] vector = new float[]{x, y, z};
        return vector;
    }

    public static Transform createPixelPerfectProjectionMatrix(float right, float left, float top, float bottom, float far, float near) {
        float x_orth = 2.0f / (right - left);
        float y_orth = 2.0f / (top - bottom);
        float z_orth = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        float[] val = new float[]{x_orth, 0.0f, 0.0f, 0.0f, 0.0f, y_orth, 0.0f, 0.0f, 0.0f, 0.0f, z_orth, 0.0f, tx, ty, tz, 1.0f};
        Transform projMatrix = new Transform();
        projMatrix.set(val);
        return projMatrix;
    }

    public static ArrayList getTrianglesFromStrip(short[] vertices, short[] uvs, int[] triangleStrips) {
        int i;
        short[] verts = new short[triangleStrips.length * 3];
        short[] textures = new short[triangleStrips.length * 2];
        int[] stripLengths = new int[triangleStrips.length / 3];
        int j = 0;
        int k = 0;
        for (i = 0; i < triangleStrips.length; ++i) {
            verts[j++] = vertices[triangleStrips[i] * 3];
            verts[j++] = vertices[triangleStrips[i] * 3 + 1];
            verts[j++] = vertices[triangleStrips[i] * 3 + 2];
            textures[k++] = uvs[triangleStrips[i] * 2];
            textures[k++] = uvs[triangleStrips[i] * 2 + 1];
        }
        for (i = 0; i < stripLengths.length; ++i) {
            stripLengths[i] = 3;
        }
        ArrayList list = new ArrayList(3);
        list.addElement(verts);
        list.addElement(textures);
        list.addElement(stripLengths);
        return list;
    }
}

