/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.yourgamename.CreditComponent;
import javax.microedition.lcdui.Graphics;

public class CreditCategory
extends CreditComponent {
    private static GameFont font;
    private static int drawOffset;
    ArrayList creditComponents = new ArrayList();
    private String creditCategoryName;

    public CreditCategory(String creditCategoryName) {
        this.creditCategoryName = creditCategoryName.toUpperCase();
    }

    public void add(CreditComponent newAboutComponent) {
        this.creditComponents.addElement(newAboutComponent);
    }

    CreditComponent getAboutComponent(int componentIndex) {
        return (CreditComponent)this.creditComponents.elementAt(componentIndex);
    }

    public void setPositionY(float py) {
        this.top = py;
        float nameY = this.top + (float)this.getFont().stringHeight() + (float)drawOffset;
        for (int i = 0; i < this.creditComponents.size(); ++i) {
            CreditComponent creditComponent = this.getAboutComponent(i);
            creditComponent.setPositionY(nameY);
            nameY = creditComponent.getBottom();
            if (i != this.creditComponents.size() - 1) continue;
            nameY += (float)drawOffset;
        }
        this.bottom = nameY;
    }

    void paint(Graphics g2) {
        int x = GameManager.screenWidth / 2 - font.stringWidth(this.creditCategoryName) / 2;
        font.drawString(this.creditCategoryName, g2, x, (int)this.getTop());
        for (int i = 0; i < this.creditComponents.size(); ++i) {
            this.getAboutComponent(i).paint(g2);
        }
    }

    public GameFont getFont() {
        return font;
    }

    public static void setFont(GameFont creditCategoryFont, int offsetForDraw) {
        font = creditCategoryFont;
        drawOffset = offsetForDraw;
    }

    public static void deallocate() {
        font = null;
    }
}

