/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Random;

public class ParticleEmitter {
    private float b = 1.0f;
    private float c = 0.0f;
    private float d;
    private float e;
    private float f = 0.0f;
    private float g = 0.0f;
    private float h = 0.0f;
    protected int mMaxParticleCount = 0;
    private float i = 0.5f;
    private float j = 1.0f;
    private float k = 0.0f;
    private Body l;
    private FXVector m;
    private FXVector n;
    private boolean o;
    private float p = 1.0f;
    private float q = 0.0f;
    private float r = 0.0f;
    private float s = 0.0f;
    boolean a = true;
    protected float[] mXFX;
    protected float[] mYFX;
    protected float[] mXPrevFX;
    protected float[] mYPrevFX;
    protected short[] mLife;
    private Random t = new Random();
    private static FXMatrix u = new FXMatrix();
    private static FXVector v = new FXVector();
    private static FXVector w = new FXVector();
    protected UserData mUserData = null;

    private ParticleEmitter(int n) {
        this.setMaxParticleCount(n);
    }

    public ParticleEmitter(int n, float f2, float f3, float f4, float f5, Body body, FXVector fXVector, FXVector fXVector2, float f6, float f7, float f8, float f9, boolean bl, float f10, float f11, float f12, float f13) {
        this(n);
        this.b = f2;
        this.c = f3;
        this.d = f13 * f2;
        this.e = f13 * f3;
        this.g = f4;
        this.h = f5;
        this.d = f13 * this.b;
        this.e = f13 * this.c;
        this.l = body;
        this.m = fXVector;
        this.n = fXVector2;
        this.o = bl;
        this.p = f6;
        this.q = f7;
        this.r = f8;
        this.s = f9;
        this.i = f10;
        this.j = f11;
        this.k = f12;
    }

    public ParticleEmitter(ParticleEmitter particleEmitter) {
        this(particleEmitter.mMaxParticleCount);
        this.b = particleEmitter.b;
        this.d = particleEmitter.d;
        this.c = particleEmitter.c;
        this.e = particleEmitter.e;
        this.g = particleEmitter.g;
        this.h = particleEmitter.h;
        this.l = particleEmitter.l;
        this.m = particleEmitter.m;
        this.n = particleEmitter.n;
        this.o = particleEmitter.o;
        this.p = particleEmitter.p;
        this.q = particleEmitter.q;
        this.r = particleEmitter.r;
        this.s = particleEmitter.s;
        this.i = particleEmitter.i;
        this.j = particleEmitter.j;
        this.k = particleEmitter.k;
        if (particleEmitter.mUserData != null) {
            this.mUserData = particleEmitter.mUserData.copy();
        }
    }

    private ParticleEmitter() {
    }

    public ParticleEmitter copy(Body[] bodyArray) {
        ParticleEmitter particleEmitter = new ParticleEmitter(this);
        if (this.l != null) {
            particleEmitter.l = bodyArray == null ? this.l : bodyArray[this.l.mId];
        }
        return particleEmitter;
    }

    protected final void createParticle(int n, float f2) {
        float f3 = this.t.nextFloat();
        if (this.l == null) {
            this.mXFX[n] = this.m.xFX + f3 * (this.n.xFX - this.m.xFX);
            this.mYFX[n] = this.m.yFX + f3 * (this.n.yFX - this.m.yFX);
        } else if (this.o) {
            this.mXFX[n] = this.l.mPositionFX.xFX + this.m.xFX + f3 * (this.n.xFX - this.m.xFX);
            this.mYFX[n] = this.l.mPositionFX.yFX + this.m.yFX + f3 * (this.n.yFX - this.m.yFX);
        } else {
            v.assignFX(this.m.xFX + f3 * (this.n.xFX - this.m.xFX), this.m.yFX + f3 * (this.n.yFX - this.m.yFX));
            this.l.getRotationMatrix().mult(v, w);
            this.mXFX[n] = ParticleEmitter.w.xFX + this.l.mPositionFX.xFX;
            this.mYFX[n] = ParticleEmitter.w.yFX + this.l.mPositionFX.yFX;
        }
        f3 = this.t.nextFloat() - 0.5f;
        f3 = this.r + this.s * f3;
        if (!this.o && this.l != null) {
            f3 += this.l.mRotation2FX;
        }
        f3 = FXUtil.wrapAngleFX(f3);
        u.setRotationMatrix(f3);
        f3 = this.t.nextFloat() - 0.5f;
        u.mult(this.p + this.q * f3, 0.0f, v);
        FXVector fXVector = v;
        if (this.l != null) {
            fXVector.xFX += this.l.mVelocityFX.xFX;
            fXVector.yFX += this.l.mVelocityFX.yFX;
        }
        fXVector.multFX(f2);
        this.mXPrevFX[n] = this.mXFX[n] - fXVector.xFX;
        this.mYPrevFX[n] = this.mYFX[n] - fXVector.yFX;
    }

    protected void createParticles(float f2) {
        int n = this.a(0);
        while (this.f < this.d && n != -1) {
            float f3 = this.g + (this.t.nextFloat() - 0.5f) * this.h;
            this.mLife[n] = (short)FXUtil.divideFX(f3, f2);
            this.createParticle(n, f2);
            this.f += 1.0f;
            n = this.a(n);
        }
        f2 = this.t.nextFloat() - 0.5f;
        this.f = Math.max(0.0f, this.f - this.d - f2 * this.e);
    }

    private final int a(int n) {
        while (n < this.mMaxParticleCount) {
            if (this.mLife[n] <= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void integrateParticles(float f2) {
        float f3;
        float f4;
        int n;
        this.createParticles(f2);
        f2 = 1.0f - this.k;
        for (n = 0; n < this.mMaxParticleCount; ++n) {
            if (this.mLife[n] <= 0) continue;
            f4 = this.mXFX[n];
            f3 = this.mYFX[n];
            if (f2 != 1.0f) {
                int n2 = n;
                this.mXFX[n2] = this.mXFX[n2] + f2 * (this.mXFX[n] - this.mXPrevFX[n]);
                int n3 = n;
                this.mYFX[n3] = this.mYFX[n3] + f2 * (this.mYFX[n] - this.mYPrevFX[n]);
            } else {
                int n4 = n;
                this.mXFX[n4] = this.mXFX[n4] + (this.mXFX[n] - this.mXPrevFX[n]);
                int n5 = n;
                this.mYFX[n5] = this.mYFX[n5] + (this.mYFX[n] - this.mYPrevFX[n]);
            }
            this.mXPrevFX[n] = f4;
            this.mYPrevFX[n] = f3;
            int n6 = n;
            this.mLife[n6] = (short)(this.mLife[n6] - 1);
        }
        ParticleEmitter particleEmitter = this;
        f4 = 0.0f;
        f3 = 0.0f;
        n = 0;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n7 = 0;
        for (int i = 1; i < particleEmitter.mMaxParticleCount; ++i) {
            if (particleEmitter.mLife[i] <= 0) continue;
            f4 = particleEmitter.mXFX[i];
            f3 = particleEmitter.mYFX[i];
            n = particleEmitter.mLife[i];
            f5 = particleEmitter.mXPrevFX[i];
            f6 = particleEmitter.mYPrevFX[i];
            for (n7 = i - 1; n7 >= 0 && (particleEmitter.mXFX[n7] > f4 || particleEmitter.mLife[n7] <= 0); --n7) {
                particleEmitter.mXFX[n7 + 1] = particleEmitter.mXFX[n7];
                particleEmitter.mYFX[n7 + 1] = particleEmitter.mYFX[n7];
                particleEmitter.mLife[n7 + 1] = particleEmitter.mLife[n7];
                particleEmitter.mXPrevFX[n7 + 1] = particleEmitter.mXPrevFX[n7];
                particleEmitter.mYPrevFX[n7 + 1] = particleEmitter.mYPrevFX[n7];
            }
            particleEmitter.mXFX[n7 + 1] = f4;
            particleEmitter.mYFX[n7 + 1] = f3;
            particleEmitter.mLife[n7 + 1] = n;
            particleEmitter.mXPrevFX[n7 + 1] = f5;
            particleEmitter.mYPrevFX[n7 + 1] = f6;
        }
    }

    public void applyAcceleration(FXVector fXVector, float f2) {
        f2 = f2 * f2 * this.j;
        for (int i = 0; i < this.mMaxParticleCount; ++i) {
            if (this.mLife[i] <= 0) continue;
            int n = i;
            this.mXFX[n] = this.mXFX[n] + f2 * fXVector.xFX;
            int n2 = i;
            this.mYFX[n2] = this.mYFX[n2] + f2 * fXVector.yFX;
        }
    }

    protected void collide(FXVector fXVector, int n) {
        int n2 = n;
        this.mXFX[n2] = this.mXFX[n2] - fXVector.xFX;
        int n3 = n;
        this.mYFX[n3] = this.mYFX[n3] - fXVector.yFX;
        int n4 = n;
        this.mXPrevFX[n4] = this.mXPrevFX[n4] - fXVector.xFX;
        int n5 = n;
        this.mYPrevFX[n5] = this.mYPrevFX[n5] - fXVector.yFX;
        fXVector.normalizeFast();
        w.assignFX(this.mXFX[n] - this.mXPrevFX[n], this.mYFX[n] - this.mYPrevFX[n]);
        v.assign(fXVector);
        v.multFX(ParticleEmitter.w.xFX * fXVector.xFX + ParticleEmitter.w.yFX * fXVector.yFX);
        int n6 = n;
        this.mXPrevFX[n6] = this.mXPrevFX[n6] + ParticleEmitter.v.xFX;
        int n7 = n;
        this.mYPrevFX[n7] = this.mYPrevFX[n7] + ParticleEmitter.v.yFX;
        v.multFX(this.i);
        int n8 = n;
        this.mXFX[n8] = this.mXFX[n8] - ParticleEmitter.v.xFX;
        int n9 = n;
        this.mYFX[n9] = this.mYFX[n9] - ParticleEmitter.v.yFX;
    }

    public float getCreationRateFX() {
        return this.b;
    }

    public float getCreationRateDeviationFX() {
        return this.c;
    }

    public float getAvgLifeTimeFX() {
        return this.g;
    }

    public float getAvgLifeTimeDeviationFX() {
        return this.h;
    }

    public int getMaxParticleCount() {
        return this.mMaxParticleCount;
    }

    public float getElasticityFX() {
        return this.i;
    }

    public float getGravityEffectFX() {
        return this.j;
    }

    public Body getEmitter() {
        return this.l;
    }

    public FXVector getRelEmitterPos1() {
        return this.m;
    }

    public FXVector getRelEmitterPos2() {
        return this.n;
    }

    public boolean emitAxesFixed() {
        return this.o;
    }

    public float getEmitSpeedFX() {
        return this.p;
    }

    public float getEmitSpeedDeviationFX() {
        return this.q;
    }

    public float getEmitAngle2FX() {
        return this.r;
    }

    public float getEmitAngleDeviation2FX() {
        return this.s;
    }

    public float getDampingFX() {
        return this.k;
    }

    public boolean canCollide() {
        return this.a;
    }

    public void setCreationRateFX(float f2, float f3, float f4) {
        this.b = f2;
        this.d = f4 * f2;
        this.c = f3;
        this.e = f4 * f3;
    }

    public void setAvgLifeTime(float f2, float f3) {
        this.g = f2;
        this.h = f3;
    }

    public void setElasticityFX(float f2) {
        this.i = f2;
    }

    public void setGravityEffectFX(float f2) {
        this.j = f2;
    }

    public void setEmitter(Body body) {
        this.l = body;
    }

    public void setRelEmitterPos1(FXVector fXVector) {
        this.m = fXVector;
    }

    public void setRelEmitterPos2(FXVector fXVector) {
        this.n = fXVector;
    }

    public void setEmitAxesFixed(boolean bl) {
        this.o = bl;
    }

    public void setEmitSpeedFX(float f2, float f3) {
        this.p = f2;
        this.q = f3;
    }

    public void setEmitAngle2FX(float f2, float f3) {
        this.r = f2;
        this.s = f3;
    }

    public void setMaxParticleCount(int n) {
        if (this.mMaxParticleCount != n) {
            this.mMaxParticleCount = n;
            this.mXFX = new float[n];
            this.mYFX = new float[n];
            this.mXPrevFX = new float[n];
            this.mYPrevFX = new float[n];
            this.mLife = new short[n];
        }
    }

    public void setDampingFX(float f2) {
        this.k = f2;
    }

    public void setCanCollide(boolean bl) {
        this.a = bl;
    }

    public float[] getXPosFX() {
        return this.mXFX;
    }

    public float[] getYPosFX() {
        return this.mYFX;
    }

    public float[] getXPrevPosFX() {
        return this.mXPrevFX;
    }

    public float[] getYPrevPosFX() {
        return this.mYPrevFX;
    }

    public short[] getLifeTimes() {
        return this.mLife;
    }

    public static ParticleEmitter loadParticleEmitter(PhysicsFileReader object, World world, UserData userData) {
        ParticleEmitter particleEmitter = new ParticleEmitter();
        new ParticleEmitter().l = world.findBodyById(((PhysicsFileReader)object).next());
        particleEmitter.o = ((PhysicsFileReader)object).next() != 0;
        particleEmitter.m = ((PhysicsFileReader)object).nextVector();
        particleEmitter.n = ((PhysicsFileReader)object).nextVector();
        particleEmitter.setEmitAngle2FX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setEmitSpeedFX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setCreationRateFX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX(), world.getTimestepFX());
        particleEmitter.setAvgLifeTime(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setMaxParticleCount(((PhysicsFileReader)object).nextInt());
        particleEmitter.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setGravityEffectFX(((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setDampingFX(((PhysicsFileReader)object).nextIntFX());
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                particleEmitter.mUserData = userData.createNewUserData((String)object, 5);
            }
        }
        return particleEmitter;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

