/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.platform.Debug;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Music {
    public static int totalMusicsInMemory = 0;
    public Player player;
    public int volume;
    public String path;
    public int loopCount;
    public boolean isReloaded;
    static /* synthetic */ Class class$com$renderedideas$platform$Music;

    public Music(int volume, String path, int loopCount) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.volume = volume;
        this.path = path;
        this.loopCount = loopCount;
        this.isReloaded = false;
        if (!this.load(volume, path, loopCount)) {
            throw new Exception("Can't load sound-> " + path);
        }
        Debug.print(path + " loaded.");
    }

    private boolean load(int soundVolume, String filePath, int loopCount) {
        try {
            String protocol;
            String format;
            InputStream in = null;
            VolumeControl vc = null;
            if (filePath.endsWith("wav")) {
                format = "";
                protocol = "audio/x-wav";
            } else if (this.isAudioFormatSupported("audio/x-ms-wma")) {
                format = ".wma";
                protocol = "audio/x-ms-wma";
            } else if (this.isAudioFormatSupported("audio/m4a")) {
                format = ".aac";
                protocol = "audio/m4a";
            } else if (this.isAudioFormatSupported("audio/aac")) {
                format = ".aac";
                protocol = "audio/aac";
            } else {
                return false;
            }
            in = (class$com$renderedideas$platform$Music == null ? (class$com$renderedideas$platform$Music = Music.class$("com.renderedideas.platform.Music")) : class$com$renderedideas$platform$Music).getResourceAsStream(filePath + format);
            this.player = Manager.createPlayer((InputStream)in, (String)protocol);
            this.player.setLoopCount(loopCount);
            this.player.realize();
            vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(soundVolume);
            }
            this.player.prefetch();
            vc = null;
            ++totalMusicsInMemory;
            return true;
        }
        catch (Exception e2) {
            Debug.print("errorMusicLoad->Music:" + e2);
            return false;
        }
    }

    private void reload() {
        this.unload();
        this.load(this.volume, this.path, this.loopCount);
    }

    public boolean unload() {
        try {
            if (this.player != null) {
                if (this.player.getState() == 400) {
                    this.player.stop();
                }
                this.player.deallocate();
                this.player.close();
                this.player = null;
                System.gc();
            }
            --totalMusicsInMemory;
            return true;
        }
        catch (Exception e2) {
            Debug.print("errorMusicUnload->Music:" + e2);
            return false;
        }
    }

    public void play() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Music.this.player.start();
                    Music.this.isReloaded = false;
                }
                catch (Exception e2) {
                    Debug.print("errorMusicPlay->Music:" + e2);
                    if (!Music.this.isReloaded) {
                        Music.this.reload();
                        Music.this.isReloaded = true;
                        Music.this.play();
                    }
                    Music.this.isReloaded = false;
                }
            }
        });
        t.start();
    }

    public void stop() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    if (Music.this.player.getState() == 400) {
                        Music.this.player.stop();
                    }
                }
                catch (Exception e2) {
                    Debug.print("errorMusicStop->Music:" + e2);
                }
            }
        });
        t.start();
    }

    public void pause() {
        this.stop();
    }

    public void resume() {
        this.play();
    }

    private boolean isAudioFormatSupported(String str) {
        String[] formats = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < formats.length; ++i) {
            if (!str.trim().equalsIgnoreCase(formats[i].trim())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

