/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.util.StringUtil;
import java.util.Random;
import java.util.Vector;

final class TrackingURL {
    private static final Random random = new Random(System.currentTimeMillis());
    private static final String urlPreffix = "";
    private Vector keys = new Vector();
    private Vector values = new Vector();

    public TrackingURL() {
        this.keys = new Vector(15);
        this.values = new Vector(15);
        this.addParameter("utmwv", "1");
        this.addParameter("utmn", String.valueOf(Math.abs(random.nextInt())));
        this.addParameter("utmcs", System.getProperty("microedition.encoding"));
        this.addParameter("utmul", System.getProperty("microedition.locale"));
        this.addParameter("utmje", "1");
        this.addParameter("utmdt", urlPreffix);
        this.addParameter("utmhn", "localhost");
        this.addParameter("utmr", urlPreffix);
        this.addParameter("utmt", urlPreffix);
        this.addParameter("utme", urlPreffix);
        this.addParameter("utmp", urlPreffix);
    }

    public void addParameter(String key, String value) {
        if (this.keys.contains(key)) {
            this.values.setElementAt(value, this.keys.indexOf(key));
        } else {
            this.keys.addElement(key);
            this.values.addElement(value);
        }
    }

    public void removeParameter(String key) {
        if (this.keys.contains(key)) {
            int ix = this.keys.indexOf(key);
            this.values.removeElementAt(ix);
            this.keys.removeElementAt(ix);
        }
    }

    public String getParameter(String key) {
        if (this.keys.contains(key)) {
            int ix = this.keys.indexOf(key);
            return (String)this.values.elementAt(ix);
        }
        return null;
    }

    public String getURL() {
        return urlPreffix + this.queryString();
    }

    public int size() {
        return this.keys.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TrackingURL)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    public String toString() {
        return this.getURL();
    }

    private String queryString() {
        StringBuffer query = new StringBuffer();
        int size = this.keys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this.keys.elementAt(i);
            String value = (String)this.values.elementAt(i);
            if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
            query.append(key);
            query.append("=");
            query.append(value);
            query.append("&");
        }
        String queryStr = query.toString();
        if (queryStr.endsWith("&")) {
            queryStr = queryStr.substring(0, queryStr.length() - 1);
        }
        return queryStr;
    }
}

