/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;
import com.renderedideas.yourgamename.Selector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class HelpView
extends GameView3D {
    private static final int SCROLL_SPEED = (int)((double)GameManager.screenWidth * 0.04);
    private static int NO_OF_SCREENS = 3;
    private Bitmap[] helpBitmaps;
    private Point[] helpBitmapCurrentPositions;
    private Point[] helpBitmapPreviousPositions;
    private Bitmap backBtnBitmap;
    private Point backBtnBitmapPos;
    private Bitmap forwardBtnBitmap;
    private Point forwardBtnBitmapPos;
    int currentPage = 1;
    private boolean swipedRight;
    private boolean swipedLeft;
    public static boolean fromGamePlayView;

    public HelpView() {
        this.ID = Constants.VIEW_ID_HELP;
        NO_OF_SCREENS = PlatformService.isTouchSupported() ? 2 : 4;
        NO_OF_SCREENS = PlatformService.isTouchSupported() ? 3 : 4;
        this.initBitmaps();
        this.initializeBitmapPositions();
        PlatformService.enableGestures();
    }

    public void update(float deltaTime) {
        if (this.swipedLeft) {
            this.moveBitmaps(-1);
        } else if (this.swipedRight) {
            this.moveBitmaps(1);
        }
        Selector.update();
    }

    public void paint(Graphics g2) {
        this.paintGUI(g2);
        Selector.paint(g2);
    }

    public void paintGUI(Graphics g2) {
        for (int i = 0; i < this.helpBitmaps.length; ++i) {
            if (this.helpBitmaps[i] == null) continue;
            Bitmap.drawBitmap(g2, this.helpBitmaps[i], (int)this.helpBitmapCurrentPositions[i].X, (int)this.helpBitmapCurrentPositions[i].Y);
        }
        Bitmap.drawBitmap(g2, this.backBtnBitmap, (int)this.backBtnBitmapPos.X, (int)this.backBtnBitmapPos.Y);
        Bitmap.drawBitmap(g2, this.forwardBtnBitmap, (int)this.forwardBtnBitmapPos.X, (int)this.forwardBtnBitmapPos.Y);
    }

    public void keyPressed(int keyID) {
        Debug.print("keyid pressed: " + keyID);
        Selector.keyPressed(keyID);
        if (keyID == 103 || keyID == 102 || keyID == 108) {
            Debug.print("keyid: " + keyID);
            if (Selector.position != null) {
                Debug.print("keyid clicked: " + keyID);
                this.pointerPressed(keyID, (int)Selector.position.X, (int)Selector.position.Y);
            }
        }
        if (keyID == 101) {
            this.selectPrev();
        } else if (keyID == 102) {
            this.selectNext();
        }
    }

    public void keyReleased(int keyID) {
        Selector.keyReleased(keyID);
        if ((keyID == 103 || keyID == 102 || keyID == 108) && Selector.position != null) {
            Debug.print("key released2");
            this.pointerReleased(keyID, (int)Selector.position.X, (int)Selector.position.Y);
        }
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pointerID, int x, int y) {
    }

    public void pointerReleased(int pointerID, int x, int y) {
        if (HelpView.isPointInsideBitmap(x, y, this.backBtnBitmap, (int)this.backBtnBitmapPos.X, (int)this.backBtnBitmapPos.Y)) {
            this.selectPrev();
        } else if (HelpView.isPointInsideBitmap(x, y, this.forwardBtnBitmap, (int)this.forwardBtnBitmapPos.X, (int)this.forwardBtnBitmapPos.Y)) {
            this.selectNext();
        }
    }

    public void pointerDragged(int pointerID, int x, int y) {
    }

    public void onBackKey() {
        this.selectPrev();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        PlatformService.disableGestures();
        this.helpBitmaps = null;
        this.helpBitmapCurrentPositions = null;
        this.helpBitmapPreviousPositions = null;
        this.backBtnBitmap = null;
        this.backBtnBitmapPos = null;
        this.forwardBtnBitmap = null;
        this.forwardBtnBitmapPos = null;
    }

    public void accelerometerData(double x, double y, double z, double min, double max) {
    }

    public void handleSwipe(int direction, int pointerIndex) {
        if (direction == 118) {
            this.selectNext();
        } else if (direction == 119) {
            this.selectPrev();
        }
    }

    private void initBitmaps() {
        this.helpBitmaps = new Bitmap[NO_OF_SCREENS];
        this.loadBitmap(this.currentPage);
        this.forwardBtnBitmap = new Bitmap("level select/forward-button.png");
        this.backBtnBitmap = new Bitmap("level select/back-button.png");
    }

    private void initializeBitmapPositions() {
        this.helpBitmapCurrentPositions = new Point[NO_OF_SCREENS];
        this.helpBitmapPreviousPositions = new Point[NO_OF_SCREENS];
        for (int i = 0; i < this.helpBitmapCurrentPositions.length; ++i) {
            this.helpBitmapCurrentPositions[i] = new Point(i * GameManager.screenWidth, 0.0f);
            this.helpBitmapPreviousPositions[i] = new Point(i * GameManager.screenWidth, 0.0f);
        }
        this.backBtnBitmapPos = new Point(0.0f, GameManager.screenHeight - this.backBtnBitmap.getHeight());
        this.forwardBtnBitmapPos = new Point(GameManager.screenWidth - this.forwardBtnBitmap.getWidth(), GameManager.screenHeight - this.forwardBtnBitmap.getHeight());
    }

    private void saveCurrentPositions() {
        for (int i = 0; i < this.helpBitmapPreviousPositions.length; ++i) {
            this.helpBitmapPreviousPositions[i].X = this.helpBitmapCurrentPositions[i].X;
        }
    }

    private void selectPrev() {
        if (this.swipedLeft || this.swipedRight) {
            return;
        }
        --this.currentPage;
        this.loadBitmap(this.currentPage);
        if (this.currentPage < 1) {
            if (fromGamePlayView) {
                Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
            } else {
                Game.changeView(Constants.VIEW_ID_MENU);
            }
        } else {
            this.saveCurrentPositions();
            this.swipedRight = true;
        }
    }

    private void selectNext() {
        if (this.swipedLeft || this.swipedRight) {
            return;
        }
        if (this.currentPage < this.helpBitmaps.length) {
            ++this.currentPage;
            this.loadBitmap(this.currentPage);
            this.saveCurrentPositions();
            this.swipedLeft = true;
        } else if (fromGamePlayView) {
            fromGamePlayView = false;
            Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
        } else {
            Game.changeView(Constants.VIEW_ID_MENU);
        }
    }

    public static boolean isPointInsideBitmap(float x, float y, Bitmap bitmap, float bitmapX, float bitmapY) {
        return x > bitmapX && y > bitmapY && x < bitmapX + (float)bitmap.getWidth() && y < bitmapY + (float)bitmap.getHeight();
    }

    public static boolean isPointInsideBitmap(float x, float y, Bitmap bitmap, float bitmapX, float bitmapY, int extraSpace) {
        return x > bitmapX - (float)extraSpace && y > bitmapY - (float)extraSpace && x < bitmapX + (float)bitmap.getWidth() + (float)extraSpace && y < bitmapY + (float)bitmap.getHeight() + (float)extraSpace;
    }

    private void loadBitmap(int pageToLoad) {
        int index = pageToLoad - 1;
        if (index < 0) {
            return;
        }
        this.helpBitmaps[index] = !PlatformService.isTouchSupported() ? new Bitmap("help/keyPad" + pageToLoad + ".png") : new Bitmap("help/" + pageToLoad + ".png");
    }

    private void moveBitmaps(int direction) {
        for (int i = 0; i < this.helpBitmapCurrentPositions.length; ++i) {
            this.helpBitmapCurrentPositions[i].X = (int)HelpView.approach(this.helpBitmapCurrentPositions[i].X, this.helpBitmapPreviousPositions[i].X + (float)(direction * GameManager.screenWidth), SCROLL_SPEED);
            if (this.helpBitmapCurrentPositions[this.helpBitmapCurrentPositions.length - 1].X != this.helpBitmapPreviousPositions[this.helpBitmapCurrentPositions.length - 1].X + (float)(direction * GameManager.screenWidth)) continue;
            this.swipedLeft = false;
            this.swipedRight = false;
            this.unloadOutOfScreenBitmaps();
            this.saveCurrentPositions();
        }
    }

    public static float approach(float currentValue, float destinationValue, float speed) {
        if (currentValue == destinationValue) {
            return currentValue;
        }
        int dirX = 1;
        if (destinationValue < currentValue) {
            dirX = -1;
        }
        currentValue += speed * (float)dirX;
        if (dirX == 1 && currentValue >= destinationValue || dirX == -1 && currentValue <= destinationValue) {
            currentValue = destinationValue;
        }
        return currentValue;
    }

    private void unloadOutOfScreenBitmaps() {
        int bitmapRequiredIndex = this.currentPage - 1;
        for (int i = 0; i < this.helpBitmaps.length; ++i) {
            if (i == bitmapRequiredIndex) continue;
            this.helpBitmaps[i] = null;
        }
    }

    public void update() {
        this.update(1.0f);
    }

    public void handleSwipe(int direction) {
        this.handleSwipe(direction, direction);
    }

    public void paint(Graphics g2, float extrapolationFactor) {
        this.paint(g2);
    }

    public void paint2D_before(Graphics g2) {
    }

    public void paint3D_before(Graphics3D g2) {
    }

    public void paint2D_after(Graphics g2) {
    }

    public void paint3D_after(Graphics3D g2) {
    }
}

